/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameLogic;
import cc.jmap.games.I18NResource;
import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.net.BTClient;
import cc.jmap.games.net.ClientConnectThread;
import java.io.IOException;
import javax.bluetooth.RemoteDevice;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PageCanvas
extends Canvas {
    public static final int PAGE_BRAND = 0;
    public static final int PAGE_MAIN = 1;
    public static final int PAGE_MAIN_HELP_1 = 2;
    public static final int PAGE_MAIN_HELP_2 = 3;
    public static final int PAGE_MAIN_TWO_CHOOSE = 4;
    public static final int PAGE_MAIN_TWO_MASTER_WAIT = 5;
    public static final int PAGE_MAIN_TWO_MASTER_READY_TO_PLAY = 6;
    public static final int PAGE_MAIN_TWO_SLAVE_DISCOVERING = 7;
    public static final int PAGE_MAIN_TWO_SLAVE_SELECT_DEVICES = 8;
    public static final int PAGE_MAIN_TWO_SLAVE_CONNECTING = 9;
    public static final int PAGE_MAIN_TWO_SLAVE_CONNECTED = 10;
    public static final int PAGE_MAIN_TWO_CONNECTING_ERROR = 11;
    private int state = 0;
    private Image brandPage = null;
    private Image mainPage = null;
    private static Image[] langIcons = new Image[3];
    private static Image[] helpIcons = new Image[2];
    public static Image[] btIcons = new Image[7];
    private ParatrooperMidlet midlet = null;
    public static Font sfont = null;
    public static String btstatus = "";
    public static PageCanvas instance = null;
    private static int btSelectPage = 0;
    private static ClientConnectThread clientThread = null;

    public void initOthers() {
        try {
            sfont = Font.getFont((int)64, (int)0, (int)8);
            I18NResource.init();
            this.mainPage = Image.createImage((String)"/main/main.png");
            PageCanvas.helpIcons[0] = Image.createImage((String)"/main/help_box.png");
            PageCanvas.helpIcons[1] = Image.createImage((String)"/main/help_check.png");
            BTClient.initData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getState() {
        return this.state;
    }

    public static void setI18N() {
    }

    public PageCanvas(ParatrooperMidlet parent) {
        this.setFullScreenMode(true);
        try {
            this.brandPage = Image.createImage((String)"/brand/brand.png");
            PageCanvas.langIcons[0] = Image.createImage((String)"/brand/btn_en.png");
            PageCanvas.langIcons[1] = Image.createImage((String)"/brand/btn_tc.png");
            PageCanvas.langIcons[2] = Image.createImage((String)"/brand/btn_sc.png");
            PageCanvas.btIcons[0] = Image.createImage((String)"/bt/box01.png");
            PageCanvas.btIcons[1] = Image.createImage((String)"/bt/box02.png");
            PageCanvas.btIcons[2] = Image.createImage((String)"/bt/box03.png");
            PageCanvas.btIcons[3] = Image.createImage((String)"/bt/bt_go.png");
            PageCanvas.btIcons[4] = Image.createImage((String)"/bt/bt_go2.png");
            PageCanvas.btIcons[5] = Image.createImage((String)"/bt/bt_light.png");
            PageCanvas.btIcons[6] = Image.createImage((String)"/bt/bt_light2.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.midlet = parent;
        instance = this;
    }

    public void showMain() {
        try {
            ParatrooperMidlet.engine.logic.sync.stopAndReset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state = 1;
        this.repaint();
    }

    public void showTwoChoose() {
        this.state = 4;
        this.repaint();
    }

    public static void goError(String reason) {
        PageCanvas.instance.state = 11;
        btstatus = reason;
        instance.repaint();
    }

    public void showMaster() {
        System.out.println("showMaster");
    }

    public void showSlave() {
        System.out.println("showSlave");
    }

    public void showHelp() {
        this.state = 2;
        this.repaint();
    }

    private void drawCenterString(Graphics g, String str, int y) {
        int x = (360 - sfont.stringWidth(str)) / 2;
        g.drawString(str, x, y, 0);
    }

    private void drawMain(Graphics g) {
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage(I18NResource.i18Imgs[0], (360 - I18NResource.i18Imgs[0].getWidth()) / 2, 0, 20);
        g.drawImage(I18NResource.i18Imgs[1], 60, 200, 20);
        g.drawImage(I18NResource.i18Imgs[10], 60, 290, 20);
        g.drawImage(I18NResource.i18Imgs[2], 60, 380, 20);
        g.drawImage(I18NResource.i18Imgs[3], 0, 640 - I18NResource.i18Imgs[3].getHeight(), 20);
        g.drawImage(I18NResource.i18Imgs[4], 360 - I18NResource.i18Imgs[4].getWidth(), 640 - I18NResource.i18Imgs[3].getHeight(), 20);
    }

    private void drawMasterSlaveSelect(Graphics g) {
        int x = 50;
        int ygap = 30;
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage(btIcons[0], 0, 0, 20);
        g.drawImage(btIcons[1], 0, 0, 20);
        g.drawImage(I18NResource.i18Imgs[13], 0, 175, 20);
        g.drawImage(I18NResource.i18Imgs[14], 0, 345, 20);
        g.drawImage(btIcons[3], 270, 235, 20);
        g.drawImage(btIcons[3], 270, 400, 20);
        Font PLAIN_SMALL = Font.getFont((int)64, (int)0, (int)8);
        g.setFont(PLAIN_SMALL);
        g.setColor(0xFFFFFF);
        g.drawString(I18NResource.btLines[0], x, 230, 0);
        g.drawString(I18NResource.btLines[1], x, 230 + ygap * 1, 0);
        g.drawString(I18NResource.btLines[2], x, 400, 0);
        g.drawString(I18NResource.btLines[3], x, 400 + ygap * 1, 0);
        if (!BTClient.lastServerFriendlyName.equals("")) {
            g.drawImage(btIcons[3], 270, 480, 20);
            g.drawString(I18NResource.btLines[4], x, 480, 0);
            g.drawString(BTClient.lastServerFriendlyName, x, 480 + ygap * 1, 0);
        } else {
            g.drawImage(btIcons[4], 270, 480, 20);
            g.drawString(I18NResource.btLines[4], x, 480, 0);
            g.drawString(I18NResource.btLines[20], x, 480 + ygap * 1, 0);
        }
        g.drawImage(I18NResource.i18Imgs[15], 360 - I18NResource.i18Imgs[15].getWidth(), 640 - I18NResource.i18Imgs[15].getHeight(), 20);
    }

    private void drawMaster(Graphics g) {
        g.setFont(sfont);
        g.setColor(0xFFFFFF);
        int ygap = 30;
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage(btIcons[2], 0, 0, 20);
        g.drawImage(I18NResource.i18Imgs[13], 0, 180, 20);
        Image img = I18NResource.i18Imgs[15];
        g.drawImage(img, 360 - img.getWidth(), 640 - img.getHeight(), 20);
        if (this.state == 5) {
            this.drawCenterString(g, I18NResource.btLines[16], 250);
            this.drawCenterString(g, I18NResource.btLines[17], 250 + ygap * 1);
            img = I18NResource.i18Imgs[12];
            g.drawImage(img, (360 - img.getWidth()) / 2, 450, 20);
        } else if (this.state == 6) {
            this.drawCenterString(g, I18NResource.btLines[18], 250);
            this.drawCenterString(g, I18NResource.btLines[19], 250 + ygap * 1);
            img = I18NResource.i18Imgs[11];
            g.drawImage(img, (360 - img.getWidth()) / 2, 440, 20);
        }
    }

    private void drawSlave(Graphics g) {
        g.setFont(sfont);
        g.setColor(0xFFFFFF);
        int x = 100;
        int ygap = 30;
        int y = 0;
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage(btIcons[2], 0, 0, 20);
        g.drawImage(I18NResource.i18Imgs[14], 0, 180, 20);
        Image img = I18NResource.i18Imgs[15];
        g.drawImage(img, 360 - img.getWidth(), 640 - img.getHeight(), 20);
        if (this.state == 7) {
            this.drawCenterString(g, I18NResource.btLines[2], 250);
            this.drawCenterString(g, I18NResource.btLines[3], 250 + ygap * 1);
            this.drawCenterString(g, BTClient.lastFoundDeviceName, 250 + ygap * 2);
            if (BTClient.canCancel()) {
                img = I18NResource.i18Imgs[17];
                g.drawImage(img, (360 - img.getWidth()) / 2, 440, 20);
            }
        } else if (this.state == 8) {
            img = btIcons[6];
            x = (360 - img.getWidth()) / 2;
            y = 230;
            ygap = 53;
            int i = 0;
            while (i < 6) {
                g.drawImage(img, x, y + ygap * i, 20);
                ++i;
            }
            y = 230;
            int total_page = this.getDeviceTotalPage();
            int now_page = btSelectPage % total_page;
            g.setColor(0xFFFFFF);
            if (BTClient.devices.size() == 0) {
                String text = I18NResource.btLines[23];
                x = (360 - sfont.stringWidth(text)) / 2;
                g.drawString(text, x, y + ygap * 0 + 8, 0);
                return;
            }
            int i2 = now_page * 5;
            while (i2 < (now_page + 1) * 5) {
                if (i2 < BTClient.devices.size()) {
                    try {
                        RemoteDevice device = (RemoteDevice)BTClient.devices.elementAt(i2);
                        if (device != null) {
                            String name = BTClient.getFriendlyName(device);
                            x = (360 - sfont.stringWidth(name)) / 2;
                            this.drawCenterString(g, name, y + ygap * (i2 % 5) + 8);
                        }
                    }
                    catch (Exception e) {
                        PageCanvas.setBTStatus("e1A " + e.getMessage());
                    }
                }
                ++i2;
            }
            if (total_page > 1) {
                String s = I18NResource.btLines[22];
                s = String.valueOf(s) + " " + String.valueOf(now_page + 1) + "/" + String.valueOf(total_page);
                x = (360 - sfont.stringWidth(s)) / 2;
                g.drawString(s, x, y + ygap * 5 + 8, 0);
            }
        } else if (this.state == 9) {
            this.drawCenterString(g, I18NResource.btLines[6], 250);
            this.drawCenterString(g, I18NResource.btLines[7], 250 + ygap * 1);
        } else if (this.state == 10) {
            this.drawCenterString(g, I18NResource.btLines[8], 250);
            this.drawCenterString(g, I18NResource.btLines[9], 250 + ygap * 1);
        }
    }

    private void drawClientConnectError(Graphics g) {
        g.setFont(sfont);
        g.setColor(0xFFFFFF);
        int ygap = 30;
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage(btIcons[2], 0, 0, 20);
        g.drawImage(I18NResource.i18Imgs[14], 0, 180, 20);
        Image img = I18NResource.i18Imgs[15];
        g.drawImage(img, 360 - img.getWidth(), 640 - img.getHeight(), 20);
        this.drawCenterString(g, I18NResource.btLines[10], 250);
        this.drawCenterString(g, I18NResource.btLines[11], 250 + ygap * 1);
        this.drawCenterString(g, I18NResource.btLines[12], 250 + ygap * 2);
        this.drawCenterString(g, I18NResource.btLines[13], 250 + ygap * 3);
    }

    private void drawDebug(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 360, 100);
        g.setFont(sfont);
        g.setColor(0xFF0000);
        int x = 5;
        int ygap = 22;
        g.drawString("state:" + this.state, x, ygap * 0, 0);
        g.drawString("bt.status:" + btstatus, x, ygap * 1, 0);
    }

    public static void setBTStatus(String s) {
        btstatus = s;
    }

    public void paint(Graphics g) {
        if (this.state == 0) {
            g.drawImage(this.brandPage, 0, 0, 20);
            g.drawImage(langIcons[0], 0, 640 - langIcons[0].getHeight(), 20);
            g.drawImage(langIcons[1], (360 - langIcons[1].getWidth()) / 2, 640 - langIcons[1].getHeight(), 20);
            g.drawImage(langIcons[2], 360 - langIcons[2].getWidth(), 640 - langIcons[2].getHeight(), 20);
        } else if (this.state == 1) {
            this.drawMain(g);
        } else if (this.state == 2 || this.state == 3) {
            this.drawMain(g);
            Font font = Font.getFont((int)0, (int)0, (int)8);
            g.setFont(font);
            g.drawImage(helpIcons[0], (360 - helpIcons[0].getWidth()) / 2, (640 - helpIcons[0].getHeight()) / 2, 20);
            g.setColor(0xD7D7D7);
            int x = 29;
            int y = 33;
            int yGap = 26;
            int start = 0;
            int end = 20;
            if (this.state == 3) {
                start = 20;
                end = 40;
            }
            int i = start;
            while (i < end) {
                g.drawString(I18NResource.helpLines[i], x, y + yGap * (i - start), 0);
                ++i;
            }
            if (this.state == 3) {
                g.drawImage(helpIcons[1], (360 - helpIcons[1].getWidth()) / 2, 575, 20);
            }
        } else if (this.state == 4) {
            this.drawMasterSlaveSelect(g);
        } else if (this.state == 5) {
            this.drawMaster(g);
        } else if (this.state == 6) {
            this.drawMaster(g);
        } else if (this.state == 7) {
            this.drawSlave(g);
        } else if (this.state == 8) {
            this.drawSlave(g);
        } else if (this.state == 9) {
            this.drawSlave(g);
        } else if (this.state == 10) {
            this.drawSlave(g);
        } else if (this.state == 11) {
            this.drawClientConnectError(g);
        }
    }

    protected void pointerPressed(int x, int y) {
        try {
            if (this.state == 0) {
                boolean flag = false;
                if (x < 120 && y > 520) {
                    I18NResource.setLanguage(2);
                    flag = true;
                } else if (x > 120 && x < 240 && y > 520) {
                    I18NResource.setLanguage(0);
                    flag = true;
                } else if (x > 240 && y > 520) {
                    I18NResource.setLanguage(1);
                    flag = true;
                }
                if (flag) {
                    SoundPlayer.playStart();
                    this.showMain();
                    this.midlet.gotoMain();
                }
            } else if (this.state == 1) {
                if (x > 40 && y > 180 && x < 320 && y < 280) {
                    GameLogic.playerMode = 0;
                    this.midlet.gotoPlay();
                } else if (x > 40 && y > 280 && x < 320 && y < 370) {
                    this.state = 4;
                    this.repaint();
                } else if (x > 40 && y > 370 && x < 320 && y < 460) {
                    ParatrooperMidlet.viewHighScore();
                } else if (x < 180 && y > 570) {
                    this.showHelp();
                } else if (x > 180 && y > 570) {
                    this.midlet.exit();
                }
            } else if (this.state == 2) {
                this.state = 3;
                this.repaint();
            } else if (this.state == 3) {
                this.showMain();
            } else if (this.state == 4) {
                if (x > 10 && y > 220 && x < 360 && y < 350) {
                    this.state = 5;
                    this.repaint();
                    this.midlet.goMasterBinding();
                } else if (x > 10 && y > 380 && x < 360 && y < 465) {
                    this.state = 7;
                    this.repaint();
                    this.midlet.goSlaveDiscovery("");
                    btstatus = "goSlaveDiscovery() #N";
                } else if (x > 10 && y > 465 && x < 360 && y < 550) {
                    if (!BTClient.lastServerFriendlyName.equals("")) {
                        this.state = 9;
                        this.repaint();
                        this.midlet.goSlaveDiscovery(BTClient.lastServerUrl);
                        btstatus = "goSlaveDiscovery() #N2";
                    }
                } else if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 5) {
                if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 6) {
                if (x > 10 && y > 380 && x < 350 && y < 550) {
                    GameLogic.sendSystemStatus(2, 101);
                    ParatrooperMidlet.instance.goMasterStartPlay();
                } else if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 7) {
                if (x > 10 && y > 380 && x < 350 && y < 550) {
                    if (BTClient.canCancel()) {
                        BTClient.instance.cancelDeviceDiscovered();
                        PageCanvas.btInquiryCompleted();
                    }
                } else if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 8) {
                int now_page;
                int num;
                if (BTClient.devices.size() == 0) {
                    return;
                }
                if (x > 180 && y > 570) {
                    this.showMain();
                }
                int ypos = 230;
                int index = (y - ypos) / 53;
                PageCanvas.setBTStatus("SELECT_DEVICES:" + index);
                if (index == 5) {
                    ++btSelectPage;
                    this.repaint();
                } else if (index >= 0 && index <= 4 && (num = index + 5 * (now_page = btSelectPage % this.getDeviceTotalPage())) < BTClient.devices.size()) {
                    try {
                        BTClient.lastSelectDeviceName = BTClient.getFriendlyName((RemoteDevice)BTClient.devices.elementAt(num));
                        PageCanvas.clientConnectTo(num);
                    }
                    catch (Exception e) {
                        PageCanvas.setBTStatus("e7:" + e.getMessage());
                    }
                }
            } else if (this.state == 9) {
                if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 10) {
                if (x > 180 && y > 570) {
                    this.showMain();
                }
            } else if (this.state == 11 && x > 180 && y > 570) {
                this.showMain();
            }
        }
        catch (Exception e) {
            PageCanvas.setBTStatus("pointerPressed:" + e.toString());
        }
    }

    public int getDeviceTotalPage() {
        int more = BTClient.devices.size() % 5 == 0 ? 0 : 1;
        return BTClient.devices.size() / 5 + more;
    }

    public static void serverReadyToStart() {
        if (PageCanvas.instance.state == 5) {
            PageCanvas.instance.state = 6;
            instance.repaint();
        }
    }

    public static void clientStartToPlay() {
        PageCanvas.setBTStatus("clientStartToPlay()");
        ParatrooperMidlet.instance.goSlavePlay();
    }

    public static void clientConnectTo(int index) {
        try {
            PageCanvas.instance.state = 9;
            clientThread = new ClientConnectThread();
            clientThread.setIndexToRun(index);
            clientThread.start();
            instance.repaint();
        }
        catch (Exception e) {
            PageCanvas.setBTStatus("e3" + e.getMessage());
        }
    }

    public static void btDeviceDiscovered() {
        instance.repaint();
    }

    public static void btInquiryCompleted() {
        if (PageCanvas.instance.state == 7) {
            if (BTClient.devices.size() > 0) {
                PageCanvas.instance.state = 8;
                instance.repaint();
            } else {
                PageCanvas.instance.state = 11;
                instance.repaint();
            }
        }
    }

    public static void btServicesDiscovered() {
        clientThread = new ClientConnectThread();
        clientThread.setStep(2);
        clientThread.start();
    }

    public static void btClientConnected() {
        PageCanvas.instance.state = 10;
        instance.repaint();
        PageCanvas.setBTStatus("#1 btClientConnected() #N");
    }
}

