/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.ParatrooperMidlet;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SoundPlayer
extends Thread {
    public static final int SOUND_START = 0;
    public static final int SOUND_BGM = 1;
    public static final int SOUND_GAMEOVER = 2;
    public static final int SOUND_EAT = 3;
    public static final int SOUND_HIT = 4;
    private static Player startPlayer;
    private static Player bgmPlayer;
    private static Player gameOverPlayer;
    private static Player eatPlayer;
    private static Player hitPlayer;
    public static boolean musicFlag;
    public static boolean soundFlag;
    public static SoundPlayer instance;
    private boolean running = true;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private Command[] commands = new Command[10];
    private static final String RMS_NAME = "sound";
    private static final int RECORD_ID = 1;
    private static byte[] data;

    static {
        musicFlag = true;
        soundFlag = true;
        instance = null;
        data = new byte[2];
    }

    public SoundPlayer() {
        instance = this;
        SoundPlayer.restoreData();
        int i = 0;
        while (i < 10) {
            this.commands[i] = new Command();
            ++i;
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.producerIndex > this.consumerIndex) {
                    Command cmd = this.commands[this.consumerIndex % 10];
                    ++this.consumerIndex;
                    if (cmd.type >= 10) {
                        this.playMidiInternal(cmd.type - 10);
                        continue;
                    }
                    this.playFileInternal(cmd.type);
                    continue;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public void closeResource() {
        this.running = false;
    }

    private synchronized void addCommand(int type, boolean playOrStop) {
        Command cmd = this.commands[this.producerIndex % 10];
        cmd.type = type;
        cmd.play = playOrStop;
        ++this.producerIndex;
    }

    public static void toggleMusicState() {
        if (musicFlag) {
            musicFlag = false;
            SoundPlayer.playStop(1);
        } else {
            musicFlag = true;
            SoundPlayer.playFile(1);
        }
        SoundPlayer.saveData();
    }

    public static void toggleSoundState() {
        soundFlag = !soundFlag;
        SoundPlayer.saveData();
    }

    public static void resume() {
        if (instance != null && musicFlag) {
            SoundPlayer.playFile(1);
        }
    }

    public static void pause() {
        if (instance != null) {
            SoundPlayer.playStop(1);
            SoundPlayer.playStop(2);
        }
    }

    public static void soundInit() {
        InputStream in2;
        if (bgmPlayer == null) {
            try {
                in2 = ParatrooperMidlet.instance.getClass().getResourceAsStream("/sounds/miluegg_para_bgm.mp3");
                bgmPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                bgmPlayer.setLoopCount(-1);
                bgmPlayer.realize();
                bgmPlayer.prefetch();
            }
            catch (Exception in2) {
                // empty catch block
            }
        }
        if (gameOverPlayer == null) {
            try {
                in2 = ParatrooperMidlet.instance.getClass().getResourceAsStream("/sounds/miluegg_para_gameover.mp3");
                gameOverPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                gameOverPlayer.realize();
                gameOverPlayer.prefetch();
            }
            catch (Exception in3) {
                // empty catch block
            }
        }
        if (eatPlayer == null) {
            try {
                in2 = ParatrooperMidlet.instance.getClass().getResourceAsStream("/sounds/miluegg_para_eat.mp3");
                eatPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                eatPlayer.realize();
                eatPlayer.prefetch();
            }
            catch (Exception in4) {
                // empty catch block
            }
        }
        if (hitPlayer == null) {
            try {
                in2 = ParatrooperMidlet.instance.getClass().getResourceAsStream("/sounds/miluegg_para_hit.mp3");
                hitPlayer = Manager.createPlayer((InputStream)in2, (String)"audio/mpeg");
                hitPlayer.realize();
                hitPlayer.prefetch();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void soundFinalize() {
        try {
            if (startPlayer != null) {
                startPlayer.close();
            } else if (bgmPlayer != null) {
                bgmPlayer.close();
            } else if (gameOverPlayer != null) {
                gameOverPlayer.close();
            } else if (eatPlayer != null) {
                eatPlayer.close();
            } else if (hitPlayer != null) {
                hitPlayer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playStop(int sound) {
        try {
            SoundPlayer.soundInit();
            if (sound == 0 && startPlayer != null) {
                startPlayer.stop();
            }
            if (sound == 1 && bgmPlayer != null) {
                bgmPlayer.stop();
            }
            if (sound == 2 && gameOverPlayer != null) {
                gameOverPlayer.stop();
            }
            if (sound == 3 && eatPlayer != null) {
                eatPlayer.stop();
            }
            if (sound == 4 && hitPlayer != null) {
                hitPlayer.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void playFileInternal(int sound) {
        try {
            SoundPlayer.soundInit();
            if (sound == 1 && bgmPlayer != null && musicFlag) {
                bgmPlayer.setMediaTime(0L);
                bgmPlayer.start();
            }
            if (soundFlag) {
                if (sound == 0 && startPlayer != null) {
                    startPlayer.start();
                } else if (sound == 2 && gameOverPlayer != null) {
                    gameOverPlayer.setMediaTime(0L);
                    gameOverPlayer.start();
                    if (bgmPlayer != null) {
                        bgmPlayer.stop();
                    }
                } else if (sound == 3 && eatPlayer != null) {
                    eatPlayer.start();
                } else if (sound == 4 && hitPlayer != null) {
                    hitPlayer.start();
                }
            }
            if (sound == 2 && bgmPlayer != null) {
                bgmPlayer.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void playFile(int file) {
        try {
            instance.addCommand(file, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playMidiInternal(int note) {
        try {
            int base;
            int noteVal = base = 72;
            if (note == 0) {
                noteVal = base;
            } else if (note == 1) {
                noteVal = base + 2;
            } else if (note == 2) {
                noteVal = base + 4;
            } else if (note == 3) {
                noteVal = base + 5;
            } else if (note == 4) {
                noteVal = base + 7;
            } else if (note == 5) {
                noteVal = base + 9;
            } else if (note == 6) {
                noteVal = base + 11;
            } else if (note == 7) {
                noteVal = base + 12;
            }
            Manager.playTone((int)noteVal, (int)200, (int)100);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public static void playMidi(int note) {
        try {
            instance.addCommand(note + 10, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playStart() {
        if (startPlayer == null) {
            try {
                InputStream in = ParatrooperMidlet.instance.getClass().getResourceAsStream("/sounds/game_start.mp3");
                startPlayer = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
                startPlayer.realize();
                startPlayer.prefetch();
                startPlayer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveData() {
        System.out.println("saveData");
        SoundPlayer.data[0] = (byte)(musicFlag ? 1 : 0);
        SoundPlayer.data[1] = (byte)(soundFlag ? 1 : 0);
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (rs.getNextRecordID() == 1) {
                rs.addRecord(data, 0, data.length);
                System.out.println("saveData #1");
            } else {
                rs.setRecord(1, data, 0, data.length);
                System.out.println("saveData #1B");
            }
            rs.closeRecordStore();
            System.out.println("saveData #2");
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        System.out.println("saveData #N");
    }

    public static void restoreData() {
        System.out.println("restoreData");
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            byte[] d = rs.getRecord(1);
            rs.closeRecordStore();
            SoundPlayer.data[0] = d[0];
            SoundPlayer.data[1] = d[1];
            System.out.println("restoreData() data[0]:" + data[0] + "/data[1]:" + data[1]);
            musicFlag = data[0] == 1;
            soundFlag = data[1] == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            SoundPlayer.saveData();
        }
        System.out.println("restoreData #N");
    }

    class Command {
        public int type = 0;
        public boolean play = true;
    }
}

