/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.menu;

import java.util.Vector;

public class JBElement {
    private String title;
    private String action;
    private String condition = null;
    private String key = "-";
    private Vector optionsVector = new Vector();
    private int selectedOption = 0;

    public JBElement(String title, String action) {
        this.title = title;
        this.action = action;
    }

    public JBElement(String title) {
        this.title = title;
    }

    public JBElement(String title, String key, String[] options) {
        this.title = title;
        this.key = key;
        for (int i = 0; i < options.length; ++i) {
            this.optionsVector.addElement(options[i]);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getConditon() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addOption(String option) {
        if (this.optionsVector == null) {
            this.optionsVector = new Vector();
        }
        this.optionsVector.addElement(option);
    }

    public String selectNextOption() {
        if (this.optionsVector == null || this.optionsVector.size() == 0) {
            return "NA";
        }
        ++this.selectedOption;
        if (this.selectedOption > this.optionsVector.size() - 1) {
            this.selectedOption = 0;
        }
        return (String)this.optionsVector.elementAt(this.selectedOption);
    }

    public String selectPrevOption() {
        if (this.optionsVector == null || this.optionsVector.size() == 0) {
            return "NA";
        }
        --this.selectedOption;
        if (this.selectedOption < 0) {
            this.selectedOption = this.optionsVector.size() - 1;
        }
        return (String)this.optionsVector.elementAt(this.selectedOption);
    }

    public void selectOption(String value) {
        for (int i = 0; i < this.optionsVector.size(); ++i) {
            String option = (String)this.optionsVector.elementAt(i);
            if (!option.equals(value)) continue;
            this.selectedOption = i;
            break;
        }
    }

    public String getSelectedOption() {
        return (String)this.optionsVector.elementAt(this.selectedOption);
    }
}

