/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.util;

public class TEA {
    private static final int SUGAR = -1640531527;
    private static final int CUPS = 32;
    private static final int UNSUGAR = -957401312;
    private int[] S = new int[4];

    public TEA(byte[] key) {
        if (key == null) {
            throw new RuntimeException("Invalid key: Key was null");
        }
        if (key.length < 16) {
            throw new RuntimeException("Invalid key: Length was less than 16 bytes");
        }
        int off = 0;
        for (int i = 0; i < 4; ++i) {
            this.S[i] = key[off++] & 0xFF | (key[off++] & 0xFF) << 8 | (key[off++] & 0xFF) << 16 | (key[off++] & 0xFF) << 24;
        }
    }

    public byte[] encrypt(byte[] clear) {
        int paddedSize = (clear.length / 8 + (clear.length % 8 == 0 ? 0 : 1)) * 2;
        int[] buffer = new int[paddedSize + 1];
        buffer[0] = clear.length;
        this.pack(clear, buffer, 1);
        this.brew(buffer);
        return this.unpack(buffer, 0, buffer.length * 4);
    }

    public byte[] decrypt(byte[] crypt) {
        if (crypt.length % 4 != 0) {
            return null;
        }
        if (crypt.length / 4 % 2 != 1) {
            return null;
        }
        int[] buffer = new int[crypt.length / 4];
        this.pack(crypt, buffer, 0);
        this.unbrew(buffer);
        return this.unpack(buffer, 1, buffer[0]);
    }

    void brew(int[] buf) {
        if (buf.length % 2 != 1) {
            return;
        }
        for (int i = 1; i < buf.length; i += 2) {
            int n = 32;
            int v0 = buf[i];
            int v1 = buf[i + 1];
            int sum = 0;
            while (n-- > 0) {
                v1 += (((v0 += ((v1 << 4) + this.S[0] ^ v1) + ((sum -= 1640531527) ^ v1 >>> 5) + this.S[1]) << 4) + this.S[2] ^ v0) + (sum ^ v0 >>> 5) + this.S[3];
            }
            buf[i] = v0;
            buf[i + 1] = v1;
        }
    }

    void unbrew(int[] buf) {
        if (buf.length % 2 != 1) {
            return;
        }
        for (int i = 1; i < buf.length; i += 2) {
            int n = 32;
            int v0 = buf[i];
            int v1 = buf[i + 1];
            int sum = -957401312;
            while (n-- > 0) {
                v0 -= (((v1 -= ((v0 << 4) + this.S[2] ^ v0) + (sum ^ v0 >>> 5) + this.S[3]) << 4) + this.S[0] ^ v1) + (sum ^ v1 >>> 5) + this.S[1];
                sum += 1640531527;
            }
            buf[i] = v0;
            buf[i + 1] = v1;
        }
    }

    void pack(byte[] src, int[] dest, int destOffset) {
        if (destOffset + src.length / 4 > dest.length) {
            return;
        }
        int shift = 24;
        int j = destOffset;
        dest[j] = 0;
        for (int i = 0; i < src.length; ++i) {
            int n = j++;
            dest[n] = dest[n] | (src[i] & 0xFF) << shift;
            if (shift == 0) {
                shift = 24;
                if (j >= dest.length) continue;
                dest[j] = 0;
                continue;
            }
            shift -= 8;
        }
    }

    byte[] unpack(int[] src, int srcOffset, int destLength) {
        if (destLength > (src.length - srcOffset) * 4) {
            return null;
        }
        byte[] dest = new byte[destLength];
        int i = srcOffset;
        int count = 0;
        for (int j = 0; j < destLength; ++j) {
            dest[j] = (byte)(src[i] >> 24 - 8 * count & 0xFF);
            if (++count != 4) continue;
            count = 0;
            ++i;
        }
        return dest;
    }
}

