/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.text;

import com.jarbull.jbf.text.JBTextWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class JBHexWriter
implements JBTextWriter {
    private Hashtable hexHash = new Hashtable();
    private String[] hexArray;
    private int stringLength;
    private int rgbArrayLength = 0;
    private int totalWidth = 0;
    private int height;
    private Image pngImage;

    public JBHexWriter(String pngPath, String indexPath) {
        this.fillHexHash(indexPath);
        try {
            this.pngImage = Image.createImage((String)pngPath);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void fillHexHash(String indexPath) {
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream(indexPath);
            byte[] buffer = new byte[50000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        while (content.indexOf(10) != -1) {
            int index = content.indexOf(10);
            String line = content.substring(0, index);
            content = content.substring(index + 1);
            String hexCode = line.substring(0, line.indexOf(58));
            line = line.substring(line.indexOf(58) + 1);
            int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
            line = line.substring(line.indexOf(58) + 1);
            int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
            line = line.substring(line.indexOf(58) + 1);
            int w = Integer.parseInt(line.substring(0, line.indexOf(58)));
            line = line.substring(line.indexOf(58) + 1);
            int h = Integer.parseInt(line.substring(0, line.indexOf(58)));
            this.hexHash.put(hexCode, new int[]{x, y, w, h});
        }
    }

    private int strHexLength(String myString) {
        int stringLengthh = 0;
        for (int i = 0; i < myString.length(); ++i) {
            if (myString.charAt(i) == '&' && myString.charAt(i + 1) == '#') {
                ++stringLengthh;
                i += 4;
                continue;
            }
            ++stringLengthh;
        }
        return stringLengthh;
    }

    private String[] str2HexArray(String myString) {
        String[] hexArray = new String[this.stringLength];
        int a = 0;
        for (int i = 0; i < this.stringLength; ++i) {
            if (myString.charAt(a) == '&' && myString.charAt(a + 1) == '#') {
                if (myString.charAt(a + 2) != 'x') {
                    hexArray[i] = myString.substring(a + 2, a + 5).toUpperCase();
                    a += 5;
                    continue;
                }
                hexArray[i] = myString.substring(a + 3, a + 5).toUpperCase();
                a += 5;
                continue;
            }
            hexArray[i] = Integer.toHexString(myString.charAt(a)).toUpperCase();
            ++a;
        }
        return hexArray;
    }

    private int[] placesDimensions2RGBArray() {
        this.totalWidth = 0;
        this.rgbArrayLength = 0;
        for (int i = 0; i < this.hexArray.length; ++i) {
            int[] arr = (int[])this.hexHash.get(this.hexArray[i]);
            if (this.hexHash.get(this.hexArray[i]) == null) {
                arr = (int[])this.hexHash.get("3F");
            }
            this.totalWidth += arr[2];
            this.rgbArrayLength += arr[2] * arr[3];
        }
        int[] finalRGB = new int[this.rgbArrayLength];
        for (int i = 0; i < this.hexArray.length; ++i) {
            int[] arr = (int[])this.hexHash.get(this.hexArray[i]);
            if (this.hexHash.get(this.hexArray[i]) == null) {
                arr = (int[])this.hexHash.get("3F");
            }
            Image myImage = Image.createImage((Image)this.pngImage, (int)arr[0], (int)arr[1], (int)arr[2], (int)arr[3], (int)0);
            int[] myImageRGB = new int[myImage.getWidth() * myImage.getHeight()];
            myImage.getRGB(myImageRGB, 0, myImage.getWidth(), 0, 0, myImage.getWidth(), myImage.getHeight());
            int finalRGBCounter = 0;
            for (int a = 0; a < i; ++a) {
                int[] arrTemp = (int[])this.hexHash.get(this.hexArray[a]);
                finalRGBCounter += arrTemp[2];
            }
            int c = 0;
            for (int a = 0; a < arr[3]; ++a) {
                for (int b = 0; b < arr[2]; ++b) {
                    finalRGB[finalRGBCounter] = myImageRGB[c];
                    ++finalRGBCounter;
                    ++c;
                }
                finalRGBCounter += this.totalWidth - arr[2];
            }
        }
        return finalRGB;
    }

    public Image getImage(String text) {
        this.stringLength = this.strHexLength(text);
        this.hexArray = this.str2HexArray(text);
        int[] fRGB = this.placesDimensions2RGBArray();
        this.height = ((int[])this.hexHash.get(this.hexArray[0]))[3];
        return Image.createRGBImage((int[])fRGB, (int)this.totalWidth, (int)this.height, (boolean)true);
    }
}

