/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.UnsupportedEncodingException;

public class ServerSocketMessage
implements IByteArray {
    private static final int FOUR_BIT_MASK = 15;
    private static final int SIX_BIT_MASK = 63;
    private static final int SEVEN_BIT_MASK = 127;
    private static final int ONE_BYTE_NEGATIVE_FILL = -64;
    private static final int TWO_BYTE_NEGATIVE_FILL = -8192;
    private static final int THREE_BYTE_NEGATIVE_FILL = -1048576;
    private static final int FOUR_BYTE_NEGATIVE_FILL = -134217728;
    private static final int FIVE_BYTE_NEGATIVE_FILL = Integer.MIN_VALUE;
    private static final int FIRST_BYTE_NEGATIVE = 64;
    private static final int FIRST_BYTE_POSITIVE_CONTINUE = 128;
    private static final int FIRST_BYTE_NEGATIVE_CONTINUE = 192;
    private static final int SUBSEQUENT_BYTE_CONTINUE = 128;
    private static final int NEEDS_ONE_BYTE = 64;
    private static final int NEEDS_TWO_BYTES = 8192;
    private static final int NEEDS_THREE_BYTES = 0x100000;
    private static final int NEEDS_FOUR_BYTES = 0x8000000;
    private static final int NEGATIVE_NEEDS_ONE_BYTE = -64;
    private static final int NEGATIVE_NEEDS_TWO_BYTES = -8192;
    private static final int NEGATIVE_NEEDS_THREE_BYTES = -1048576;
    private static final int NEGATIVE_NEEDS_FOUR_BYTES = -134217728;
    private static final int NEGATIVE_MASK = 64;
    private static final int CONTINUE_MASK = 128;
    public static final int MAXIMUM_STRING_LENGTH = 300000;
    private static final String CHARSET = "utf-8";
    private int initialOffset = 0;
    private int initialLength = 0;
    private int offset = 0;
    private int bitOffset = 0;
    private static byte[] EMPTY_MESSAGE_BYTES = new byte[0];
    private byte[] messageBytes;
    public static final int MAXIMUM_MESSAGE_LENGTH = 300000;
    private int proxySessionId = -1;
    private int messageType;
    private boolean readMode;

    private ServerSocketMessage() {
    }

    public static ServerSocketMessage createOutgoingMessage(int n) {
        ServerSocketMessage serverSocketMessage = new ServerSocketMessage();
        serverSocketMessage.messageBytes = EMPTY_MESSAGE_BYTES;
        serverSocketMessage.readMode = false;
        serverSocketMessage.messageType = n;
        return serverSocketMessage;
    }

    public static ServerSocketMessage createIncomingMessage(int n, byte[] byArray, int n2, int n3) {
        ServerSocketMessage serverSocketMessage = new ServerSocketMessage();
        serverSocketMessage.messageBytes = byArray;
        serverSocketMessage.initialLength = n3;
        serverSocketMessage.initialOffset = n2;
        serverSocketMessage.offset = n2;
        serverSocketMessage.readMode = true;
        serverSocketMessage.messageType = n;
        return serverSocketMessage;
    }

    private int getCapacityIncrement() {
        return 100;
    }

    public byte[] getBytes() {
        if (this.readMode) {
            byte[] byArray = new byte[this.initialLength];
            System.arraycopy(this.messageBytes, this.initialOffset, byArray, 0, this.initialLength);
            return byArray;
        }
        return this.getMessageBytes();
    }

    public int getSize() {
        if (this.readMode) {
            return this.initialLength;
        }
        return this.getEncodingLength();
    }

    private byte[] getMessageBytes() {
        if (this.messageBytes == null) {
            this.messageBytes = EMPTY_MESSAGE_BYTES;
        } else {
            this.packMessageBytes();
        }
        return this.messageBytes;
    }

    private void packMessageBytes() {
        if (this.messageBytes.length > this.getEncodingLength()) {
            byte[] byArray = new byte[this.getEncodingLength()];
            System.arraycopy(this.messageBytes, 0, byArray, 0, this.getEncodingLength());
            this.messageBytes = byArray;
        }
    }

    private int getEncodingLength() {
        return this.offset;
    }

    public boolean readBoolean() {
        throw new RuntimeException("Not supported (yet).");
    }

    public byte readByte() {
        throw new RuntimeException("Not supported.");
    }

    public int readInt() {
        return this.decodeNextInt();
    }

    public String readUTF() {
        return this.decodeNextString();
    }

    public void writeBoolean(boolean bl) {
        throw new RuntimeException("Not supported (yet).");
    }

    public void writeByte(byte by) {
        throw new RuntimeException("Not supported.");
    }

    public void writeInt(int n) {
        this.encodeInt(n);
    }

    public void writeUTF(String string) {
        this.encodeString(string);
    }

    private String decodeNextString() {
        int n = this.decodeNextInt();
        if (n < 0) {
            throw new RuntimeException("Negative string length encountered.");
        }
        if (this.offset + n > 300000) {
            throw new RuntimeException("Too long string in message. Offset goes over limit for message length.");
        }
        String string = null;
        try {
            string = new String(this.messageBytes, this.offset, n, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "ERROR";
        }
        this.offset += n;
        return string;
    }

    private void encodeInt(int n) {
        if (n < 0) {
            if (n > -64) {
                this.ensureCapacity(1);
                this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0x40);
            } else if (n > -8192) {
                this.ensureCapacity(2);
                this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0xC0);
                this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F);
            } else if (n > -1048576) {
                this.ensureCapacity(3);
                this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0xC0);
                this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F);
            } else if (n > -134217728) {
                this.ensureCapacity(4);
                this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0xC0);
                this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 20 & 0x7F);
            } else {
                this.ensureCapacity(5);
                this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0xC0);
                this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 20 & 0x7F | 0x80);
                this.messageBytes[this.offset++] = (byte)(n >> 27 & 0xF);
            }
        } else if (n < 64) {
            this.ensureCapacity(1);
            this.messageBytes[this.offset++] = (byte)(n & 0x3F);
        } else if (n < 8192) {
            this.ensureCapacity(2);
            this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F);
        } else if (n < 0x100000) {
            this.ensureCapacity(3);
            this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F);
        } else if (n < 0x8000000) {
            this.ensureCapacity(4);
            this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 20 & 0x7F);
        } else {
            this.ensureCapacity(5);
            this.messageBytes[this.offset++] = (byte)(n & 0x3F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 6 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 13 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 20 & 0x7F | 0x80);
            this.messageBytes[this.offset++] = (byte)(n >> 27 & 0xF);
        }
    }

    private int decodeNextInt() {
        byte by;
        int n = 0;
        if (((by = this.messageBytes[this.offset++]) & 0x40) == 0) {
            n |= by & 0x3F;
            if ((by & 0x80) != 0) {
                by = this.messageBytes[this.offset++];
                n |= (by & 0x7F) << 6;
                if ((by & 0x80) != 0) {
                    by = this.messageBytes[this.offset++];
                    n |= (by & 0x7F) << 13;
                    if ((by & 0x80) != 0) {
                        by = this.messageBytes[this.offset++];
                        n |= (by & 0x7F) << 20;
                        if ((by & 0x80) != 0) {
                            by = this.messageBytes[this.offset++];
                            n |= (by & 0x7F) << 27;
                        }
                    }
                }
            }
        } else {
            n |= by & 0x3F;
            if ((by & 0x80) != 0) {
                by = this.messageBytes[this.offset++];
                n |= (by & 0x7F) << 6;
                if ((by & 0x80) != 0) {
                    by = this.messageBytes[this.offset++];
                    n |= (by & 0x7F) << 13;
                    if ((by & 0x80) != 0) {
                        by = this.messageBytes[this.offset++];
                        n |= (by & 0x7F) << 20;
                        if ((by & 0x80) != 0) {
                            by = this.messageBytes[this.offset++];
                            n |= (by & 0x7F) << 27;
                            n |= Integer.MIN_VALUE;
                        } else {
                            n |= 0xF8000000;
                        }
                    } else {
                        n |= 0xFFF00000;
                    }
                } else {
                    n |= 0xFFFFE000;
                }
            } else {
                n |= 0xFFFFFFC0;
            }
        }
        return n;
    }

    private void encodeString(String string) {
        if (string == null) {
            this.encodeInt(0);
            return;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n = byArray.length;
        this.encodeInt(n);
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.messageBytes, this.offset, n);
        this.offset += n;
        this.bitOffset = 0;
    }

    private void ensureCapacity(int n) {
        if (this.offset + n > this.messageBytes.length) {
            byte[] byArray = this.messageBytes;
            this.messageBytes = new byte[this.messageBytes.length + n + this.getCapacityIncrement()];
            System.arraycopy(byArray, 0, this.messageBytes, 0, byArray.length);
        }
    }

    public short readShort() throws EOFException {
        throw new RuntimeException("Not supported.");
    }

    public int readUnsignedByte() throws EOFException {
        throw new RuntimeException("Not supported.");
    }

    public int readUnsignedShort() throws EOFException {
        throw new RuntimeException("Not supported.");
    }

    public void writeByte(int n) {
        throw new RuntimeException("Not supported.");
    }

    public void writeShort(int n) {
        throw new RuntimeException("Not supported.");
    }

    public void skip(int n) {
        throw new RuntimeException("Not supported.");
    }

    public int getType() {
        return this.messageType;
    }
}

