/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SimpleRenderingPlatform
implements IRenderingPlatform {
    private int[] mPolygonX;
    private int[] mPolygonY;
    private int[] mTriangleBuffer;
    private Graphics mGraphicsContext;
    private int mPivotX;
    private int mPivotY;
    private int[] smNokiaPolygonX;
    private int[] smNokiaPolygonY;
    private static int[] smPolygonEdge;
    private static int[] smEdgeStartY;
    private static int[] smEdgeEndY;
    private static int[] smEdgeStartX;
    private static int[] smEdgeDeltaX;
    private static int[] smStopPoint;
    private static final int BEZIER_POINT_PER_PIXELS = 8;
    private static int[] smBezierPolygon;
    private static final int BEZIER_STEP_FP = 15;
    private static IRenderingPlatform sm_renderingPlatform;

    public SimpleRenderingPlatform() {
        this.disableAllEffects();
    }

    public void setRotation(int n) {
    }

    public void setBlur(int n, int n2) {
    }

    public int getBlurWidth() {
        return 0;
    }

    public int getBlurHeight() {
        return 0;
    }

    public void drawImage(DChocImage dChocImage, int n, int n2, int n3, int n4) {
        Image image = dChocImage.getImage();
        if ((n4 & 1) != 0) {
            n -= dChocImage.getWidth() >> 1;
        } else if ((n4 & 8) != 0) {
            n -= dChocImage.getWidth();
        }
        if ((n4 & 2) != 0) {
            n2 -= dChocImage.getHeight() >> 1;
        } else if ((n4 & 0x20) != 0) {
            n2 -= dChocImage.getHeight();
        }
        n += this.getPivotX();
        n2 += this.getPivotY();
        boolean bl = dChocImage.isRegioned();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (bl) {
            int n9;
            int n10;
            n5 = this.mGraphicsContext.getClipX();
            n6 = this.mGraphicsContext.getClipY();
            n7 = this.mGraphicsContext.getClipWidth();
            n8 = this.mGraphicsContext.getClipHeight();
            int n11 = n;
            int n12 = n2;
            if ((n3 & 4) != 0 || (n3 & 0x10) != 0) {
                n10 = dChocImage.getRegionHeight();
                n9 = dChocImage.getRegionWidth();
            } else {
                n10 = dChocImage.getRegionWidth();
                n9 = dChocImage.getRegionHeight();
            }
            if (n11 + n10 <= n5 || n12 + n9 <= n6 || n11 >= n5 + n7 || n12 >= n6 + n8) {
                return;
            }
            this.mGraphicsContext.clipRect(n11, n12, n10, n9);
        }
        if (n3 != 0) {
            // empty if block
        }
        if (bl) {
            n -= dChocImage.getRegionX();
            n2 -= dChocImage.getRegionY();
        }
        this.mGraphicsContext.drawImage(image, n, n2, 20);
        if (bl) {
            this.mGraphicsContext.setClip(n5, n6, n7, n8);
        }
    }

    private DirectGraphics getDirectGraphics() {
        return null;
    }

    public int getRotation() {
        return 0;
    }

    public int getColorModification() {
        return -8355712;
    }

    public int getScaleWidth() {
        return 1024;
    }

    public int getScaleHeight() {
        return 1024;
    }

    public void setScale(int n, int n2) {
    }

    public void setRenderMode(int n) {
    }

    public int getRenderMode() {
        return 0;
    }

    public void disableAllEffects() {
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.setColorARGB((n & 0xFF) << 16 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF);
    }

    public void setColor(int n) {
        this.mGraphicsContext.setColor(n);
    }

    public void setColorARGB(int n) {
        this.mGraphicsContext.setColor(n);
    }

    public void setColorModification(int n, int n2, int n3, int n4) {
    }

    public void setColorModification(int n) {
    }

    public void setGraphicsContext(DChocImage dChocImage) {
        this.setGraphicsContext(dChocImage.getGraphics());
    }

    public void setGraphicsContext(Graphics graphics) {
        this.mGraphicsContext = graphics;
    }

    public Graphics getGraphicsContext() {
        return this.mGraphicsContext;
    }

    public void setColorKey(int n) {
    }

    public void setFiltering(int n, boolean bl) {
    }

    public void setPivot(int n, int n2) {
        this.mPivotX = n;
        this.mPivotY = n2;
    }

    public int getPivotX() {
        return this.mPivotX;
    }

    public int getPivotY() {
        return this.mPivotY;
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.mGraphicsContext.fillRect(n += this.getPivotX(), n2 += this.getPivotY(), n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.mGraphicsContext.drawLine(n += this.getPivotX(), n2 += this.getPivotY(), n3 += this.getPivotX(), n4 += this.getPivotY());
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.mGraphicsContext.drawRect(n += this.getPivotX(), n2 += this.getPivotY(), n3, n4);
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mTriangleBuffer == null) {
            this.mTriangleBuffer = new int[6];
        }
        this.mTriangleBuffer[0] = n;
        this.mTriangleBuffer[1] = n2;
        this.mTriangleBuffer[2] = n3;
        this.mTriangleBuffer[3] = n4;
        this.mTriangleBuffer[4] = n5;
        this.mTriangleBuffer[5] = n6;
        this.fillPolygon(this.mTriangleBuffer, 0, 3);
    }

    public void fillPolygon(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = this.getScaleWidth();
        int n14 = this.getScaleHeight();
        int n15 = this.getPivotX();
        int n16 = this.getPivotY();
        if (this.mPolygonX == null || this.mPolygonX.length < n2) {
            this.mPolygonX = new int[n2];
            this.mPolygonY = new int[n2];
        }
        int n17 = this.getRotation();
        int n18 = MathUtils.sin(n17);
        int n19 = MathUtils.cos(n17);
        int n20 = n;
        for (int i = 0; i < n2; ++i) {
            n12 = nArray[n20++] * n13 >> 10;
            n11 = nArray[n20++] * n14 >> 10;
            this.mPolygonX[i] = (n12 * n19 - n11 * n18 >> 15) + n15;
            this.mPolygonY[i] = (n11 * n19 + n12 * n18 >> 15) + n16;
        }
        if (n2 == 3) {
            // empty if block
        }
        if (smPolygonEdge == null || n2 > smPolygonEdge.length) {
            smPolygonEdge = new int[n2];
            smEdgeStartY = new int[n2];
            smEdgeEndY = new int[n2];
            smEdgeStartX = new int[n2];
            smEdgeDeltaX = new int[n2];
            smStopPoint = new int[n2];
        }
        n12 = Integer.MAX_VALUE;
        n11 = Integer.MAX_VALUE;
        int n21 = Integer.MIN_VALUE;
        int n22 = Integer.MIN_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        Object var20_19 = null;
        for (n10 = 0; n10 < n2; ++n10) {
            SimpleRenderingPlatform.smEdgeStartX[n10] = this.mPolygonX[n10] << 16;
            SimpleRenderingPlatform.smEdgeStartY[n10] = this.mPolygonY[n10];
        }
        for (n10 = 0; n10 < n2; ++n10) {
            n9 = n10 + 1;
            if (n9 == n2) {
                n9 = 0;
            }
            SimpleRenderingPlatform.smEdgeEndY[n10] = smEdgeStartY[n9];
            SimpleRenderingPlatform.smEdgeDeltaX[n10] = smEdgeStartX[n9];
        }
        n10 = 0;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = smEdgeEndY[n9] - smEdgeStartY[n9];
            if (n8 != 0) {
                if (n8 < 0) {
                    n7 = smEdgeStartY[n9];
                    SimpleRenderingPlatform.smEdgeStartY[n9] = smEdgeEndY[n9];
                    SimpleRenderingPlatform.smEdgeEndY[n9] = n7;
                    n7 = smEdgeStartX[n9];
                    SimpleRenderingPlatform.smEdgeStartX[n9] = smEdgeDeltaX[n9];
                    SimpleRenderingPlatform.smEdgeDeltaX[n9] = n7;
                    n8 = -n8;
                }
                int n23 = n9;
                smEdgeDeltaX[n23] = smEdgeDeltaX[n23] - smEdgeStartX[n9];
                int n24 = n9;
                smEdgeDeltaX[n24] = smEdgeDeltaX[n24] / n8;
            }
            n7 = smEdgeStartY[n9];
            n6 = smEdgeEndY[n9];
            n5 = 0;
            n4 = 0;
            n3 = n10;
            while (--n3 >= 0) {
                if (smStopPoint[n3] == n7) {
                    n5 = 1;
                }
                if (smStopPoint[n3] != n6) continue;
                n4 = 1;
            }
            if (n5 == 0) {
                SimpleRenderingPlatform.smStopPoint[n10++] = n7;
            }
            if (n4 != 0) continue;
            SimpleRenderingPlatform.smStopPoint[n10++] = n6;
        }
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = n9 + 1; n8 < n10; ++n8) {
                if (smStopPoint[n9] <= smStopPoint[n8]) continue;
                n7 = smStopPoint[n9];
                SimpleRenderingPlatform.smStopPoint[n9] = smStopPoint[n8];
                SimpleRenderingPlatform.smStopPoint[n8] = n7;
            }
        }
        n9 = smStopPoint[0];
        n8 = 1;
        n7 = -1;
        do {
            int n25;
            int n26;
            int n27;
            n6 = 0;
            n5 = n2;
            while (--n5 >= 0) {
                if (smEdgeStartY[n5] > n9 || smEdgeEndY[n5] <= n9) continue;
                SimpleRenderingPlatform.smPolygonEdge[n6++] = n5;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = n5 + 1; n4 < n6; ++n4) {
                    n3 = smPolygonEdge[n5];
                    n27 = smEdgeStartX[n3];
                    n26 = smPolygonEdge[n4];
                    n25 = smEdgeStartX[n26];
                    if (n27 <= n25 && (n27 != n25 || smEdgeDeltaX[n3] <= smEdgeDeltaX[n26])) continue;
                    SimpleRenderingPlatform.smPolygonEdge[n4] = n3;
                    SimpleRenderingPlatform.smPolygonEdge[n5] = n26;
                }
            }
            n5 = smStopPoint[n8++];
            if (n8 == n10) {
                ++n5;
            }
            while (n9 < n5) {
                n3 = Integer.MIN_VALUE;
                n27 = 0;
                while (n27 < n6) {
                    n26 = smPolygonEdge[n27++];
                    n25 = smEdgeStartX[n26];
                    int n28 = smPolygonEdge[n27++];
                    int n29 = smEdgeStartX[n28];
                    n25 = (n25 >> 16) + ((n25 & 0xFFFF) >> 15);
                    n29 = (n29 >> 16) + ((n29 & 0xFFFF) >> 15) + 1;
                    if (n25 < n3) {
                        n25 = n3;
                    }
                    n3 = n29;
                    this.mGraphicsContext.fillRect(n25, n9, n29 - n25, 1);
                    int n30 = n26;
                    smEdgeStartX[n30] = smEdgeStartX[n30] + smEdgeDeltaX[n26];
                    int n31 = n28;
                    smEdgeStartX[n31] = smEdgeStartX[n31] + smEdgeDeltaX[n28];
                }
                ++n9;
            }
        } while (n8 < n10);
    }

    public void fillEllipse(int n, int n2, int n3, int n4) {
        this.mGraphicsContext.fillArc(n += this.getPivotX(), n2 += this.getPivotY(), n3, n4, 0, 360);
    }

    public void fillBezier(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 2; ++i) {
            if (i == 1 && (smBezierPolygon == null || smBezierPolygon.length < n3 * 2)) {
                smBezierPolygon = new int[n3 * 2];
            }
            int n5 = n;
            for (int j = 0; j < n2; ++j) {
                int n6;
                int n7 = nArray[n5];
                int n8 = nArray[n5 + 1];
                int n9 = nArray[n5 + 4];
                int n10 = nArray[n5 + 5];
                n5 = n6 = n5 + 6;
                if (j == n2 - 1) {
                    n6 = n;
                }
                int n11 = nArray[n6 + 2];
                int n12 = nArray[n6 + 3];
                int n13 = nArray[n6];
                int n14 = nArray[n6 + 1];
                if (n7 == n9 && n8 == n10 && n11 == n13 && n12 == n14) {
                    if (i == 0) {
                        ++n3;
                        continue;
                    }
                    SimpleRenderingPlatform.smBezierPolygon[n4++] = (short)n7;
                    SimpleRenderingPlatform.smBezierPolygon[n4++] = (short)n8;
                    continue;
                }
                int n15 = this.getRange(n7 - n9, n8 - n10);
                n15 += this.getRange(n9 - n11, n10 - n12);
                int n16 = n15 = (n15 += this.getRange(n11 - n13, n12 - n14)) > 8 ? n15 / 8 : 1;
                if (i == 0) {
                    n3 += n15;
                    continue;
                }
                int n17 = 32768 / n15;
                int n18 = 0;
                for (int k = 0; k < n15; ++k) {
                    SimpleRenderingPlatform.smBezierPolygon[n4++] = (short)this.bezierPoint(n7, n9, n11, n13, n18);
                    SimpleRenderingPlatform.smBezierPolygon[n4++] = (short)this.bezierPoint(n8, n10, n12, n14, n18);
                    n18 += n17;
                }
            }
        }
        this.fillPolygon(smBezierPolygon, 0, n3);
    }

    public int getFilters() {
        return 0;
    }

    public boolean isFilterEnabled(int n) {
        return false;
    }

    public void setFilters(int n) {
    }

    public void popParameters() {
    }

    public void pushParameters() {
    }

    public boolean isFrameUpToDate(DChocImage dChocImage) {
        return true;
    }

    public int getClipHeight() {
        return this.mGraphicsContext.getClipHeight();
    }

    public int getClipWidth() {
        return this.mGraphicsContext.getClipWidth();
    }

    public int getClipX() {
        return this.mGraphicsContext.getClipX();
    }

    public int getClipY() {
        return this.mGraphicsContext.getClipY();
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.mGraphicsContext.setClip(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.getClipX();
        int n7 = this.getClipY();
        int n8 = this.getClipWidth();
        int n9 = this.getClipHeight();
        if (n + n3 <= n6 || n2 + n4 <= n7 || n >= n6 + n8 || n2 >= n7 + n9) {
            this.mGraphicsContext.setClip(n6, n7, 0, 0);
            return;
        }
        int n10 = n + n3;
        if (n10 > n6 + n8) {
            n10 = n6 + n8;
        }
        if (n < n6) {
            n = n6;
        }
        if ((n5 = n2 + n4) > n7 + n9) {
            n5 = n7 + n9;
        }
        if (n2 < n7) {
            n2 = n7;
        }
        this.mGraphicsContext.setClip(n, n2, n10 - n, n5 - n2);
    }

    public int getColor() {
        return this.mGraphicsContext.getColor();
    }

    private int getRange(int n, int n2) {
        n2 = Math.abs(n2);
        if ((n = Math.abs(n)) > n2) {
            return n + (n2 * 106 >> 8);
        }
        return n2 + (n * 106 >> 8);
    }

    private int bezierPoint(int n, int n2, int n3, int n4, int n5) {
        int n6 = 32768 - n5;
        int n7 = n6 * n6 >> 15;
        int n8 = n5 * n5 >> 15;
        return (n7 * n6 >> 15) * n + (3 * n5 * n7 >> 15) * n2 + (3 * n8 * n6 >> 15) * n3 + (n8 * n5 >> 15) * n4 >> 15;
    }

    public void makeImageTransparent(DChocImage dChocImage, int n, int n2) {
    }

    public void platformBeginFrame(Graphics graphics) {
    }

    public void platformEndFrame() {
    }

    public static IRenderingPlatform getRenderingPlatform() {
        if (sm_renderingPlatform == null) {
            sm_renderingPlatform = new SimpleRenderingPlatform();
        }
        return sm_renderingPlatform;
    }
}

