/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimationFrame {
    private int mWidth;
    private int mHeight;
    private CollisionBox[] mCollisionBox;
    private int[][] mRenderable;
    public static final int MAX_DURATION = Integer.MAX_VALUE;
    private static Hashtable smDirectGraphics;
    private DChocImage mFrameBuffer;
    private static Vector smFrameBufferCacheFree;
    private Animation mParentAnimation;
    private static final CollisionBox[] COLLISION_BOX_COUNT_0;
    private static final int[][] RENDERABLE_COUNT_0;
    private static int[] smImageCacheReturnValue;

    public AnimationFrame(boolean bl, Animation animation) {
        if (bl) {
            this.mCollisionBox = COLLISION_BOX_COUNT_0;
            this.mRenderable = RENDERABLE_COUNT_0;
        }
        this.mParentAnimation = animation;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setWidth(int n) {
        this.mWidth = n;
    }

    public void setHeight(int n) {
        this.mHeight = n;
    }

    public void loadFrameData(DataInputStream dataInputStream, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (bl) {
            this.mWidth = dataInputStream.read();
            this.mHeight = dataInputStream.read();
        } else {
            this.mWidth = dataInputStream.readShort();
            this.mHeight = dataInputStream.readShort();
        }
        int n6 = dataInputStream.read();
        this.mCollisionBox = n6 == 0 ? COLLISION_BOX_COUNT_0 : new CollisionBox[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            short s;
            n4 = dataInputStream.read();
            if (bl) {
                n3 = dataInputStream.readByte();
                s = dataInputStream.readByte();
                n2 = dataInputStream.read();
                n = dataInputStream.read();
            } else {
                n3 = dataInputStream.readShort();
                s = dataInputStream.readShort();
                n2 = dataInputStream.readShort();
                n = dataInputStream.readShort();
            }
            this.mCollisionBox[n5] = new CollisionBox(n3, s, n2, n, n4);
        }
        n5 = dataInputStream.readShort();
        this.mRenderable = n5 == 0 ? RENDERABLE_COUNT_0 : (int[][])new int[n5][];
        for (n3 = 0; n3 < n5; ++n3) {
            int n7;
            int n8;
            int n9;
            int[] nArray = null;
            n2 = dataInputStream.read();
            if (n2 == 1) {
                nArray = new int[5];
                if (bl) {
                    nArray[1] = dataInputStream.readByte();
                    nArray[2] = dataInputStream.readByte();
                } else {
                    nArray[1] = dataInputStream.readShort();
                    nArray[2] = dataInputStream.readShort();
                }
                n = dataInputStream.read();
                n4 = (n >> 4) + 1;
                n9 = n & 0xF;
                n8 = dataInputStream.readInt();
                n7 = dataInputStream.read();
                DavinciUtilities.loadImageIntoCache(n8, n7, n9, n4, bl2, smImageCacheReturnValue);
                nArray[3] = smImageCacheReturnValue[0];
                nArray[4] = smImageCacheReturnValue[1];
            } else if (n2 == 9) {
                nArray = new int[5];
                if (bl) {
                    nArray[1] = dataInputStream.readByte();
                    nArray[2] = dataInputStream.readByte();
                } else {
                    nArray[1] = dataInputStream.readShort();
                    nArray[2] = dataInputStream.readShort();
                }
                dataInputStream.read();
                n = dataInputStream.readInt();
                nArray[4] = DavinciUtilities.loadAnimationIntoCache(n, bl2);
            } else if (n2 == 7) {
                nArray = new int[5];
                if (bl) {
                    nArray[1] = dataInputStream.readByte();
                    nArray[2] = dataInputStream.readByte();
                    nArray[3] = dataInputStream.read();
                    nArray[4] = dataInputStream.read();
                } else {
                    nArray[1] = dataInputStream.readShort();
                    nArray[2] = dataInputStream.readShort();
                    nArray[3] = dataInputStream.readShort();
                    nArray[4] = dataInputStream.readShort();
                }
            } else {
                n = 0xFF000000 | dataInputStream.read() << 16 | dataInputStream.read() << 8 | dataInputStream.read();
                n4 = 0;
                n9 = 2;
                if (n2 == 8 || n2 == 6) {
                    if (n2 == 8) {
                        n9 = 6;
                    }
                    n4 = 1;
                } else {
                    nArray = new int[6];
                }
                if (bl) {
                    if (n4 != 0) {
                        n8 = dataInputStream.read();
                        nArray = new int[3 + n8 * n9];
                        nArray[2] = n8;
                        n8 *= n9;
                        for (n7 = 0; n7 < n8; ++n7) {
                            nArray[3 + n7] = dataInputStream.readByte();
                        }
                    } else {
                        nArray[2] = dataInputStream.readByte();
                        nArray[3] = dataInputStream.readByte();
                        nArray[4] = dataInputStream.read();
                        nArray[5] = dataInputStream.read();
                    }
                } else {
                    n8 = 4;
                    n7 = 2;
                    if (n4 != 0) {
                        n8 = dataInputStream.read();
                        nArray = new int[3 + n8 * n9];
                        nArray[2] = n8;
                        n7 = 3;
                        n8 *= n9;
                    }
                    for (int i = 0; i < n8; ++i) {
                        nArray[n7 + i] = dataInputStream.readShort();
                    }
                }
                nArray[1] = n;
            }
            nArray[0] = n2;
            this.mRenderable[n3] = nArray;
        }
    }

    public void doDraw(Graphics graphics, int n, int n2, int n3) {
        Toolkit.getRenderingPlatform().setGraphicsContext(graphics);
        this.doDraw(n, n2, n3);
    }

    public void doDraw(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        int n8 = iRenderingPlatform.getPivotX();
        int n9 = iRenderingPlatform.getPivotY();
        iRenderingPlatform.setPivot(n, n2);
        int n10 = this.mRenderable.length;
        for (int i = 0; i < n10; ++i) {
            Object object;
            int n11;
            int n12;
            int n13;
            int[] nArray = this.mRenderable[i];
            int n14 = nArray[0];
            if (n14 == 1) {
                n13 = nArray[1];
                n12 = nArray[2];
                n11 = nArray[3];
                object = DavinciUtilities.getImageFromCache(n11);
                int n15 = 0;
                int n16 = 0;
                if (n15 & true) {
                    n16 = 1;
                }
                if ((n15 & 2) != 0) {
                    n16 |= 2;
                }
                iRenderingPlatform.drawImage((DChocImage)object, n13, n12, n16, 20);
                continue;
            }
            if (n14 == 7) {
                if (!bl) {
                    bl = true;
                    n4 = iRenderingPlatform.getClipX();
                    n5 = iRenderingPlatform.getClipY();
                    n6 = iRenderingPlatform.getClipWidth();
                    n7 = iRenderingPlatform.getClipHeight();
                } else {
                    iRenderingPlatform.setClip(n4, n5, n6, n7);
                }
                iRenderingPlatform.clipRect(nArray[1] + n, nArray[2] + n2, nArray[3], nArray[4]);
                continue;
            }
            if (n14 == 9) {
                n13 = nArray[1] + n;
                n12 = nArray[2] + n2;
                n11 = nArray[4];
                object = DavinciUtilities.getSpriteObjectFromCache(n11);
                Animation animation = ((SpriteObject)object).getCurrentAnimationData();
                if (n13 - animation.getX() + animation.getWidth() <= iRenderingPlatform.getClipX() || n12 - animation.getY() + animation.getHeight() <= iRenderingPlatform.getClipY() || n13 - animation.getX() >= iRenderingPlatform.getClipX() + iRenderingPlatform.getClipWidth() || n12 - animation.getY() >= iRenderingPlatform.getClipY() + iRenderingPlatform.getClipHeight()) continue;
                ((SpriteObject)object).setAnimation(0, -2, false);
                ((SpriteObject)object).setElapsedTime(n3);
                ((SpriteObject)object).draw(n13, n12);
                continue;
            }
            iRenderingPlatform.setColorARGB(nArray[1]);
            if (n14 == 2) {
                iRenderingPlatform.fillRect(nArray[2], nArray[3], nArray[4], nArray[5]);
                continue;
            }
            if (n14 == 6) {
                iRenderingPlatform.fillPolygon(nArray, 3, nArray[2]);
                continue;
            }
            iRenderingPlatform.fillBezier(nArray, 3, nArray[2]);
        }
        if (bl) {
            iRenderingPlatform.setClip(n4, n5, n6, n7);
        }
        iRenderingPlatform.setPivot(n8, n9);
    }

    public CollisionBox[] getCollisionBoxes() {
        return this.mCollisionBox;
    }

    public CollisionBox getCollisionBox(int n) {
        int n2 = this.mCollisionBox.length;
        while (--n2 >= 0) {
            int n3 = this.mCollisionBox[n2].getId();
            if (n3 != n) continue;
            return this.mCollisionBox[n2];
        }
        return null;
    }

    public int[][] getRenderables() {
        return this.mRenderable;
    }

    public DChocImage getGraphicsBuffer() {
        if (this.mFrameBuffer == null) {
            this.mFrameBuffer = this.getNewGraphicsBuffer();
        }
        return this.mFrameBuffer;
    }

    public boolean hasNestedAnimations() {
        int[][] nArray = this.getRenderables();
        int n = nArray.length;
        while (--n >= 0) {
            int[] nArray2 = nArray[n];
            int n2 = nArray2[0];
            if (n2 != 9) continue;
            return true;
        }
        return false;
    }

    public void freeFrameBufferResources() {
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer = null;
        }
    }

    private DChocImage getNewGraphicsBuffer() {
        int n = this.mParentAnimation.getWithoutTimelineWidth();
        int n2 = this.mParentAnimation.getWithoutTimelineHeight();
        return new DChocImage(n, n2);
    }

    static {
        COLLISION_BOX_COUNT_0 = new CollisionBox[0];
        RENDERABLE_COUNT_0 = new int[0][];
        smImageCacheReturnValue = new int[2];
    }
}

