/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DCHook
extends DChocMIDlet
implements ApplicationControl {
    private FlowProcessor mGameFlowProcessor;
    private FlowProcessor mCurrentFlowProcessor;
    private FlowProcessor mNextFlowProcessor;
    private boolean mInitialized;
    private boolean mLoading;
    private int mMaxLoadingCount;
    private int mLoadingCounter;
    private int mInitialFlowLoadingPercentage;
    private boolean mSoftKeysInitialized;
    private Image mPreviewImage;
    private ImageFont mTextImageFont;
    private ImageFont mSelectionImageFont;
    private ImageFont mTitleBarImageFont;
    private Image mLetterBoxImage;
    private int totalHeap;
    private int avaiHeap;
    private int usedHeap;

    public void logicUpdate(int n) {
        block6: {
            try {
                if (!this.mInitialized) {
                    this.initialize();
                    return;
                }
                Displace.logicUpdate(n);
                if (this.mNextFlowProcessor != this.mCurrentFlowProcessor) {
                    this.mCurrentFlowProcessor = this.mNextFlowProcessor;
                }
                if (this.mCurrentFlowProcessor != null) {
                    this.mCurrentFlowProcessor.logicUpdate(n);
                    if (this.mInitialFlowLoadingPercentage != -1) {
                        this.mInitialFlowLoadingPercentage = this.mCurrentFlowProcessor.getLoadingPercentage();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("*** logic Exception ***");
                exception.printStackTrace();
                if (!Debug.CATCH) break block6;
                Debug.setCatch(new String[]{"logicExcept", exception.toString(), Debug.smLastMethodStrs[Debug.smLastMethodInfo] + " " + Debug.smLastMethodPos + " AppState " + Game.mCurrentState});
            }
        }
    }

    private void initialize() {
        if (!this.mLoading) {
            this.mMaxLoadingCount = 6;
            this.mLoadingCounter = 0;
            this.mLoading = true;
            return;
        }
        if (this.mLoadingCounter < this.mMaxLoadingCount) {
            switch (this.mLoadingCounter) {
                case 0: {
                    this.initializeGraphics();
                    break;
                }
                case 1: {
                    this.initializeFonts();
                    break;
                }
                case 2: {
                    this.initializeScrollArrows();
                    break;
                }
                case 3: {
                    this.mGameFlowProcessor = new FlowProcessor(65536, new Game(this, this.mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont));
                    break;
                }
                case 4: {
                    this.initializeSoftkeys();
                    break;
                }
                case 5: {
                    for (int i = 0; i < DavinciUtilities.getAdditionalLoadingCount(); ++i) {
                        DavinciUtilities.loadNext();
                    }
                    break;
                }
            }
            ++this.mLoadingCounter;
        } else {
            this.mInitialized = true;
            this.mLoading = false;
            this.mNextFlowProcessor = this.mGameFlowProcessor;
            this.resetTimer();
        }
    }

    private void initializeGraphics() {
        DavinciUtilities.initialize();
    }

    private void initializeFonts() {
        try {
            Image image = null;
            Image image2 = null;
            Image image3 = null;
            Font font = Toolkit.getFont(32, 0, 8);
            Font font2 = Toolkit.getFont(32, 1, 8);
            Font font3 = Toolkit.getFont(32, 1, 0);
            this.mTextImageFont = new ImageFont(image, null, font, 0xFFFFFF, -1);
            this.mSelectionImageFont = new ImageFont(image2, null, font2, 0xFFFFFF, 0);
            this.mTitleBarImageFont = new ImageFont(image3, null, font3, 0xFFFF00, 0);
            MenuObject.setDefaultImageFonts(this.mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initializeScrollArrows() {
        Animation[] animationArray = DavinciUtilities.loadAnimations(new int[]{458757, 458759, 458758});
        Animation[] animationArray2 = DavinciUtilities.loadAnimations(new int[]{458760, 458762, 458761});
        MenuObject.setScrollArrowsDvc(new SpriteObject(animationArray, true), new SpriteObject(animationArray2, true));
    }

    private void initializeSoftkeys() {
        if (this.mSoftKeysInitialized) {
            return;
        }
        byte[] byArray = Toolkit.getResourceBytes(10092550);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            int n3 = FlowProcessor.loadResourceID(byArray, n2);
            n2 += 4;
            boolean bl = byArray[n2++] == 1;
            int n4 = FlowProcessor.loadResourceID(byArray, n2);
            n2 += 4;
            byte by2 = byArray[n2++];
            Image image = null;
            if (n4 != -1) {
                image = bl ? DavinciUtilities.getImage(n4) : Toolkit.getImage(n4);
            }
            Toolkit.createSoftKey(by, n3, image, by2);
        }
        this.mSoftKeysInitialized = true;
    }

    public void doPostDraw(Graphics graphics) {
        if (this.mCurrentFlowProcessor != null) {
            this.mCurrentFlowProcessor.doPostDraw(graphics);
        }
    }

    public void doDraw(Graphics graphics) {
        block8: {
            try {
                if (this.mLoading) {
                    DCHook.drawLoadingScreen(graphics, this.mLoadingCounter * 50 / this.mMaxLoadingCount);
                } else if (this.mCurrentFlowProcessor != null) {
                    if (this.mInitialFlowLoadingPercentage != -1) {
                        DCHook.drawLoadingScreen(graphics, 50 + (this.mInitialFlowLoadingPercentage >> 1));
                    } else {
                        this.mCurrentFlowProcessor.doDraw(graphics);
                    }
                }
                if (Debug.CATCH) {
                    graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                    Debug.doDraw(graphics);
                }
            }
            catch (Exception exception) {
                System.out.println("*** render Exception ***");
                exception.printStackTrace();
                if (!Debug.CATCH) break block8;
                Debug.setCatch(new String[]{"renderExcept", exception.toString(), Debug.smLastMethodStrs[Debug.smLastMethodInfo]});
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                Debug.doDraw(graphics);
            }
        }
    }

    public void keyEventOccurred(int n, int n2) {
        try {
            if (this.mLoading) {
                return;
            }
            if (this.mCurrentFlowProcessor != null) {
                this.mCurrentFlowProcessor.keyEventOccurred(n, n2);
            }
        }
        catch (Exception exception) {
            System.out.println("*** keyEventOccurred Exception ***");
            exception.printStackTrace();
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentFlowProcessor != null) {
            this.mCurrentFlowProcessor.pointerEventOccurred(n, n2, n3);
        }
    }

    public void appEventOccurred(int n) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentFlowProcessor != null) {
            if (n == 1) {
                this.mCurrentFlowProcessor.pause();
            } else if (n == 5) {
                this.mCurrentFlowProcessor.licenseManagerActivated();
            } else if (n == 4) {
                this.mCurrentFlowProcessor.screenSizeChanged();
            }
        }
    }

    public String[][] getHighscoreTables() {
        return new String[][]{{Toolkit.getText(-2)}};
    }

    public String getFormattedScore(int n, int n2, int n3) {
        return "" + n3;
    }

    public void switchFlowProcessor(int n) {
        this.mNextFlowProcessor = this.mGameFlowProcessor;
    }

    public void setLanguage(int n) {
        if (this.mInitialized) {
            this.mGameFlowProcessor.languageChanged();
        }
        Toolkit.setSelectedLanguage(n);
        this.mSoftKeysInitialized = false;
        this.initializeSoftkeys();
    }

    public static void drawLoadingScreen(Graphics graphics, int n) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        int n2 = Toolkit.getScreenWidth() * 88 / 176;
        int n3 = (Toolkit.getScreenHeight() << 3) / 208;
        if (n3 < 5) {
            n3 = 5;
        }
        int n4 = Toolkit.getScreenWidth() - n2 >> 1;
        int n5 = Toolkit.getScreenHeight() - n3 >> 1;
        int n6 = (n2 - 4) * n / 100;
        graphics.setColor(0);
        graphics.drawRect(n4, n5, n2 - 1, n3 - 1);
        graphics.fillRect(n4 + 2, n5 + 2, n6, n3 - 4);
    }

    public void drawLetterBox(Graphics graphics, int n, int n2, int n3) {
    }

    public void controllerEventOccurred(int n, int n2, int n3, int n4, int n5) {
        if (this.mCurrentFlowProcessor != null) {
            this.mCurrentFlowProcessor.controllerEventOccurred(n, n2, n3, n4, n5);
        }
    }
}

