/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class DChocMIDlet
extends MIDlet
implements Runnable {
    public static final int APP_EVENT_PAUSE = 0;
    public static final int APP_EVENT_RESUME = 1;
    public static final int APP_EVENT_START = 2;
    public static final int APP_EVENT_EXIT = 3;
    public static final int APP_EVENT_SCREEN_SIZE_CHANGED = 4;
    public static final int APP_EVENT_MOUSE_ENTERED = 5;
    public static final int APP_EVENT_MOUSE_EXITED = 6;
    public static final int APP_EVENT_ACTIVATE_CONTROLLER = 7;
    public static final int APP_EVENT_ACTIVATE_LICENSE_MANAGER = 5;
    public static final int LETTERBOX_TOP = 0;
    public static final int LETTERBOX_BOTTOM = 1;
    public static final int LETTERBOX_LEFT = 2;
    public static final int LETTERBOX_RIGHT = 3;
    public static final int TOUCH_INDEX_X = 0;
    public static final int TOUCH_INDEX_Y = 1;
    public static final int TOUCH_INDEX_EVENT = 2;
    public static final int TOUCH_INDEX_ID = 3;
    public static final int TOUCH_EVENT_PRESSED = 0;
    public static final int TOUCH_EVENT_RELEASED = 1;
    public static final int TOUCH_EVENT_DRAGGED = 2;
    public static final int GESTURE_INDEX_MULTI_DRAG_DELTA_X = 0;
    public static final int GESTURE_INDEX_MULTI_DRAG_DELTA_Y = 1;
    public static final int GESTURE_INDEX_SCALE = 2;
    public static final int GESTURE_INDEX_ROTATION = 3;
    public static final int GESTURE_FIXED_POINT_ACCURACY = 10;
    private static final int MAX_DELTA_TIME = 500;
    private static final int DELTA_AVG_FRAME_COUNT_SHIFT = 3;
    private static final int DELTA_AVG_FRAME_COUNT = 8;
    private static final int INITIAL_DELTA_TIME = 40;
    private long m_previousTime;
    private int m_currentDeltaTimeTableIndex;
    private int[] m_deltaTimeTable;
    private int m_cumulativeDeltaTime;
    private boolean m_appStarted;
    private boolean m_initialized;
    protected boolean m_exitApplication;
    private boolean m_beingDestroyed;
    private boolean m_appPaused;
    private boolean m_resumeApplication;
    private boolean m_callSeriallyCalled;
    private static DChocMIDlet sm_instance;
    private static Thread sm_mainLoop;
    private static boolean sm_skipManualPause;
    private static boolean sm_skipLoop;
    private static boolean sm_skipTimer;
    private boolean m_skipLogicUpdate;
    private static final int GAME_ACTION_ID_NONE = -100;
    private boolean isCallInterrupted = false;
    private static int fps;
    private static boolean sm_disclaimerScreenActive;
    private static int sm_disclaimerScreenTimer;
    private static boolean sm_disclaimerTimerDisabled;
    private static boolean sm_disclaimerSkipPressed;

    protected DChocMIDlet() {
        sm_instance = this;
        Toolkit.create(this);
    }

    public static DChocMIDlet getInstance() {
        return sm_instance;
    }

    protected void setCallInterrupted(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (!this.isCallInterrupted) {
                if (!this.m_initialized) {
                    this.m_deltaTimeTable = new int[8];
                    this.resetTimer();
                    Toolkit.initialize();
                    this.appEventOccurred(2);
                    this.m_initialized = true;
                }
                if (this.m_resumeApplication) {
                    this.appEventOccurred(1);
                    Toolkit.toolkitEventOccurred(1);
                    this.m_appPaused = false;
                    this.m_resumeApplication = false;
                    Toolkit.doRepaint();
                }
                if (sm_disclaimerScreenActive) {
                    // empty if block
                }
                if (!this.m_appPaused && !this.m_exitApplication) {
                    int n = this.updateTimer();
                    if (!sm_skipTimer) {
                        Toolkit.getLicenseManager().updateTimer(this.getRealDeltaTime());
                    }
                    sm_skipTimer = false;
                    System.gc();
                    Toolkit.processBufferedKeyEvent();
                    if (!this.m_skipLogicUpdate) {
                        this.logicUpdate(n);
                    }
                    Toolkit.toolkitEventOccurred(2);
                    Toolkit.doRepaint();
                }
                Thread.yield();
            } else {
                Toolkit.stopSoundEffect();
                Toolkit.stopMusic();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (!this.m_exitApplication && !this.m_appPaused) {
                Display.getDisplay((MIDlet)this).callSerially((Runnable)this);
            } else {
                DChocMIDlet dChocMIDlet = this;
                synchronized (dChocMIDlet) {
                    this.m_callSeriallyCalled = false;
                }
            }
        }
        if (this.m_exitApplication && !this.m_beingDestroyed) {
            Toolkit.stopSoundEffect();
            Toolkit.stopMusic();
            this.appEventOccurred(3);
            this.notifyDestroyed();
        }
    }

    public static int getFPS() {
        return fps;
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        Toolkit.stopSoundEffect();
        Toolkit.stopMusic();
        this.m_beingDestroyed = bl;
        this.m_exitApplication = true;
        if (bl) {
            this.appEventOccurred(3);
            try {
                if (sm_mainLoop != null) {
                    sm_mainLoop.join();
                    sm_mainLoop = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void pauseApp() {
        if (!this.m_appPaused) {
            Toolkit.pauseMusic();
            Toolkit.stopSoundEffect();
            this.appEventOccurred(0);
            Toolkit.toolkitEventOccurred(0);
            this.m_appPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startApp() throws MIDletStateChangeException {
        if (this.m_appStarted && this.m_appPaused) {
            this.m_previousTime = System.currentTimeMillis();
            this.m_resumeApplication = true;
            DChocMIDlet dChocMIDlet = this;
            synchronized (dChocMIDlet) {
                if (this.m_appPaused && !this.m_callSeriallyCalled) {
                    this.m_callSeriallyCalled = true;
                    Display.getDisplay((MIDlet)this).callSerially((Runnable)this);
                }
            }
        }
        if (!this.m_appStarted) {
            Toolkit.setVisible(true);
            DChocMIDlet dChocMIDlet = this;
            synchronized (dChocMIDlet) {
                if (!this.m_callSeriallyCalled) {
                    this.m_callSeriallyCalled = true;
                    Display.getDisplay((MIDlet)this).callSerially((Runnable)this);
                }
            }
            this.m_appStarted = true;
        }
    }

    public abstract void doDraw(Graphics var1);

    public abstract void logicUpdate(int var1);

    public abstract void keyEventOccurred(int var1, int var2);

    public abstract void pointerEventOccurred(int var1, int var2, int var3);

    public abstract void appEventOccurred(int var1);

    public void touchEventOccurred(int[][] nArray, int[] nArray2) {
    }

    public void keyEventOccurred(int n, int n2, int n3, char[] cArray) {
    }

    public abstract String[][] getHighscoreTables();

    public abstract String getFormattedScore(int var1, int var2, int var3);

    public String getApplicationID() {
        return "4";
    }

    public String getApplicationName() {
        return Toolkit.getText(88);
    }

    public IMenu getNewMenuObject() {
        return new MenuObject();
    }

    public void resetTimer() {
        this.m_previousTime = System.currentTimeMillis();
        this.m_currentDeltaTimeTableIndex = 0;
        for (int i = 0; i < 8; ++i) {
            this.m_deltaTimeTable[i] = 40;
        }
        this.m_cumulativeDeltaTime = 320;
    }

    protected int updateTimer() {
        long l = System.currentTimeMillis();
        int n = (int)(l - this.m_previousTime);
        this.m_previousTime = l;
        this.m_cumulativeDeltaTime -= Math.min(this.m_deltaTimeTable[this.m_currentDeltaTimeTableIndex], 500);
        this.m_cumulativeDeltaTime += Math.min(n, 500);
        this.m_deltaTimeTable[this.m_currentDeltaTimeTableIndex] = n;
        this.m_currentDeltaTimeTableIndex = this.m_currentDeltaTimeTableIndex + 1 & 7;
        return this.m_cumulativeDeltaTime >> 3;
    }

    public int getRealDeltaTime() {
        int n = this.m_currentDeltaTimeTableIndex - 1;
        if (n < 0) {
            n = 7;
        }
        return this.m_deltaTimeTable[n];
    }

    public void drawLetterBox(Graphics graphics, int n, int n2, int n3) {
    }

    public void doPostDraw(Graphics graphics) {
    }

    public void drawCustomSoftkeyArea(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void drawMouseCursor(Graphics graphics, int n, int n2) {
    }

    public void start() {
    }

    public void resume() {
    }

    public static void setCurrent(Displayable displayable) {
        Display.getDisplay((MIDlet)sm_instance).setCurrent(displayable);
    }

    public static boolean openBrowser(String string) {
        boolean bl = true;
        try {
            boolean bl2 = false;
            bl2 = sm_instance.platformRequest(string);
            if (bl2) {
                sm_instance.destroyApp(false);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void exitApplication() {
        this.m_exitApplication = true;
    }

    public static void skipManualPause() {
        sm_skipManualPause = true;
    }

    protected void checkManualPause() {
        if (!sm_skipManualPause && this.getRealDeltaTime() > 2000) {
            Toolkit.pauseMusic();
            Toolkit.stopSoundEffect();
            this.appEventOccurred(0);
            Toolkit.toolkitEventOccurred(0);
            this.appEventOccurred(1);
            Toolkit.toolkitEventOccurred(1);
        }
        sm_skipManualPause = false;
    }

    public static void skipLoop() {
        sm_skipLoop = true;
    }

    public static void skipTimer() {
        sm_skipTimer = true;
    }

    public void controllerEventOccurred(int n, int n2, int n3, int n4, int n5) {
        Toolkit.translateControllerEventToKeyEvent(n2, n3, n4, n5);
    }

    public int mapControllerEventToGameAction(int n) {
        switch (n) {
            case -1000: {
                return 50;
            }
            case -1001: {
                return 56;
            }
            case -1002: {
                return 52;
            }
            case -1003: {
                return 54;
            }
            case -1004: {
                return 53;
            }
            case -1005: {
                return 42;
            }
            case -1006: {
                return 35;
            }
            case -1007: {
                return 48;
            }
        }
        return -100;
    }

    public void skipLogicUpdate(boolean bl) {
        this.m_skipLogicUpdate = bl;
        Toolkit.pauseMusic();
        Toolkit.stopSoundEffect();
    }

    public int iRegGetConfiguration() {
        return 1;
    }

    public boolean iRegWillShowPopup() {
        return true;
    }

    public void iRegNotifyRegistrationEvent(boolean bl, boolean bl2) {
    }

    public static boolean isDisclaimerScreenActive() {
        return sm_disclaimerScreenActive;
    }

    public static void enableDisclaimerTimer(boolean bl) {
        sm_disclaimerTimerDisabled = !bl;
    }

    public static void skipDisclaimer() {
        sm_disclaimerSkipPressed = true;
    }
}

