/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameEngine {
    public static int smPlayMode;
    public static final int PLAY_MODE_TOURNAMENT = 0;
    public static final int PLAY_MODE_QUICK = 1;
    public static ImageFont smFontTitle;
    public static ImageFont smFontOutline;
    public static ImageFont smFontPlain;
    private static String[] smTotalStr;
    public static boolean smRoundCompletedSuccessful;
    private static SpriteObject[] smCountDownSpr;
    private Displace mFadeDisplace = new Displace();
    private static SpriteObject smResultsPlatSpr;
    private static boolean smPlayerWins;
    public static int smBaitCurrent;
    public static int smLineStrengthCurrent;
    public static int smLineLengthCurrent;
    public static final int GAME_WORLD_NO_EVENT = -1;
    public static final int GAME_WORLD_EVENT_MATCH_OVER = 1;
    public static World mGameWorld;
    private Game smGame;
    public static boolean mGameStarts;
    private int smTotalFishCollected;
    public static boolean smInterruptInResults;
    public static boolean smInterruptOccurred;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_PAUSED = 1;
    public static final int EVENT_COMPLETED = 2;
    public static final int KEY_LEFT_MASK = 1;
    public static final int KEY_RIGHT_MASK = 2;
    public static final int KEY_UP_MASK = 4;
    public static final int KEY_DOWN_MASK = 8;
    public static final int KEY_ACTION_MASK = 16;
    private int mKeys;
    private int mKeyPresses;
    private int mPressedSK = -1;
    private int mActionSK = -1;
    public static int smGameState;
    private int mNextGameState;
    private static int mPlayState;
    private int mUpdateTimer;
    private static final int MIN_UPDATE_TIME = 16;
    private static final int MAX_UPDATE_TIME = 333;
    private static final int GS_NONE = -1;
    private static final int GS_GAME_STARTING = 0;
    private static final int GS_GAME_INTRO_IN = 1;
    private static final int GS_GAME_COUNT_DOWN = 2;
    public static final int GS_GAME_RUNNING = 3;
    private static final int GS_GAME_TIME_UP = 4;
    public static final int GS_GAME_INTRO_OUT = 5;
    private static final int GS_GAME_FISH_GALLERY_UPDATED = 6;
    public static final int GS_GAME_COMPLETED = 7;
    private boolean mCheatsEnabled;
    private boolean mUpdateSoftKeys;
    static int smGameTime;
    static int smLastPhysicsUpdate;
    static int smPhysicsUpdateFreq;
    private static final int ACCELEROMETER_CHARGE_MAX_X = -200;
    private static final int ACCELEROMETER_THROW_MIN_X = 200;
    private static final int ACCELEROMETER_REEL_MAX_X = -200;
    public static int smDebugAccelX;
    public static int smDebugAccelY;
    public static int smDebugAccelZ;
    private static Displace smBoatDisplaceX;
    public static Displace smBoatDisplaceY;
    private static SpriteObject smIntroBoatSpr;
    private static SpriteObject smIntroBoatManSpr;
    public static SpriteObject smIntroBoatRival1Spr;
    public static SpriteObject smIntroBoatRival2Spr;
    private int mIntroState;
    private static final int INTRO_STATE_IN_BOAT_ENTER = 0;
    private static final int INTRO_STATE_OUT_FADE = 1;
    private static final int INTRO_STATE_OUT_BOAT_EXIT = 2;
    private static final int INTRO_STATE_EXIT = 3;
    public static boolean smIntroEnabled;
    public static SpriteObject[] smCountryFlagSpr;
    private int mPanelState;
    private static final int PANEL_NONE = 0;
    private static final int PANEL_GET_READY = 1;
    private static final int PANEL_COUNT_DOWN = 2;
    private static final int PANEL_TIME_UP = 3;
    private static final int PANEL_RESULTS = 4;
    private static final int PANEL_QUICK_RESULTS = 5;
    private static final int PANEL_FISH_GALLERY_UPDATED = 6;
    private static String smVersusStr;
    private static final int PANEL_COUNT_DOWN_TIME = 1650;
    private int mPanelTimeToExit;
    private Displace mRoundDisplace = new Displace();
    private static SpriteObject smVersusSpr;
    private int mPanelQuickResultsFishedTotal;
    private int mPanelQuickResultsFishedCount;
    private int mPanelQuickResultsFishedTime;
    private boolean mPanelQuickResultsFinishedSumFinished;
    private SpriteObject[] smPopupBigSpr;
    private int smPopupBigBoder;
    private String mResultsNewFishCollected;
    private static String[] smGameResultStr;
    private static Vector smSpriteObjectCache;

    public GameEngine(Game game, ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        this.smGame = game;
        smFontTitle = imageFont;
        smFontOutline = imageFont3;
        smFontPlain = imageFont2;
        Hud.setFeedbackFont(imageFont3, imageFont);
        mGameWorld = new World();
    }

    public int getLoadingCount() {
        return mGameWorld.getLoadingCount() + 6;
    }

    public void load(int n) {
        int n2 = mGameWorld.getLoadingCount();
        if (n < n2) {
            mGameWorld.load(n);
            return;
        }
        if ((n -= n2) == 0) {
            smIntroBoatSpr = GameEngine.loadSpriteObject(458824, false);
            smIntroBoatManSpr = GameEngine.loadSpriteObject(458822, false);
        } else if (n == 1) {
            smIntroBoatRival1Spr = GameEngine.loadSpriteObject(458878, false);
            smIntroBoatRival2Spr = GameEngine.loadSpriteObject(458877, false);
        } else if (n == 2) {
            smCountryFlagSpr = new SpriteObject[Game.COUNTRY_FLAG_IDS.length];
            for (int i = 0; i < Game.COUNTRY_FLAG_IDS.length; ++i) {
                GameEngine.smCountryFlagSpr[i] = GameEngine.loadSpriteObject(Game.COUNTRY_FLAG_IDS[i], false);
            }
        } else if (n == 3) {
            smResultsPlatSpr = GameEngine.loadSpriteObject(524340, false);
            smVersusStr = Toolkit.getText(120);
            smCountDownSpr = new SpriteObject[3];
            GameEngine.smCountDownSpr[0] = GameEngine.loadSpriteObject(589938, false);
            GameEngine.smCountDownSpr[1] = GameEngine.loadSpriteObject(589939, false);
            GameEngine.smCountDownSpr[2] = GameEngine.loadSpriteObject(589940, false);
        } else if (n == 4) {
            smVersusSpr = GameEngine.loadSpriteObject(524432, true);
            int[] nArray = new int[]{458854, 458846, 458852, 458833, 458862, 458851, 458865, 458858, 458849};
            this.smPopupBigSpr = new SpriteObject[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.smPopupBigSpr[i] = new SpriteObject(DavinciUtilities.loadAnimation(nArray[i]), false);
            }
            this.smPopupBigBoder = this.smPopupBigSpr[0].getHeight() >> 1;
        } else if (n == 5) {
            this.mNextGameState = -1;
            smGameState = -1;
        }
    }

    public void freeResources() {
        GameEngine.freeSpriteObjects();
        smIntroBoatSpr = null;
        smIntroBoatManSpr = null;
        smIntroBoatRival1Spr = null;
        smIntroBoatRival2Spr = null;
        smCountryFlagSpr = null;
        smCountDownSpr = null;
        Bubbles.freeAll();
        smResultsPlatSpr = null;
        smVersusSpr = null;
        smVersusStr = null;
        smTotalStr = null;
        this.mResultsNewFishCollected = null;
        mGameWorld.freeResources();
    }

    public void init() {
        if (mGameStarts) {
            mGameStarts = false;
            mGameWorld.init();
            Hud.clockStartAnimationStart();
            this.changeGameState(1);
            smIntroEnabled = true;
            this.panelInit(0);
        }
        smTotalStr = new String[3];
        GameEngine.smTotalStr[0] = Toolkit.getText(127);
        GameEngine.smTotalStr[1] = Toolkit.getText(128);
        GameEngine.smTotalStr[2] = Toolkit.getText(10);
        this.resetKeys();
        this.updateSoftKeys();
    }

    private void changeGameState(int n) {
        this.mNextGameState = n;
    }

    private void updateGameState() {
        this.panelInit(0);
        switch (this.mNextGameState) {
            case 0: {
                break;
            }
            case 1: {
                this.introInit(true);
                if (smPlayMode == 0) {
                    this.panelInit(1);
                    break;
                }
                Game.smQuickGameHiScoreCurrent = Game.smQuickGameHiScoreTotal;
                break;
            }
            case 2: {
                this.panelInit(2);
                break;
            }
            case 3: {
                this.smTotalFishCollected = MenuFishGallery.getFishCollected();
                break;
            }
            case 4: {
                this.panelInit(3);
                break;
            }
            case 5: {
                this.introInit(false);
                if (smPlayMode == 0) {
                    this.updateResults();
                    this.panelInit(4);
                    break;
                }
                this.panelInit(5);
                break;
            }
            case 6: {
                this.panelInit(6);
                break;
            }
            case 7: {
                if (smPlayMode == 0) {
                    this.panelInit(4);
                    break;
                }
                this.panelInit(5);
            }
        }
        smGameState = this.mNextGameState;
        this.mNextGameState = -1;
        if (smInterruptOccurred && smGameState == 1) {
            smInterruptOccurred = false;
            Game.mCurrentMusic = -1;
        }
        switch (smGameState) {
            case 1: {
                int n = this.updateMusic();
                if (Game.mCurrentMusic == n) break;
                Game.mCurrentMusic = n;
                Toolkit.playMusic(n, -1);
                break;
            }
            case 5: {
                int n = this.updateMusic();
                if (Game.mCurrentMusic == n) break;
                Game.mCurrentMusic = n;
                Toolkit.playMusic(n, 1);
            }
        }
        this.resetKeys();
        this.updateSoftKeys();
    }

    /*
     * Unable to fully structure code
     */
    public int logicUpdate(int var1_1) {
        block37: {
            block38: {
                block39: {
                    block40: {
                        if (this.mNextGameState != -1) {
                            this.updateGameState();
                            return 0;
                        }
                        if (this.mUpdateSoftKeys) {
                            this.updateSoftKeys();
                            this.mUpdateSoftKeys = false;
                        }
                        if (this.mPressedSK == -1) break block37;
                        var2_2 = this.mPressedSK;
                        this.resetKeys();
                        if (var2_2 == 9) {
                            return 1;
                        }
                        if (GameEngine.smGameState == 4 && var2_2 == 14) {
                            this.mPanelTimeToExit = 1;
                        }
                        if (GameEngine.smGameState == 6 && var2_2 == 15) {
                            this.mNextGameState = -1;
                            GameEngine.smGameState = -1;
                            if (GameEngine.smPlayMode == 0) {
                                return 2;
                            }
                            return 17;
                        }
                        if (GameEngine.smGameState != 5 && GameEngine.smGameState != 7) break block38;
                        if (GameEngine.smPlayMode != 0) break block39;
                        if (var2_2 != 15) break block38;
                        MenuFishGallery.updateFishCollected();
                        var3_3 = MenuFishGallery.getFishCollected();
                        if (this.smTotalFishCollected >= var3_3) break block40;
                        this.mResultsNewFishCollected = Toolkit.getText(this.smTotalFishCollected + 1 == var3_3 ? 198 : 199);
                        this.changeGameState(6);
                        break block38;
                    }
                    this.mNextGameState = -1;
                    GameEngine.smGameState = -1;
                    return 2;
                }
                if (var2_2 == 23) {
                    return 15;
                }
                if (var2_2 != 13) ** GOTO lbl46
                MenuFishGallery.updateFishCollected();
                var3_3 = MenuFishGallery.getFishCollected();
                if (this.smTotalFishCollected < var3_3) {
                    this.mResultsNewFishCollected = Toolkit.getText(this.smTotalFishCollected + 1 == var3_3 ? 198 : 199);
                    this.changeGameState(6);
                } else {
                    this.mNextGameState = -1;
                    GameEngine.smGameState = -1;
                    return 17;
lbl46:
                    // 1 sources

                    if (var2_2 == 14) {
                        this.mPanelQuickResultsFishedTime = this.mPanelQuickResultsFishedTotal << 1;
                    }
                }
            }
            if (GameEngine.smGameState == 1 && var2_2 == 14) {
                this.mIntroState = 3;
            }
            if (GameEngine.smGameState == 2 && var2_2 == 14) {
                this.mPanelTimeToExit = 1;
            }
        }
        this.mUpdateTimer += var1_1;
        if (this.mUpdateTimer < 16) {
            return 0;
        }
        var1_1 = this.mUpdateTimer;
        if (var1_1 > 333) {
            var1_1 = 333;
        }
        this.mUpdateTimer = 0;
        var2_2 = 0;
        if ((this.mKeys & 4) != 0 || (this.mKeyPresses & 4) != 0) {
            this.mKeyPresses &= -5;
        } else if ((this.mKeys & 8) != 0 || (this.mKeyPresses & 8) != 0) {
            this.mKeyPresses &= -9;
        }
        if ((this.mKeys & 1) != 0 || (this.mKeyPresses & 1) != 0) {
            this.mKeyPresses &= -2;
        } else if ((this.mKeys & 2) != 0 || (this.mKeyPresses & 2) != 0) {
            this.mKeyPresses &= -3;
        }
        if ((this.mKeys & 16) != 0 || (this.mKeyPresses & 16) != 0) {
            World.smFishermans[0].mActionButtonIsPressed = true;
            this.mKeyPresses &= -17;
        } else {
            World.smFishermans[0].mActionButtonIsPressed = false;
        }
        switch (GameEngine.smGameState) {
            case 0: {
                this.changeGameState(1);
                break;
            }
            case 1: {
                Hud.clockStartAnimationLogicUpdate(var1_1);
                this.updateGameWorld(var1_1, true);
                Statistics.statsIngameStarts();
                if (!this.introLogicUpdate(var1_1)) break;
                GameEngine.smIntroEnabled = false;
                this.changeGameState(2);
                break;
            }
            case 2: {
                Hud.clockStartAnimationLogicUpdate(var1_1);
                this.updateGameWorld(var1_1, true);
                if (!this.panelLogicUpdate(var1_1)) break;
                Hud.clockStartAnimationSkip();
                Statistics.statsIngameStarts();
                this.changeGameState(3);
                break;
            }
            case 3: {
                var3_3 = this.updateGameWorld(var1_1, false);
                switch (var3_3) {
                    case 1: {
                        if (GameEngine.smPlayMode == 0) {
                            Game.smTutorialAlreadyShowed = true;
                        }
                        Hud.mScore[0] = Hud.mScore[0] - Hud.mScore[0] % 10;
                        Hud.mScore[1] = Hud.mScore[1] - Hud.mScore[1] % 10;
                        GameEngine.smPlayerWins = Hud.mScore[0] > Hud.mScore[1];
                        this.changeGameState(4);
                    }
                }
                break;
            }
            case 4: {
                this.updateGameWorld(var1_1, true);
                if (!this.panelLogicUpdate(var1_1)) break;
                this.changeGameState(5);
                break;
            }
            case 5: {
                this.updateGameWorld(var1_1, true);
                this.panelLogicUpdate(var1_1);
                if (!this.introLogicUpdate(var1_1)) break;
                this.changeGameState(7);
                break;
            }
            case 6: {
                this.updateGameWorld(var1_1, true);
                this.panelLogicUpdate(var1_1);
                break;
            }
            case 7: {
                this.updateGameWorld(var1_1, true);
                this.panelLogicUpdate(var1_1);
            }
        }
        if (this.mFadeDisplace.mEnabled && this.mFadeDisplace.isFinished()) {
            this.mFadeDisplace.mEnabled = false;
        }
        return var2_2;
    }

    private int updateGameWorld(int n, boolean bl) {
        int n2 = 0;
        int n3 = 1;
        int n4 = 15;
        int n5 = ((smGameTime += n) - smLastPhysicsUpdate) / smPhysicsUpdateFreq;
        if (n5 != 0) {
            if (n5 > n3) {
                n5 = n3;
            }
            while (n5 > 0) {
                smLastPhysicsUpdate += smPhysicsUpdateFreq;
                World.smPhysics.integrateParticleSystem(78643);
                n2 = mGameWorld.logicUpdate(smPhysicsUpdateFreq / n5, bl);
                World.smPhysics.updateDistanceConstraintsSystem(n4);
                --n5;
            }
            int n6 = FP.toInt(World.smPhysics.pX[World.smFishermans[0].mRopeParticle[0]]);
            int n7 = FP.toInt(World.smPhysics.pY[World.smFishermans[0].mRopeParticle[0]]);
            if (World.smFishermans[0].mCurrentFishermanAnim != 3) {
                World.mCamera.cameraSetXY(n6 - World.smWorldAnchorPointX - World.smProportionalCameraOffsetX, n7 - World.smWorldAnchorPointY - World.smProportionalCameraOffsetY);
            }
        }
        return n2;
    }

    public void doDraw(Graphics graphics) {
        int n = Toolkit.getScreenWidth();
        int n2 = Toolkit.getScreenHeight();
        mGameWorld.doDraw(graphics);
        if (smGameState == 3) {
            // empty if block
        }
        this.panelDoDraw(graphics);
        if (this.mFadeDisplace.mEnabled) {
            this.smGame.fadeToColor(0xFFFFFF, this.mFadeDisplace.getOffset(), this.mFadeDisplace.mDistance2, graphics);
        }
    }

    public void keyEventOccurred(int n, int n2) {
        if (n2 == 0 || n2 == 1) {
            int n3 = Toolkit.getToolkitGameAction(n);
            int n4 = 0;
            switch (n3) {
                case 52: {
                    n4 = 1;
                    break;
                }
                case 54: {
                    n4 = 2;
                    break;
                }
                case 50: {
                    n4 = 4;
                    break;
                }
                case 56: {
                    n4 = 8;
                    break;
                }
                case 53: {
                    n4 = 16;
                }
            }
            if (n2 == 0) {
                this.mKeys |= n4;
                this.mKeyPresses |= n4;
            } else {
                this.mKeys &= ~n4;
            }
            if (n2 == 0 && Toolkit.getToolkitGameAction(n) == 53) {
                this.mPressedSK = this.mActionSK;
            }
            if (this.mCheatsEnabled && n2 == 0 && n == 48) {
                Hud.smTimeRemaining = 0;
                if (smPlayMode == 0) {
                    Hud.mScore[0] = Hud.mScore[1] + 1000;
                }
            } else if (this.mCheatsEnabled && n2 == 0 && n == 42 && smPlayMode == 1) {
                Hud.mScore[0] = 64990;
                Hud.smBalanceDestTime = 1999;
                Hud.smCheckPointScoreCurrent = Hud.mScore[0] % 10000;
            }
            if (Debug.CHEATS && n2 == 0 && n == 42) {
                Hud.smTimeRemaining = 0;
                if (smPlayMode == 0) {
                    Hud.mScore[0] = Hud.mScore[1] + 1000;
                }
            }
        } else if (n2 == 3) {
            this.mPressedSK = n;
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        if (smGameState == 3 && Util.colision(n, n2, 1, 1, 0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight())) {
            if (n3 == 0) {
                this.mKeys |= 0x10;
            }
            if (n3 == 1) {
                this.mKeys &= 0xFFFFFFEF;
            }
        }
    }

    public void controllerEventOccurred(int n, int n2, int n3, int n4, int n5) {
    }

    public static boolean isControllerEnabled() {
        return false;
    }

    public void screenSizeChanged() {
        mGameWorld.refreshWordPos();
    }

    public int updateMusic() {
        int n = -1;
        n = smPlayMode == 1 ? 196608 : (smGameState == 5 || smGameState == 7 || smGameState == 6 ? (smPlayerWins ? 262145 : 262146) : (Game.smRoundToPlay % 2 == 0 ? 196608 : 262144));
        return n;
    }

    public void enableCheats() {
        this.mCheatsEnabled = true;
        smBaitCurrent = 5;
        smLineLengthCurrent = 5;
        smLineStrengthCurrent = 5;
        Game.smImprovementTotalStars = 15;
    }

    public void continueGame() {
        this.resetKeys();
        this.mUpdateSoftKeys = true;
        Hud.initControlAnimation();
        DChocMIDlet.getInstance().resetTimer();
    }

    public void playGame() {
        this.mUpdateSoftKeys = true;
        mGameStarts = true;
    }

    private void resetKeys() {
        this.mPressedSK = -1;
        this.mActionSK = -1;
        this.mKeys = 0;
        this.mKeyPresses = 0;
    }

    private void updateSoftKeys() {
        this.mActionSK = -1;
        Toolkit.removeAllSoftKeys();
        switch (smGameState) {
            case 1: 
            case 2: {
                this.mActionSK = 14;
                Toolkit.setSoftKey(this.mActionSK, 0);
                break;
            }
            case 3: {
                Toolkit.setSoftKey(9, 0);
                break;
            }
            case 4: {
                this.mActionSK = 14;
                Toolkit.setSoftKey(this.mActionSK, 0);
                break;
            }
            case 5: 
            case 7: {
                if (smPlayMode == 0) {
                    this.mActionSK = 15;
                    Toolkit.setSoftKey(this.mActionSK, 1);
                    break;
                }
                if (this.mPanelQuickResultsFinishedSumFinished) {
                    this.mActionSK = 23;
                    Toolkit.setSoftKey(this.mActionSK, 1);
                    Toolkit.setSoftKey(13, 3);
                    break;
                }
                this.mActionSK = 14;
                Toolkit.setSoftKey(this.mActionSK, 1);
                break;
            }
            case 6: {
                this.mActionSK = 15;
                Toolkit.setSoftKey(this.mActionSK, 0);
            }
        }
    }

    private void updateResults() {
        int n;
        smRoundCompletedSuccessful = false;
        if (Hud.mScore[0] > Hud.mScore[1]) {
            n = 0;
            smRoundCompletedSuccessful = true;
        } else {
            n = Hud.mScore[0] == Hud.mScore[1] ? 2 : 1;
        }
        if (n == 0) {
            Game.smPlayerWins[0] = Game.smPlayerWins[0] + 1;
        } else if (n == 1) {
            int n2 = Game.smCountryEnemyPos;
            Game.smPlayerWins[n2] = Game.smPlayerWins[n2] + 1;
        }
        Game.smPlayerWeights[0] = Game.smPlayerWeights[0] + Hud.mScore[0];
        int n3 = Game.smCountryEnemyPos;
        Game.smPlayerWeights[n3] = Game.smPlayerWeights[n3] + Hud.mScore[1];
        Statistics.statsIngameEnds(n);
    }

    private void introInit(boolean bl) {
        if (bl) {
            this.mIntroState = 0;
            int n = World.smFishermans[0].mBoatBackSpr.getWidth();
            smBoatDisplaceX.create(-n, 2000, false, 2);
            this.mFadeDisplace.mEnabled = false;
        } else {
            this.mIntroState = 1;
            this.mFadeDisplace.create(1000, 500, true, 1);
        }
        smBoatDisplaceY.create(6, 1000, true, 3);
        smIntroEnabled = true;
    }

    private boolean introLogicUpdate(int n) {
        switch (this.mIntroState) {
            case 0: {
                if (smBoatDisplaceY.isFinished()) {
                    if (smBoatDisplaceX.isFinished()) {
                        if (!this.mFadeDisplace.mEnabled) {
                            this.mFadeDisplace.create(1000, 500, true, 1);
                        }
                    } else {
                        smBoatDisplaceY.restart();
                    }
                }
                if (!this.mFadeDisplace.mEnabled || !this.mFadeDisplace.isFinished()) break;
                this.mFadeDisplace.create(1000, 500, false, 2);
                return true;
            }
            case 1: {
                if (!this.mFadeDisplace.isFinished()) break;
                mGameWorld.initCamera();
                int n2 = Toolkit.getScreenWidth() * 10;
                smBoatDisplaceX.create(n2, 15000, true, 1);
                this.mIntroState = 2;
                this.mFadeDisplace.create(1000, 500, false, 2);
                break;
            }
            case 2: {
                if (!smBoatDisplaceY.isFinished()) break;
                if (smBoatDisplaceX.isFinished()) {
                    if (this.mFadeDisplace.mEnabled) break;
                    return true;
                }
                smBoatDisplaceY.restart();
                break;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static void introDoDraw(Graphics graphics) {
        if (smGameState != 1 && smGameState != 5) {
            return;
        }
        if (smIntroEnabled) {
            for (int i = 0; i < World.smPlayersCount; ++i) {
                int n = World.smFishermans[i].mCanvasBoatX + smBoatDisplaceX.getOffset();
                int n2 = World.smFishermans[i].mCanvasBoatY + smBoatDisplaceY.getOffset();
                n = Game.worldToPixel(n);
                n2 = Game.worldToPixel(n2);
                if (i == 0) {
                    smIntroBoatSpr.draw(graphics, n, n2);
                    smIntroBoatManSpr.draw(graphics, n, n2);
                    continue;
                }
                smIntroBoatRival1Spr.draw(graphics, n, n2);
                smIntroBoatRival2Spr.draw(graphics, n, n2);
            }
        }
    }

    private void panelInit(int n) {
        this.mPanelState = n;
        if (this.mPanelState == 1) {
            this.mRoundDisplace.create(Toolkit.getScreenWidth(), 500, false, 2);
        } else if (this.mPanelState == 3) {
            this.mPanelTimeToExit = 2000;
            smInterruptInResults = false;
        } else if (this.mPanelState == 4) {
            if (smGameResultStr == null) {
                smGameResultStr = new String[]{Toolkit.getText(122), Toolkit.getText(123), Toolkit.getText(124)};
            }
        } else if (this.mPanelState == 2) {
            smCountDownSpr[0].setAnimation(0, 1, false);
            smCountDownSpr[1].setAnimation(0, 1, false);
            smCountDownSpr[2].setAnimation(0, 1, false);
            this.mPanelTimeToExit = 1649;
        } else if (this.mPanelState == 5 && this.mNextGameState == 5) {
            Game.smQuickGameHiScoreTotal = Game.smQuickGameHiScoreCurrent;
            this.mPanelQuickResultsFishedTotal = Hud.mScore[0];
            this.mPanelQuickResultsFishedCount = 0;
            this.mPanelQuickResultsFishedTime = 0;
            this.mPanelQuickResultsFinishedSumFinished = false;
            this.updateSoftKeys();
            this.smGame.saveGame();
        } else if (this.mPanelState == 6 && smInterruptInResults) {
            Toolkit.playMusic(this.updateMusic(), 1);
        }
    }

    private boolean panelLogicUpdate(int n) {
        if (this.mPanelTimeToExit > 0 && (this.mPanelTimeToExit -= n) <= 0) {
            this.mPanelTimeToExit = 0;
            this.mPanelState = 0;
            return true;
        }
        switch (this.mPanelState) {
            case 2: {
                smCountDownSpr[this.mPanelTimeToExit / 550].logicUpdate(n);
                break;
            }
            case 5: {
                this.mPanelQuickResultsFishedTime += n;
                this.mPanelQuickResultsFishedCount = this.mPanelQuickResultsFishedTime << 5;
                this.mPanelQuickResultsFishedCount -= this.mPanelQuickResultsFishedCount % 1000;
                if (this.mPanelQuickResultsFishedCount <= this.mPanelQuickResultsFishedTotal) break;
                this.mPanelQuickResultsFishedCount = this.mPanelQuickResultsFishedTotal;
                if (this.mPanelQuickResultsFinishedSumFinished) break;
                this.mPanelQuickResultsFinishedSumFinished = true;
                this.updateSoftKeys();
            }
        }
        return false;
    }

    private void panelDoDraw(Graphics graphics) {
        switch (this.mPanelState) {
            case 1: {
                if (smGameState != 1) break;
                this.panelDrawMatch(graphics);
                break;
            }
            case 2: {
                this.panelDrawCountDown(graphics);
                break;
            }
            case 3: {
                this.panelDrawTimeUp(graphics);
                break;
            }
            case 4: {
                if (smGameState != 7 && (smGameState != 5 || this.mIntroState != 2)) break;
                this.panelDrawResults(graphics);
                break;
            }
            case 5: {
                if (smGameState != 7 && (smGameState != 5 || this.mIntroState != 2)) break;
                this.panelDrawQuickResults(graphics);
                break;
            }
            case 6: {
                this.panelDrawFishGalleryUpdated(graphics);
            }
        }
    }

    public void panelDrawMatch(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = smCountryFlagSpr[0].getWidth() + smCountryFlagSpr[0].getWidth() / 3;
        int n3 = smCountryFlagSpr[0].getHeight() + (smCountryFlagSpr[0].getHeight() >> 2);
        int n4 = n3 + smFontOutline.getHeight() / 2 + 0;
        int n5 = (n4 << 1) - (n4 >> 2) + (smVersusSpr.getHeight() - smVersusSpr.getHeight() / 3);
        int n6 = 12 * Toolkit.getScreenWidth() / 240;
        int n7 = Toolkit.getScreenWidth() - (n6 << 1);
        int n8 = smFontOutline.getHeight() + smFontTitle.getHeight() + n5 + (n << 1) + 0;
        int n9 = Toolkit.getScreenHeight() - n8 >> 1;
        int n10 = n7 / 5 * 3;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n6, n9, n7, smFontTitle.getHeight() + (n << 1));
        int n11 = n9 + n;
        String string = Toolkit.replaceParameters(Toolkit.getText(118), new String[]{Game.smRoundToPlay + 1 + "/" + Game.ROUND_TOTAL[Game.smTournamentToPlay]});
        if (Game.smRoundToPlay + 1 == Game.ROUND_TOTAL[Game.smTournamentToPlay]) {
            string = Toolkit.getText(119);
        }
        TextField.draw(graphics, string, smFontTitle, Toolkit.getScreenWidth() >> 1, n11, 17);
        n11 += smFontTitle.getHeight();
        int n12 = this.mRoundDisplace.getOffset();
        int n13 = n11 += smFontOutline.getHeight();
        int n14 = n11 + n5 - n4;
        GameEngine.drawBox(graphics, Game.smPlayerRound[1], n6 - n + n7 - n10 + n12, n14, n10, n4, false, n2);
        GameEngine.drawBox(graphics, Game.smPlayerRound[0], n6 + n - n12, n13, n10, n4, true, n2);
        smVersusSpr.draw(graphics, n6 + (n7 >> 1), n13 + (n5 >> 1));
        TextField.draw(graphics, smVersusStr, smFontOutline, n6, n13, n7, n5, 3);
    }

    private static void drawBox(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        String string = Toolkit.getText(Game.COUNTRIES_IDS[Game.smPlayerIDs[n]]);
        int n7 = Game.smPopupBoder + n6 + smFontOutline.stringWidth(string);
        if (n4 < n7) {
            if (!bl) {
                n2 -= n7 - n4;
            }
            n4 = n7;
        }
        Util.drawDialogBox(graphics, n == 0 ? Game.smPopupGreenSpr : Game.smPopupBlueSpr, n2, n3, n4, n5);
        if (bl) {
            TextField.draw(graphics, string, smFontOutline, n2 + n6, n3, 0, n5, 6);
            if (smCountryFlagSpr != null) {
                smCountryFlagSpr[Game.smPlayerIDs[n]].draw(graphics, n2 + (n6 >> 1), n3 + (n5 >> 1));
            }
        } else {
            TextField.draw(graphics, string, smFontOutline, n2 + n4 - n6, n3, 0, n5, 10);
            if (smCountryFlagSpr != null) {
                smCountryFlagSpr[Game.smPlayerIDs[n]].draw(graphics, n2 + n4 - (n6 >> 1), n3 + (n5 >> 1));
            }
        }
    }

    public void panelDrawReady(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = Math.max(smCountryFlagSpr[0].getHeight(), smFontTitle.getHeight());
        int n3 = 12 * Toolkit.getScreenWidth() / 240;
        int n4 = Toolkit.getScreenWidth() - (n3 << 1);
        int n5 = smFontOutline.getHeight() + smFontTitle.getHeight() + (n2 += smFontTitle.getHeight() >> 1) + (n << 1);
        int n6 = Toolkit.getScreenHeight() - n5 >> 1;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n3, n6, n4, n5);
        int n7 = n6 + n;
        String string = Toolkit.replaceParameters(Toolkit.getText(118), new String[]{Game.smRoundToPlay + 1 + "/" + Game.ROUND_TOTAL[Game.smTournamentToPlay]});
        if (Game.smRoundToPlay + 1 == Game.ROUND_TOTAL[Game.smTournamentToPlay]) {
            string = Toolkit.getText(119);
        }
        TextField.draw(graphics, string, smFontTitle, Toolkit.getScreenWidth() >> 1, n7, 17);
        TextField.draw(graphics, Toolkit.getText(120), smFontTitle, n3, n7 += smFontTitle.getHeight(), n4, n2, 3);
        smCountryFlagSpr[Game.smPlayerIDs[Game.smPlayerRound[0]]].draw(graphics, Toolkit.getScreenWidth() >> 2, n7 + (n2 >> 1));
        smCountryFlagSpr[Game.smPlayerIDs[Game.smPlayerRound[1]]].draw(graphics, Toolkit.getScreenWidth() - (Toolkit.getScreenWidth() >> 2), n7 + (n2 >> 1));
        n7 += n2;
    }

    public void panelDrawCountDown(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = 12 * Toolkit.getScreenWidth() / 240;
        int n3 = Toolkit.getScreenWidth() - (n2 << 1);
        int n4 = (smFontOutline.getHeight() << 1) + (n << 1);
        int n5 = Toolkit.getScreenHeight() - n4 >> 1;
        smCountDownSpr[this.mPanelTimeToExit / 550].draw(graphics, Toolkit.getScreenWidth() >> 1, n5 + (n4 >> 1));
    }

    public void panelDrawTimeUp(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = 12 * Toolkit.getScreenWidth() / 240;
        int n3 = Toolkit.getScreenWidth() - (n2 << 1);
        String[] stringArray = MenuObject.splitString(Toolkit.getText(9), smFontOutline, n3 - (n << 1));
        int n4 = smFontOutline.getHeight() * stringArray.length + (n << 1);
        int n5 = Toolkit.getScreenHeight() - n4 >> 1;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n2, n5, n3, n4);
        TextField.draw(graphics, stringArray, smFontOutline, Toolkit.getScreenWidth() >> 1, n5 + (n4 >> 1), 3);
    }

    public void panelDrawResults(Graphics graphics) {
        int n = smPlayerWins ? 0 : 1;
        int n2 = this.smPopupBigBoder;
        int n3 = Math.max(smCountryFlagSpr[0].getHeight(), smFontTitle.getHeight());
        int n4 = 12 * Toolkit.getScreenWidth() / 240;
        int n5 = Toolkit.getScreenWidth() - (n4 << 1);
        int n6 = (smFontOutline.getHeight() << 1) + (n3 += smFontTitle.getHeight() >> 1) + (smFontOutline.getHeight() << 1) + (n2 << 1) + 0;
        if (n != 0) {
            n6 += smFontOutline.getHeight();
        }
        int n7 = Toolkit.getScreenHeight() - n6 >> 1;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n4, n7, n5, n6 + 0);
        int n8 = n7 + n2;
        TextField.draw(graphics, Toolkit.getText(121), smFontTitle, Toolkit.getScreenWidth() >> 1, n8, 17);
        ImageFont imageFont = smFontTitle;
        smCountryFlagSpr[Game.smPlayerIDs[Game.smPlayerRound[0]]].draw(graphics, Toolkit.getScreenWidth() / 3, (n8 += smFontTitle.getHeight()) + (n3 >> 1));
        if (Hud.mScore[0] == Hud.mScore[1]) {
            n = 2;
        }
        String string = n == 0 ? Toolkit.getText(122) : (n == 1 ? Toolkit.getText(123) : Toolkit.getText(124));
        TextField.draw(graphics, string, imageFont, Toolkit.getScreenWidth() - Toolkit.getScreenWidth() / 3, n8 + (n3 >> 1), 3);
        n8 += n3;
        if (n != 0) {
            TextField.draw(graphics, Toolkit.getText(126), smFontOutline, n4 + (n5 >> 1), n8 + 0, 17);
            n8 += smFontOutline.getHeight();
        }
        int n9 = imageFont.stringWidth(Game.toKg(Hud.mScore[0]) + " " + smTotalStr[2] + "  ");
        TextField.drawScrolling(graphics, Toolkit.getText(125) + "  " + Game.toKg(Hud.mScore[0]) + " " + smTotalStr[2], imageFont, n4 + n2, n8 + 0, n5 - (n2 << 1), smFontTitle.getHeight(), true);
        TextField.drawScrolling(graphics, smTotalStr[0] + " " + Game.toKg(Game.smPlayerWeights[0]) + " " + smTotalStr[2] + "  ", smFontPlain, n4 + n2, (n8 += imageFont.getHeight()) + 45, n5 - (n2 << 1), smFontTitle.getHeight(), true);
        TextField.drawScrolling(graphics, smTotalStr[1] + "  " + Game.smPlayerWins[0] + " ", smFontPlain, n4 + n2, n8 + smFontPlain.getHeight() + 45, n5 - (n2 << 1), smFontTitle.getHeight(), true);
    }

    public void panelDrawQuickResults(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = Math.max(smResultsPlatSpr.getHeight(), smFontTitle.getHeight());
        int n3 = 12 * Toolkit.getScreenWidth() / 240;
        int n4 = Toolkit.getScreenWidth() - (n3 << 1);
        int n5 = smFontTitle.getHeight() + n2 + smFontOutline.getHeight() + (n << 1);
        int n6 = Toolkit.getScreenHeight() - n5 >> 1;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n3, n6, n4, n5 + 0);
        int n7 = n6 + n;
        String string = Toolkit.getText(121);
        TextField.draw(graphics, string, smFontTitle, Toolkit.getScreenWidth() >> 1, n7, 17);
        n7 += smFontTitle.getHeight();
        int n8 = smResultsPlatSpr.getWidth();
        int n9 = smFontTitle.stringWidth("888.88" + smTotalStr[2]);
        int n10 = 0;
        if (this.mPanelQuickResultsFishedTotal > 0) {
            n10 = Util.regla3(this.mPanelQuickResultsFishedCount, this.mPanelQuickResultsFishedTotal, smResultsPlatSpr.getFrameCount() - 1);
        }
        int[] nArray = new int[]{n8, n9};
        int[] nArray2 = Util.calculateDistributionBoxes(nArray, n4);
        smResultsPlatSpr.setAnimationFrame(n10);
        smResultsPlatSpr.draw(graphics, n3 + nArray2[0] + (nArray[0] >> 1) + 0, n7 + smResultsPlatSpr.getPivotY());
        TextField.draw(graphics, Game.toKg(this.mPanelQuickResultsFishedCount) + " " + smTotalStr[2], smFontTitle, n3 + nArray2[1], n7, nArray[1], n2, 10);
        n7 += n2;
        if (this.mPanelQuickResultsFinishedSumFinished) {
            int n11 = 166;
            n11 = this.mPanelQuickResultsFishedTotal < Tuner.QUICK_GAME_WEIGHT_FEEDBACK[0] ? 166 : (this.mPanelQuickResultsFishedTotal < Tuner.QUICK_GAME_WEIGHT_FEEDBACK[1] ? 167 : (this.mPanelQuickResultsFishedTotal < Tuner.QUICK_GAME_WEIGHT_FEEDBACK[2] ? 168 : (this.mPanelQuickResultsFishedTotal < Tuner.QUICK_GAME_WEIGHT_FEEDBACK[3] ? 169 : 170)));
            TextField.draw(graphics, Toolkit.getText(n11), smFontOutline, n3 + n, n7, n4 - (n << 1), smFontOutline.getHeight(), 3);
        }
    }

    public void panelDrawFishGalleryUpdated(Graphics graphics) {
        int n = this.smPopupBigBoder;
        int n2 = 12 * Toolkit.getScreenWidth() / 240;
        int n3 = Toolkit.getScreenWidth() - (n2 << 1);
        String[] stringArray = MenuObject.splitString(this.mResultsNewFishCollected, smFontOutline, n3 - (n << 1));
        int n4 = smFontOutline.getHeight() * stringArray.length + (n << 1);
        int n5 = Toolkit.getScreenHeight() - n4 >> 1;
        Util.drawDialogBox(graphics, this.smPopupBigSpr, n2, n5, n3, n4);
        TextField.draw(graphics, stringArray, smFontOutline, Toolkit.getScreenWidth() >> 1, n5 + (n4 >> 1), 3);
    }

    public static SpriteObject loadSpriteObject(int[] nArray, boolean bl) {
        Animation[] animationArray = DavinciUtilities.loadAnimations(nArray);
        SpriteObject spriteObject = new SpriteObject(animationArray, bl);
        if (smSpriteObjectCache == null) {
            smSpriteObjectCache = new Vector();
        }
        smSpriteObjectCache.addElement(spriteObject);
        return spriteObject;
    }

    public static SpriteObject loadSpriteObject(int n, boolean bl) {
        return GameEngine.loadSpriteObject(new int[]{n}, bl);
    }

    public static void freeSpriteObjects() {
        if (smSpriteObjectCache != null) {
            for (int i = 0; i < smSpriteObjectCache.size(); ++i) {
                SpriteObject spriteObject = (SpriteObject)smSpriteObjectCache.elementAt(i);
                spriteObject.freeResources();
            }
            smSpriteObjectCache = null;
        }
    }

    static {
        smGameTime = 0;
        smLastPhysicsUpdate = 0;
        smPhysicsUpdateFreq = 60;
        smBoatDisplaceX = new Displace();
        smBoatDisplaceY = new Displace();
        smIntroEnabled = false;
    }
}

