/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuObject
implements IMenu {
    private int mOffsetY = 0;
    public static final int ITEM_ICON_INDEX_NOT_SELECTED = 0;
    public static final int ITEM_ICON_INDEX_SELECTED = 1;
    public static final int ITEM_ICON_INDEX_LOCKED = 2;
    public static final int ITEM_ICON_INDEX_SETTING_OFF = 3;
    public static final int ITEM_STATE_NORMAL = 0;
    public static final int ITEM_STATE_LOCKED = 1;
    public static final int TABLE_COLUMN_WEIGHT_COMPACT = -1;
    public static final int ALIGNMENT_RIGHT = 4;
    public static final int ALIGNMENT_BOTTOM = 8;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean ENABLE_SMOOTH_TEXT_SCROLLING = true;
    private static final int VERTICAL_SCROLLING_LINE_DELAY = 300;
    private static final int SCROLLING_EVENT_NONE = 0;
    private static final int SCROLLING_EVENT_DOWN = 1;
    private static final int SCROLLING_EVENT_UP = 2;
    private static final int SCROLL_ANIMATION_INDEX_NORMAL = 0;
    private static final int SCROLL_ANIMATION_INDEX_CLICKED = 1;
    private static final int SCROLL_ANIMATION_INDEX_PRESSED = 2;
    private static Image smScrollImage;
    private static SpriteObject smScrollUpAnimations;
    private static SpriteObject smScrollDownAnimations;
    private static SpriteObject mScrollUpAnimations;
    private static SpriteObject mScrollDownAnimations;
    private static boolean smDisableArrowUpdate;
    private static int smScrollArrowUpSpace;
    private static int smScrollArrowDownSpace;
    private int mScrollingEvent;
    private int mVerticalScrollingOffset;
    private int[] mPageBreaks;
    private int mCurrentPage;
    private int mScrollingTimer;
    private int mScrollingAreaHeight;
    private int mPageHeight;
    private int mScrollArrowX;
    private int mScrollArrowUpY;
    private int mScrollArrowDownY;
    private int mEnsureScrollOnce;
    private static final int ENSURE_SCROLL_STARTED = 0;
    private static final int ENSURE_SCROLL_SCROLLED = 1;
    private static final int ENSURE_SCROLL_STOP_AFTER_SCROLLED = 2;
    private static SpriteObject smScrollLeftAnimations;
    private static SpriteObject smScrollRightAnimations;
    private static int smScrollArrowLeftSpace;
    private static int smScrollArrowRightSpace;
    private static final boolean ENABLE_ITEM_SCROLLING = true;
    private static final int HORIZONTAL_SCROLLING_DELAY = 40;
    private static final int HORIZONTAL_SCROLLING_TURNOVER_DELAY = 2000;
    private static final int LINE_VISIBLE_TIME = 2000;
    private static final int SCROLLING_DIRECTION_LEFT = 0;
    private static final int SCROLLING_DIRECTION_RIGHT = 1;
    private int mTemporaryScrollingOffset;
    private int mTemporaryScrollingDirection;
    private int mTemporaryUpdateTimer;
    private int mTemporaryVisibleLine;
    private static final boolean ENABLE_IMAGE_ICONS = true;
    private static final boolean ENABLE_DAVINCI_ICONS = true;
    private static final boolean ENABLE_DAVINCI_SCROLL_ARROWS = true;
    private static final boolean ENABLE_BACKGROUND_GRADIENT = true;
    private static final int BACKGROUND_GRADIENT_SLIDE_HEIGHT = 1;
    private static final boolean ENABLE_BORDERS = true;
    private static final int TEXT_LINE_Y_MARGIN = 2;
    private static final int ITEM_X_MARGIN = 8;
    private static final int ITEM_Y_MARGIN = 6;
    private static final int TABLE_CELL_X_BORDER = 4;
    private static final int BORDER_THICKNESS = 4;
    private static ImageFont smDefaultTitleBarFont;
    private static ImageFont smDefaultTextFont;
    private static ImageFont smDefaultSelectionFont;
    private ImageFont mTitleBarFont;
    private int mTitleBarFontHeight;
    public ImageFont mTextFont;
    private int mTextFontHeight;
    private ImageFont mSelectionFont;
    private int mSelectionFontHeight;
    private static ImageFont smSplitStringFont;
    private ImageFont[] mItemFont;
    public static final int STYLE_BLANK = 1;
    public static final int STYLE_TRANSPARENT = 2;
    public static final int STYLE_FULL_SCREEN = 3;
    public static final int STYLE_BOX = 4;
    public static final int STYLE_BOX_EMBEDDED_TITLE_BAR = 5;
    public static final int STYLE_SUB_MENU = 6;
    public static final int STYLE_SUB_MENU_BORDERS = 7;
    public static final int STYLE_DEFAULT = 2;
    private int mStyle;
    private boolean mEnableBackground;
    private boolean mEnableBorders;
    private boolean mTitleBarsOnTop;
    private boolean mSeparateTitleBarBackground;
    private int mBackgroundColor;
    private int mBackgroundGradientColor;
    private int mTitleBarBackgroundColor;
    private int mTitleBarBackgroundGradientColor;
    private int mSelectedItemBackgroundColor;
    private boolean mLooseItemAreaAlignment;
    private int mScreenXMargin;
    private int mScreenYMargin;
    private int mScreenMinX;
    private int mScreenMinY;
    private int mScreenMaxWidth;
    private int mScreenMaxHeight;
    private int mScreenSoftkeyAreaHeight;
    private int mScreenType;
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private int mMaxItemCount;
    private boolean mNewMenuEventAvailable;
    private final int[] mLastMenuEvent = new int[2];
    private static final int INVALID_DRAWING_COORDINATE = Integer.MAX_VALUE;
    private int mLastDrawX;
    private int mLastDrawY;
    private final int[] mSoftKeys = new int[2];
    private static final boolean ENABLE_TITLE_BARS = true;
    private static final int TITLE_BAR_GRADIENT_SLIDE_HEIGHT = 2;
    private static final boolean ENABLE_ITEM_SPECIFIC_TITLE_BARS = false;
    private boolean mHasTitleBar;
    private int mTitleBarAlignment;
    private int mTitleBarScrollingOffset;
    private int mTitleBarScrollingDirection;
    private int mTitleBarUpdateTimer;
    private int mTitleBarVisibleLine;
    private String mTitleBarSourceText;
    private String[] mTitleBarText;
    private Image mTitleBarImage;
    private SpriteObject mTitleBarSprite;
    private int mTitleBarX;
    private int mTitleBarHeight;
    private int mTitleBarTextAreaWidth;
    private int mTitleBarImageAreaWidth;
    private static final int ITEM_INDEX_TITLE_BAR = -2;
    private String[] mItemTitleBarSourceTexts;
    private String[][] mItemTitleBarTexts;
    private static final int BOUNDS_SIZE = 4;
    private static final int BOUNDS_X = 0;
    private static final int BOUNDS_Y = 1;
    private static final int BOUNDS_WIDTH = 2;
    private static final int BOUNDS_HEIGHT = 3;
    private int mItemAreaX;
    private int mItemAreaY;
    private int mItemAreaWidth;
    private int mItemAreaHeight;
    private int mItemAlignment;
    private int[] mItemTypes;
    private int[] mItemBounds;
    private int[] mItemCornerRows;
    private int[] mItemTextAreaWidths;
    private int[] mItemImageAreaWidths;
    private Image[][] mItemIcons;
    private SpriteObject[] mItemSprites;
    public String[] mItemSourceTexts;
    private String[][] mItemTexts;
    private static final boolean ENABLE_EXTENDED_ITEM_PARAMETERS = false;
    public static final int EXTENDED_PARAMETER_DEFAULT = -1;
    private int[] mItemAlignments;
    private int[] mItemMargins;
    private static final int INVALID_ITEM_INDEX = -1;
    private int mSelectedIndex;
    private int[] mItemStates;
    private int[] mItemEvents;
    private int mSelectionItemsPerScreen;
    private int mSelectionItemHeight;
    private int mSelectedItemScrollingOffset;
    private int mSelectedItemScrollingDirection;
    private int mSelectedItemUpdateTimer;
    private int mSelectedItemVisibleLine;
    private static final boolean ENABLE_SLIDER_ITEMS = true;
    private static final int ITEM_TYPE_SLIDER = 4;
    private static final int ITEM_TYPE_SWITCH = 5;
    private static final int SLIDER_SECTION_WIDTH = 12;
    private int[] mSettingItemTextAreaWidths;
    private int[] mSettingItemImageAreaWidths;
    private int[] mSettingItemValues;
    private int[] mSettingItemValueCounts;
    private String[][] mSwitchItemTexts;
    private Image[][] mSwitchItemIcons;
    private SpriteObject[] mSwitchItemSprites;
    private static final boolean ENABLE_INPUT_ITEMS = false;
    private static final boolean USE_VERTICAL_INPUT_CURSOR = true;
    private static final int ITEM_TYPE_INPUT_BOX = 3;
    private int mInputBoxHeight;
    private int[] mInputItemMappingTypes;
    private StringBuffer[] mInputItemTexts;
    private char[] mInputChars;
    private int mInputTextPosition;
    private boolean mInputEditing;
    private static final int INPUT_KEY_VARIATION_DELAY = 750;
    private int mInputKeyVariationTimer;
    private boolean mInputKeyVariationTimerShouldDecrease;
    private int mInputKeyVariation;
    private int mInputPreviousKey;
    private static final int INPUT_CURSOR_BLINK_DURATION = 1000;
    private int mInputCursorBlinkTimer;
    private static final boolean ENABLE_TABLE_ITEMS = false;
    private static final int ITEM_TYPE_TABLE = 6;
    private int[][] mTableItemColumnWeights;
    private int[][] mTableItemColumnAlignments;
    private String[][] mTableItemSourceTexts;
    private String[][][] mTableItemTexts;
    private Image[][] mTableItemIcons;
    private SpriteObject[][] mTableItemSprites;
    private int[][] mTableItemColumnWidths;
    private int[][] mTableItemRowHeights;
    private static final boolean ENABLE_SUB_MENUS = false;
    public static final int SCREEN_TYPE_MENU_COMBINER = 3;
    private static final int ITEM_TYPE_SUB_MENU = 7;
    private MenuObject[] mSubMenus;
    private boolean mHasSeveralSubMenus;
    private static final boolean ENABLE_ITEM_BLINK = true;
    private int[][] mItemBlinkSequence;
    private int mBlinkingTimer;
    private static final boolean ENABLE_EXAMPLE_HORIZONTAL_ARROWS = false;
    public static final int SCREEN_TYPE_EXAMPLE_HORIZONTAL_ARROWS = 100;

    public static void setDefaultImageFonts(ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        smDefaultTitleBarFont = imageFont;
        smDefaultTextFont = imageFont2;
        smDefaultSelectionFont = imageFont3;
    }

    public static void setScrollArrows(Image image) {
    }

    public static void setScrollArrowsDvc(SpriteObject spriteObject, SpriteObject spriteObject2) {
        int n;
        smScrollUpAnimations = spriteObject;
        smScrollDownAnimations = spriteObject2;
        smScrollArrowUpSpace = 0;
        for (n = 0; n < spriteObject.getAnimationCount(); ++n) {
            spriteObject.setAnimation(n, -1, true);
            smScrollArrowUpSpace = Math.max(smScrollArrowUpSpace, spriteObject.getHeight() + 2);
        }
        smScrollArrowDownSpace = 0;
        for (n = 0; n < spriteObject2.getAnimationCount(); ++n) {
            spriteObject2.setAnimation(n, -1, true);
            smScrollArrowDownSpace = Math.max(smScrollArrowDownSpace, spriteObject2.getHeight() + 2);
        }
    }

    public static void setHorizontalScrollArrows(SpriteObject spriteObject, SpriteObject spriteObject2) {
    }

    public void setScreen(int n, int n2, int n3) {
        this.mScreenType = n;
        this.mSelectedIndex = -1;
        this.mVerticalScrollingOffset = 0;
        this.mScrollingEvent = 0;
        this.mItemAlignment = n3;
        this.mScrollingTimer = 0;
        this.mTitleBarAlignment = n3;
        this.mItemTypes = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.mItemTypes[i] = -1;
        }
        this.mItemSourceTexts = new String[n2];
        this.mItemTexts = new String[n2][];
        this.mItemEvents = new int[n2];
        this.mItemStates = new int[n2];
        this.mItemIcons = new Image[n2][];
        this.mItemSprites = new SpriteObject[n2];
        mScrollUpAnimations = smScrollUpAnimations.clone();
        mScrollDownAnimations = smScrollDownAnimations.clone();
        this.mMaxItemCount = n2;
        this.mTitleBarScrollingDirection = 1;
        this.mHasTitleBar = false;
        this.mSelectedItemScrollingDirection = 1;
        this.mSoftKeys[0] = -1;
        this.mSoftKeys[1] = -1;
        this.setImageFonts(smDefaultTitleBarFont, smDefaultTextFont, smDefaultSelectionFont);
        this.setStyle(-1);
        this.mScreenMaxWidth = Toolkit.getScreenWidth();
        this.mScreenMaxHeight = Toolkit.getScreenHeight();
        this.mScreenSoftkeyAreaHeight = Toolkit.getSoftKeyAreaHeight();
    }

    public void setSoftkey(int n, int n2) {
        this.mSoftKeys[n2] = n;
    }

    public void setStyle(int n) {
        if (n != -1) {
            n = 1;
        }
        switch (n) {
            case 1: {
                this.mEnableBackground = true;
                this.mBackgroundColor = 0xFFFFFF;
                this.mBackgroundGradientColor = 0xFFFFFF;
                this.mTitleBarsOnTop = false;
                this.mSeparateTitleBarBackground = false;
                this.mSelectedItemBackgroundColor = 9486550;
                this.mEnableBorders = false;
                this.mLooseItemAreaAlignment = true;
                break;
            }
            case 2: {
                this.mEnableBackground = false;
                this.mTitleBarsOnTop = true;
                this.mSelectedItemBackgroundColor = 0xFFFF00;
                this.mEnableBorders = false;
                this.mLooseItemAreaAlignment = true;
                break;
            }
            case 3: {
                this.mEnableBackground = true;
                this.mBackgroundColor = 0xCCFFCC;
                this.mBackgroundGradientColor = 0x99FF99;
                this.mTitleBarsOnTop = false;
                this.mSeparateTitleBarBackground = true;
                this.mTitleBarBackgroundColor = 0xCCCCFF;
                this.mTitleBarBackgroundGradientColor = 0x9999FF;
                this.mSelectedItemBackgroundColor = 0xFFFF00;
                this.mEnableBorders = false;
                this.mLooseItemAreaAlignment = true;
                break;
            }
            case 4: {
                this.mEnableBackground = true;
                this.mBackgroundColor = 0xCCFFCC;
                this.mBackgroundGradientColor = 0x99FF99;
                this.mTitleBarsOnTop = true;
                this.mSeparateTitleBarBackground = true;
                this.mTitleBarBackgroundColor = 0xCCCCFF;
                this.mTitleBarBackgroundGradientColor = 0x9999FF;
                this.mSelectedItemBackgroundColor = 0xFFFF00;
                this.mEnableBorders = true;
                this.mLooseItemAreaAlignment = false;
                break;
            }
            case 5: {
                this.mEnableBackground = true;
                this.mBackgroundColor = 0xCCFFCC;
                this.mBackgroundGradientColor = 0x99FF99;
                this.mTitleBarsOnTop = false;
                this.mSeparateTitleBarBackground = true;
                this.mSelectedItemBackgroundColor = 0xFFFF00;
                this.mEnableBorders = true;
                this.mLooseItemAreaAlignment = false;
                break;
            }
            case 6: {
                break;
            }
        }
        if (this.mEnableBorders) {
            this.mScreenXMargin = 1;
            this.mScreenYMargin = 1;
        } else {
            this.mScreenXMargin = 8;
            this.mScreenYMargin = 8;
        }
        this.mStyle = n;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setTitleBar(String string, Image image, int n) {
        this.mHasTitleBar = string != null || image != null;
        this.mTitleBarSourceText = string;
        this.mTitleBarImage = image;
        this.mTitleBarAlignment = n;
    }

    public void setTitleBarDvc(String string, SpriteObject spriteObject, int n) {
        this.setTitleBar(string, null, n);
        this.mHasTitleBar = this.mHasTitleBar || spriteObject != null;
        this.mTitleBarSprite = spriteObject;
    }

    public void setItem(int n, int n2, String string, Image[] imageArray, int n3) {
        if (this.mItemTypes[n] != -1) {
            this.destroyItem(n);
        }
        this.mItemTypes[n] = n2;
        this.mItemEvents[n] = n3;
        this.mItemIcons[n] = imageArray;
        this.mItemSourceTexts[n] = string;
    }

    public void setItemDvc(int n, int n2, String string, SpriteObject spriteObject, int n3) {
        this.setItem(n, n2, string, null, n3);
        this.mItemSprites[n] = spriteObject;
    }

    public void setInputItem(int n, int n2, String string, String string2, Image[] imageArray, int n3, int n4) {
    }

    public void setInputItemDvc(int n, int n2, String string, String string2, SpriteObject spriteObject, int n3, int n4) {
    }

    public void setSwitchItem(int n, String string, Image[] imageArray, String[] stringArray, Image[] imageArray2, int n2) {
        this.setItem(n, 5, string, imageArray, n2);
        if (this.mSettingItemValues == null) {
            this.mSettingItemValues = new int[this.mMaxItemCount];
            this.mSettingItemValueCounts = new int[this.mMaxItemCount];
        }
        this.mSettingItemValues[n] = 0;
        int n3 = this.mSettingItemValueCounts[n] = stringArray != null ? stringArray.length : 0;
        if (this.mSwitchItemTexts == null) {
            this.mSwitchItemTexts = new String[this.mMaxItemCount][];
        }
        this.mSwitchItemTexts[n] = stringArray;
        this.mSettingItemValueCounts[n] = Math.max(this.mSettingItemValueCounts[n], imageArray2 != null ? imageArray2.length : 0);
        if (this.mSwitchItemIcons == null) {
            this.mSwitchItemIcons = new Image[this.mMaxItemCount][];
        }
        this.mSwitchItemIcons[n] = imageArray2;
        if (this.mSwitchItemSprites == null) {
            this.mSwitchItemSprites = new SpriteObject[this.mMaxItemCount];
        }
    }

    public void setSwitchItemDvc(int n, String string, SpriteObject spriteObject, String[] stringArray, SpriteObject spriteObject2, int n2) {
        this.setSwitchItem(n, string, null, stringArray, null, n2);
        this.mSettingItemValueCounts[n] = Math.max(this.mSettingItemValueCounts[n], spriteObject2 != null ? spriteObject2.getAnimationCount() : 0);
        this.mItemSprites[n] = spriteObject;
        this.mSwitchItemSprites[n] = spriteObject2;
    }

    public void setSliderItem(int n, String string, Image[] imageArray, int n2, int n3, int n4) {
        this.setItem(n, 4, string, imageArray, n4);
        if (this.mSettingItemValues == null) {
            this.mSettingItemValues = new int[this.mMaxItemCount];
            this.mSettingItemValueCounts = new int[this.mMaxItemCount];
        }
        this.mSettingItemValues[n] = n2;
        this.mSettingItemValueCounts[n] = n3 + 1;
    }

    public void setSliderItemDvc(int n, String string, SpriteObject spriteObject, int n2, int n3, int n4) {
        this.setSliderItem(n, string, null, n2, n3, n4);
        this.mItemSprites[n] = spriteObject;
    }

    public void setTableItem(int n, int[] nArray, int[] nArray2, String[] stringArray, Image[] imageArray) {
    }

    public void setTableItemDvc(int n, int[] nArray, int[] nArray2, String[] stringArray, SpriteObject[] spriteObjectArray) {
    }

    public void setSubMenuItem(int n, MenuObject menuObject) {
    }

    public void setExtendedItemParameters(int n, int n2, int n3) {
    }

    public void setItemSpecificTitleBar(int n, String string) {
    }

    public void destroyItem(int n) {
        int n2 = this.mItemTypes[n];
        if (n2 != -1 && this.mSelectedIndex == n) {
            this.mSelectedIndex = this.getNextSelectableItemIndex(n);
            if (this.mSelectedIndex < n) {
                this.mSelectedIndex = this.getPreviousSelectableItemIndex(n);
            }
        }
        if (this.mItemIcons != null) {
            this.mItemIcons[n] = null;
        }
        if (this.mSwitchItemIcons != null) {
            this.mSwitchItemIcons[n] = null;
        }
        if (this.mItemSprites != null && this.mItemSprites[n] != null) {
            this.mItemSprites[n].freeResources();
            this.mItemSprites[n] = null;
        }
        if (this.mSwitchItemSprites != null && this.mSwitchItemSprites[n] != null) {
            this.mSwitchItemSprites[n].freeResources();
            this.mSwitchItemSprites[n] = null;
        }
        this.mItemSourceTexts[n] = null;
        this.mItemTexts[n] = null;
        this.mItemTypes[n] = -1;
        if (this.mSwitchItemTexts != null) {
            this.mSwitchItemTexts[n] = null;
        }
    }

    public void setScreenBounds(int n, int n2, int n3, int n4, int n5) {
        this.mScreenMinX = n;
        this.mScreenMinY = n2;
        this.mScreenMaxWidth = n3;
        this.mScreenMaxHeight = n4;
        this.mScreenSoftkeyAreaHeight = n5;
    }

    public void setImageFonts(ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        if (imageFont != null) {
            this.mTitleBarFont = imageFont;
            this.mTitleBarFontHeight = imageFont.getHeight();
        }
        if (imageFont2 != null) {
            this.mTextFont = imageFont2;
            this.mTextFontHeight = imageFont2.getHeight();
        }
        if (imageFont3 != null) {
            this.mSelectionFont = imageFont3;
            this.mSelectionFontHeight = imageFont3.getHeight();
        }
    }

    public int getPreferredWidth(int n) {
        int n2;
        this.setSize(n, Integer.MAX_VALUE, true);
        int n3 = 0;
        if (!this.mTitleBarsOnTop) {
            n2 = this.mTitleBarTextAreaWidth + this.mTitleBarImageAreaWidth;
            n3 = Math.max(n3, n2);
        }
        n2 = 0;
        for (int i = 0; i < this.mMaxItemCount; ++i) {
            n2 = Math.max(n2, this.mItemBounds[i * 4 + 2]);
        }
        n3 = Math.max(n3, this.mWidth - (this.mItemAreaWidth - n2));
        if (this.mEnableBorders) {
            n3 += 8;
        }
        return n3;
    }

    public int getPreferredHeight(int n, int n2) {
        this.setSize(n, n2, true);
        int n3 = Math.min(this.mItemAreaHeight, this.mScrollingAreaHeight);
        if (this.mScreenType == 1) {
            boolean bl = false;
            int n4 = this.mMaxItemCount;
            while (--n4 >= 0) {
                bl = bl || this.mItemTexts[n4] != null;
            }
            if (bl) {
                n4 = this.mTextFontHeight + 2;
                int n5 = n3 / n4 * n4;
                if (n5 < n3) {
                    n5 += n4;
                }
                n3 = n5;
            }
        } else if (this.mScreenType == 0) {
            int n6 = this.mSelectionItemHeight;
            n3 = n3 / n6 * n6;
        }
        int n7 = this.mHeight - (this.mItemAreaHeight - n3);
        if (this.mEnableBorders) {
            n7 += 8;
        }
        return n7;
    }

    public void setSize(int n, int n2) {
        this.setSize(n, n2, false);
    }

    private void setSize(int n, int n2, boolean bl) {
        if (this.mEnableBorders) {
            n -= 8;
            n2 -= 8;
        }
        this.mWidth = n;
        this.mHeight = n2;
        this.mItemAreaX = this.mScreenXMargin;
        this.mItemAreaWidth = n - (this.mScreenXMargin << 1);
        if (this.mScreenType == 0 && Game.smMenuResourcesLoaded) {
            this.mItemAreaWidth = 160 * Toolkit.getScreenWidth() / 240;
            this.mItemAreaX = n - this.mItemAreaWidth >> 1;
        }
        this.calculateTitleBarLayout(bl);
        this.calculateItemLayout(bl);
        if (bl) {
            return;
        }
        if (this.mScreenType == 0) {
            this.mSelectionItemsPerScreen = this.mItemAreaHeight / this.mSelectionItemHeight;
            if (this.mItemAreaHeight < this.mScrollingAreaHeight) {
                this.mItemAreaY += this.mItemAreaHeight - this.mSelectionItemsPerScreen * this.mSelectionItemHeight >> 1;
            }
        }
        if (this.mSelectedIndex == -1) {
            this.mSelectedIndex = 0;
        }
        this.mSelectedIndex = this.getNextSelectableItemIndex(this.mSelectedIndex);
        if (this.mSelectedIndex != -1) {
            this.mSelectedIndex = this.getPreviousSelectableItemIndex(this.mSelectedIndex);
        }
        this.mVerticalScrollingOffset = 0;
        this.mCurrentPage = 0;
        if (this.mSelectedIndex != -1) {
            this.setSelectedItem(this.mSelectedIndex);
        }
        this.mLastDrawX = Integer.MAX_VALUE;
        this.mLastDrawY = Integer.MAX_VALUE;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.mX = 0;
        this.mY = 0;
        this.mLastDrawX = 0;
        this.mLastDrawY = 0;
        this.setSize(n3, n4);
        this.mX = n;
        this.mY = n2;
        this.mLastDrawX = n;
        this.mLastDrawY = n2;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getX() {
        return this.mLastDrawX;
    }

    public int getY() {
        return this.mLastDrawY;
    }

    public void setVisible() {
        this.selectionChanged();
        this.mScrollingEvent = 0;
        this.mTitleBarUpdateTimer = 2000;
        this.mTitleBarScrollingOffset = 0;
        this.mBlinkingTimer = 0;
        mScrollUpAnimations.setAnimation(0, -1, true);
        mScrollDownAnimations.setAnimation(0, -1, true);
    }

    public int[] logicUpdate(int n) {
        int n2;
        this.mBlinkingTimer += n;
        this.mBlinkingTimer &= 0xFFFFFFF;
        if (this.mScrollingEvent != 0 && this.mScrollingAreaHeight > this.mItemAreaHeight) {
            this.mScrollingTimer += n;
            n2 = this.mScrollingTimer * (this.mTextFontHeight + 2) / 300;
            this.mScrollingTimer -= n2 * 300 / (this.mTextFontHeight + 2);
            if (this.mScrollingEvent == 2) {
                this.mVerticalScrollingOffset -= n2;
            } else if (this.mScrollingEvent == 1) {
                this.mVerticalScrollingOffset += n2;
            }
            if (this.mEnsureScrollOnce == 2) {
                this.mScrollingEvent = 0;
            } else {
                this.mEnsureScrollOnce = 1;
            }
            this.mVerticalScrollingOffset = Math.max(this.mVerticalScrollingOffset, 0);
            this.mVerticalScrollingOffset = Math.min(this.mVerticalScrollingOffset, this.mScrollingAreaHeight - this.mItemAreaHeight);
        }
        if (this.mHasTitleBar) {
            this.updateTitleBar(n);
        }
        for (n2 = 0; n2 < this.mMaxItemCount; ++n2) {
            this.updateItem(n2, n);
        }
        mScrollUpAnimations.logicUpdate(n);
        mScrollDownAnimations.logicUpdate(n);
        if (this.mScreenType == 1) {
            int n3;
            int n4 = n2 = this.mScrollingEvent == 2 ? 2 : 0;
            if (n2 != mScrollUpAnimations.getCurrentAnimationIndex()) {
                mScrollUpAnimations.setAnimation(n2, -1, true);
            }
            int n5 = n3 = this.mScrollingEvent == 1 ? 2 : 0;
            if (n3 != mScrollDownAnimations.getCurrentAnimationIndex()) {
                mScrollDownAnimations.setAnimation(n3, -1, true);
            }
        } else {
            if (mScrollUpAnimations.isFinishedAnimation()) {
                mScrollUpAnimations.setAnimation(0, -1, true);
            }
            if (mScrollDownAnimations.isFinishedAnimation()) {
                mScrollDownAnimations.setAnimation(0, -1, true);
            }
        }
        if (this.mNewMenuEventAvailable) {
            this.mNewMenuEventAvailable = false;
            return this.mLastMenuEvent;
        }
        return null;
    }

    private boolean drawScrollUpArrow() {
        if (this.mScrollingAreaHeight > this.mItemAreaHeight) {
            boolean bl = this.mVerticalScrollingOffset > 0;
            bl = bl || mScrollUpAnimations.getCurrentAnimationIndex() == 1;
            return bl;
        }
        return false;
    }

    private boolean drawScrollDownArrow() {
        if (this.mScrollingAreaHeight > this.mItemAreaHeight) {
            boolean bl = this.mVerticalScrollingOffset + this.mItemAreaHeight < this.mScrollingAreaHeight;
            bl = bl || mScrollDownAnimations.getCurrentAnimationIndex() == 1;
            return bl;
        }
        return false;
    }

    public void doDraw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mEnableBorders) {
            n += 4;
            n2 += 4;
        }
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = n;
        int n16 = n2;
        int n17 = this.mWidth;
        int n18 = this.mHeight;
        if (this.mHasTitleBar) {
            if (this.mTitleBarsOnTop) {
                n11 = this.mScreenMinX;
                n12 = this.mScreenMinY;
                n13 = this.mScreenMaxWidth;
            } else {
                n11 = n;
                n12 = n2;
                n13 = this.mWidth;
            }
            n14 = this.mTitleBarHeight;
        }
        if (this.mHasTitleBar && this.mSeparateTitleBarBackground) {
            graphics.setClip(n11, n12, n13, n14);
            this.drawTitleBarBackground(graphics, n11, n12, n13, n14);
            n16 += n14;
            n18 -= n14;
        }
        if (this.mEnableBackground) {
            graphics.setClip(n15, n16, n17, n18);
            this.drawBackground(graphics, n15, n16, n17, n18);
        }
        if (this.mEnableBorders) {
            if (!this.mTitleBarsOnTop && this.mSeparateTitleBarBackground) {
                n16 -= n14;
                n18 += n14;
            }
            n6 = n15 - 4;
            n5 = n16 - 4;
            n4 = n17 + 8;
            n3 = n18 + 8;
            this.drawBorders(graphics, n6, n5, n4, n3);
        }
        n6 = n2;
        if (this.mHasTitleBar) {
            graphics.setClip(n11 += this.mTitleBarX, n12, n13, this.mTitleBarHeight);
            this.drawTitleBar(graphics, n11, n12, n14);
            n6 += this.mTitleBarHeight;
        }
        graphics.setClip(n, n6, this.mWidth, this.mHeight - this.mTitleBarHeight);
        if (this.mScrollingAreaHeight < this.mItemAreaHeight) {
            if ((this.mItemAlignment & 2) != 0) {
                n2 += this.mItemAreaHeight - this.mScrollingAreaHeight >> 1;
            } else if ((this.mItemAlignment & 8) != 0) {
                n2 += this.mItemAreaHeight - this.mScrollingAreaHeight;
            }
        }
        if (this.mScreenType == 0) {
            int n19;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            this.mOffsetY = 0;
            if (this.mItemAlignment == 0) {
                for (n19 = 0; n19 < this.mMaxItemCount; ++n19) {
                    this.mOffsetY += this.mItemBounds[n19 * 4 + 3];
                }
                this.mOffsetY = (this.mItemAreaHeight - this.mOffsetY) / 2;
                if (this.mOffsetY < 0) {
                    this.mOffsetY = 0;
                }
            }
            for (n19 = 0; n19 < this.mMaxItemCount; ++n19) {
                int n20 = n + this.mItemAreaX + this.mItemBounds[n19 * 4 + 0];
                int n21 = this.mItemBounds[n19 * 4 + 1] - this.mVerticalScrollingOffset;
                int n22 = this.mItemBounds[n19 * 4 + 2];
                int n23 = this.mItemBounds[n19 * 4 + 3];
                if (n21 < 0 || n21 + n23 > this.mItemAreaHeight) continue;
                n21 += n2 + this.mItemAreaY;
                if (this.mItemTexts[n19] == null) continue;
                this.drawOptionBar(graphics, this.mItemTexts[n19][0], n19 == this.mSelectedIndex, this.mItemAreaX, n21 + this.mOffsetY + 2, this.mItemAreaWidth, n23 - 4);
                graphics.setClip(n + this.mItemAreaX, n2 + this.mItemAreaY + this.mOffsetY, this.mItemAreaWidth, this.mItemAreaHeight);
                if (Game.mCurrentState == 0 || Game.mCurrentState == 1 || Game.mCurrentState == 3 || Game.mCurrentState == 9 || Game.mCurrentState == 19) {
                    this.drawItem(graphics, n19, n20, n21 + this.mOffsetY + 0, n22, n23, n);
                } else {
                    this.drawItem(graphics, n19, n20, n21 + this.mOffsetY, n22, n23, n);
                }
                if (n19 != this.mSelectedIndex) continue;
                n3 = n23 - 4;
                n5 = this.mItemAreaX + (this.mItemAreaWidth >> 1);
                n4 = n21 + (n3 >> 1) + this.mOffsetY + 2;
            }
            if (Game.smSelectorSpr != null) {
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                Game.smSelectorSpr[0].draw(graphics, n5 - (this.mItemAreaWidth >> 1), n4 - (n3 >> 1));
                Game.smSelectorSpr[1].draw(graphics, n5 + (this.mItemAreaWidth >> 1), n4 - (n3 >> 1));
                Game.smSelectorSpr[2].draw(graphics, n5 - (this.mItemAreaWidth >> 1), n4 + (n3 >> 1));
                Game.smSelectorSpr[3].draw(graphics, n5 + (this.mItemAreaWidth >> 1), n4 + (n3 >> 1));
            }
        } else if (this.mScreenType == 1) {
            for (n5 = 0; n5 < this.mMaxItemCount; ++n5) {
                n4 = this.mItemAreaX + this.mItemBounds[n5 * 4 + 0];
                n3 = this.mItemAreaY + this.mItemBounds[n5 * 4 + 1] - this.mVerticalScrollingOffset;
                int n24 = this.mItemBounds[n5 * 4 + 2];
                int n25 = this.mItemBounds[n5 * 4 + 3];
                if (n3 + n25 < this.mItemAreaY || n3 >= this.mItemAreaY + this.mItemAreaHeight) continue;
                graphics.setClip(n + this.mItemAreaX, n2 + this.mItemAreaY, this.mItemAreaWidth, this.mItemAreaHeight);
                this.drawItem(graphics, n5, n + n4, n2 + n3, n24, n25, n);
            }
        }
        if (this.drawScrollUpArrow()) {
            n5 = n + this.mScrollArrowX;
            n4 = n2 + this.mScrollArrowUpY;
            graphics.setClip(n7, n8, n9, n10);
            mScrollUpAnimations.draw(graphics, (n5 -= mScrollUpAnimations.getWidth() >> 1) + mScrollUpAnimations.getPivotX(), (n4 -= mScrollUpAnimations.getHeight() >> 1) + mScrollUpAnimations.getPivotY());
        }
        if (this.drawScrollDownArrow()) {
            n5 = n + this.mScrollArrowX;
            n4 = n2 + this.mScrollArrowDownY;
            graphics.setClip(n7, n8, n9, n10);
            mScrollDownAnimations.draw(graphics, (n5 -= mScrollDownAnimations.getWidth() >> 1) + mScrollDownAnimations.getPivotX(), (n4 -= mScrollDownAnimations.getHeight() >> 1) + mScrollDownAnimations.getPivotY());
        }
        graphics.setClip(n7, n8, n9, n10);
        this.mLastDrawX = n;
        this.mLastDrawY = n2;
    }

    public void doDraw(Graphics graphics) {
        this.doDraw(graphics, this.mX, this.mY);
    }

    public void keyEventOccurred(int n, int n2) {
        int n3 = -1;
        if (!this.mNewMenuEventAvailable) {
            switch (n2) {
                case 3: {
                    if (this.mScreenType == 0) {
                        if (n == this.mSoftKeys[1]) {
                            n3 = 0;
                        }
                        if (this.mSelectedIndex == -1 || this.mItemStates[this.mSelectedIndex] == 1 || n != this.mSoftKeys[0]) break;
                        if (this.mItemTypes[this.mSelectedIndex] == 4 || this.mItemTypes[this.mSelectedIndex] == 5) {
                            this.mSettingItemValues[this.mSelectedIndex] = (this.mSettingItemValues[this.mSelectedIndex] + 1) % this.mSettingItemValueCounts[this.mSelectedIndex];
                        }
                        n3 = 1;
                        break;
                    }
                    n3 = 0;
                    break;
                }
                case 0: {
                    int n4;
                    int n5 = Toolkit.getToolkitGameAction(n);
                    if (this.mScreenType == 0 && this.mSelectedIndex != -1 && (this.mItemTypes[this.mSelectedIndex] == 4 || this.mItemTypes[this.mSelectedIndex] == 5) && this.mItemStates[this.mSelectedIndex] != 1) {
                        n4 = this.mSettingItemValues[this.mSelectedIndex];
                        if (n5 == 52) {
                            int n6 = this.mSelectedIndex;
                            this.mSettingItemValues[n6] = this.mSettingItemValues[n6] - 1;
                        } else if (n5 == 54) {
                            int n7 = this.mSelectedIndex;
                            this.mSettingItemValues[n7] = this.mSettingItemValues[n7] + 1;
                        }
                        this.mSettingItemValues[this.mSelectedIndex] = this.mItemTypes[this.mSelectedIndex] == 4 ? Math.max(Math.min(this.mSettingItemValues[this.mSelectedIndex], this.mSettingItemValueCounts[this.mSelectedIndex] - 1), 0) : (this.mSettingItemValues[this.mSelectedIndex] + this.mSettingItemValueCounts[this.mSelectedIndex]) % this.mSettingItemValueCounts[this.mSelectedIndex];
                        if (this.mSettingItemValues[this.mSelectedIndex] != n4) {
                            n3 = 1;
                        }
                    }
                    if (n5 == 53) {
                        if (this.mScreenType == 0) {
                            if (this.mSelectedIndex == -1 || this.mItemStates[this.mSelectedIndex] == 1) break;
                            if (this.mItemTypes[this.mSelectedIndex] == 0) {
                                n3 = 1;
                                break;
                            }
                            if (this.mItemTypes[this.mSelectedIndex] != 5 && this.mItemTypes[this.mSelectedIndex] != 4) break;
                            this.mSettingItemValues[this.mSelectedIndex] = (this.mSettingItemValues[this.mSelectedIndex] + 1) % this.mSettingItemValueCounts[this.mSelectedIndex];
                            n3 = 1;
                            break;
                        }
                        n3 = 0;
                        n = this.mSoftKeys[0];
                        break;
                    }
                    if (n5 == 50) {
                        if (this.mScreenType == 0) {
                            n4 = this.getPreviousSelectableItemIndex(this.mSelectedIndex);
                            if (n4 == -1) break;
                            this.setSelectedItem(n4);
                            if (this.drawScrollUpArrow()) {
                                mScrollUpAnimations.setAnimation(1, 1, true);
                            }
                            this.selectionChanged();
                            break;
                        }
                        if (this.mScreenType != 1) break;
                        this.mScrollingEvent = 2;
                        this.mEnsureScrollOnce = 0;
                        break;
                    }
                    if (n5 != 56) break;
                    if (this.mScreenType == 0) {
                        n4 = this.getNextSelectableItemIndex(this.mSelectedIndex);
                        if (n4 == -1) break;
                        this.setSelectedItem(n4);
                        if (this.drawScrollDownArrow()) {
                            mScrollDownAnimations.setAnimation(1, 1, true);
                        }
                        this.selectionChanged();
                        break;
                    }
                    if (this.mScreenType != 1) break;
                    this.mScrollingEvent = 1;
                    this.mEnsureScrollOnce = 0;
                    break;
                }
                case 1: {
                    if (this.mEnsureScrollOnce == 1) {
                        this.mScrollingEvent = 0;
                        break;
                    }
                    this.mEnsureScrollOnce = 2;
                }
            }
        }
        if (n3 != -1) {
            this.mNewMenuEventAvailable = true;
            this.mLastMenuEvent[0] = n3;
            this.mLastMenuEvent[1] = n3 == 1 ? this.mItemEvents[this.mSelectedIndex] : n;
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        n -= this.mLastDrawX;
        n2 -= this.mLastDrawY;
        if (n3 == 0) {
            if (this.mScrollingAreaHeight > this.mItemAreaHeight) {
                if (this.mVerticalScrollingOffset > 0 && n >= this.mScrollArrowX - mScrollUpAnimations.getWidth() - 40 && n < this.mScrollArrowX + mScrollUpAnimations.getWidth() - -40 && n2 >= this.mScrollArrowUpY - mScrollUpAnimations.getHeight() - 40 && n2 < this.mScrollArrowUpY + mScrollUpAnimations.getHeight() - -40) {
                    if (this.mScreenType == 0) {
                        int n4 = this.getPreviousSelectableItemIndex(this.mSelectedIndex);
                        if (n4 != -1) {
                            this.setSelectedItem(n4);
                            if (this.drawScrollUpArrow()) {
                                mScrollUpAnimations.setAnimation(1, 1, true);
                            }
                            this.selectionChanged();
                        }
                    } else {
                        this.mScrollingEvent = 2;
                        this.mEnsureScrollOnce = 1;
                    }
                    return;
                }
                if (this.mVerticalScrollingOffset + this.mItemAreaHeight < this.mScrollingAreaHeight && n >= this.mScrollArrowX - mScrollDownAnimations.getWidth() - 40 && n < this.mScrollArrowX + mScrollDownAnimations.getWidth() - -40 && n2 >= this.mScrollArrowDownY - mScrollDownAnimations.getHeight() - 40 && n2 < this.mScrollArrowDownY + mScrollDownAnimations.getHeight() - -40) {
                    if (this.mScreenType == 0) {
                        int n5 = this.getNextSelectableItemIndex(this.mSelectedIndex);
                        if (n5 != -1) {
                            this.setSelectedItem(n5);
                            if (this.drawScrollDownArrow()) {
                                mScrollDownAnimations.setAnimation(1, 1, true);
                            }
                            this.selectionChanged();
                        }
                    } else {
                        this.mScrollingEvent = 1;
                        this.mEnsureScrollOnce = 1;
                    }
                    return;
                }
            }
            if (this.mScreenType == 0) {
                int n6 = this.mSelectionItemsPerScreen * this.mSelectionItemHeight;
                if (n >= this.mItemAreaX && n < this.mItemAreaX + this.mItemAreaWidth && n2 >= this.mItemAreaY && n2 < this.mItemAreaY + n6) {
                    for (int i = 0; i < this.mMaxItemCount; ++i) {
                        int n7 = this.mItemAreaY + this.mItemBounds[i * 4 + 1] - this.mVerticalScrollingOffset + this.mOffsetY;
                        int n8 = this.mItemBounds[i * 4 + 3];
                        if (n2 < n7 || n2 >= n7 + n8) continue;
                        if (this.mSelectedIndex == i) {
                            if (this.mItemStates[this.mSelectedIndex] != 1) {
                                boolean bl = false;
                                if (this.mItemTypes[i] == 0) {
                                    bl = true;
                                } else if (this.mItemTypes[i] == 5 || this.mItemTypes[i] == 4) {
                                    this.mSettingItemValues[i] = (this.mSettingItemValues[i] + 1) % this.mSettingItemValueCounts[i];
                                    bl = true;
                                }
                                if (bl) {
                                    this.mNewMenuEventAvailable = true;
                                    this.mLastMenuEvent[0] = 1;
                                    this.mLastMenuEvent[1] = this.mItemEvents[i];
                                }
                            }
                        } else {
                            this.setSelectedItem(i);
                            this.selectionChanged();
                            this.setInputEditingMode(false);
                        }
                        return;
                    }
                }
            }
        } else if (n3 == 1) {
            this.mScrollingEvent = 0;
        }
    }

    public void setSelectedItem(int n) {
        this.mSelectedIndex = this.getNextSelectableItemIndex(n - 1);
        if (this.mSelectedIndex == -1) {
            return;
        }
        this.mSelectedItemUpdateTimer = 0;
        this.mSelectedItemScrollingOffset = 0;
        this.mSelectedItemScrollingDirection = 0;
        if (this.mScrollingAreaHeight > this.mItemAreaHeight) {
            int n2 = this.mVerticalScrollingOffset / this.mSelectionItemHeight;
            int n3 = this.mScrollingAreaHeight / this.mSelectionItemHeight;
            int n4 = this.mItemBounds[n * 4 + 1] / this.mSelectionItemHeight;
            n2 = Math.max(n2, n4 - (this.mSelectionItemsPerScreen >> 1));
            n2 = Math.min(n2, n4 - (this.mSelectionItemsPerScreen - 1 >> 1));
            n2 = Math.max(n2, 0);
            n2 = Math.min(n2, n3 - this.mSelectionItemsPerScreen);
            this.mVerticalScrollingOffset = n2 * this.mSelectionItemHeight;
        } else {
            this.mVerticalScrollingOffset = 0;
        }
        this.mSelectedItemScrollingDirection = 0;
        this.mSelectedItemScrollingOffset = 0;
    }

    public int getSelectedItem() {
        return this.mSelectedIndex;
    }

    public void setSelectionItemState(int n, int n2) {
        this.mItemStates[n] = n2;
    }

    public int getSelectionItemState(int n) {
        return this.mItemStates[n];
    }

    public void setItemIntValue(int n, int n2) {
        this.mSettingItemValues[n] = n2;
    }

    public int getItemIntValue(int n) {
        return this.mSettingItemValues[n];
    }

    public String getItemStringValue(int n) {
        return null;
    }

    public static void drawGradientRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n5 != n6) {
            int n8 = (n5 & 0xFF0000) >> 16;
            int n9 = (n5 & 0xFF00) >> 8;
            int n10 = n5 & 0xFF;
            int n11 = ((n6 & 0xFF0000) >> 16) - n8;
            int n12 = ((n6 & 0xFF00) >> 8) - n9;
            int n13 = (n6 & 0xFF) - n10;
            for (int i = 0; i < n4; i += n7) {
                if (i + n7 > n4) {
                    n7 = n4 - i;
                }
                graphics.setColor(n8 + i * n11 / (n4 - 1), n9 + i * n12 / (n4 - 1), n10 + i * n13 / (n4 - 1));
                graphics.fillRect(n, n2 + i, n3, n7);
            }
        } else {
            graphics.setColor(n5);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    public static String[] splitString(String string, ImageFont imageFont, int n) {
        smSplitStringFont = imageFont;
        return MenuObject.splitString(string, n, 0, 0);
    }

    private void calculateTitleBarLayout(boolean bl) {
        if (this.mHasTitleBar) {
            int n = 0;
            int n2 = 0;
            if (this.mTitleBarImage != null) {
                n = this.mTitleBarImage.getWidth() + 16;
                n2 = this.mTitleBarImage.getHeight();
            }
            if (this.mTitleBarSprite != null) {
                n = this.mTitleBarSprite.getWidth() + 16;
                n2 = this.mTitleBarSprite.getHeight();
            }
            this.mTitleBarImageAreaWidth = n;
            this.mTitleBarHeight = Math.max(this.mTitleBarFontHeight, n2) + 12;
            int n3 = n;
            int n4 = this.mTitleBarsOnTop ? this.mScreenMaxWidth : this.mWidth;
            int n5 = n4 - 16 - n;
            if (this.mTitleBarSourceText != null) {
                this.mTitleBarText = new String[]{this.mTitleBarSourceText};
            }
            int n6 = 0;
            boolean bl2 = false;
            if (this.mTitleBarText != null) {
                for (int i = 0; i < this.mTitleBarText.length; ++i) {
                    n6 = Math.max(n6, this.mTitleBarFont.stringWidth(this.mTitleBarText[i]));
                }
                bl2 = true;
                if (!bl) {
                    this.mTitleBarSourceText = null;
                }
            }
            if (bl2) {
                n6 = Math.min(n6, n4 - n3 - 16);
                this.mTitleBarTextAreaWidth = n6 + 16;
                n3 += this.mTitleBarTextAreaWidth;
            } else {
                this.mTitleBarTextAreaWidth = 0;
            }
            this.mTitleBarX = 0;
            if ((this.mTitleBarAlignment & 1) != 0) {
                this.mTitleBarX = n4 - n3 >> 1;
            } else if ((this.mTitleBarAlignment & 4) != 0) {
                this.mTitleBarX = n4 - n3;
            }
        } else {
            this.mTitleBarHeight = 0;
        }
    }

    private void calculateItemLayout(boolean bl) {
        int n;
        int n2;
        int n3;
        if (this.mHasTitleBar) {
            n3 = this.mTitleBarHeight;
            if (this.mTitleBarsOnTop) {
                n3 += this.mScreenYMargin;
            }
        } else {
            n3 = this.mScreenYMargin;
        }
        this.mItemAreaY = n3;
        int n4 = this.mScreenMinY + this.mScreenMaxHeight - this.mScreenSoftkeyAreaHeight;
        int n5 = this.mHeight;
        int n6 = Math.min(n5 - this.mItemAreaY - this.mScreenYMargin, n4 - this.mItemAreaY);
        int n7 = Math.min(n5 - this.mScreenYMargin - smScrollArrowDownSpace, n4) - this.mItemAreaY - smScrollArrowUpSpace;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.mScreenType == 0) {
            for (n2 = 0; n2 < this.mMaxItemCount; ++n2) {
                int n10;
                n = 8;
                Object object = this.mItemIcons[n2];
                if (object != null) {
                    for (n10 = 0; n10 < ((Image[])object).length; ++n10) {
                        if (object[n10] == null) continue;
                        n8 = Math.max(n8, object[n10].getWidth() + (n << 1));
                        n9 = Math.max(n9, object[n10].getHeight() + 12);
                    }
                }
                if ((object = this.mItemSprites[n2]) != null) {
                    for (n10 = 0; n10 < ((SpriteObject)object).getAnimationCount(); ++n10) {
                        ((SpriteObject)object).setAnimation(n10, -2, true);
                        n8 = Math.max(n8, ((SpriteObject)object).getWidth() + (n << 1));
                        n9 = Math.max(n9, ((SpriteObject)object).getHeight() + 12);
                    }
                }
                boolean bl5 = bl3 = bl3 || this.mItemTypes[n2] == 4 || this.mItemTypes[n2] == 5;
                if (this.mItemTypes[n2] != 5) continue;
                object = this.mSwitchItemIcons[n2];
                if (object != null) {
                    for (n10 = 0; n10 < ((Object)object).length; ++n10) {
                        if (object[n10] == null) continue;
                        n9 = Math.max(n9, object[n10].getHeight() + 12);
                    }
                }
                if ((object = this.mSwitchItemSprites[n2]) == null) continue;
                for (n10 = 0; n10 < ((SpriteObject)object).getAnimationCount(); ++n10) {
                    ((SpriteObject)object).setAnimation(n10, -2, true);
                    n9 = Math.max(n9, ((SpriteObject)object).getHeight() + 12);
                }
            }
        } else if (this.mScreenType == 1) {
            // empty if block
        }
        this.mItemBounds = new int[this.mMaxItemCount * 4];
        this.mItemImageAreaWidths = new int[this.mMaxItemCount];
        this.mItemTextAreaWidths = new int[this.mMaxItemCount];
        if (this.mScreenType == 1) {
            this.mItemCornerRows = new int[this.mMaxItemCount];
        }
        if (bl3) {
            this.mSettingItemImageAreaWidths = new int[this.mMaxItemCount];
            this.mSettingItemTextAreaWidths = new int[this.mMaxItemCount];
        }
        if (this.mScreenType == 0) {
            this.mSelectionItemHeight = Math.max(n9, this.mSelectionFontHeight + 12);
            if (this.mItemFont != null) {
                for (n2 = 0; n2 < this.mMaxItemCount; ++n2) {
                    if (this.mItemFont[n2] == null) continue;
                    this.mSelectionItemHeight = Math.max(this.mSelectionItemHeight, this.mItemFont[n2].getHeight() + 12);
                }
            }
        }
        this.calculateItemSizes(n8, n9, bl);
        for (n2 = 0; n2 < this.mMaxItemCount; ++n2) {
            n = 0;
            if (this.mScreenType != 0 && (n == 0 || (this.mItemAlignments[n2] & 1) == 0) && (n != 0 || (this.mItemAlignment & 1) == 0)) continue;
            this.mItemBounds[n2 * 4 + 0] = this.mItemAreaWidth - this.mItemBounds[n2 * 4 + 2] >> 1;
        }
        n2 = 0;
        do {
            int n11;
            if (n2 != 0) {
                this.mItemAreaY = n3 + smScrollArrowUpSpace;
                this.mItemAreaHeight = n7;
                this.mScrollArrowX = this.mWidth >> 1;
                this.mScrollArrowUpY = this.mItemAreaY - smScrollArrowUpSpace + (smScrollArrowUpSpace >> 1);
                this.mScrollArrowDownY = this.mItemAreaY + this.mItemAreaHeight + (smScrollArrowDownSpace >> 1);
            } else {
                this.mItemAreaHeight = n6;
            }
            if (this.mScreenType == 1) {
                this.mItemAreaY += 6;
                this.mItemAreaHeight -= 12;
                if (!bl) {
                    n = 0;
                    n11 = this.mMaxItemCount;
                    while (--n11 >= 0) {
                        n = n != 0 || this.mItemTexts[n11] != null ? 1 : 0;
                    }
                    if (n != 0) {
                        n11 = this.mTextFontHeight + 2;
                        this.mItemAreaY += this.mItemAreaHeight % n11 >> 1;
                        this.mItemAreaHeight = this.mItemAreaHeight / n11 * n11;
                    }
                }
            }
            n = 0;
            for (n11 = 0; n11 < this.mMaxItemCount; ++n11) {
                this.mItemBounds[n11 * 4 + 1] = n;
                if (this.mScreenType != 1 || (n += this.mItemBounds[n11 * 4 + 3]) == 0) continue;
                n = ((n - 1) / (this.mTextFontHeight + 2) + 1) * (this.mTextFontHeight + 2);
            }
            if (this.mMaxItemCount > 0) {
                this.mScrollingAreaHeight = this.mItemBounds[(this.mMaxItemCount - 1) * 4 + 1] + this.mItemBounds[(this.mMaxItemCount - 1) * 4 + 3];
            }
            if (n2 != 0) {
                n2 = 0;
                continue;
            }
            if (this.mScrollingAreaHeight > this.mItemAreaHeight) {
                n2 = 1;
                continue;
            }
            if (!this.mLooseItemAreaAlignment) continue;
            if (this.mScreenType == 0 && n7 / this.mSelectionItemHeight >= 3) {
                n2 = 1;
                continue;
            }
            if (this.mScreenType != 1 || n7 / (this.mTextFontHeight + 2) < 3) continue;
            n2 = 1;
        } while (n2 != 0);
    }

    private ImageFont getMenuItemFont(int n) {
        if (this.mItemFont != null && this.mItemFont[n] != null) {
            return this.mItemFont[n];
        }
        return this.mSelectionFont;
    }

    public void setMenuItemFont(int n, ImageFont imageFont) {
        if (this.mItemFont == null) {
            this.mItemFont = new ImageFont[this.mMaxItemCount];
        }
        this.mItemFont[n] = imageFont;
    }

    private void calculateItemSizes(int n, int n2, boolean bl) {
        for (int i = 0; i < this.mMaxItemCount; ++i) {
            int n3;
            String string;
            int n4;
            int n5;
            int n6;
            ImageFont imageFont = this.getMenuItemFont(i);
            int n7 = imageFont.getHeight();
            int n8 = 8;
            int n9 = 0;
            int n10 = 0;
            if (this.mScreenType == 0) {
                n9 = n;
                n10 = n2;
            } else {
                if (this.mItemIcons[i] != null) {
                    n9 = this.mItemIcons[i][0].getWidth() + (n8 << 1);
                    n10 = this.mItemIcons[i][0].getHeight();
                }
                if (this.mItemSprites[i] != null) {
                    n9 = this.mItemSprites[i].getWidth() + (n8 << 1);
                    n10 = this.mItemSprites[i].getHeight();
                }
            }
            if (this.mScreenType != 0) {
                this.mItemImageAreaWidths[i] = n9;
            }
            int n11 = 0;
            int n12 = n10;
            if (this.mItemTypes[i] == 5) {
                n6 = 0;
                Object object = this.mSwitchItemIcons[i];
                if (object != null) {
                    for (n5 = 0; n5 < ((Image[])object).length; ++n5) {
                        if (object[n5] == null) continue;
                        n6 = Math.max(n6, object[n5].getWidth() + (n8 << 1));
                    }
                }
                if ((object = this.mSwitchItemSprites[i]) != null) {
                    for (n5 = 0; n5 < ((SpriteObject)object).getAnimationCount(); ++n5) {
                        ((SpriteObject)object).setAnimation(n5, -2, true);
                        n6 = Math.max(n6, ((SpriteObject)object).getWidth() + (n8 << 1));
                    }
                }
                this.mSettingItemImageAreaWidths[i] = n6;
                n4 = 0;
                if (this.mSwitchItemTexts[i] != null) {
                    for (n5 = 0; n5 < this.mSwitchItemTexts[i].length; ++n5) {
                        string = this.mSwitchItemTexts[i][n5];
                        if (string == null) continue;
                        n4 = Math.max(n4, imageFont.stringWidth(string));
                    }
                    n4 += n8 << 1;
                }
                this.mSettingItemTextAreaWidths[i] = n4;
                n11 += n6 + n4;
            } else if (this.mItemTypes[i] == 4) {
                this.mSettingItemImageAreaWidths[i] = n6 = 12 + (this.mSettingItemValueCounts[i] - 2) * 13 + (n8 << 1);
                this.mSettingItemTextAreaWidths[i] = 0;
                n11 += n6;
            }
            n6 = 0;
            n4 = 0;
            if (this.mScreenType == 1) {
                if (this.mItemIcons[i] != null) {
                    n6 = this.mItemIcons[i][0].getWidth() + (n8 << 1);
                    n5 = this.mItemIcons[i][0].getHeight();
                    n4 = (n5 - 1) / (this.mTextFontHeight + 2) + 1;
                }
                if (this.mItemSprites[i] != null) {
                    n6 = this.mItemSprites[i].getWidth() + (n8 << 1);
                    n5 = this.mItemSprites[i].getHeight();
                    n4 = (n5 - 1) / (this.mTextFontHeight + 2) + 1;
                }
                this.mItemCornerRows[i] = n4;
            } else if (this.mScreenType != 0) {
                // empty if block
            }
            String[] stringArray = this.mItemTexts[i];
            string = this.mItemSourceTexts[i];
            if (string != null) {
                if (this.mScreenType == 0) {
                    stringArray = new String[]{string};
                } else {
                    n3 = this.mItemAreaWidth - (n8 << 1) - n11;
                    smSplitStringFont = this.mScreenType == 0 ? imageFont : this.mTextFont;
                    stringArray = MenuObject.splitString(string, n3, n6, n4);
                }
            }
            if (stringArray != null) {
                int n13;
                n3 = 0;
                for (n13 = 0; n13 < stringArray.length; ++n13) {
                    String string2 = stringArray[n13];
                    int n14 = this.mScreenType == 0 ? imageFont.stringWidth(string2) : this.mTextFont.stringWidth(string2);
                    if (n13 < n4) {
                        n14 += n6;
                    }
                    n3 = Math.max(n3, n14);
                }
                n3 = Math.min(n3, this.mItemAreaWidth - n11 - (n8 << 1));
                this.mItemTextAreaWidths[i] = n3 + (n8 << 1);
                n11 += this.mItemTextAreaWidths[i];
                n13 = this.mScreenType == 0 ? n7 + 12 : this.mTextFontHeight * stringArray.length + 2 * stringArray.length;
                n12 = Math.max(n12, n13);
                if (this.mScreenType == 0) {
                    n12 += 8;
                }
                if (!bl) {
                    this.mItemSourceTexts[i] = null;
                }
                this.mItemTexts[i] = stringArray;
            } else if (this.mItemIcons[i] == null && this.mItemSprites[i] == null) {
                n12 = 0;
            }
            if (this.mScreenType == 1 && stringArray == null) {
                n11 += n9;
            }
            if (!(bl || this.mItemTypes[i] != 5 && this.mItemTypes[i] != 4)) {
                n11 = this.mItemAreaWidth;
            }
            if (this.mScreenType == 0 && n12 > 0) {
                n12 = this.mSelectionItemHeight;
            }
            this.mItemBounds[i * 4 + 2] = n11;
            this.mItemBounds[i * 4 + 3] = n12;
        }
    }

    private void calculateTableItemLayout(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 8;
        int n7 = this.mItemAreaWidth - (n6 << 1);
        int n8 = 0;
        int[] nArray = this.mTableItemColumnWeights[n];
        int n9 = nArray.length;
        int n10 = 0;
        if (this.mTableItemSourceTexts[n] != null) {
            n10 = this.mTableItemSourceTexts[n].length;
        } else if (this.mTableItemIcons[n] != null) {
            n10 = this.mTableItemIcons[n].length;
        } else if (this.mTableItemSprites[n] != null) {
            n10 = this.mTableItemSprites[n].length;
        }
        int n11 = n10 / n9;
        int[] nArray2 = new int[n9];
        int[] nArray3 = new int[n11];
        String[][] stringArrayArray = new String[n10][];
        this.mTableItemColumnWidths[n] = nArray2;
        this.mTableItemRowHeights[n] = nArray3;
        this.mTableItemTexts[n] = stringArrayArray;
        int n12 = n7;
        for (n5 = 0; n5 < n9; ++n5) {
            if (nArray[n5] != -1) continue;
            n4 = 0;
            for (n3 = n5; n3 < n10; n3 += n9) {
                Object object;
                if (this.mTableItemSourceTexts[n] != null && this.mTableItemSourceTexts[n][n3] != null) {
                    object = this.mTableItemSourceTexts[n][n3];
                    n4 = Math.max(n4, this.mTextFont.stringWidth((String)object));
                    stringArrayArray[n3] = new String[]{object};
                }
                if (this.mTableItemIcons[n] != null && this.mTableItemIcons[n][n3] != null) {
                    object = this.mTableItemIcons[n][n3];
                    n4 = Math.max(n4, object.getWidth());
                }
                if (this.mTableItemSprites[n] == null || this.mTableItemSprites[n][n3] == null) continue;
                object = this.mTableItemSprites[n][n3];
                n4 = Math.max(n4, ((SpriteObject)object).getWidth());
            }
            nArray2[n5] = n4 += 8;
            n12 -= n4;
        }
        for (n5 = 0; n5 < n9; ++n5) {
            if (nArray[n5] == -1) continue;
            nArray2[n5] = n12 * nArray[n5] / 100;
        }
        n12 = n7;
        for (n5 = 0; n5 < n9; ++n5) {
            n12 -= nArray2[n5];
        }
        int n13 = n9 - 1;
        nArray2[n13] = nArray2[n13] + n12;
        n4 = 0;
        for (n5 = 0; n5 < n11; ++n5) {
            n3 = 0;
            int n14 = 0;
            while (n14 < n9) {
                if (nArray[n14] != -1) {
                    n2 = nArray2[n14] - 8;
                    if (this.mTableItemSourceTexts[n] != null && this.mTableItemSourceTexts[n][n4] != null) {
                        this.mTableItemTexts[n][n4] = MenuObject.splitString(this.mTableItemSourceTexts[n][n4], this.mTextFont, n2);
                    }
                }
                if (this.mTableItemSprites[n] != null && this.mTableItemSprites[n][n4] != null) {
                    n3 = Math.max(n3, this.mTableItemSprites[n][n4].getHeight());
                } else if (this.mTableItemIcons[n] != null && this.mTableItemIcons[n][n4] != null) {
                    n3 = Math.max(n3, this.mTableItemIcons[n][n4].getHeight());
                } else if (this.mTableItemSourceTexts[n] != null && this.mTableItemSourceTexts[n][n4] != null) {
                    n3 = Math.max(n3, this.mTableItemTexts[n][n4].length * this.mTextFontHeight);
                }
                ++n14;
                ++n4;
            }
            n3 += 2;
            nArray3[n5] = n3 = ((n3 - 1) / (this.mTextFontHeight + 2) + 1) * (this.mTextFontHeight + 2);
            n8 += n3;
        }
        if (bl) {
            n5 = 0;
            n3 = 0;
            for (n4 = 0; n4 < n9; ++n4) {
                if (nArray[n4] == -1) continue;
                int n15 = 0;
                n2 = 0;
                while (n2 < n11) {
                    if (this.mTableItemSprites[n] != null && this.mTableItemSprites[n][n3] != null) {
                        n15 = Math.max(n15, this.mTableItemSprites[n][n3].getWidth());
                    } else if (this.mTableItemIcons[n] != null && this.mTableItemIcons[n][n3] != null) {
                        n15 = Math.max(n15, this.mTableItemIcons[n][n3].getWidth());
                    } else if (this.mTableItemTexts[n] != null && this.mTableItemTexts[n][n3] != null) {
                        String[] stringArray = this.mTableItemTexts[n][n3];
                        for (int i = 0; i < stringArray.length; ++i) {
                            n15 = Math.max(n15, this.mTextFont.stringWidth(stringArray[i]));
                        }
                    }
                    ++n2;
                    ++n3;
                }
                n5 = Math.max(n5, ((n15 += 8) * 100 + nArray[n4] - 1) / nArray[n4]);
            }
            n12 = n5;
            n7 = 0;
            for (n4 = 0; n4 < n9; ++n4) {
                if (nArray[n4] != -1) {
                    nArray2[n4] = n5 * nArray[n4] / 100;
                    n12 -= nArray2[n4];
                }
                n7 += nArray2[n4];
            }
            int n16 = n9 - 1;
            nArray2[n16] = nArray2[n16] + n12;
            n7 += n12;
        }
        if (!bl) {
            this.mTableItemSourceTexts[n] = null;
        }
        this.mItemBounds[n * 4 + 2] = n7 + (n6 << 1);
        this.mItemBounds[n * 4 + 3] = n8;
    }

    private void updateTitleBar(int n) {
        if (this.mTitleBarSprite != null) {
            this.mTitleBarSprite.logicUpdate(n);
        }
        String[] stringArray = null;
        if (this.mTitleBarText != null) {
            stringArray = this.mTitleBarText;
        }
        if (stringArray != null) {
            this.mTemporaryUpdateTimer = this.mTitleBarUpdateTimer;
            this.mTemporaryScrollingOffset = this.mTitleBarScrollingOffset;
            this.mTemporaryScrollingDirection = this.mTitleBarScrollingDirection;
            int n2 = this.mTitleBarFont.stringWidth(stringArray[0]);
            this.updateHorizontalScrolling(n, n2, this.mTitleBarTextAreaWidth - 16);
            this.mTitleBarScrollingOffset = this.mTemporaryScrollingOffset;
            this.mTitleBarScrollingDirection = this.mTemporaryScrollingDirection;
            this.mTitleBarUpdateTimer = this.mTemporaryUpdateTimer;
        }
    }

    private void updateItem(int n, int n2) {
        if (this.mItemSprites[n] != null && this.mItemSprites[n] != null) {
            this.mItemSprites[n].logicUpdate(n2);
        }
        if (this.mSwitchItemSprites != null && this.mSwitchItemSprites[n] != null) {
            this.mSwitchItemSprites[n].logicUpdate(n2);
        }
        if (n == this.mSelectedIndex && this.mItemTexts[n] != null) {
            this.mTemporaryUpdateTimer = this.mSelectedItemUpdateTimer;
            String[] stringArray = this.mItemTexts[n];
            if (stringArray != null) {
                this.mTemporaryScrollingOffset = this.mSelectedItemScrollingOffset;
                this.mTemporaryScrollingDirection = this.mSelectedItemScrollingDirection;
                int n3 = this.getMenuItemFont(n).stringWidth(stringArray[0]);
                int n4 = 8;
                this.updateHorizontalScrolling(n2, n3, this.mItemTextAreaWidths[n] - (n4 << 1));
                this.mSelectedItemScrollingOffset = this.mTemporaryScrollingOffset;
                this.mSelectedItemScrollingDirection = this.mTemporaryScrollingDirection;
            }
            this.mSelectedItemUpdateTimer = this.mTemporaryUpdateTimer;
        }
    }

    private void updateHorizontalScrolling(int n, int n2, int n3) {
        int n4 = n2 - n3;
        if (n4 <= 0) {
            this.mTemporaryScrollingOffset = 0;
        } else {
            int n5 = 25;
            int n6 = -n5;
            n4 += n5;
            this.mTemporaryUpdateTimer -= n;
            while (this.mTemporaryUpdateTimer < 0) {
                this.mTemporaryScrollingOffset = this.mTemporaryScrollingDirection == 1 ? ++this.mTemporaryScrollingOffset : --this.mTemporaryScrollingOffset;
                if (this.mTemporaryScrollingOffset > n4) {
                    this.mTemporaryScrollingOffset = n4;
                    this.mTemporaryScrollingDirection = 0;
                } else if (this.mTemporaryScrollingOffset < n6) {
                    this.mTemporaryScrollingOffset = n6;
                    this.mTemporaryScrollingDirection = 1;
                }
                this.mTemporaryUpdateTimer += 40;
            }
        }
    }

    private void updateVisibleLine(int n, int n2) {
        this.mTemporaryUpdateTimer -= n;
        if (this.mTemporaryUpdateTimer < 0) {
            ++this.mTemporaryVisibleLine;
            if (this.mTemporaryVisibleLine >= n2) {
                this.mTemporaryVisibleLine = 0;
            }
            this.mTemporaryUpdateTimer += 2000;
        }
    }

    private void drawTitleBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        MenuObject.drawGradientRect(graphics, n, n2, n3, n4, this.mTitleBarBackgroundColor, this.mTitleBarBackgroundGradientColor, 2);
    }

    private void drawBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        if (Game.smMenuResourcesLoaded) {
            if (this.isTextScreen()) {
                Util.drawDialogBox(graphics, Game.smPopupBlueSpr, n, n2, n3, n4);
            }
        } else {
            MenuObject.drawGradientRect(graphics, n, n2, n3, n4, this.mBackgroundColor, this.mBackgroundGradientColor, 1);
        }
    }

    private void drawBorders(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void drawTitleBar(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.mTitleBarTextAreaWidth;
        int n5 = this.mTitleBarImageAreaWidth;
        this.drawItemIcon(graphics, -2, n, n2, n5, n3);
        this.drawItemText(graphics, -2, n + n5, n2, n4, n3);
    }

    private void drawItem(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 8;
        int n8 = this.mItemTextAreaWidths[n];
        int n9 = this.mItemImageAreaWidths[n];
        if (this.mScreenType == 1 && n8 > 0) {
            n9 = 0;
        } else if (this.mScreenType == 0 && n == this.mSelectedIndex && !Game.smMenuResourcesLoaded) {
            graphics.setColor(this.mSelectedItemBackgroundColor);
            graphics.fillRect(n6 + this.mItemAreaX, n3, this.mItemAreaWidth, n5);
        }
        if (this.isBlinkStateHidden(n)) {
            return;
        }
        if (this.mScreenType != 0) {
            this.drawItemIcon(graphics, n, n2, n3, this.mItemImageAreaWidths[n], n5);
        }
        this.drawItemText(graphics, n, n2 + n9, n3, n8, n5);
        if (this.mItemTypes[n] == 5) {
            this.drawSwitch(graphics, n, n2, n3, n4, n5);
        } else if (this.mItemTypes[n] == 4) {
            this.drawSlider(graphics, n, n2, n3, n4, n5);
        }
    }

    private void drawItemIcon(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        boolean bl2 = bl = n == -2;
        if (bl || this.mScreenType == 1) {
            n9 = 0;
        } else {
            n9 = this.mItemStates[n] == 0 ? (this.mSelectedIndex == n ? 1 : 0) : 2;
            if ((this.mItemTypes[n] == 5 || this.mItemTypes[n] == 4) && this.mSettingItemValues[n] == 0) {
                n9 = 3;
            }
        }
        Object object = null;
        if (bl) {
            object = this.mTitleBarImage;
        } else if (this.mItemIcons[n] != null) {
            object = this.mItemIcons[n][n9];
        }
        if (object != null) {
            n8 = n2 + (n4 - object.getWidth() >> 1);
            n7 = n3;
            if (bl || this.mScreenType == 0) {
                n7 += n5 - object.getHeight() >> 1;
            } else if (this.mItemTexts[n] != null && this.mItemTexts[n].length > this.mItemCornerRows[n]) {
                n6 = this.mItemCornerRows[n] * (this.mTextFontHeight + 2) - 2;
                if (object.getHeight() > n6) {
                    n6 += 2;
                }
                n7 += n6 - object.getHeight() >> 1;
            }
            graphics.drawImage((Image)object, n8, n7, 20);
        }
        if ((object = bl ? this.mTitleBarSprite : this.mItemSprites[n]) != null) {
            if (n9 != ((SpriteObject)object).getCurrentAnimationIndex()) {
                ((SpriteObject)object).setAnimation(n9, -2, true);
            }
            n8 = n2 + (n4 - ((SpriteObject)object).getWidth() >> 1);
            n7 = n3;
            if (bl || this.mScreenType == 0) {
                n7 += n5 - ((SpriteObject)object).getHeight() >> 1;
            } else if (this.mItemTexts[n] != null && this.mItemTexts[n].length > this.mItemCornerRows[n]) {
                n6 = this.mItemCornerRows[n] * (this.mTextFontHeight + 2) - 2;
                if (((SpriteObject)object).getHeight() > n6) {
                    n6 += 2;
                }
                n7 += n6 - ((SpriteObject)object).getHeight() >> 1;
            }
            if (Game.mCurrentState == 0 || Game.mCurrentState == 1 || Game.mCurrentState == 3 || Game.mCurrentState == 9) {
                ((SpriteObject)object).draw(graphics, n8 + ((SpriteObject)object).getPivotX() + 0, n7 + ((SpriteObject)object).getPivotY() + 0);
            } else {
                ((SpriteObject)object).draw(graphics, n8 + ((SpriteObject)object).getPivotX(), n7 + ((SpriteObject)object).getPivotY());
            }
        }
    }

    private void drawItemText(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 8;
        String[] stringArray = n == -2 ? this.mTitleBarText : this.mItemTexts[n];
        if (stringArray != null) {
            int n7 = n2 + n6;
            int n8 = this.mTextFontHeight;
            ImageFont imageFont = this.mTextFont;
            if (n == -2) {
                n8 = this.mTitleBarFontHeight;
                imageFont = this.mTitleBarFont;
            } else if (this.mScreenType == 0) {
                imageFont = this.getMenuItemFont(n);
                n8 = imageFont.getHeight();
            }
            if (n != -2 && this.mScreenType == 1) {
                int n9;
                int n10 = n8 + 2;
                int n11 = n3;
                int n12 = graphics.getClipY();
                int n13 = graphics.getClipHeight();
                int n14 = 0;
                if (n11 < n12) {
                    n14 = (n12 - n11) / n10;
                }
                int n15 = (n9 = n12 + n13 - (n11 + n14 * n10)) == 0 ? 0 : (n9 - 1) / n10 + 1;
                int n16 = Math.min(n14 + n15, this.mItemTexts[n].length);
                int n17 = 0;
                int n18 = 0;
                if (this.mScreenType == 1) {
                    n17 = this.mItemImageAreaWidths[n];
                    n18 = this.mItemCornerRows[n];
                }
                for (int i = n14; i < n16; ++i) {
                    String string = this.mItemTexts[n][i];
                    int n19 = n7;
                    int n20 = n11 + n10 * i;
                    if (i < n18) {
                        n19 += n17;
                    } else {
                        boolean bl = false;
                        if (bl && (this.mItemAlignments[n] & 1) != 0 || !bl && (this.mItemAlignment & 1) != 0) {
                            int n21 = imageFont.stringWidth(string);
                            n19 += (n4 - n21 >> 1) - n6;
                        }
                    }
                    imageFont.drawString(graphics, string, n19, n20, 20);
                }
            } else {
                int n22 = n3 + (n5 - n8 >> 1);
                int n23 = imageFont.stringWidth(stringArray[0]);
                boolean bl = n23 <= n4 - n6 * 2;
                int n24 = graphics.getClipX();
                int n25 = graphics.getClipY();
                int n26 = graphics.getClipWidth();
                int n27 = graphics.getClipHeight();
                if (!bl) {
                    int n28 = n24 + n26;
                    int n29 = n25 + n27;
                    int n30 = Math.max(n24, n7);
                    int n31 = Math.max(n25, n3);
                    int n32 = Math.max(n30, Math.min(n28, n7 + (n4 - n6 * 2)));
                    int n33 = Math.max(n31, Math.min(n29, n3 + n5));
                    graphics.setClip(n30, n31, n32 - n30, n33 - n31);
                    if (n == -2) {
                        if (this.mTitleBarScrollingOffset >= 0) {
                            int n34 = n23 - (this.mTitleBarTextAreaWidth - (n6 << 1));
                            n7 -= Math.min(n34, this.mTitleBarScrollingOffset);
                        }
                    } else if (n == this.mSelectedIndex && this.mSelectedItemScrollingOffset >= 0) {
                        int n35 = n23 - (this.mItemTextAreaWidths[n] - (n6 << 1));
                        n7 -= Math.min(n35, this.mSelectedItemScrollingOffset);
                    }
                }
                imageFont.drawString(graphics, stringArray[0], n7, n22, 20);
                graphics.setClip(n24, n25, n26, n27);
            }
        }
    }

    private void drawSlider(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 8;
        int n7 = this.mSettingItemTextAreaWidths[n];
        int n8 = this.mSettingItemImageAreaWidths[n];
        int n9 = n2 + n4 - n7 - n8;
        int n10 = this.mSettingItemValueCounts[n] - 1;
        int n11 = this.mSettingItemValues[n];
        int n12 = this.getMenuItemFont(n).getHeight() - 4;
        for (int i = 1; i <= n10; ++i) {
            int n13 = n9 + (i - 1) * 13 + n6;
            int n14 = n3 + (n5 + n12 >> 1);
            int n15 = n12 * i / n10;
            if (n11 >= i) {
                graphics.setColor(0xFF0000);
            } else {
                graphics.setColor(0);
            }
            graphics.fillRect(n13, n14 - n15, 12, n15);
        }
    }

    private void drawSwitch(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Object object;
        int n6 = 8;
        int n7 = this.mSettingItemTextAreaWidths[n];
        int n8 = this.mSettingItemImageAreaWidths[n];
        int n9 = n2 + n4 - n7 - n8;
        int n10 = this.mSettingItemValues[n];
        if (this.mSwitchItemIcons[n] != null && (object = this.mSwitchItemIcons[n][n10]) != null) {
            graphics.drawImage((Image)object, n9 + (n8 >> 1), n3 + (n5 >> 1), 3);
        }
        if (this.mSwitchItemSprites[n] != null) {
            object = this.mSwitchItemSprites[n];
            if (n10 != ((SpriteObject)object).getCurrentAnimationIndex()) {
                ((SpriteObject)object).setAnimation(n10, -2, true);
            }
            ((SpriteObject)object).draw(graphics, n9 + ((SpriteObject)object).getPivotX() + (n8 - ((SpriteObject)object).getWidth() >> 1), n3 + ((SpriteObject)object).getPivotY() + (n5 - ((SpriteObject)object).getHeight() >> 1));
        }
        if (this.mSwitchItemTexts[n] != null) {
            object = this.getMenuItemFont(n);
            int n11 = ((ImageFont)object).getHeight();
            String string = this.mSwitchItemTexts[n][n10];
            if (string != null) {
                int n12 = n9 + n8 + n6;
                int n13 = n3 + (n5 - n11 >> 1);
                ((ImageFont)object).drawString(graphics, string, n12, n13, 20);
            }
        }
    }

    private void drawInput(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private void drawTable(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 8;
        int[] nArray = this.mTableItemColumnWidths[n];
        int[] nArray2 = this.mTableItemRowHeights[n];
        int[] nArray3 = this.mTableItemColumnAlignments[n];
        int n7 = nArray.length;
        int n8 = nArray2.length;
        int n9 = n3;
        int n10 = 0;
        for (int i = 0; i < n8; ++i) {
            int n11 = nArray2[i] - 2;
            int n12 = n2 + n6;
            int n13 = 0;
            while (n13 < n7) {
                String[] stringArray;
                int n14 = nArray[n13] - 8;
                int n15 = nArray3[n13];
                int n16 = n12 + 4;
                int n17 = n9;
                if (this.mTableItemSprites[n] != null && this.mTableItemSprites[n][n10] != null) {
                    stringArray = this.mTableItemSprites[n][n10];
                    if ((n15 & 1) != 0) {
                        n16 += n14 - stringArray.getWidth() >> 1;
                    } else if ((n15 & 4) != 0) {
                        n16 += n14 - stringArray.getWidth();
                    }
                    if ((n15 & 2) != 0) {
                        n17 += n11 - stringArray.getHeight() >> 1;
                    } else if ((n15 & 8) != 0) {
                        n17 += n11 - stringArray.getHeight();
                    }
                    stringArray.draw(graphics, n16 + stringArray.getPivotX(), n17 + stringArray.getPivotY());
                } else if (this.mTableItemIcons[n] != null && this.mTableItemIcons[n][n10] != null) {
                    stringArray = this.mTableItemIcons[n][n10];
                    if ((n15 & 1) != 0) {
                        n16 += n14 - stringArray.getWidth() >> 1;
                    } else if ((n15 & 4) != 0) {
                        n16 += n14 - stringArray.getWidth();
                    }
                    if ((n15 & 2) != 0) {
                        n17 += n11 - stringArray.getHeight() >> 1;
                    } else if ((n15 & 8) != 0) {
                        n17 += n11 - stringArray.getHeight();
                    }
                    graphics.drawImage((Image)stringArray, n16, n17, 20);
                } else if (this.mTableItemTexts[n] != null && this.mTableItemTexts[n][n10] != null) {
                    stringArray = this.mTableItemTexts[n][n10];
                    int n18 = stringArray.length * this.mTextFontHeight;
                    if ((n15 & 2) != 0) {
                        n17 += n11 - n18 >> 1;
                    } else if ((n15 & 8) != 0) {
                        n17 += n11 - n18;
                    }
                    int n19 = n17;
                    int n20 = stringArray.length;
                    for (int j = 0; j < n20; ++j) {
                        String string = stringArray[j];
                        int n21 = n16;
                        if ((n15 & 5) != 0) {
                            int n22 = this.mTextFont.stringWidth(string);
                            if ((n15 & 1) != 0) {
                                n21 += n14 - n22 >> 1;
                            } else if ((n15 & 4) != 0) {
                                n21 += n14 - n22;
                            }
                        }
                        this.mTextFont.drawString(graphics, string, n21, n19, 20);
                        n19 += this.mTextFontHeight;
                    }
                }
                n12 += nArray[n13];
                ++n13;
                ++n10;
            }
            n9 += nArray2[i];
        }
    }

    private void drawSubMenus(Graphics graphics, int n, int n2) {
    }

    private void drawExampleHorizontalArrowsScreen(Graphics graphics, int n, int n2) {
    }

    private void selectionChanged() {
        Toolkit.removeAllSoftKeys();
        int n = -1;
        if (this.mItemTypes != null && this.mSelectedIndex < this.mItemTypes.length && this.mSelectedIndex != -1) {
            n = this.mItemTypes[this.mSelectedIndex];
        }
        int n2 = 0;
        if (this.mItemStates != null && this.mSelectedIndex < this.mItemStates.length && this.mSelectedIndex != -1) {
            n2 = this.mItemStates[this.mSelectedIndex];
        }
        if (this.mSoftKeys[0] != -1 && n2 != 1) {
            Toolkit.setSoftKey(this.mSoftKeys[0], 0);
        }
        if (this.mSoftKeys[1] != -1) {
            Toolkit.setSoftKey(this.mSoftKeys[1], 0);
        }
        if (this.mScreenType == 1) {
            this.mVerticalScrollingOffset = 0;
            this.mCurrentPage = 0;
        }
        this.mSelectedItemUpdateTimer = 0;
    }

    private int getNextSelectableItemIndex(int n) {
        if (this.mMaxItemCount == 0) {
            return -1;
        }
        int n2 = this.mMaxItemCount;
        do {
            n = (n + 1) % this.mMaxItemCount;
            if (n2-- > 0) continue;
            return -1;
        } while (!this.isItemSelectable(n));
        return n;
    }

    private int getPreviousSelectableItemIndex(int n) {
        if (this.mMaxItemCount == 0) {
            return -1;
        }
        if (n == -1) {
            n = 0;
        }
        int n2 = this.mMaxItemCount;
        do {
            n = (n + this.mMaxItemCount - 1) % this.mMaxItemCount;
            if (n2-- > 0) continue;
            return -1;
        } while (!this.isItemSelectable(n));
        return n;
    }

    private void setInputEditingMode(boolean bl) {
    }

    private boolean isItemSelectable(int n) {
        return this.mItemTypes[n] == 0 || this.mItemTypes[n] == 4 || this.mItemTypes[n] == 5;
    }

    private static String[] splitString(String string, int n, int n2, int n3) {
        int n4;
        char[] cArray = new char[]{'.', '/'};
        n -= smSplitStringFont.getEmptyStringWidth();
        int n5 = 0;
        int n6 = 0;
        int n7 = string.length();
        Vector<String> vector = new Vector<String>();
        int n8 = 0;
        if (string.length() == 0) {
            vector.addElement(string);
        }
        while (n6 < n7) {
            n6 = string.indexOf("\\n", n5);
            if (n6 == -1) {
                n6 = n7;
            }
            boolean bl = false;
            while (!bl) {
                char c;
                int n9 = n5;
                n4 = 0;
                int n10 = -1;
                int n11 = n;
                if (n8 < n3) {
                    n11 -= n2;
                }
                while (n4 <= n11 && n9 < n6) {
                    c = string.charAt(n9);
                    n4 += smSplitStringFont.charWidth(c);
                    ++n9;
                    if (c != ' ') continue;
                    n10 = n9;
                }
                if (n9 == n6 && n4 <= n11) {
                    bl = true;
                } else if (n10 != -1) {
                    n9 = n10 - 1;
                } else {
                    c = '\u0000';
                    for (int i = --n9; i > n5 && c == '\u0000'; --i) {
                        char c2 = string.charAt(i);
                        int n12 = cArray.length;
                        while (--n12 >= 0 && c == '\u0000') {
                            if (c2 != cArray[n12]) continue;
                            n9 = i + 1;
                            c = '\u0001';
                        }
                    }
                }
                vector.addElement(string.substring(n5, n9));
                ++n8;
                if (bl && n9 < n7) {
                    n9 += 2;
                } else if (n10 != -1) {
                    // empty if block
                }
                n5 = ++n9;
            }
        }
        String[] stringArray = new String[vector.size()];
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            stringArray[n4] = (String)vector.elementAt(n4);
        }
        smSplitStringFont = null;
        return stringArray;
    }

    public void releaseScreen() {
        if (this.mItemTypes != null) {
            for (int i = 0; i < this.mMaxItemCount; ++i) {
                this.destroyItem(i);
            }
        }
        if (this.mTitleBarSprite != null) {
            this.mTitleBarSprite.freeResources();
        }
    }

    public void drawLoadingScreen(Graphics graphics, String[] stringArray, int n) {
    }

    public void setItemBlink(int n, int[] nArray) {
        if (this.mItemBlinkSequence == null) {
            this.mItemBlinkSequence = new int[this.mMaxItemCount][];
        }
        this.mItemBlinkSequence[n] = nArray;
    }

    private boolean isBlinkStateHidden(int n) {
        int n2;
        if (this.mItemBlinkSequence == null) {
            return false;
        }
        int[] nArray = this.mItemBlinkSequence[n];
        if (nArray == null) {
            return false;
        }
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 += nArray[n2];
        }
        n2 = this.mBlinkingTimer % n3;
        n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 >= (n3 += nArray[i])) continue;
            return (i & 1) == 1;
        }
        return false;
    }

    public void stopScrolling() {
        this.mScrollingEvent = 0;
    }

    public boolean isTextScreen() {
        return this.mScreenType == 1;
    }

    public void drawOptionBar(Graphics graphics, String string, boolean bl, int n, int n2, int n3, int n4) {
        if (string != null) {
            if (Game.smPopupBlueSpr != null) {
                Util.drawDialogBox(graphics, bl ? Game.smPopupGreenSpr : Game.smPopupBlueSpr, n, n2, n3, n4);
            } else if (Game.msIsMenuScreenLoaded) {
                Util.drawDialogBox(graphics, null, n, n2, n3, n4);
            }
        }
    }
}

