/*
 * Decompiled with CFR 0.152.
 */
package com.alienfactory.javamappy;

import com.alienfactory.javamappy.AnimBlock;
import com.alienfactory.javamappy.Block;
import com.alienfactory.javamappy.Map;
import com.alienfactory.javamappy.MapHeader;
import com.alienfactory.javamappy.util.ParameterChecker;

public class Layer {
    private final MapHeader a;
    private final short[][] b;
    private final Block[] c;
    private final AnimBlock[] d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;

    public Layer(Map map, short[][] sArray) {
        this(map.getMapHeader(), sArray, map.getBlocks(), map.getAnimBlocks());
    }

    public Layer(MapHeader mapHeader, short[][] sArray, Block[] blockArray, AnimBlock[] animBlockArray) {
        ParameterChecker.checkNotNull(mapHeader, "mapHeader");
        ParameterChecker.checkNotNull(sArray, "layerData");
        ParameterChecker.checkNotNull(blockArray, "blocks");
        ParameterChecker.checkNotNull(animBlockArray, "animBlocks");
        this.a = mapHeader;
        this.b = sArray;
        this.c = blockArray;
        this.d = animBlockArray;
        this.e = sArray.length > 0 ? sArray[0].length : 0;
        this.f = sArray.length;
        this.g = mapHeader.getMapPixelWidth();
        this.h = mapHeader.getMapPixelHeight();
    }

    public MapHeader getMapHeader() {
        return this.a;
    }

    public int getWidthInBlocks() {
        return this.e;
    }

    public int getHeightInBlocks() {
        return this.f;
    }

    public int getWidthInPixels() {
        return this.g;
    }

    public int getHeightInPixels() {
        return this.h;
    }

    public short[][] getLayerData() {
        return this.b;
    }

    public Block[] getBlocks() {
        return this.c;
    }

    public AnimBlock[] getAnimBlocks() {
        return this.d;
    }

    public int getBlockIndex(int n, int n2) {
        ParameterChecker.checkMinMax(n, "blockX", 0, this.e - 1);
        ParameterChecker.checkMinMax(n2, "blockY", 0, this.f - 1);
        return this.b[n2][n];
    }

    public void setBlockIndex(int n, int n2, int n3) {
        ParameterChecker.checkMinMax(n, "blockX", 0, this.e - 1);
        ParameterChecker.checkMinMax(n2, "blockY", 0, this.f - 1);
        ParameterChecker.checkMinMax(n3, "blockIndex", -this.d.length, this.c.length - 1);
        this.b[n2][n] = (short)n3;
    }

    public Block getBlock(int n, int n2) {
        ParameterChecker.checkMinMax(n, "blockX", 0, this.e - 1);
        ParameterChecker.checkMinMax(n2, "blockY", 0, this.f - 1);
        n = this.b[n2][n];
        if (n < 0) {
            n = this.d[-n - 1].getCurrentFrame();
        }
        ParameterChecker.checkMinMax(n, "blockIndex", 0, this.c.length - 1);
        return this.c[n];
    }

    public AnimBlock getAnimBlock(int n, int n2) {
        int n3 = this.getBlockIndex(n, n2);
        if (n3 >= 0) {
            throw new IllegalArgumentException("The block at coors [" + n + "][" + n2 + "] is not an AnimBlock");
        }
        return this.d[-n3 - 1];
    }

    public boolean isAnimBlock(int n, int n2) {
        ParameterChecker.checkMinMax(n, "blockX", 0, this.e - 1);
        ParameterChecker.checkMinMax(n2, "blockY", 0, this.f - 1);
        return this.b[n2][n] < 0;
    }

    public boolean isCollisionAt(int n, int n2) {
        return this.getCollisionAt(n, n2) != -1;
    }

    public int getCollisionAt(int n, int n2) {
        int n3 = this.a.getBlockWidth();
        int n4 = this.a.getBlockHeight();
        int n5 = n / n3;
        int n6 = n2 / n4;
        Block block = this.getBlock(n5, n6);
        n = (n %= n3) >= n3 / 2 ? 8 : 4;
        n = (n2 %= n4) >= n4 / 2 ? (n |= 0x20) : (n |= 0x10);
        if (!block.getCollisionFlag(n)) {
            n = -1;
        }
        return n;
    }

    public int getTopCollisionCoor(int n, int n2, int n3, int n4) {
        ParameterChecker.checkMinMax(n, "pixelX", 0, this.g - n3);
        ParameterChecker.checkMinMax(n2, "pixelY", 0, this.h - n4);
        ParameterChecker.checkMin(n3, "width", 1);
        ParameterChecker.checkMin(n4, "height", 1);
        int n5 = this.a.getBlockWidth();
        int n6 = this.a.getBlockHeight();
        int n7 = n5 / 2;
        int n8 = n6 / 2;
        int n9 = n;
        int n10 = n2;
        n3 = n + n3;
        n4 = n2 + n4;
        int n11 = n / n5;
        int n12 = n2 / n6;
        int n13 = n3 / n5;
        n = n4 / n6;
        n2 = n * n6 + n8;
        for (int i = n; i >= n12; --i) {
            int n14 = -1;
            n = n11 * n5 + n7;
            for (int j = n11; j <= n13; ++j) {
                int n15 = this.b[i][j];
                if (n15 < 0) {
                    n15 = this.d[-n15 - 1].getCurrentFrame();
                }
                Block block = this.c[n15];
                if (n4 > n2) {
                    if (n9 < n && block.getCollisionFlag(36)) {
                        return n2 + n8;
                    }
                    if (n3 > n && block.getCollisionFlag(40)) {
                        return n2 + n8;
                    }
                }
                if (n14 == -1 && n10 < n2) {
                    if (n9 < n && block.getCollisionFlag(20)) {
                        n14 = n2;
                    }
                    if (n3 > n && block.getCollisionFlag(24)) {
                        n14 = n2;
                    }
                }
                n += n5;
            }
            if (n14 != -1) {
                return n14;
            }
            n2 -= n6;
        }
        return -1;
    }

    public int getBottomCollisionCoor(int n, int n2, int n3, int n4) {
        ParameterChecker.checkMinMax(n, "pixelX", 0, this.g - n3);
        ParameterChecker.checkMinMax(n2, "pixelY", 0, this.h - n4);
        ParameterChecker.checkMin(n3, "width", 1);
        ParameterChecker.checkMin(n4, "height", 1);
        int n5 = this.a.getBlockWidth();
        int n6 = this.a.getBlockHeight();
        int n7 = n5 / 2;
        int n8 = n6 / 2;
        int n9 = n;
        int n10 = n2;
        n3 = n + n3;
        n4 = n2 + n4;
        int n11 = n / n5;
        n = n2 / n6;
        int n12 = n3 / n5;
        int n13 = n4 / n6;
        n2 = n * n6 + n8;
        for (int i = n; i <= n13; ++i) {
            int n14 = -1;
            n = n11 * n5 + n7;
            for (int j = n11; j <= n12; ++j) {
                int n15 = this.b[i][j];
                if (n15 < 0) {
                    n15 = this.d[-n15 - 1].getCurrentFrame();
                }
                Block block = this.c[n15];
                if (n10 < n2) {
                    if (n9 < n && block.getCollisionFlag(20)) {
                        return n2 - n8;
                    }
                    if (n3 > n && block.getCollisionFlag(24)) {
                        return n2 - n8;
                    }
                }
                if (n14 == -1 && n4 > n2) {
                    if (n9 < n && block.getCollisionFlag(36)) {
                        n14 = n2;
                    }
                    if (n3 > n && block.getCollisionFlag(40)) {
                        n14 = n2;
                    }
                }
                n += n5;
            }
            if (n14 != -1) {
                return n14;
            }
            n2 += n6;
        }
        return -1;
    }

    public int getLeftCollisionCoor(int n, int n2, int n3, int n4) {
        ParameterChecker.checkMinMax(n, "pixelX", 0, this.g - n3);
        ParameterChecker.checkMinMax(n2, "pixelY", 0, this.h - n4);
        ParameterChecker.checkMin(n3, "width", 1);
        ParameterChecker.checkMin(n4, "height", 1);
        int n5 = this.a.getBlockWidth();
        int n6 = this.a.getBlockHeight();
        int n7 = n5 / 2;
        int n8 = n6 / 2;
        int n9 = n;
        int n10 = n2;
        n3 = n + n3;
        n4 = n2 + n4;
        int n11 = n / n5;
        int n12 = n2 / n6;
        n2 = n3 / n5;
        int n13 = n4 / n6;
        n = n2 * n5 + n7;
        for (int i = n2; i >= n11; --i) {
            int n14 = -1;
            n2 = n12 * n6 + n8;
            for (int j = n12; j <= n13; ++j) {
                int n15 = this.b[j][i];
                if (n15 < 0) {
                    n15 = this.d[-n15 - 1].getCurrentFrame();
                }
                Block block = this.c[n15];
                if (n3 > n) {
                    if (n10 < n2 && block.getCollisionFlag(24)) {
                        return n + n7;
                    }
                    if (n4 > n2 && block.getCollisionFlag(40)) {
                        return n + n7;
                    }
                }
                if (n14 == -1 && n9 < n) {
                    if (n10 < n2 && block.getCollisionFlag(20)) {
                        n14 = n;
                    }
                    if (n4 > n2 && block.getCollisionFlag(36)) {
                        n14 = n;
                    }
                }
                n2 += n6;
            }
            if (n14 != -1) {
                return n14;
            }
            n -= n5;
        }
        return -1;
    }

    public int getRightCollisionCoor(int n, int n2, int n3, int n4) {
        ParameterChecker.checkMinMax(n, "pixelX", 0, this.g - n3);
        ParameterChecker.checkMinMax(n2, "pixelY", 0, this.h - n4);
        ParameterChecker.checkMin(n3, "width", 1);
        ParameterChecker.checkMin(n4, "height", 1);
        int n5 = this.a.getBlockWidth();
        int n6 = this.a.getBlockHeight();
        int n7 = n5 / 2;
        int n8 = n6 / 2;
        int n9 = n;
        int n10 = n2;
        n3 = n + n3;
        n4 = n2 + n4;
        int n11 = n / n5;
        int n12 = n2 / n6;
        int n13 = n3 / n5;
        int n14 = n4 / n6;
        n = n11 * n5 + n7;
        for (int i = n11; i <= n13; ++i) {
            n11 = -1;
            n2 = n12 * n6 + n8;
            for (int j = n12; j <= n14; ++j) {
                n7 = this.b[j][i];
                if (n7 < 0) {
                    n7 = this.d[-n7 - 1].getCurrentFrame();
                }
                Block block = this.c[n7];
                if (n9 < n) {
                    if (n10 < n2 && block.getCollisionFlag(20)) {
                        return n - n8;
                    }
                    if (n4 > n2 && block.getCollisionFlag(36)) {
                        return n - n8;
                    }
                }
                if (n11 == -1 && n3 > n) {
                    if (n10 < n2 && block.getCollisionFlag(24)) {
                        n11 = n;
                    }
                    if (n4 > n2 && block.getCollisionFlag(40)) {
                        n11 = n;
                    }
                }
                n2 += n6;
            }
            if (n11 != -1) {
                return n11;
            }
            n += n5;
        }
        return -1;
    }
}

