/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class DashEngine
extends Canvas
implements Runnable,
AppStateHandler,
SPDefines {
    public static final int KEY_INVALID = -1;
    public static final int KEY_UP = 0;
    public static final int KEY_DOWN = 1;
    public static final int KEY_LEFT = 2;
    public static final int KEY_RIGHT = 3;
    public static final int KEY_SELECT = 4;
    public static final int KEY_SOFTLEFT = 5;
    public static final int KEY_SOFTRIGHT = 6;
    public static final int KEY_CLR = 7;
    public static final int KEY_1 = 8;
    public static final int KEY_2 = 9;
    public static final int KEY_3 = 10;
    public static final int KEY_4 = 11;
    public static final int KEY_5 = 12;
    public static final int KEY_6 = 13;
    public static final int KEY_7 = 14;
    public static final int KEY_8 = 15;
    public static final int KEY_9 = 16;
    public static final int KEY_0 = 17;
    public static final int KEY_STAR = 18;
    public static final int KEY_POUND = 19;
    private static final int KEYBUFFERMAX = 21;
    public static int debugKey = 0;
    public static int debugKey2 = 0;
    public static final int DASH_POINTER_PRESSED = 100;
    public static final int DASH_POINTER_DRAGGED = 101;
    public static final int DASH_POINTER_RELEASED = 102;
    public int fullHeight = 0;
    protected static int[] keyPressedBuffer = null;
    protected static boolean[] keyReleasedBuffer = null;
    protected static int[] keyMap = new int[]{0, 0, 0, 0, 0, -6, -7, -8, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 42, 35};
    private static int LOOKUPLENGTH = 66;
    private static int LOOKUPOFFSET = 8;
    private static int[] keyLookup = null;
    private static String softLeft = null;
    private static String softRight = null;
    private boolean started = false;
    private boolean systemPause = false;
    protected boolean finished = false;
    protected static MainMidlet myMidlet = null;
    private Thread myThread = null;
    protected static DashEngine me = null;
    protected AppState m_gameState = null;
    public static boolean isMenu = false;
    public boolean m_vfsActive;
    public static SaveGame m_savedGame = new SaveGame();
    public static SavePrefs m_savedPrefs = new SavePrefs();
    public static Vector m_favoriteList = new Vector();
    public static Song[] m_songs = new Song[6];
    public static Vector m_leaderboard = new Vector();
    public int m_speedMod;
    public boolean m_remix;
    public boolean m_playBGM;
    public long bgmRetry;
    public static sResultsData m_resultsData = new sResultsData();
    public static sGameCircuit m_gameCircuit = new sGameCircuit();
    public static DashEngine m_instance;
    public boolean m_stopOnDeath;
    public static int m_messageReceipts;
    public static String m_tourName;
    public static int dlPack;
    private static boolean isDirty;
    public boolean stateChange = false;
    public static DashFont softkeyFont;
    protected static boolean drawSoftKeys;
    private static boolean m_flip_softkeys;
    private boolean m_use_double_buffer = false;
    private boolean m_use_sleep = true;
    private boolean m_use_catch = true;
    private boolean m_use_timer_delta_pause = true;
    private Image m_dbi = null;
    private Graphics m_dbg = null;
    protected static int m_frametime;
    private long m_last_frame = 0L;
    public static int[] px;
    public static int[] py;
    public static long[] pt;
    public static int p_event_x;
    public static int p_event_y;
    public static final int POINTER_GESTURE_PIXELS = 100;
    public static final long POINTER_TAP_TIME = 200L;
    String currState = "";
    protected static DashResourceProvider m_pProvider;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DashEngine() {
        m_instance = this;
        this.started = false;
        m_pProvider = null;
        keyPressedBuffer = null;
        keyReleasedBuffer = null;
        myMidlet = null;
        this.m_playBGM = false;
        this.bgmRetry = 0L;
        this.setFullScreenMode(true);
        me = this;
        try {
            m_pProvider = new DashResourceProvider(this, "/metainfo.bin");
        }
        catch (Exception ioe) {
            throw new RuntimeException("cannot initiate resource manager.");
        }
        softkeyFont = null;
        try {
            if (this.getKeyCode(1) == -1 && this.getKeyCode(6) == -6 && this.getKeyCode(2) == -2 && this.getKeyCode(5) == -5) {
                SoundOptions.buffered = true;
                drawSoftKeys = true;
                if (Runtime.getRuntime().totalMemory() / 1024L < 900L) {
                    m_flip_softkeys = false;
                }
                this.m_use_timer_delta_pause = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getGameAction(-10) != 8) {
                // empty if block
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getGameAction(-16) == 93) {
                DashEngine.keyMap[7] = -16;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasPointerEvents()) {
            this.m_use_sleep = true;
            drawSoftKeys = true;
        }
        DashEngine.m_savedPrefs.prefSoundOn = true;
        this.m_speedMod = 0;
        this.m_remix = false;
        DashEngine.m_gameCircuit.difficultySelected = 0;
        DashEngine.m_resultsData.songSelected = 0;
        DashEngine.m_resultsData.powerupSelected = 7;
        m_messageReceipts = 0;
        this.m_stopOnDeath = false;
        DashEngine.m_resultsData.progression = 0;
        DashEngine.m_resultsData.maxProgression = 18;
        softkeyFont = DashResourceProvider.getFont(31);
    }

    protected void sizeChanged(int w, int h) {
        m_pProvider.setScreenArea();
    }

    protected void sizeChange(int w, int h) {
        if (h > this.fullHeight) {
            this.fullHeight = h;
        } else {
            this.setFullScreenMode(true);
        }
    }

    protected void go(MainMidlet mm) {
        if (this.started) {
            return;
        }
        this.setFullScreenMode(true);
        this.fullHeight = this.getHeight();
        myMidlet = mm;
        try {
            DashEngine.keyMap[5] = Integer.parseInt(myMidlet.getAppProperty("SOFTKEY_LEFT"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DashEngine.keyMap[6] = Integer.parseInt(myMidlet.getAppProperty("SOFTKEY_RIGHT"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DashEngine.keyMap[7] = Integer.parseInt(myMidlet.getAppProperty("BACK_KEY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("true".equals(myMidlet.getAppProperty("DASH-use-doublebuffer"))) {
            this.m_use_double_buffer = true;
        }
        this.started = true;
        this.myThread = new Thread(this);
        this.resetKeys();
        this.myThread.start();
        this.RequestStateChange("gs_FTI");
    }

    public void paint(Graphics g) {
        if (this.stateChange) {
            g.setColor(0);
            g.fillRect(0, 0, DashResourceProvider.getScreenWidth(), DashResourceProvider.getScreenHeight());
            DashResourceProvider.getFont(31).drawString(g, GameStrings.LOADING[DashResourceProvider.currentLanguage], DashResourceProvider.getScreenWidth() / 2, DashResourceProvider.getScreenHeight() / 2, 33);
            return;
        }
        if (this.m_use_double_buffer) {
            if (this.m_dbi != null) {
                g.drawImage(this.m_dbi, 0, 0, 0);
            }
        } else if (this.m_gameState != null) {
            if (this.m_use_catch) {
                try {
                    this.m_gameState.Render(g);
                    this.overlaySoftKeys(g);
                    g.setColor(255, 0, 255);
                }
                catch (Throwable s) {
                    s.printStackTrace();
                }
            } else {
                this.m_gameState.Render(g);
            }
        }
    }

    public int getActualHeight() {
        return super.getHeight();
    }

    public int getActualWidth() {
        return super.getWidth();
    }

    public static void setRightSoftKey(String right) {
        if (m_flip_softkeys) {
            softLeft = right;
        } else {
            softRight = right;
        }
        isDirty = true;
    }

    public static void setLeftSoftKey(String left) {
        if (m_flip_softkeys) {
            softRight = left;
        } else {
            softLeft = left;
        }
        isDirty = true;
    }

    protected void overlaySoftKeys(Graphics g) {
        if (drawSoftKeys && softkeyFont != null) {
            g.translate(-g.getTranslateX(), -g.getTranslateY());
            g.setClip(0, 0, this.getWidth(), this.getHeight() + 32);
            int dy = softkeyFont.getHeight();
            if (isDirty) {
                isDirty = false;
            } else {
                if (softLeft != null) {
                    softkeyFont.drawString(g, softLeft, 2, this.getHeight(), 36);
                }
                if (softRight != null) {
                    softkeyFont.drawString(g, softRight, this.getWidth() - 2, this.getHeight(), 40);
                }
            }
        }
    }

    public static boolean avk_ok(int key) {
        return key == 4 || key == 12;
    }

    public static boolean avk_left(int key) {
        return key == 2 || key == 11;
    }

    public static boolean avk_right(int key) {
        return key == 3 || key == 13;
    }

    public static boolean avk_up(int key) {
        return key == 0 || key == 9;
    }

    public static boolean avk_down(int key) {
        return key == 1 || key == 15;
    }

    protected int getUsableHeight() {
        return this.getHeight();
    }

    public void run() {
        this.m_last_frame = System.currentTimeMillis();
        m_frametime = 50;
        while (!this.finished) {
            while (!this.systemPause && !this.finished) {
                long curr = System.currentTimeMillis();
                if (this.m_playBGM && curr - this.bgmRetry > 500L) {
                    this.bgmRetry = curr;
                    if (!DashResourceProvider.isSoundPlaying(139) && this.m_gameState != null) {
                        DashResourceProvider.playSound(139, true, false);
                    }
                }
                if (this.m_use_double_buffer && this.m_dbi == null) {
                    this.m_dbi = Image.createImage((int)DashResourceProvider.m_canvas.getWidth(), (int)DashResourceProvider.m_canvas.getHeight());
                    this.m_dbg = this.m_dbi.getGraphics();
                }
                if (this.m_gameState != null) {
                    DashResourceProvider.soundMainLoop();
                    this.m_gameState.Update();
                    if (this.m_use_double_buffer) {
                        this.m_gameState.Render(this.m_dbg);
                    }
                }
                this.resetReleasedKeys();
                this.myRepaint();
                this.serviceRepaints();
                long ft = System.currentTimeMillis() - this.m_last_frame;
                try {
                    if (ft < (long)m_frametime) {
                        Thread.sleep((long)m_frametime - ft);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ft < 0L) {
                    DashResourceProvider.m_timers[0] = DashResourceProvider.m_timers[0] + ft;
                    ft = 0L;
                }
                this.m_last_frame += ft;
            }
        }
        this.terminate();
    }

    protected void hideNotify() {
        if (!this.systemPause) {
            this.resetKeys();
            DashResourceProvider.pauseTimer(0);
            if (this.m_gameState != null) {
                this.m_gameState.Pause();
            }
            this.systemPause = true;
            DashResourceProvider.stopSound();
            DashResourceProvider.soundMainLoop();
        }
    }

    protected void showNotify() {
        if (this.systemPause) {
            if (DashResourceProvider.getCurrSound() == 139) {
                DashResourceProvider.playSound(139, true, false);
            }
            this.resetKeys();
            DashResourceProvider.resumeTimer(0);
            if (this.m_gameState != null) {
                this.m_gameState.Resume();
            }
            this.systemPause = false;
        }
    }

    private void initKeyLookup() {
        int i;
        int max;
        if (keyLookup != null) {
            return;
        }
        int min = max = keyMap[0];
        for (i = 1; i < keyMap.length; ++i) {
            min = Math.min(min, keyMap[i]);
            max = Math.max(max, keyMap[i]);
        }
        LOOKUPLENGTH = max - min + 1;
        LOOKUPOFFSET = -min;
        keyLookup = new int[LOOKUPLENGTH];
        for (i = 0; i < keyLookup.length; ++i) {
            DashEngine.keyLookup[i] = -1;
        }
        for (i = 0; i < keyMap.length; ++i) {
            DashEngine.keyLookup[DashEngine.keyMap[i] + DashEngine.LOOKUPOFFSET] = i;
        }
    }

    private int lookupKey(int keycode) {
        if (keyLookup == null) {
            this.initKeyLookup();
        }
        if (keycode + LOOKUPOFFSET >= keyLookup.length || keycode + LOOKUPOFFSET < 0) {
            return -1;
        }
        int retval = keyLookup[keycode + LOOKUPOFFSET];
        return retval;
    }

    private int lookupGameAction(int keycode) {
        int gameaction = 0;
        try {
            gameaction = this.getGameAction(keycode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (gameaction) {
            case 1: {
                return 0;
            }
            case 6: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    private static int mapKey(int keyCode) {
        return keyCode;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -10) {
            return;
        }
        debugKey = keyCode;
        debugKey2 = keyCode = DashEngine.mapKey(keyCode);
        if (keyCode == keyMap[7]) {
            // empty if block
        }
        if (keyCode == 0) {
            return;
        }
        int key = this.lookupKey(keyCode);
        if (key == -1 && (key = this.lookupGameAction(keyCode)) == -1) {
            return;
        }
        int n = key;
        keyPressedBuffer[n] = keyPressedBuffer[n] + 1;
        DashEngine.keyReleasedBuffer[key] = false;
        if (this.m_gameState != null) {
            try {
                this.m_gameState.KeyPressed(key);
            }
            catch (Throwable s) {
                s.printStackTrace();
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -10) {
            return;
        }
        int key = this.lookupKey(keyCode = DashEngine.mapKey(keyCode));
        if (key == -1 && (key = this.lookupGameAction(keyCode)) == -1) {
            return;
        }
        DashEngine.keyReleasedBuffer[key] = true;
        if (this.m_gameState != null) {
            this.m_gameState.KeyReleased(key);
        }
    }

    protected void pointerPressed(int x, int y) {
        p_event_x = DashEngine.px[0] = x;
        p_event_y = DashEngine.py[0] = y;
        DashEngine.pt[0] = System.currentTimeMillis();
        if (this.m_gameState != null) {
            this.m_gameState.KeyPressed(100);
        }
    }

    protected void pointerDragged(int x, int y) {
        p_event_x = DashEngine.px[1] = x;
        p_event_y = DashEngine.py[1] = y;
        DashEngine.pt[1] = System.currentTimeMillis();
        if (this.m_gameState != null) {
            this.m_gameState.KeyPressed(101);
        }
    }

    protected void pointerReleased(int x, int y) {
        p_event_x = DashEngine.px[2] = x;
        p_event_y = DashEngine.py[2] = y;
        DashEngine.pt[2] = System.currentTimeMillis();
        if (this.m_gameState != null) {
            this.m_gameState.KeyPressed(102);
        }
    }

    public static int pointerGesture(int key) {
        if (key == 102) {
            int dx = px[2] - px[0];
            int dy = py[2] - py[0];
            long dt = pt[2] - pt[0];
            if (dx > 100) {
                return 3;
            }
            if (dx < -100) {
                return 2;
            }
            if (dy > 100) {
                return 1;
            }
            if (dy < -100) {
                return 0;
            }
            if (dt < 200L) {
                return 4;
            }
        }
        return -1;
    }

    private void resetReleasedKeys() {
        for (int i = 0; i < 21; ++i) {
            if (!keyReleasedBuffer[i]) continue;
            DashEngine.keyPressedBuffer[i] = 0;
            DashEngine.keyReleasedBuffer[i] = false;
        }
    }

    private void resetKeys() {
        if (keyPressedBuffer == null) {
            keyPressedBuffer = new int[21];
        }
        if (keyReleasedBuffer == null) {
            keyReleasedBuffer = new boolean[21];
        }
        for (int i = 0; i < 21; ++i) {
            DashEngine.keyPressedBuffer[i] = 0;
            DashEngine.keyReleasedBuffer[i] = false;
        }
    }

    public static int getKeyAction(int key) {
        return me.getGameAction(keyMap[key]);
    }

    public static int getCanvasGameAction(int key) {
        try {
            return me.getGameAction(keyMap[key]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isKeyPressed(int key) {
        return keyPressedBuffer[key] > 0;
    }

    protected void terminate() {
        if (!this.finished) {
            this.finished = true;
            this.getProvider();
            DashResourceProvider.stopSound();
            myMidlet.RequestDestroy();
        }
    }

    public void RequestStateChange(String state_name) {
        System.gc();
        this.stateChange = true;
        this.myRepaint();
        this.serviceRepaints();
        String oldState = this.currState;
        this.currState = state_name;
        if (this.m_gameState != null) {
            this.m_gameState.unload();
            this.m_gameState = null;
        }
        this.m_playBGM = true;
        if (state_name.equals("gs_FTI")) {
            this.m_gameState = new gs_FTI(this);
            m_tourName = DashEngine.m_savedGame.tourName;
        } else if (state_name.equals("gs_mainMenu")) {
            this.m_gameState = new gs_mainMenu(this);
        } else if (state_name.equals("gs_mainGame") || state_name.equals("gs_mainGameMP")) {
            this.m_playBGM = false;
            this.m_gameState = state_name.equals("gs_mainGameMP") ? new gs_mainGame(this, DashEngine.m_resultsData.songSelected, DashEngine.m_gameCircuit.difficultySelected, false, 0, true) : (DashEngine.m_gameCircuit.fromMultiplayer == 6 ? new gs_mainGame(this, DashEngine.m_resultsData.songSelected, DashEngine.m_gameCircuit.difficultySelected, false, 0, false) : new gs_mainGame(this, DashEngine.m_resultsData.songSelected, DashEngine.m_gameCircuit.difficultySelected, this.m_remix, this.m_speedMod, false));
        } else if (state_name.equals("gs_Intro")) {
            this.m_playBGM = false;
            this.m_gameState = new gs_Intro(this);
        } else {
            if (state_name.equals("gs_CreditsScroll")) {
                this.m_playBGM = false;
            }
            this.m_gameState = new gs_AnimatedBackground(this, state_name, oldState);
        }
        this.bgmRetry = System.currentTimeMillis();
        this.stateChange = false;
    }

    public void RequestDestroy() {
        this.terminate();
    }

    public sGameCircuit getGameCircuit() {
        return m_gameCircuit;
    }

    public sResultsData getResultsData() {
        return m_resultsData;
    }

    public SaveGame getSaveGame() {
        return m_savedGame;
    }

    public SavePrefs getSavePrefs() {
        return m_savedPrefs;
    }

    public Song[] getSongs() {
        return m_songs;
    }

    public Object getAsset(String asset_name) {
        return null;
    }

    public DashResourceProvider getProvider() {
        return m_pProvider;
    }

    public static String getAppProperty(String key) {
        return myMidlet.getAppProperty(key);
    }

    public static int MAKE_RGB(int r, int g, int b) {
        return (r << 16) + (g << 8) + (b << 0);
    }

    public static void fillRect(Graphics g, int x, int y, int w, int h, int color) {
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public static MIDlet getMIDlet() {
        return myMidlet;
    }

    public static void drawNetLoadIcon(Graphics g, int x, int y, long deltaT) {
    }

    public void myRepaint() {
        this.repaint();
    }

    static {
        m_tourName = "";
        dlPack = 0;
        isDirty = true;
        softkeyFont = null;
        drawSoftKeys = true;
        m_flip_softkeys = false;
        px = new int[3];
        py = new int[3];
        pt = new long[3];
        m_pProvider = null;
    }
}

