/*
 * Decompiled with CFR 0.152.
 */
public class DashStorage {
    public static boolean storeInt(int id, int i) {
        return FS.writeRMS(id, DashStorage.toBytes(i)) == 4;
    }

    public static boolean storeString(int id, String str) {
        return FS.writeRMS(id, str.getBytes()) == str.length();
    }

    public static boolean storeData(int id, byte[] data) {
        return FS.writeRMS(id, data) == data.length;
    }

    public static int loadInt(int id) {
        int retval = 0;
        byte[] data = FS.readRMS(id);
        if (data == null || data.length < 4) {
            return -1;
        }
        retval |= (data[3] & 0xFF) << 24;
        retval |= (data[2] & 0xFF) << 16;
        retval |= (data[1] & 0xFF) << 8;
        return retval |= data[0] & 0xFF;
    }

    public static String loadString(int id) {
        byte[] retval = FS.readRMS(id);
        if (retval == null) {
            return "";
        }
        if (retval[0] == 0) {
            return "";
        }
        return new String(retval);
    }

    public static byte[] loadData(int id) {
        return FS.readRMS(id);
    }

    public static boolean init(int sizeInBytes) {
        return true;
    }

    public static boolean checkFile(int id) {
        return FS.checkRecord(id);
    }

    protected static byte[] toBytes(int i) {
        byte[] data = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return data;
    }

    public static void deleteFile(int id) {
        FS.deleteRecord(id);
    }

    private DashStorage() {
    }
}

