/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;

public class MidiFileIn {
    short format_;
    short nTracks_;
    int division_;
    boolean usingTimeCode_;
    Track m_track = null;
    Vector m_eventsByChannel = new Vector();

    int Swap32BE(int a) {
        return a;
    }

    short Swap16BE(short a) {
        return a;
    }

    long Load(int fileName, byte[] fromBuffer) throws IOException {
        int tickrate;
        byte[] filedata = null;
        filedata = fromBuffer == null ? (DashEngine.dlPack != 0 ? DashStorage.loadData(2 + fileName) : DashResourceProvider.getBinary(fileName)) : fromBuffer;
        DataInputStream file_ = new DataInputStream(new ByteArrayInputStream(filedata));
        long size = 0L;
        byte[] chunkType = new byte[4];
        file_.readFully(chunkType);
        int length = file_.readInt();
        length = this.Swap32BE(length);
        if (!"MThd".equals(new String(chunkType)) || length != 6) {
            throw new RuntimeException("MidiFileIn: file (" + fileName + ") does not appear to be a MIDI file! " + new String(chunkType));
        }
        short data = file_.readShort();
        if ((data = this.Swap16BE(data)) < 0 || data > 2) {
            throw new RuntimeException("MidiFileIn: the file (" + fileName + ") format is invalid!");
        }
        this.format_ = data;
        if (this.format_ != 0) {
            throw new RuntimeException("joe is lazy and only supports midi format 0!  diaf");
        }
        data = file_.readShort();
        data = this.Swap16BE(data);
        if (this.format_ == 0 && data != 1) {
            throw new RuntimeException("MidiFileIn: invalid number of tracks (>1) for a file format = 0!");
        }
        this.nTracks_ = data;
        data = file_.readShort();
        data = this.Swap16BE(data);
        this.division_ = data;
        this.usingTimeCode_ = false;
        if ((data & 0x8000) != 0) {
            tickrate = -(data & 0x7F00);
            tickrate *= data & 0xFF;
            this.usingTimeCode_ = true;
        } else {
            tickrate = data & Short.MAX_VALUE;
        }
        for (int i = 0; i < this.nTracks_; ++i) {
            file_.readFully(chunkType);
            if (!"MTrk".equals(new String(chunkType))) {
                throw new RuntimeException("invalid track header " + chunkType);
            }
            length = file_.readInt();
            length = this.Swap32BE(length);
            this.m_track = new Track(length, 0, file_, this.format_, this.usingTimeCode_);
        }
        file_.close();
        return length;
    }

    byte[] getTempoModifiedTrack(int resID, boolean faster, int modPercent) {
        try {
            long size = this.Load(resID, null);
            Track track = this.m_track;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1297377380);
            dos.writeInt(6);
            dos.writeShort(0);
            dos.writeShort(1);
            dos.writeShort(this.division_);
            dos.writeInt(1297379947);
            ByteArrayOutputStream trackbaos = new ByteArrayOutputStream();
            DataOutputStream trackdos = new DataOutputStream(trackbaos);
            byte[] file_ = track.rawdata;
            int fileIndex = 0;
            long currTick = 0L;
            long bytes = 0L;
            boolean skippedevents = false;
            while (fileIndex < file_.length) {
                if (file_[fileIndex] == 255) {
                    trackdos.writeByte(file_[fileIndex]);
                    if (file_[++fileIndex] == 81) {
                        trackdos.writeByte(file_[fileIndex]);
                        trackdos.writeByte(file_[++fileIndex]);
                        int[] oldMPQN = new int[3];
                        int n = ++fileIndex;
                        oldMPQN[0] = file_[n];
                        int n2 = ++fileIndex;
                        oldMPQN[1] = file_[n2];
                        oldMPQN[2] = file_[++fileIndex];
                        long value = (oldMPQN[0] << 16) + (oldMPQN[1] << 8) + oldMPQN[2];
                        long mod = value * (long)modPercent / 100L;
                        value = faster ? (value -= mod) : (value += mod);
                        trackdos.writeByte((int)(value >>= 8) & 0xFF0000);
                        trackdos.writeByte((int)value & 0xFF00);
                        trackdos.writeByte((int)value & 0xFF);
                        continue;
                    }
                    trackdos.writeByte(file_[fileIndex]);
                } else {
                    trackdos.writeByte(file_[fileIndex]);
                }
                ++fileIndex;
            }
            trackdos.flush();
            byte[] trackdata = trackbaos.toByteArray();
            dos.writeInt(trackdata.length);
            dos.write(trackdata, 0, trackdata.length);
            dos.flush();
            byte[] retBytes = baos.toByteArray();
            trackdos.close();
            trackbaos.close();
            baos.close();
            dos.close();
            return retBytes;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    long readVariableLength(DataInputStream file_) throws IOException {
        long value = 0L;
        int c = file_.readUnsignedByte();
        value = c;
        if ((value & 0x80L) != 0L) {
            value &= 0x7FL;
            do {
                c = file_.readUnsignedByte();
                value = (value << 7) + (long)(c & 0x7F);
            } while ((c & 0x80) != 0);
        }
        return value;
    }

    void writeVariableLength(long data, DataOutputStream dos) throws IOException {
        if (data > 128L) {
            throw new RuntimeException("writeVariableLength needs a proper implementation");
        }
        if (data < 128L) {
            dos.writeByte((int)data);
        } else {
            long buffer = data & 0x7FL;
            while ((data >>= 7) > 0L) {
                buffer <<= 8;
                buffer |= 0x80L;
                buffer += data & 0x7FL;
            }
            while (true) {
                dos.writeByte((int)data);
                if ((buffer & 0x80L) == 0L) break;
                buffer >>= 8;
            }
        }
    }

    void setupMidiEvents(int channel) {
        if (this.m_track == null) {
            return;
        }
        int ebcIdx = -1;
        for (int e = 0; e < this.m_eventsByChannel.size(); ++e) {
            if (((chEvtVector)this.m_eventsByChannel.elementAt((int)e)).channel != channel) continue;
            ebcIdx = e;
        }
        if (ebcIdx != -1 && ((chEvtVector)this.m_eventsByChannel.elementAt((int)ebcIdx)).channelEvents.size() > 0) {
            ((chEvtVector)this.m_eventsByChannel.elementAt((int)ebcIdx)).channelEvents.removeAllElements();
        }
        if (ebcIdx == -1) {
            chEvtVector cev = new chEvtVector();
            cev.channel = channel;
            this.m_eventsByChannel.addElement(cev);
            ebcIdx = this.m_eventsByChannel.size() - 1;
        }
        int evtChannel = 144 + channel;
        for (int i = 0; i < this.m_track.m_trackEvents.size(); ++i) {
            long ce;
            long currGameTicks;
            MidiEvent mEvent_i = (MidiEvent)this.m_track.m_trackEvents.elementAt(i);
            if (mEvent_i.event != evtChannel) continue;
            if (((tmpEvt)this.m_track.m_tempoEvents.elementAt((int)(this.m_track.m_tempoEvents.size() - 1))).absoluteTimeMillis != 0L) {
                int currTEvt = 0;
                long milliCount = 0L;
                long milliCurr = 0L;
                for (int k = 0; k < this.m_track.m_tempoEvents.size(); ++k) {
                    boolean doBreak = false;
                    tmpEvt tempoEvent_k = (tmpEvt)this.m_track.m_tempoEvents.elementAt(k);
                    if (mEvent_i.ticks > tempoEvent_k.ticks) {
                        ++currTEvt;
                        milliCount += tempoEvent_k.absoluteTimeMillis;
                        if (k == this.m_track.m_tempoEvents.size() - 1) {
                            doBreak = true;
                        }
                    } else {
                        doBreak = true;
                    }
                    if (!doBreak) continue;
                    --currTEvt;
                    if (milliCount != 0L) {
                        milliCount -= ((tmpEvt)this.m_track.m_tempoEvents.elementAt((int)currTEvt)).absoluteTimeMillis;
                    }
                    if (currTEvt < 0) {
                        currTEvt = 0;
                    }
                    if (milliCount >= 0L) break;
                    milliCount = 0L;
                    break;
                }
                tmpEvt tempoEvent_curr = (tmpEvt)this.m_track.m_tempoEvents.elementAt(currTEvt);
                milliCurr = (mEvent_i.ticks - tempoEvent_curr.ticks) / (long)this.division_ * tempoEvent_curr.mpqn / 1000L + (mEvent_i.ticks - tempoEvent_curr.ticks) % (long)this.division_ * tempoEvent_curr.mpqn / (long)this.division_ / 1000L;
                ce = currGameTicks = (milliCount + milliCurr) * 150L / 1000L;
            } else {
                ce = currGameTicks = mEvent_i.ticks / (long)this.division_ * this.m_track.mpqn / 1000L * 150L / 1000L + mEvent_i.ticks % (long)this.division_ * this.m_track.mpqn / (long)this.division_ / 1000L * 150L / 1000L;
            }
            ((chEvtVector)this.m_eventsByChannel.elementAt((int)ebcIdx)).channelEvents.addElement(new Long(ce));
        }
    }

    boolean checkForChannelEvent(int channel, long currTicks) {
        int i;
        int ebcIdx = -1;
        for (int e = 0; e < this.m_eventsByChannel.size(); ++e) {
            if (((chEvtVector)this.m_eventsByChannel.elementAt((int)e)).channel != channel) continue;
            ebcIdx = e;
        }
        if (ebcIdx == -1) {
            return false;
        }
        int evtCount = 0;
        chEvtVector currEvtVec = (chEvtVector)this.m_eventsByChannel.elementAt(ebcIdx);
        for (i = 0; i < currEvtVec.channelEvents.size() && currTicks >= (Long)currEvtVec.channelEvents.elementAt(i); ++i) {
            ++evtCount;
        }
        if (evtCount > 0) {
            for (i = 0; i < evtCount - 1; ++i) {
                currEvtVec.channelEvents.removeElementAt(i);
            }
            return true;
        }
        return false;
    }

    int getNumEventChannels() {
        return this.m_eventsByChannel.size();
    }

    int getChannelAt(int pos) {
        if (pos < this.getNumEventChannels()) {
            return ((chEvtVector)this.m_eventsByChannel.elementAt((int)pos)).channel;
        }
        return 0;
    }

    byte[] getInstrumentModifiedTrack(int resID, byte[] buffIn) {
        try {
            long size = this.Load(resID, buffIn);
            Track track = this.m_track;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1297377380);
            dos.writeInt(6);
            dos.writeShort(0);
            dos.writeShort(1);
            dos.writeShort(this.division_);
            dos.writeInt(1297379947);
            ByteArrayOutputStream trackbaos = new ByteArrayOutputStream();
            DataOutputStream trackdos = new DataOutputStream(trackbaos);
            byte[] file_ = track.rawdata;
            int fileIndex = 0;
            long currTick = 0L;
            long bytes = 0L;
            boolean skippedevents = false;
            while (fileIndex < file_.length) {
                if (file_[fileIndex] == 255) {
                    trackdos.writeByte(file_[fileIndex]);
                    trackdos.writeByte(file_[++fileIndex]);
                    int sze = file_[++fileIndex];
                    trackdos.writeByte(sze);
                    for (int s = 0; s < sze; ++s) {
                        trackdos.writeByte(file_[++fileIndex]);
                    }
                }
                int b = file_[fileIndex];
                if ((b &= 0xF0) == 192) {
                    trackdos.writeByte(b);
                    byte ins = file_[++fileIndex];
                    ++fileIndex;
                    int new_ins = this.convertInstrument(ins);
                    trackdos.writeByte(new_ins);
                    continue;
                }
                trackdos.writeByte(file_[fileIndex]);
                ++fileIndex;
            }
            trackdos.flush();
            byte[] trackdata = trackbaos.toByteArray();
            dos.writeInt(trackdata.length);
            dos.write(trackdata, 0, trackdata.length);
            dos.flush();
            byte[] retBytes = baos.toByteArray();
            trackdos.close();
            trackbaos.close();
            baos.close();
            dos.close();
            return retBytes;
        }
        catch (Throwable skeeet) {
            skeeet.printStackTrace();
            return null;
        }
    }

    int convertInstrument(int instrumentIn) {
        int instrumentOut = 0;
        int[][] families = new int[][]{{0, 7}, {8, 15}, {16, 23}, {24, 31}, {32, 39}, {40, 47}, {48, 55}, {56, 63}, {64, 71}, {72, 79}, {80, 87}, {88, 95}, {96, 103}, {104, 111}, {112, 119}, {120, 127}};
        for (int i = 0; i < 16; ++i) {
            if (instrumentIn < families[i][0] || instrumentIn > families[i][1]) continue;
            while ((instrumentOut = DashResourceProvider.getRand(families[i][0], families[i][1])) == instrumentIn) {
            }
            return instrumentOut;
        }
        return 0;
    }

    public byte[] getResume(int filename, long milliseconds, byte[] buffIn) throws IOException {
        long tickspassed;
        this.Load(filename, buffIn);
        Track track = this.m_track;
        tmpEvt temoEvent = (tmpEvt)this.m_track.m_tempoEvents.elementAt(this.m_track.m_tempoEvents.size() - 1);
        if (temoEvent.absoluteTimeMillis != 0L) {
            int currTEvt = 0;
            long milliCount = 0L;
            long ticksCount = 0L;
            for (int k = 0; k < this.m_track.m_tempoEvents.size(); ++k) {
                boolean doBreak = false;
                if (milliseconds > milliCount) {
                    ++currTEvt;
                    temoEvent = (tmpEvt)this.m_track.m_tempoEvents.elementAt(k);
                    milliCount += temoEvent.absoluteTimeMillis;
                    if (k == this.m_track.m_tempoEvents.size() - 1) {
                        doBreak = true;
                    }
                } else {
                    doBreak = true;
                }
                if (!doBreak) continue;
                temoEvent = (tmpEvt)this.m_track.m_tempoEvents.elementAt(--currTEvt);
                if (milliCount != 0L) {
                    milliCount -= temoEvent.absoluteTimeMillis;
                }
                if (currTEvt >= 0) {
                    ticksCount = temoEvent.ticks;
                }
                if (currTEvt < 0) {
                    currTEvt = 0;
                }
                if (milliCount < 0L) {
                    milliCount = 0L;
                }
                if (ticksCount >= 0L) break;
                ticksCount = 0L;
                break;
            }
            long msIntoCurrChunk = milliseconds - milliCount;
            if (currTEvt >= 0) {
                temoEvent = (tmpEvt)this.m_track.m_tempoEvents.elementAt(currTEvt);
                tickspassed = ticksCount + (msIntoCurrChunk * 1000L / temoEvent.mpqn * (long)this.division_ + msIntoCurrChunk * 1000L % temoEvent.mpqn * (long)this.division_ / temoEvent.mpqn);
            } else {
                tickspassed = ticksCount;
            }
        } else {
            tickspassed = milliseconds * 1000L / track.mpqn * (long)this.division_ + milliseconds * 1000L % track.mpqn * (long)this.division_ / this.m_track.mpqn;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(1297377380);
        dos.writeInt(6);
        dos.writeShort(0);
        dos.writeShort(1);
        dos.writeShort(this.division_);
        dos.writeInt(1297379947);
        ByteArrayOutputStream trackbaos = new ByteArrayOutputStream();
        DataOutputStream trackdos = new DataOutputStream(trackbaos);
        DataInputStream file_ = new DataInputStream(new ByteArrayInputStream(track.rawdata));
        long currTick = 0L;
        long bytes = 0L;
        int skippedevents = 0;
        int firstByte = 0;
        while (file_.available() > 0) {
            int c;
            long ticks;
            try {
                ticks = this.readVariableLength(file_);
                file_.mark(1);
                firstByte = file_.readUnsignedByte();
                file_.reset();
            }
            catch (EOFException eof) {
                break;
            }
            if ((currTick += ticks) >= tickspassed && (firstByte >> 4 == 9 || tickspassed == 0L)) {
                int tickOffset = (int)(currTick - tickspassed > 127L ? 127L : currTick - tickspassed);
                this.writeVariableLength(tickOffset, trackdos);
                int left = file_.available();
                trackdos.write(track.rawdata, track.rawdata.length - left, left);
                break;
            }
            firstByte = c = file_.readUnsignedByte();
            boolean skipEvent = false;
            bytes = 0L;
            switch (c) {
                case 255: {
                    trackdos.write(0);
                    trackdos.writeByte(c);
                    c = file_.readUnsignedByte();
                    trackdos.writeByte(c);
                    bytes = this.readVariableLength(file_);
                    this.writeVariableLength(bytes, trackdos);
                    break;
                }
                case 240: 
                case 247: {
                    trackdos.write(0);
                    track.status = 0;
                    trackdos.writeByte(c);
                    bytes = this.readVariableLength(file_);
                    this.writeVariableLength(bytes, trackdos);
                    break;
                }
                default: {
                    switch (c >> 4) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 14: {
                            ++skippedevents;
                            skipEvent = true;
                        }
                    }
                    if ((c & 0x80) != 0) {
                        if (c > 240) {
                            throw new RuntimeException("NotesLoaderMidi status byte");
                        }
                        if (!skipEvent) {
                            trackdos.write(0);
                        }
                        if (!skipEvent) {
                            trackdos.writeByte(c);
                        }
                        if ((c &= 0xF0) == 192 || c == 208) {
                            bytes = 1L;
                            break;
                        }
                        bytes = 2L;
                        break;
                    }
                    skipEvent = true;
                    bytes = 1L;
                }
            }
            for (long i = 0L; i < bytes; ++i) {
                c = file_.readUnsignedByte();
                if (skipEvent) continue;
                trackdos.writeByte(c);
            }
        }
        trackdos.flush();
        byte[] trackdata = trackbaos.toByteArray();
        dos.writeInt(trackdata.length);
        dos.write(trackdata, 0, trackdata.length);
        dos.flush();
        byte[] retBytes = baos.toByteArray();
        file_.close();
        trackdos.close();
        trackbaos.close();
        baos.close();
        dos.close();
        return retBytes;
    }

    byte[] getAccentuatedInstrumentTrack(int resID, byte instrument, byte[] sndBufIn) {
        byte accentuatedChannel;
        switch (instrument) {
            case 0: {
                accentuatedChannel = 1;
                break;
            }
            case 1: {
                accentuatedChannel = 2;
                break;
            }
            case 3: {
                accentuatedChannel = 0;
                break;
            }
            case 2: {
                accentuatedChannel = 9;
                break;
            }
            default: {
                accentuatedChannel = 0;
            }
        }
        try {
            long size = this.Load(resID, sndBufIn);
            Track track = this.m_track;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1297377380);
            dos.writeInt(6);
            dos.writeShort(0);
            dos.writeShort(1);
            dos.writeShort(this.division_);
            dos.writeInt(1297379947);
            byte[] file_ = track.rawdata;
            int fileIndex = 0;
            ByteArrayOutputStream trackbaos = new ByteArrayOutputStream();
            DataOutputStream trackdos = new DataOutputStream(trackbaos);
            long currTick = 0L;
            long bytes = 0L;
            boolean skippedevents = false;
            boolean skipNoteOns = false;
            while (fileIndex < file_.length) {
                if (file_[fileIndex] == 255) {
                    trackdos.writeByte(file_[fileIndex]);
                    if (file_[++fileIndex] == 47) {
                        skipNoteOns = true;
                    }
                    trackdos.writeByte(file_[fileIndex]);
                    int sze = file_[++fileIndex];
                    trackdos.writeByte(sze);
                    boolean breakUrFace = false;
                    for (int s = 0; s < sze; ++s) {
                        trackdos.writeByte(file_[fileIndex]);
                        if (++fileIndex < file_.length) continue;
                        breakUrFace = true;
                        break;
                    }
                    if (breakUrFace) break;
                }
                byte b = file_[fileIndex];
                if ((b = (byte)(b & 0xF0)) == 144 && !skipNoteOns) {
                    int addition;
                    byte channel = file_[fileIndex];
                    channel = (byte)(channel & 0xF);
                    trackdos.writeByte(file_[fileIndex]);
                    trackdos.writeByte(file_[++fileIndex]);
                    int ADDITIVE_VELOCITY_PERCENT = 30;
                    int SUBTRACTIVE_VELOCITY_PERCENT = 30;
                    int vel = file_[++fileIndex];
                    int new_vel = vel <= 127 ? ((addition = accentuatedChannel == channel ? vel * ADDITIVE_VELOCITY_PERCENT / 100 : -(vel * SUBTRACTIVE_VELOCITY_PERCENT / 100)) + vel > 127 ? 127 : (addition + vel < 0 ? 0 : (int)((byte)(vel + (byte)addition)))) : vel;
                    trackdos.writeByte(new_vel);
                    continue;
                }
                trackdos.writeByte(file_[fileIndex]);
                ++fileIndex;
            }
            trackdos.flush();
            byte[] trackdata = trackbaos.toByteArray();
            dos.writeInt(trackdata.length);
            dos.write(trackdata, 0, trackdata.length);
            dos.flush();
            byte[] retBytes = baos.toByteArray();
            trackdos.close();
            trackbaos.close();
            baos.close();
            dos.close();
            return retBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class Track {
        int status;
        byte[] rawdata;
        int rawdata_len;
        long mpqn;
        int format;
        boolean usingTimeCode;
        Vector m_trackEvents = new Vector();
        Vector m_tempoEvents = new Vector();

        public Track(int len, int stat, DataInputStream din, int format_, boolean usingTimeCode_) throws IOException {
            long ticks;
            this.rawdata = new byte[len];
            din.readFully(this.rawdata);
            this.rawdata_len = len;
            this.format = format_;
            this.usingTimeCode = usingTimeCode_;
            this.status = stat;
            DataInputStream dtemp = new DataInputStream(new ByteArrayInputStream(this.rawdata));
            while (dtemp.available() > 0 && (ticks = this.getNextEvent(this, dtemp)) >= 0L) {
            }
            this.status = stat;
            dtemp.close();
        }

        long getNextEvent(Track track, DataInputStream file_) throws IOException {
            long ticks;
            long bytes = 0L;
            MidiEvent me = new MidiEvent();
            Vector<MidiEvent> nEvent = new Vector<MidiEvent>();
            boolean isTempoEvent = false;
            try {
                ticks = MidiFileIn.this.readVariableLength(file_);
            }
            catch (EOFException eof) {
                return -1L;
            }
            int c = file_.readUnsignedByte();
            switch (c) {
                case 255: {
                    me.event = c;
                    nEvent.addElement(me);
                    c = file_.readUnsignedByte();
                    nEvent.addElement(me);
                    if (MidiFileIn.this.format_ != 1 && c == 81) {
                        isTempoEvent = true;
                    }
                    bytes = MidiFileIn.this.readVariableLength(file_);
                    break;
                }
                case 240: 
                case 247: {
                    me.event = c;
                    track.status = 0;
                    nEvent.addElement(me);
                    bytes = MidiFileIn.this.readVariableLength(file_);
                    break;
                }
                default: {
                    if ((c & 0x80) != 0) {
                        if (c > 240) {
                            throw new RuntimeException("NotesLoaderMidi status byte");
                        }
                        track.status = c;
                        me.event = c;
                        nEvent.addElement(me);
                        if ((c &= 0xF0) == 192 || c == 208) {
                            bytes = 1L;
                            break;
                        }
                        bytes = 2L;
                        break;
                    }
                    if ((track.status & 0x80) != 0) {
                        me.event = track.status;
                        nEvent.addElement(me);
                        me.event = c;
                        nEvent.addElement(me);
                        c = track.status & 0xF0;
                        if (c == 192 || c == 208) break;
                        bytes = 1L;
                        break;
                    }
                    throw new RuntimeException("NotesLoaderMidi default dush");
                }
            }
            for (long i = 0L; i < bytes; ++i) {
                me.event = c = file_.readUnsignedByte();
                nEvent.addElement(me);
            }
            if (!MidiFileIn.this.usingTimeCode_ && isTempoEvent) {
                long value = (((MidiEvent)nEvent.elementAt((int)2)).event << 16) + (((MidiEvent)nEvent.elementAt((int)3)).event << 8) + ((MidiEvent)nEvent.elementAt((int)4)).event;
                int bpm = (int)(60000000L / value);
                long tT = this.m_trackEvents.size() > 0 ? ticks + ((MidiEvent)this.m_trackEvents.elementAt((int)(this.m_trackEvents.size() - 1))).ticks : 0L;
                tmpEvt te = new tmpEvt();
                te.mpqn = value;
                te.ticks = tT;
                te.absoluteTimeMillis = 0L;
                this.m_tempoEvents.addElement(te);
                track.mpqn = value;
            }
            long tempTicks = this.m_trackEvents.size() > 0 ? ticks + ((MidiEvent)this.m_trackEvents.elementAt((int)(this.m_trackEvents.size() - 1))).ticks : 0L;
            for (int i = 0; i < nEvent.size(); ++i) {
                MidiEvent me_eeeh = (MidiEvent)nEvent.elementAt(i);
                me_eeeh.ticks = tempTicks;
                this.m_trackEvents.addElement(me_eeeh);
            }
            return ticks;
        }
    }

    class MidiEvent {
        int event;
        long ticks;

        public MidiEvent(int c) {
            this.event = c;
        }

        public MidiEvent() {
            this.event = -1;
        }
    }

    class chEvtVector {
        Vector channelEvents = new Vector();
        int channel;
    }

    class tmpEvt {
        long ticks;
        long mpqn;
        long absoluteTimeMillis;
    }
}

