/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ScoreDisplay
implements SPDefines {
    long m_judge_timer;
    int m_judge;
    int m_judgeLane;
    long m_combo_timer;
    int m_combo_size;
    long m_spin_timer;
    int m_scorePosX;
    int m_scorePosY;
    long m_score;
    int[] m_judgePosX = new int[4];
    int[] m_judgePosY = new int[4];
    int m_comboPosX;
    int m_comboPosY;
    int m_comboJumpOffset;
    long m_oppScore;
    long m_oppScoreTimer;
    boolean m_mp;

    public ScoreDisplay(boolean mp, int scoreBackX, int scoreBackY) {
        DashFont imgSFnt = DashResourceProvider.getFont(37);
        this.m_mp = mp;
        this.m_judge_timer = -1L;
        this.m_judge = 0;
        this.m_combo_timer = -1L;
        this.m_spin_timer = -1L;
        this.m_comboPosX = 0;
        this.m_comboPosY = 0;
        this.m_comboJumpOffset = 0;
        this.m_score = 0L;
        int scoreBottom = 22;
        this.m_scorePosX = scoreBackX + DashResourceProvider.getImage(66).getWidth() - 3;
        this.m_scorePosY = scoreBackY + scoreBottom;
        for (int i = 0; i < 4; ++i) {
            this.setJudgePos(i, DashResourceProvider.getScreenWidth() / 2, DashResourceProvider.getScreenHeight() / 2);
        }
        this.m_oppScore = 0L;
        this.m_oppScoreTimer = -1L;
    }

    void startJudge(int judge, int lane) {
        this.m_judge = judge;
        this.m_judgeLane = lane;
        this.m_judge_timer = DashResourceProvider.getTime(1);
    }

    void reset() {
        this.m_judge_timer = -1L;
        this.m_judge = 0;
        this.m_combo_timer = -1L;
        this.m_spin_timer = -1L;
        this.m_score = 0L;
    }

    void startCombo(int comboSize) {
        if (comboSize < 2) {
            this.m_combo_size = 0;
            this.m_combo_timer = -1L;
            return;
        }
        this.m_combo_size = comboSize;
        this.m_combo_timer = DashResourceProvider.getTime(1);
        this.m_comboJumpOffset = 0;
    }

    void updateScore(long newScore) {
        if (newScore == this.m_score) {
            return;
        }
        if (this.m_oppScoreTimer == -1L) {
            this.m_spin_timer = DashResourceProvider.getTime(1);
        }
        this.m_score = newScore;
    }

    void showOpponentScore(long oppScore) {
        this.m_oppScore = oppScore;
        this.m_oppScoreTimer = DashResourceProvider.getTime(1);
        this.m_spin_timer = -1L;
    }

    void update() {
        if (this.m_judge_timer != -1L && DashResourceProvider.getTime(1) - this.m_judge_timer > 450L) {
            this.m_judge_timer = -1L;
            return;
        }
        if (this.m_combo_timer != -1L) {
            if (DashResourceProvider.getTime(1) - this.m_combo_timer < 500L) {
                --this.m_comboJumpOffset;
            } else {
                this.m_comboJumpOffset += 4;
                if (this.m_comboJumpOffset > 0) {
                    this.m_comboJumpOffset = 0;
                }
            }
            if (DashResourceProvider.getTime(1) - this.m_combo_timer > 1000L) {
                this.m_combo_timer = -1L;
                return;
            }
        }
        long currTime = DashResourceProvider.getTime(1);
        if (DashResourceProvider.getTime(1) - this.m_spin_timer > 800L) {
            this.m_spin_timer = -1L;
        }
        if (DashResourceProvider.getTime(1) - this.m_oppScoreTimer > 3000L) {
            this.m_oppScoreTimer = -1L;
        }
    }

    void draw(Graphics g) {
        DashImage imgJudge;
        switch (DashResourceProvider.currentLanguage) {
            case 1: {
                imgJudge = DashResourceProvider.getImage(141);
                break;
            }
            case 2: {
                imgJudge = DashResourceProvider.getImage(142);
                break;
            }
            default: {
                imgJudge = DashResourceProvider.getImage(72);
            }
        }
        DashImage imgComboBG = DashResourceProvider.getImage(69);
        DashFont fntCombo = DashResourceProvider.getFont(38);
        if (this.m_judge_timer != -1L) {
            imgJudge.draw(g, this.m_judgePosX[this.m_judgeLane], this.m_judgePosY[this.m_judgeLane], this.m_judge, 20);
        }
        if (this.m_combo_timer != -1L) {
            imgComboBG.draw(g, this.m_comboPosX, this.m_comboPosY, 20);
            fntCombo.drawString(g, "c", this.m_comboPosX + imgComboBG.getWidth() / 2, this.m_comboPosY + imgComboBG.getHeight() / 5 + this.m_comboJumpOffset, 3);
            fntCombo.drawString(g, "" + this.m_combo_size, this.m_comboPosX + imgComboBG.getWidth() / 2, this.m_comboPosY + imgComboBG.getHeight() / 5 + fntCombo.getHeight() / 2 + 2 + this.m_comboJumpOffset, 17);
        }
        if (this.m_mp) {
            int tFrame = 0;
            if (this.m_oppScoreTimer != -1L) {
                tFrame = 1;
            }
            DashResourceProvider.getImage(74).draw(g, this.m_scorePosX - DashResourceProvider.getImage(66).getWidth(), this.m_scorePosY, tFrame, 40);
        }
        long dispScore = this.m_oppScoreTimer != -1L ? this.m_oppScore : this.m_score;
        if (this.m_spin_timer > 0L && !DashResourceProvider.isTimerPaused(1)) {
            int rnd = DashResourceProvider.getRand(0, 99);
            if ((long)rnd > dispScore) {
                rnd = (int)dispScore - 1;
            }
            dispScore -= (long)rnd;
        }
        String scoreString = gs_resultsScreen.stringValue((int)dispScore, -1);
        DashResourceProvider.getFont(37).drawString(g, scoreString, this.m_scorePosX, this.m_scorePosY, 40);
    }

    public void setJudgePos(int lane, int posX, int posY) {
        this.m_judgePosX[lane] = posX;
        this.m_judgePosY[lane] = posY;
    }

    public void setComboPos(int posX, int posY) {
        this.m_comboPosX = posX;
        this.m_comboPosY = posY;
    }
}

