/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SaveData {
    private static SaveData self;
    public boolean soundOn = true;
    public int[] highScores;
    public String[] highNames;
    public boolean shownInstructions = false;
    public Date firstRun = new Date();
    public static final int MAX_SCORES = 5;

    private SaveData() {
        if (this.highScores == null) {
            this.highScores = new int[5];
            this.highNames = new String[5];
            for (int i = 0; i < this.highScores.length; ++i) {
                this.highScores[i] = 0;
                this.highNames[i] = "NOK";
            }
        }
        this.load();
    }

    public static SaveData getInstance() {
        if (self == null) {
            self = new SaveData();
        }
        return self;
    }

    public void save() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"options", (boolean)true);
            byte[] byArray = this.saveOptions();
            if (recordStore.getNumRecords() != 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private byte[] saveOptions() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            dataOutputStream.writeBoolean(this.soundOn);
            for (n = 0; n < this.highScores.length; ++n) {
                dataOutputStream.writeInt(this.highScores[n]);
            }
            dataOutputStream.writeBoolean(this.shownInstructions);
            dataOutputStream.writeLong(this.firstRun.getTime());
            for (n = 0; n < this.highScores.length; ++n) {
                dataOutputStream.writeChars(this.highNames[n]);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void load() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"options", (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                this.loadOptions(recordStore.getRecord(1));
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void loadOptions(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.soundOn = dataInputStream.readBoolean();
            for (int i = 0; i < this.highScores.length; ++i) {
                int n;
                this.highScores[i] = n = dataInputStream.readInt();
            }
            this.shownInstructions = dataInputStream.readBoolean();
            long l = dataInputStream.readLong();
            this.firstRun = new Date(l);
            for (int i = 0; i < this.highScores.length; ++i) {
                this.highNames[i] = "" + dataInputStream.readChar() + dataInputStream.readChar() + dataInputStream.readChar();
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean reportScore(int n, String string) {
        int n2;
        int n3 = 5;
        for (n2 = 0; n2 < this.highScores.length; ++n2) {
            if (n <= this.highScores[n2]) continue;
            n3 = n2;
            break;
        }
        if (n3 >= 5) {
            return false;
        }
        for (n2 = this.highScores.length - 1; n2 > n3; --n2) {
            this.highScores[n2] = this.highScores[n2 - 1];
            this.highNames[n2] = this.highNames[n2 - 1];
        }
        this.highScores[n3] = n;
        this.highNames[n3] = string;
        return true;
    }

    public boolean isHighScore(int n) {
        int n2 = 5;
        for (int i = 0; i < this.highScores.length; ++i) {
            if (n <= this.highScores[i]) continue;
            n2 = i;
            break;
        }
        return n2 < 5;
    }

    public Date getFirstRunDate() {
        return this.firstRun;
    }

    public void exit() {
        System.out.println("Saving game data");
        this.save();
    }
}

