/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.paperglider.game;

import com.neonplay.helper.SaveData;
import com.neonplay.helper.SoundItem;
import com.neonplay.paperglider.Main;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class GameViewBase
extends GameCanvas
implements Runnable {
    protected static final int VIRTUAL_SCREEN_WIDTH = 480;
    protected static final int VIRTUAL_SCREEN_HEIGHT = 320;
    protected static final int PLANE_WIDTH = 64;
    protected static final int PLANE_HEIGHT = 24;
    protected static final float FRICTION_SPEEDUP_VALUE = 500.0f;
    protected static final float FRICTION_SLOWDOWN_VALUE = 300.0f;
    protected static final float FRICTION_SPEEDUP_VALUE_OUTSIDE = 550.0f;
    protected static final float FRICTION_SLOWDOWN_VALUE_OUTSIDE = 475.0f;
    protected static final float Y_POSITION_VALUE = 0.3f;
    protected static final float GRAVITY = 20.0f;
    protected static final float GRAVITY_OUTSIDE = 12.0f;
    protected static final float PLANE_XPOS_SPEED_THRESHOLD_VALUE = 0.1f;
    protected static final float PLANE_XPOS_SPEED_VALUE = 0.5f;
    protected static final float ANGLE_DESCENDING_VALUE = 5.0E-4f;
    protected static final float ANGLE_CLIMBING_VALUE = 3.0E-4f;
    protected static final float ANGLE_DESCENDING_VALUE_OUTSIDE = 6.0E-4f;
    protected static final float ANGLE_CLIMBING_VALUE_OUTSIDE = 3.0E-4f;
    protected static final float VELOCITY_ANGLE_THRESHOLD = 700.0f;
    protected static final float VELOCITY_ANGLE_THRESHOLD_OUTSIDE = 800.0f;
    protected static final float MAX_PLANE_ANGLE = 85.0f;
    protected static final int PLANE_XPOS_VALUE = 100;
    protected static final float WIND_BOOST_DECREMENT_VALUE = 20.0f;
    protected static final float WIND_BOOST_INITIAL_VALUE = 100.0f;
    protected static final float VELOCITY_BOOST = 200.0f;
    protected static final float BACKGROUND_CITY_SCROLL_VALUE = 0.016f;
    protected static final float BACKGROUND_CITY_SCROLL_ANGLE_VALUE = 5.0f;
    protected static final int TOUCH_YPOS_BUFFER = 60;
    protected static final float FLICK_TARGET_ANGLE_VALUE = 10.0f;
    protected static final float FLICK_LEVEL_ANGLE_VALUE = 200.0f;
    protected static final float FLICK_TIME_UNTIL_LEVEL_THE_PLANE = 0.3f;
    protected static final float FLICK_PAUSE_TIME_BUFFER = 2.0f;
    protected static final float VELOCITY_STARTING_BOOST = 12.0f;
    protected static final float FLICK_VALUE = 750.0f;
    protected static final float VELOCITY_MAX_VALUE = 1000.0f;
    protected static final float VELOCITY_MINIMUM_VALUE = 600.0f;
    protected static final float FLICK_MIN_PIXEL_DISTANCE = 6.0f;
    protected Graphics g;
    protected Image doubleBuffer;
    protected volatile Thread gameThread;
    protected float score;
    protected int best;
    protected boolean isHighScore;
    protected String playerName = "AAA";
    protected int touchOldX;
    protected int touchOldY;
    protected float planeX;
    protected float planeY;
    protected float planeVelocityX;
    protected float planeVelocityY;
    protected float planeAngle;
    protected float planeSinAngle;
    protected float planeCosAngle;
    protected boolean windBoostActive;
    protected float windBoostRemaining;
    protected float targetWindBoostRemaining;
    protected boolean planeMadeItThroughWindow;
    protected float slowDownValue;
    protected float planeTargetXPositionSpeed;
    protected float targetXPosition;
    protected boolean diveBomb;
    protected boolean diveBombLift;
    protected float angleThreshold;
    protected float flickStartingX;
    protected float flickStartingY;
    protected boolean flightInProgress;
    protected boolean flickingInProgress;
    protected boolean keyboardLaunch;
    protected boolean planeCanBeReleasedFromFlick;
    protected boolean levelOutThePlane;
    protected float flickTargetAngle;
    protected float timeSinceFlickingMovement;
    protected int pixelsMovedForFlick;
    protected boolean angleDownKeyPressed;
    protected boolean angleUpKeyPressed;
    protected boolean gameIsOver;
    protected boolean returnToMenu;
    protected boolean paused;
    protected long lastTime;
    protected long elapsedMillis;
    protected long currentTime;
    protected SoundItem windBoostSound;
    protected SoundItem crunchSound;
    protected int currentLoopSound;

    public GameViewBase() {
        super(false);
        this.setFullScreenMode(true);
        this.init();
        this.doubleBuffer = Image.createImage((int)this.getLandscapeWidth(), (int)this.getLandscapeHeight());
        this.reset();
    }

    public void showNotify() {
        System.out.println("showNotify");
        this.lastTime = System.currentTimeMillis();
        this.g = this.getGraphics();
        this.gameThread = new Thread(this);
        this.gameThread.start();
        if (!this.gameIsOver && SaveData.getInstance().soundOn) {
            this.changeBackgroundSound(this.currentLoopSound, true);
        }
    }

    protected void hideNotify() {
        System.out.println("hideNotify");
        this.gameThread = null;
        this.windBoostSound.stop();
        this.crunchSound.stop();
    }

    public void run() {
        if (this.gameThread == null) {
            return;
        }
        this.currentTime = System.currentTimeMillis();
        this.elapsedMillis = this.currentTime - this.lastTime;
        float f = (float)this.elapsedMillis / 1000.0f;
        this.lastTime = this.currentTime;
        this.update(f);
        this.repaint();
        Display display = Main.getInstance().getDisplay();
        display.callSerially((Runnable)this);
    }

    protected void init() {
        this.windBoostSound = new SoundItem("/disappear off screen.wav", false);
        this.crunchSound = new SoundItem("/paper crunch.wav", false);
        this.currentLoopSound = -1;
    }

    public void reset() {
        this.score = 0.0f;
        this.best = SaveData.getInstance().highScores[0];
        this.planeX = 100.0f;
        this.planeY = 100.0f;
        this.planeAngle = 0.0f;
        this.flickTargetAngle = 0.0f;
        this.flickingInProgress = true;
        this.flightInProgress = false;
        this.keyboardLaunch = true;
        this.planeMadeItThroughWindow = false;
        this.slowDownValue = 300.0f;
        this.angleThreshold = 700.0f;
        this.targetXPosition = 192.0f;
        this.planeTargetXPositionSpeed = 100.0f;
        this.windBoostActive = false;
        this.windBoostRemaining = 100.0f;
        this.angleDownKeyPressed = false;
        this.angleUpKeyPressed = false;
        this.gameIsOver = false;
        this.paused = false;
        this.returnToMenu = false;
        this.stopBackgroundSound();
        if (this.gameThread != null && SaveData.getInstance().soundOn) {
            this.changeBackgroundSound(0, true);
        }
    }

    protected void launchPlane(int n, int n2) {
        this.flickingInProgress = false;
        this.flightInProgress = true;
        float f = this.flickStartingX - (float)n;
        float f2 = this.flickStartingY - (float)n2;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        this.planeVelocityX = f3 * 0.3f * 12.0f;
        this.planeVelocityX -= this.timeSinceFlickingMovement * 750.0f;
        System.out.println("Launch velocity = " + this.planeVelocityX + " angle " + this.planeAngle);
        if (this.planeVelocityX <= 600.0f || (float)this.pixelsMovedForFlick < 6.0f) {
            this.planeVelocityX = 600.0f;
        } else if (this.planeVelocityX > 1000.0f) {
            this.planeVelocityX = 1000.0f;
        }
        System.out.println("Launch velocity = " + this.planeVelocityX + " angle " + this.planeAngle);
        this.planeVelocityX = 900.0f;
    }

    protected final void setGameIsOver() {
        this.isHighScore = SaveData.getInstance().isHighScore((int)this.score);
        this.gameIsOver = true;
        this.stopBackgroundSound();
        if (this.score > 1700.0f) {
            SaveData.getInstance().shownInstructions = true;
        }
    }

    protected final void update(float f) {
        if (this.paused) {
            return;
        }
        if (!this.gameIsOver) {
            this.updatePlane(f);
            this.updateBackground(f);
            this.updateHasThePlaneGoneOffScreen(f);
            if (this.score >= 1700.0f && this.score <= 1750.0f && (this.planeY > 220.0f || this.planeY < 80.0f)) {
                this.setGameIsOver();
                if (SaveData.getInstance().soundOn) {
                    this.crunchSound.play();
                }
            }
        }
        if (this.returnToMenu) {
            Main.getInstance().getMenuView().setCurrentMenu(0);
            Main.getInstance().showMenuView();
        }
    }

    protected abstract void updateBackground(float var1);

    protected void changeBackgroundSound(int n, boolean bl) {
    }

    protected void stopBackgroundSound() {
    }

    protected final void updatePlane(float f) {
        if (this.flickingInProgress) {
            if (this.angleUpKeyPressed) {
                System.out.println("angle up");
                this.planeCanBeReleasedFromFlick = true;
                this.timeSinceFlickingMovement = 0.0f;
                this.flickTargetAngle += f * 200.0f;
                if (this.flickTargetAngle > 89.0f) {
                    this.flickTargetAngle = 89.0f;
                }
            } else if (this.angleDownKeyPressed) {
                System.out.println("angle down");
                this.planeCanBeReleasedFromFlick = true;
                this.timeSinceFlickingMovement = 0.0f;
                this.flickTargetAngle -= f * 200.0f;
                if (this.flickTargetAngle < -89.0f) {
                    this.flickTargetAngle = -89.0f;
                }
            }
            this.timeSinceFlickingMovement += f;
            if (this.timeSinceFlickingMovement > 0.3f && this.planeAngle != 0.0f && !this.keyboardLaunch) {
                this.levelOutThePlane = true;
            }
            if (this.levelOutThePlane) {
                if (this.planeAngle > 0.0f) {
                    this.planeAngle -= 200.0f * f;
                    if (this.planeAngle < 0.0f) {
                        this.planeAngle = 0.0f;
                        this.levelOutThePlane = false;
                        this.flickTargetAngle = 0.0f;
                    }
                } else {
                    this.planeAngle += 200.0f * f;
                    if (this.planeAngle > 0.0f) {
                        this.planeAngle = 0.0f;
                        this.levelOutThePlane = false;
                        this.flickTargetAngle = 0.0f;
                    }
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            } else {
                if (this.planeAngle != this.flickTargetAngle) {
                    if (this.flickTargetAngle != 0.0f) {
                        this.planeAngle += this.flickTargetAngle * 10.0f * f;
                    } else if (this.planeAngle > 0.0f) {
                        this.planeAngle -= 10.0f * f;
                        if (this.planeAngle < 0.0f) {
                            this.planeAngle = 0.0f;
                        }
                    } else {
                        this.planeAngle -= 10.0f * f;
                        if (this.planeAngle > 0.0f) {
                            this.planeAngle = 0.0f;
                        }
                    }
                }
                if (this.flickTargetAngle > 0.0f) {
                    if (this.planeAngle > this.flickTargetAngle) {
                        this.planeAngle = this.flickTargetAngle;
                    }
                } else if (this.planeAngle < this.flickTargetAngle) {
                    this.planeAngle = this.flickTargetAngle;
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            }
        } else if (this.flightInProgress) {
            float f2;
            float f3 = this.planeX;
            float f4 = this.planeY;
            if (this.windBoostActive && this.windBoostRemaining > 0.0f) {
                this.windBoostRemaining -= 20.0f * f;
                if (this.windBoostRemaining < 0.0f) {
                    this.windBoostRemaining = 0.0f;
                    this.windBoostActive = false;
                }
                this.targetWindBoostRemaining = this.windBoostRemaining;
                this.planeVelocityX += 200.0f * f;
            }
            if (this.planeMadeItThroughWindow && this.slowDownValue != 475.0f) {
                this.slowDownValue += 12.0f * f;
                if (this.slowDownValue > 475.0f) {
                    this.slowDownValue = 475.0f;
                }
            }
            float f5 = this.planeMadeItThroughWindow ? 550.0f : 500.0f;
            float f6 = this.planeSinAngle > 0.0f ? this.slowDownValue * this.planeSinAngle : f5 * this.planeSinAngle;
            this.planeVelocityX -= f6 * f;
            if (this.planeMadeItThroughWindow) {
                f2 = 2.0f;
                this.planeVelocityX -= f2 * f;
            }
            this.planeY += this.planeVelocityX * -this.planeSinAngle * 0.3f * f;
            f2 = this.planeMadeItThroughWindow ? 12.0f : 20.0f;
            this.planeY += f2 * f;
            this.planeTargetXPositionSpeed -= 0.5f * f;
            if (this.planeTargetXPositionSpeed < 0.1f) {
                this.planeTargetXPositionSpeed = 0.1f;
            }
            if (this.planeX > this.targetXPosition) {
                this.planeX -= this.planeTargetXPositionSpeed * f;
                if (this.planeX < this.targetXPosition) {
                    this.planeX = this.targetXPosition;
                }
            } else if (this.planeX < this.targetXPosition) {
                this.planeX += this.planeTargetXPositionSpeed * f;
                if (this.planeX > this.targetXPosition) {
                    this.planeX = this.targetXPosition;
                }
            }
            if (!this.diveBomb) {
                float f7;
                float f8 = this.planeMadeItThroughWindow ? 6.0E-4f : 5.0E-4f;
                float f9 = f7 = this.planeMadeItThroughWindow ? 3.0E-4f : 3.0E-4f;
                if (this.planeMadeItThroughWindow && this.angleThreshold != 800.0f) {
                    this.angleThreshold += 10.0f * f;
                    if (this.angleThreshold > 800.0f) {
                        this.angleThreshold = 800.0f;
                    }
                }
                this.planeAngle = this.planeVelocityX - this.angleThreshold < 0.0f ? (this.planeAngle -= (this.planeVelocityX - this.angleThreshold) * (this.planeVelocityX - this.angleThreshold) * f8 * f) : (this.planeAngle += (this.planeVelocityX - this.angleThreshold) * (this.planeVelocityX - this.angleThreshold) * f7 * f);
                this.planeAngle -= 20.0f * f;
                if (this.planeAngle > 85.0f) {
                    this.planeAngle = 85.0f;
                } else if (this.planeAngle < -85.0f && !this.diveBomb) {
                    this.planeAngle = -85.0f;
                    this.diveBomb = true;
                    System.out.println("Nose diving");
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            } else {
                if (this.planeAngle < -95.0f || this.diveBombLift) {
                    if (this.planeAngle < -95.0f) {
                        this.diveBombLift = true;
                    }
                    if (this.planeAngle > -85.0f) {
                        this.diveBombLift = false;
                    }
                    this.planeAngle += (this.planeVelocityX - 700.0f) * (this.planeVelocityX - 700.0f) * 3.0E-4f * f;
                } else {
                    this.planeAngle -= (this.planeVelocityX - 700.0f) * (this.planeVelocityX - 700.0f) * 5.0E-4f * f;
                }
                double d = Math.toRadians(this.planeAngle);
                this.planeSinAngle = (float)Math.sin(d);
                this.planeCosAngle = (float)Math.cos(d);
            }
        }
    }

    protected void updateHasThePlaneGoneOffScreen(float f) {
        float f2 = 32.0f;
        float f3 = 0.0f;
        float f4 = this.planeY + (this.planeSinAngle * f2 + this.planeCosAngle * f3);
        float f5 = -32.0f;
        float f6 = -12.0f;
        float f7 = this.planeY + (-this.planeSinAngle * f5 + this.planeCosAngle * f6);
        float f8 = -32.0f;
        float f9 = 12.0f;
        float f10 = this.planeY + (-this.planeSinAngle * f8 + this.planeCosAngle * f9);
        if (f4 <= 0.0f && f7 <= 0.0f && f10 <= 0.0f) {
            this.setGameIsOver();
            if (SaveData.getInstance().soundOn) {
                this.windBoostSound.play();
            }
        } else if (f4 >= 320.0f && f7 >= 320.0f && f10 >= 320.0f) {
            this.setGameIsOver();
            if (SaveData.getInstance().soundOn) {
                this.crunchSound.play();
            }
        }
    }

    public abstract void paint(Graphics var1);

    protected void pointerPressed(int n, int n2) {
        if (!this.isLandscape()) {
            int n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (!this.flightInProgress) {
            this.flickingInProgress = true;
            this.keyboardLaunch = false;
            this.planeX = n;
            this.planeY = n2 - 60;
            this.flickStartingX = n;
            this.flickStartingY = n2;
            this.timeSinceFlickingMovement = 0.0f;
            this.planeCanBeReleasedFromFlick = false;
            this.pixelsMovedForFlick = 0;
        } else if (this.windBoostRemaining > 0.0f) {
            this.windBoostActive = true;
            if (SaveData.getInstance().soundOn) {
                this.windBoostSound.play();
            }
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerDragged(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (this.flickingInProgress) {
            this.keyboardLaunch = false;
            this.planeX = n;
            this.planeY = n2 - 60;
            float f = n > this.touchOldX ? (float)(n - this.touchOldX) : (float)(this.touchOldX - n);
            if (f > (float)(n3 = 2)) {
                this.timeSinceFlickingMovement = 0.0f;
                this.levelOutThePlane = false;
                this.planeCanBeReleasedFromFlick = false;
            }
            boolean bl = false;
            if (n < this.touchOldX) {
                bl = true;
                this.planeCanBeReleasedFromFlick = false;
                this.pixelsMovedForFlick = 0;
            } else {
                if (!this.planeCanBeReleasedFromFlick) {
                    this.timeSinceFlickingMovement = 0.0f;
                    this.planeCanBeReleasedFromFlick = true;
                    this.flickStartingX = n;
                    this.flickStartingY = n2;
                }
                this.pixelsMovedForFlick = (int)((float)this.pixelsMovedForFlick + f);
            }
            float f2 = this.touchOldY - n2;
            float f3 = n - this.touchOldX;
            if (f2 != 0.0f || f3 != 0.0f) {
                float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
                float f5 = (float)Math.toDegrees(GameViewBase.asin(f2 / f4));
                if (bl) {
                    f5 = -f5;
                }
                this.flickTargetAngle = f5;
            }
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerReleased(int n, int n2) {
        if (!this.isLandscape()) {
            int n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (this.timeSinceFlickingMovement < 2.0f && this.flickingInProgress && !this.flightInProgress) {
            if (this.planeCanBeReleasedFromFlick) {
                this.launchPlane(n, n2);
            }
        } else {
            this.windBoostActive = false;
        }
    }

    protected void keyPressed(int n) {
        System.out.println("Key pressed " + n);
        switch (n) {
            case -1: 
            case 50: {
                if (!this.isLandscape()) break;
                this.angleUpKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -2: 
            case 56: {
                if (!this.isLandscape()) break;
                this.angleDownKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -3: 
            case 52: {
                if (this.isLandscape()) break;
                this.angleUpKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -4: 
            case 54: {
                if (this.isLandscape()) break;
                this.angleDownKeyPressed = true;
                this.keyboardLaunch = true;
                break;
            }
            case -5: 
            case 53: {
                if (!this.flightInProgress) {
                    this.launchPlane((int)this.planeX, (int)this.planeY);
                    break;
                }
                this.windBoostActive = true;
            }
        }
    }

    protected void keyReleased(int n) {
        System.out.println("Key released " + n);
        switch (n) {
            case -1: 
            case 50: {
                this.angleUpKeyPressed = false;
                break;
            }
            case -2: 
            case 56: {
                this.angleDownKeyPressed = false;
                break;
            }
            case -3: 
            case 52: {
                this.angleUpKeyPressed = false;
                break;
            }
            case -4: 
            case 54: {
                this.angleDownKeyPressed = false;
                break;
            }
            case -5: 
            case 53: {
                this.windBoostActive = false;
            }
        }
    }

    public boolean isLandscape() {
        return this.getWidth() > this.getHeight();
    }

    public int getLandscapeWidth() {
        int n;
        int n2 = this.getWidth();
        return n2 > (n = this.getHeight()) ? n2 : n;
    }

    public int getLandscapeHeight() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        return n2 < n ? n2 : n;
    }

    public static double asin(double d) {
        double d2 = d;
        while (Math.abs(Math.sin(d2 -= (Math.sin(d2) - d) / Math.cos(d2)) - d) > 0.001) {
        }
        return d2;
    }

    public void setPlayerName(String string) {
        this.playerName = string;
    }

    public void saveScore() {
        if (this.gameIsOver) {
            SaveData.getInstance().reportScore((int)this.score, this.playerName);
        }
    }

    public void pause() {
        Main.getInstance().getMenuView().playSelectSound();
        System.out.println("Paused");
        this.paused = true;
    }

    public void unpause() {
        System.out.println("Paused");
        this.paused = false;
    }
}

