/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.paperglider.game;

import com.neonplay.helper.ImageHelper;
import com.neonplay.helper.ImageItem;
import com.neonplay.helper.ImageLoader;
import com.neonplay.helper.SaveData;
import com.neonplay.paperglider.game.GameViewBase;
import com.neonplay.paperglider.view.components.ContinueItem;
import com.neonplay.paperglider.view.components.MainMenuItem;
import com.neonplay.paperglider.view.components.PlayAgainItem;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameViewLargePhone
extends GameViewBase {
    protected Image[] planeImages;
    protected Image garden1BackgroundImage;
    protected Image garden2BackgroundImage;
    protected Image garden3BackgroundImage;
    protected Image garden4BackgroundImage;
    protected Image cityBackgroundImage;
    protected Image countryBackgroundImage;
    protected Image forestBackgroundImage;
    protected Image nevadaBackgroundImage;
    protected Image moonBackgroundImage;
    protected Image houseBackgroundImage;
    protected float backgroundScrollX;
    protected int bgStage;
    protected int bgPlaceInStage;
    protected Image bgImage1;
    protected Image bgImage2;
    protected Image bgImage3;
    protected boolean bgHouse;
    protected int houseScrollX;
    protected Image pauseImage;
    protected Image soundImage;
    protected Image windBarImage;
    protected Image emptyWindBarImage;
    protected Image distanceImage;
    protected Image bestImage;
    protected Image windImage;
    protected Image instructionsImage;
    protected Image tapToBoostImage;
    protected Image useWindWiselyImage;
    protected Image doSmallTapsImage;
    protected Image scoreTabImage;
    protected Image[] numberImage;
    protected Image gameOverImage;
    protected Image highScoreImage;
    protected PlayAgainItem playAgainItem;
    protected MainMenuItem mainMenuItem;
    protected Image[] characterImage;
    protected Image panelImage;
    protected ImageItem pauseTitleImage;
    protected MainMenuItem pauseMainMenuItem;
    protected PlayAgainItem pausePlayAgainItem;
    protected ContinueItem pauseContinueItem;
    protected boolean showInstructions;
    protected int instructionShowing;
    protected float instructionTimer;
    protected long lastTime;

    protected void init() {
        super.init();
        try {
            int n;
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.garden1BackgroundImage = imageLoader.loadImage("/bggarden1.png");
            this.garden2BackgroundImage = imageLoader.loadImage("/bggarden2.png");
            this.garden3BackgroundImage = imageLoader.loadImage("/bggarden3.png");
            this.garden4BackgroundImage = imageLoader.loadImage("/bggarden4.png");
            this.cityBackgroundImage = imageLoader.loadImage("/bgcity.png");
            this.countryBackgroundImage = imageLoader.loadImage("/bgcountry.png");
            this.forestBackgroundImage = imageLoader.loadImage("/bgforest.png");
            this.nevadaBackgroundImage = imageLoader.loadImage("/bgnevada.png");
            this.moonBackgroundImage = imageLoader.loadImage("/bgmoon.png");
            this.houseBackgroundImage = imageLoader.loadImage("/buildingtransition.png");
            System.out.println("Loading plane graphics");
            this.planeImages = new Image[61];
            for (n = 0; n <= 60; ++n) {
                this.planeImages[n] = imageLoader.loadImage("/paper_plane2_" + n + ".png");
            }
            this.pauseImage = imageLoader.loadImage("/pause.png");
            this.soundImage = SaveData.getInstance().soundOn ? imageLoader.loadImage("/sound_on.png") : imageLoader.loadImage("/sound_off.png");
            this.windBarImage = imageLoader.loadImage("/windbar.png");
            this.emptyWindBarImage = imageLoader.loadImage("/windbar_empty.png");
            this.distanceImage = imageLoader.loadImage("/distance.png");
            this.bestImage = imageLoader.loadImage("/best.png");
            this.windImage = imageLoader.loadImage("/wind.png");
            this.instructionsImage = imageLoader.loadImage("/instructions.png");
            this.tapToBoostImage = imageLoader.loadImage("/taptoboost.png");
            this.useWindWiselyImage = imageLoader.loadImage("/usewindwisely.png");
            this.doSmallTapsImage = imageLoader.loadImage("/dosmalltaps.png");
            this.scoreTabImage = imageLoader.loadImage("/scoretab.png");
            this.numberImage = new Image[10];
            for (n = 0; n < 10; ++n) {
                this.numberImage[n] = imageLoader.loadImage("/num" + n + ".png");
            }
            this.gameOverImage = imageLoader.loadImage("/gameoverpanel.png");
            this.highScoreImage = imageLoader.loadImage("/highscorepanel.png");
            this.characterImage = new Image[26];
            System.out.println("Loading character graphics");
            for (n = 0; n < 26; ++n) {
                char c = (char)(65 + n);
                String string = "/" + c + ".png";
                this.characterImage[n] = imageLoader.loadImage(string);
            }
            this.playAgainItem = new PlayAgainItem(this);
            this.mainMenuItem = new MainMenuItem(this);
            this.playAgainItem.setPosition(247, 256);
            this.mainMenuItem.setPosition(254, 298);
            this.panelImage = imageLoader.loadImage("/menupanel.png");
            this.pauseTitleImage = new ImageItem("/pause_title.png");
            this.pauseContinueItem = new ContinueItem(this);
            this.pauseMainMenuItem = new MainMenuItem(this);
            this.pausePlayAgainItem = new PlayAgainItem(this);
            this.pauseTitleImage.setPosition(247, 80);
            this.pauseContinueItem.setPosition(254, 160);
            this.pausePlayAgainItem.setPosition(247, 222);
            this.pauseMainMenuItem.setPosition(254, 284);
        }
        catch (IOException iOException) {
            System.out.println("Image loading error.");
        }
        System.out.println("Images loaded");
    }

    public void reset() {
        super.reset();
        this.backgroundScrollX = 0.0f;
        this.bgStage = 0;
        this.bgPlaceInStage = 0;
        this.bgImage1 = this.garden1BackgroundImage;
        this.bgImage2 = this.garden2BackgroundImage;
        this.bgImage3 = this.garden3BackgroundImage;
        this.bgHouse = false;
        this.showInstructions = false;
        this.instructionShowing = 0;
        this.instructionTimer = 0.0f;
    }

    public void showNotify() {
        super.showNotify();
        try {
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.soundImage = SaveData.getInstance().soundOn ? imageLoader.loadImage("/sound_on.png") : imageLoader.loadImage("/sound_off.png");
        }
        catch (IOException iOException) {
            System.out.println("Image loading error.");
        }
    }

    protected void updateBackground(float f) {
        if (this.flightInProgress) {
            float f2 = Math.abs(this.planeVelocityX * 0.016f - this.planeSinAngle * 5.0f);
            this.backgroundScrollX += (f2 *= 25.0f * f);
            if (this.bgHouse) {
                this.houseScrollX = (int)((float)this.houseScrollX + f2);
                if (this.houseScrollX >= 512) {
                    this.bgHouse = false;
                }
            }
            this.score += f2;
            while (this.backgroundScrollX > 512.0f) {
                this.backgroundScrollX -= 512.0f;
                this.bgImage1 = this.bgImage2;
                this.bgImage2 = this.bgImage3;
                ++this.bgPlaceInStage;
                if (this.bgStage == 0) {
                    if (this.bgPlaceInStage >= 2) {
                        ++this.bgStage;
                        this.bgPlaceInStage = 0;
                        this.planeMadeItThroughWindow = true;
                    }
                } else if (this.bgPlaceInStage >= 13) {
                    this.bgHouse = true;
                    this.houseScrollX = -720;
                    ++this.bgStage;
                    this.bgPlaceInStage = 0;
                    if (this.bgStage >= 6) {
                        this.bgStage = 1;
                    }
                }
                if (this.bgPlaceInStage == 1 && SaveData.getInstance().soundOn) {
                    this.changeBackgroundSound(this.bgStage, false);
                }
                switch (this.bgStage) {
                    case 0: {
                        if (this.bgPlaceInStage == 0) {
                            this.bgImage3 = this.garden3BackgroundImage;
                        }
                        if (this.bgPlaceInStage == 1) {
                            this.bgImage3 = this.garden4BackgroundImage;
                        }
                        if (this.bgPlaceInStage != 2) break;
                        this.bgImage3 = this.garden4BackgroundImage;
                        break;
                    }
                    case 1: {
                        this.bgImage3 = this.cityBackgroundImage;
                        break;
                    }
                    case 2: {
                        this.bgImage3 = this.countryBackgroundImage;
                        break;
                    }
                    case 3: {
                        this.bgImage3 = this.forestBackgroundImage;
                        break;
                    }
                    case 4: {
                        this.bgImage3 = this.nevadaBackgroundImage;
                        break;
                    }
                    case 5: {
                        this.bgImage3 = this.moonBackgroundImage;
                    }
                }
            }
        }
        if (this.showInstructions) {
            this.instructionTimer += f;
            if (this.instructionTimer > 2.5f) {
                ++this.instructionShowing;
                if (this.instructionShowing >= 3) {
                    this.showInstructions = false;
                }
                this.instructionTimer -= 2.5f;
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getLandscapeWidth();
        int n6 = this.getLandscapeHeight();
        Graphics graphics2 = this.doubleBuffer.getGraphics();
        int n7 = (int)(-this.backgroundScrollX * (float)n6 / 320.0f);
        graphics2.drawImage(this.bgImage1, n7, 0, 4 | 0x10);
        graphics2.drawImage(this.bgImage2, n7 + this.cityBackgroundImage.getWidth(), 0, 4 | 0x10);
        graphics2.drawImage(this.bgImage3, n7 + 2 * this.cityBackgroundImage.getWidth(), 0, 4 | 0x10);
        if (this.bgHouse) {
            n7 = -this.houseScrollX * n6 / 320;
            graphics2.drawImage(this.houseBackgroundImage, n7, 0, 4 | 0x10);
        }
        if (!SaveData.getInstance().shownInstructions && (n4 = (int)(-220.0f - this.score + 192.0f + 100.0f)) + this.instructionsImage.getWidth() > 0) {
            graphics2.drawImage(this.instructionsImage, n4, n6 - 50, 4 | 0x20);
        }
        if ((n4 = (int)(-this.planeAngle + 30.0f)) < 0) {
            n4 = 0;
        }
        if (n4 >= 61) {
            n4 = 60;
        }
        Image image = ImageHelper.rotateImage(this.planeImages[n4], -this.planeAngle);
        graphics2.drawImage(image, (int)this.planeX * n5 / 480, (int)this.planeY * n6 / 320, 1 | 2);
        for (n3 = 0; n3 < 5; ++n3) {
            n2 = SaveData.getInstance().highScores[n3];
            if (n2 <= 0 || (n = (int)((float)n2 - this.score + 192.0f + 100.0f)) <= -40 || n >= n5 + 40) continue;
            graphics2.drawImage(this.scoreTabImage, n, n6, 1 | 0x20);
            String string = SaveData.getInstance().highNames[n3];
            for (int i = 0; i < 3; ++i) {
                int n8 = string.charAt(i) - 65;
                if (n8 < 0 || n8 >= 26) continue;
                graphics2.drawImage(this.characterImage[n8], n - 17 + i * 15, n6 - 84, 1 | 0x10);
            }
        }
        if (!this.gameIsOver) {
            graphics2.drawImage(this.pauseImage, 0, n6 - 4, 4 | 0x20);
            graphics2.drawImage(this.soundImage, n5, n6 - 4, 8 | 0x20);
        }
        n3 = n5 - this.emptyWindBarImage.getWidth() >> 1;
        n2 = (int)(259.0f * this.windBoostRemaining / 100.0f);
        graphics2.drawImage(this.windImage, n5 >> 1, 3, 1 | 0x10);
        graphics2.drawImage(this.emptyWindBarImage, n3, 28, 4 | 0x10);
        graphics2.setClip(n3 + 3, 0, n2, n6);
        graphics2.drawImage(this.windBarImage, n3, 28, 4 | 0x10);
        graphics2.setClip(0, 0, n5, n6);
        if (this.showInstructions && !this.gameIsOver) {
            switch (this.instructionShowing) {
                case 0: {
                    graphics2.drawImage(this.tapToBoostImage, n5 >> 1, 53, 1 | 0x10);
                    break;
                }
                case 1: {
                    graphics2.drawImage(this.doSmallTapsImage, n5 >> 1, 53, 1 | 0x10);
                    break;
                }
                case 2: {
                    graphics2.drawImage(this.useWindWiselyImage, n5 >> 1, 53, 1 | 0x10);
                }
            }
        }
        graphics2.drawImage(this.distanceImage, 4, 3, 4 | 0x10);
        this.renderNumber(graphics2, (int)this.score, 4, 30, 4 | 0x10);
        graphics2.drawImage(this.bestImage, n5 - 4, 3, 8 | 0x10);
        this.renderNumber(graphics2, this.best, n5 - 4, 30, 8 | 0x10);
        if (this.gameIsOver) {
            this.isHighScore = true;
            if (this.isHighScore) {
                graphics2.drawImage(this.highScoreImage, n5 >> 1, n6, 1 | 0x20);
                for (n = 0; n < 3; ++n) {
                    int n9 = this.playerName.charAt(n) - 65;
                    graphics2.drawImage(this.characterImage[n9], 250 + n * 63, 192, 1 | 0x10);
                }
            } else {
                graphics2.drawImage(this.gameOverImage, n5 >> 1, n6, 1 | 0x20);
            }
            this.playAgainItem.render(graphics2);
            this.mainMenuItem.render(graphics2);
        }
        if (this.paused) {
            graphics2.drawImage(this.panelImage, n5 >> 1, n6, 1 | 0x20);
            this.pauseTitleImage.render(graphics2);
            this.pauseContinueItem.render(graphics2);
            this.pausePlayAgainItem.render(graphics2);
            this.pauseMainMenuItem.render(graphics2);
        }
        if (this.isLandscape()) {
            graphics.drawImage(this.doubleBuffer, 0, 0, 20);
        } else {
            graphics.drawRegion(this.doubleBuffer, 0, 0, this.getLandscapeWidth(), this.getLandscapeHeight(), 6, 0, 0, 20);
        }
    }

    protected void renderNumber(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 & (0x10 | 2 | 0x20);
        int n7 = n;
        int n8 = 0;
        do {
            n5 = n7 % 10;
            n8 += this.numberImage[n5].getWidth() - 4;
        } while ((n7 /= 10) != 0);
        n2 = (n4 & 4) != 0 ? (n2 += n8) : ((n4 & 1) != 0 ? (n2 += n8 - 4 >> 1) : (n2 -= 4));
        n7 = n;
        do {
            n5 = n7 % 10;
            graphics.drawImage(this.numberImage[n5], n2 -= this.numberImage[n5].getWidth() - 4, n3, 4 | n6);
            n8 += this.numberImage[n5].getWidth() - 4;
        } while ((n7 /= 10) != 0);
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n3 = n;
        int n4 = n2;
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (!this.paused) {
            if (n3 > this.getLandscapeWidth() - 50 && n4 > this.getLandscapeHeight() - 50) {
                SaveData saveData = SaveData.getInstance();
                saveData.soundOn = !saveData.soundOn;
                try {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    if (saveData.soundOn) {
                        this.soundImage = imageLoader.loadImage("/sound_on.png");
                        this.changeBackgroundSound(this.bgStage, true);
                    } else {
                        this.soundImage = imageLoader.loadImage("/sound_off.png");
                        this.stopBackgroundSound();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Image loading error.");
                }
                return;
            }
            if (!this.gameIsOver) {
                if (n3 < 50 && n4 > this.getLandscapeHeight() - 50) {
                    if (this.paused) {
                        this.unpause();
                    } else {
                        this.pause();
                    }
                    return;
                }
                if (!this.flightInProgress) {
                    this.flickingInProgress = true;
                    this.keyboardLaunch = false;
                    this.planeX = n;
                    this.planeY = n2 - 60;
                    this.flickStartingX = n;
                    this.flickStartingY = n2;
                    this.timeSinceFlickingMovement = 0.0f;
                    this.planeCanBeReleasedFromFlick = false;
                    this.pixelsMovedForFlick = 0;
                } else if (this.windBoostRemaining > 0.0f) {
                    this.windBoostActive = true;
                    if (SaveData.getInstance().soundOn) {
                        this.windBoostSound.play();
                    }
                }
            } else {
                boolean bl = false;
                if (this.isHighScore && n4 > 162 && n4 < 262) {
                    char[] cArray = this.playerName.toCharArray();
                    for (int i = 0; i < 3; ++i) {
                        System.out.println("pressed char " + i);
                        if (n3 <= 219 + i * 63 || n3 >= 281 + i * 63) continue;
                        int n5 = i;
                        cArray[n5] = (char)(cArray[n5] + '\u0001');
                        if (cArray[i] > 'Z') {
                            cArray[i] = 65;
                        }
                        bl = true;
                        this.playerName = "" + cArray[0] + cArray[1] + cArray[2];
                        break;
                    }
                }
                if (!bl) {
                    this.playAgainItem.pointerPressed(n3, n4);
                    this.mainMenuItem.pointerPressed(n3, n4);
                }
            }
        } else {
            this.pauseContinueItem.pointerPressed(n3, n4);
            this.pauseMainMenuItem.pointerPressed(n3, n4);
            this.pausePlayAgainItem.pointerPressed(n3, n4);
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerDragged(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n3 = n;
        int n4 = n2;
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (!this.paused && !this.gameIsOver && this.flickingInProgress) {
            int n5;
            this.keyboardLaunch = false;
            this.planeX = n;
            this.planeY = n2 - 60;
            float f = n > this.touchOldX ? (float)(n - this.touchOldX) : (float)(this.touchOldX - n);
            if (f > (float)(n5 = 2)) {
                this.timeSinceFlickingMovement = 0.0f;
                this.levelOutThePlane = false;
                this.planeCanBeReleasedFromFlick = false;
            }
            boolean bl = false;
            if (n < this.touchOldX) {
                bl = true;
                this.planeCanBeReleasedFromFlick = false;
                this.pixelsMovedForFlick = 0;
            } else {
                if (!this.planeCanBeReleasedFromFlick) {
                    this.timeSinceFlickingMovement = 0.0f;
                    this.planeCanBeReleasedFromFlick = true;
                    this.flickStartingX = n;
                    this.flickStartingY = n2;
                }
                this.pixelsMovedForFlick = (int)((float)this.pixelsMovedForFlick + f);
            }
            float f2 = this.touchOldY - n2;
            float f3 = n - this.touchOldX;
            if (f2 != 0.0f || f3 != 0.0f) {
                float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
                float f5 = (float)Math.toDegrees(GameViewLargePhone.asin(f2 / f4));
                if (bl) {
                    f5 = -f5;
                }
                this.flickTargetAngle = f5;
            }
        }
        this.touchOldX = n;
        this.touchOldY = n2;
    }

    protected void pointerReleased(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        n3 = n;
        int n4 = n2;
        n = n * 480 / this.getLandscapeWidth();
        n2 = n2 * 320 / this.getLandscapeHeight();
        if (!this.paused) {
            if (!this.gameIsOver) {
                if (this.timeSinceFlickingMovement < 2.0f && this.flickingInProgress && !this.flightInProgress) {
                    if (this.planeCanBeReleasedFromFlick) {
                        this.launchPlane(n, n2);
                        this.showInstructions = true;
                    }
                } else {
                    this.windBoostActive = false;
                }
            } else {
                this.playAgainItem.pointerReleased(n3, n4);
                this.mainMenuItem.pointerReleased(n3, n4);
            }
        } else {
            this.pauseContinueItem.pointerReleased(n3, n4);
            this.pauseMainMenuItem.pointerReleased(n3, n4);
            this.pausePlayAgainItem.pointerReleased(n3, n4);
        }
    }
}

