/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class AudioControl {
    private ConnectThePairsCanvas canvas;
    private int currentID;
    private int tempID;
    private boolean isPlaying;
    private String resourceName;
    private Player player;
    private String playerStatus = "";
    private VolumeControl volumeControl;
    private int levelVolume = 100;
    private boolean isLoopSound = false;
    private Listener listener;

    public AudioControl(ConnectThePairsCanvas canvas) {
        this.canvas = canvas;
        this.currentID = -1;
        this.isPlaying = false;
    }

    public void setAudioData(String resName, int audioID) {
        this.listener = new Listener();
        if (audioID == this.currentID) {
            this.stop();
        } else {
            this.close();
        }
        this.resourceName = resName;
        this.tempID = audioID;
        this.isLoopSound = false;
    }

    public void setAudioData(String resName, int audioID, boolean loop) {
        this.listener = new Listener();
        if (audioID == this.currentID) {
            this.stop();
        } else {
            this.close();
        }
        this.resourceName = resName;
        this.tempID = audioID;
        this.isLoopSound = loop;
    }

    private void setVolume(int level) {
        this.levelVolume = level;
    }

    public void stop() {
        if (this.player != null) {
            try {
                if (this.player.getState() == 400) {
                    this.player.stop();
                    this.player.setMediaTime(0L);
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public void playSplash() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    AudioControl.this.currentID = AudioControl.this.tempID;
                    if (AudioControl.this.player == null) {
                        AudioControl.this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(AudioControl.this.resourceName), (String)"audio/X-wav");
                        AudioControl.this.player.realize();
                        AudioControl.this.player.addPlayerListener((PlayerListener)AudioControl.this.listener);
                        AudioControl.this.volumeControl = (VolumeControl)AudioControl.this.player.getControl("VolumeControl");
                        AudioControl.this.volumeControl.setLevel(AudioControl.this.levelVolume);
                    }
                    int n = AudioControl.this.player.getState();
                    AudioControl.this.player;
                    if (n != 0) {
                        AudioControl.this.player.setLoopCount(-1);
                        AudioControl.this.player.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public void playWavSound() {
        Thread playerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (((AudioControl)AudioControl.this).canvas.soundOn) {
                        AudioControl.this.currentID = AudioControl.this.tempID;
                        if (AudioControl.this.player == null) {
                            AudioControl.this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(AudioControl.this.resourceName), (String)"audio/X-wav");
                            AudioControl.this.player.realize();
                            AudioControl.this.player.addPlayerListener((PlayerListener)AudioControl.this.listener);
                            AudioControl.this.volumeControl = (VolumeControl)AudioControl.this.player.getControl("VolumeControl");
                            AudioControl.this.volumeControl.setLevel(AudioControl.this.levelVolume);
                        }
                        int n = AudioControl.this.player.getState();
                        AudioControl.this.player;
                        if (n != 0) {
                            AudioControl.this.player.start();
                        }
                    }
                }
                catch (Exception e) {
                    if (AudioControl.this.player != null) {
                        System.out.println("player get state " + AudioControl.this.player.getState());
                    }
                    e.printStackTrace();
                }
            }
        });
        playerThread.start();
    }

    public void play() {
        Thread playerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (((AudioControl)AudioControl.this).canvas.soundOn) {
                        AudioControl.this.currentID = AudioControl.this.tempID;
                        if (AudioControl.this.player == null) {
                            AudioControl.this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(AudioControl.this.resourceName), (String)"audio/midi");
                            AudioControl.this.player.realize();
                            AudioControl.this.player.addPlayerListener((PlayerListener)AudioControl.this.listener);
                            AudioControl.this.volumeControl = (VolumeControl)AudioControl.this.player.getControl("VolumeControl");
                            AudioControl.this.volumeControl.setLevel(AudioControl.this.levelVolume);
                        }
                        int n = AudioControl.this.player.getState();
                        AudioControl.this.player;
                        if (n != 0) {
                            AudioControl.this.player.start();
                        }
                    }
                }
                catch (Exception e) {
                    if (AudioControl.this.player != null) {
                        System.out.println("player get state " + AudioControl.this.player.getState());
                    }
                    e.printStackTrace();
                }
            }
        });
        playerThread.start();
    }

    private void loop() {
        this.isLoopSound = true;
        this.play();
    }

    public void playerUpdate(Player player, final String status, Object data) {
        Thread playerThread = new Thread(new Runnable(){

            public void run() {
                AudioControl.this.playerStatus = status;
                if (AudioControl.this.playerStatus == "endOfMedia" && AudioControl.this.isLoopSound) {
                    AudioControl.this.play();
                }
            }
        });
        playerThread.start();
    }

    class Listener
    implements PlayerListener {
        Listener() {
        }

        public void playerUpdate(Player player, String status, Object data) {
            AudioControl.this.playerStatus = status;
            if (player != null && AudioControl.this.playerStatus == "endOfMedia" && AudioControl.this.isLoopSound && AudioControl.this.currentID == AudioControl.this.tempID) {
                AudioControl.this.play();
            }
        }
    }
}

