/*
 * Decompiled with CFR 0.152.
 */
package game;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.helper.BBSFunctions;
import bbs.framework.helper.BBSKeys;
import bbs.framework.library.BBSTile;
import bbs.framework.models.BBSLoader;
import bbs.framework.models.BBSMenu;
import bbs.framework.models.BBSObjectFactory;
import bbs.framework.models.BBSSmartSprite;
import bbs.framework.models.BBSStory;
import bbs.framework.starter.BBSStarter;
import game.xLoader;
import game.xMenu;
import game.xObjects;
import javax.microedition.lcdui.Graphics;

public class xGame
extends BBSSmartGame {
    public BBSSmartSprite _RedEvil;
    private char[] scoreS = new char[6];
    private int heightOfMenuAndQuit = 0;
    public int[][] enemies;
    public int[][] bonuses;
    public byte[][] map;
    public int SCORE;
    public int LIVE;
    public boolean IMMORTAL;
    public long timeImmortal;
    public long timeJump;
    public long timeHold;
    public int force = 0;
    public int lifeX = 0;
    public int scoreX = 0;
    private char[] lives = new char[6];
    private char[] lifeStatement = new char[2];
    private char[] scores = new char[6];
    private char[] scoreStatement = new char[4];
    public int gameHasFinished = 0;

    public xGame(BBSStarter inst) {
        super(inst);
    }

    protected BBSObjectFactory getObjectFactory() {
        return new xObjects();
    }

    public String[] getGameFonts() {
        return new String[]{"MenuRed", "MenuOrange", "InGameBlack", "InGameRed", "InGameGreen", "InGameMenu", "Help"};
    }

    public BBSMenu getGameMenu() {
        return new xMenu(this);
    }

    public BBSLoader getGameLoader() {
        return new xLoader(this, 1);
    }

    public BBSStory getGameStory() {
        return null;
    }

    public void stageLoading() {
        if (this.stage == 6) {
            this.buy(false);
        } else if (this.stage == 11) {
            this.buy(true);
        } else {
            this.showAd();
        }
        String[][] objs = this.loadObjects(this.stage);
        this.loader.setMaxValue(objs.length + 4);
        this.map = null;
        byte[] level = BBSFunctions.loadData(this, "tilesets/stage" + String.valueOf(this.stage) + ".til");
        int width = level[0] & 0xFF;
        int height = level[1] & 0xFF;
        this.map = new byte[height][width];
        for (int cnt = 5; cnt < level.length; ++cnt) {
            this.map[(cnt - 5) / width][(cnt - 5) % width] = level[cnt];
        }
        level = null;
        int enemyLength = 0;
        for (int i = 0; i < 254; ++i) {
            if (this.map[i][0] != 0) {
                ++enemyLength;
            }
            if (this.map[i][11] == 0) continue;
            ++enemyLength;
        }
        this.enemies = new int[enemyLength][6];
        int j = 0;
        for (int i = 0; i < 254; ++i) {
            if (this.map[i][0] != 0) {
                this.enemies[j][0] = 1;
                this.enemies[j][1] = this.map[i][0] - 11;
                this.enemies[j][2] = -1;
                this.enemies[j][3] = 0;
                this.enemies[j][4] = 0;
                this.enemies[j][5] = i + 1;
                ++j;
            }
            if (this.map[i][11] == 0) continue;
            this.enemies[j][0] = 1;
            this.enemies[j][1] = this.map[i][11] - 11;
            this.enemies[j][2] = 1;
            this.enemies[j][3] = 0;
            this.enemies[j][4] = 0;
            this.enemies[j][5] = i + 1;
            ++j;
        }
        this.loader.progress(this);
        int bonusLength = 0;
        for (int m = 0; m < 254; ++m) {
            for (int n = 1; n < 11; ++n) {
                if (this.map[m][n] == 0) continue;
                ++bonusLength;
            }
        }
        this.bonuses = new int[bonusLength][5];
        int k = 0;
        for (int m = 0; m < 254; ++m) {
            for (int n = 1; n < 11; ++n) {
                if (this.map[m][n] == 0) continue;
                this.bonuses[k][0] = 0;
                this.bonuses[k][1] = this.map[m][n];
                this.bonuses[k][2] = 0;
                this.bonuses[k][3] = n;
                this.bonuses[k][4] = m + 1;
                ++k;
            }
        }
        this.map = null;
        this.loader.progress(this);
        this.tileSet = new BBSTile();
        this.tileSet.createTiles(this, this.stage, 5, 0, 0, 4, false);
        this.tileSet.y = this.tileSet.fullH - this.tileSet.sch;
        this.loader.progress(this);
        for (int cnt = 0; cnt < objs.length; ++cnt) {
            this.factory.objectFactory(this, objs[cnt], cnt);
            this.loader.progress(this);
        }
        objs = null;
        this.createSmarts();
        this.loader.progress(this);
    }

    public void stageStart() {
        this.SCORE = 0;
        this.LIVE = this.w == 128 ? 5 : 1;
        this.IMMORTAL = false;
        this.timeImmortal = 0L;
        this.timeJump = 0L;
        this.timeHold = 0L;
        if (this.music) {
            this.loadMusic("music");
            this.playMusic("music");
        }
    }

    public void stageEnd() {
        ++this.stage;
        this.gameState = 3;
    }

    public void stageDraw(Graphics g) {
        try {
            this.tileSet.x = -(this.w - this.tileSet.fullW) / 2;
            if (this.w == 128) {
                this.tileSet.x -= 16;
            }
            this.tileSet.drawTiles(this, g, this.stage);
            if (this.gameState == 9) {
                this.drawText(g, this.w / 2, this.h / 2, "CONGRATULATIONS", null, 1, 1);
            }
            if (this.gameState == 7) {
                this.drawText(g, this.w / 2, this.h / 2, "NEXT LEVEL", null, 1, 1);
            }
            if (this.gameState == 8) {
                this.drawText(g, this.w / 2, this.h / 2, "GAME OVER", null, 1, 1);
            }
            this.lives = this.scoreToChr(this.LIVE);
            this.lifeStatement[0] = 120;
            this.lifeStatement[1] = this.lives[5];
            this.scores = this.scoreToChr(this.SCORE);
            this.scoreStatement[0] = this.scores[3];
            this.scoreStatement[1] = this.scores[4];
            this.scoreStatement[2] = this.scores[5];
            this.scoreStatement[3] = 36;
            int liveX = 5;
            if (this.tileSet.tileWidth == 32) {
                liveX = 12;
            }
            int scoreX = 0;
            if (this.w == 128) {
                liveX = 18;
                scoreX = 4;
            }
            this.drawText(g, 30 - liveX, 0, null, this.lifeStatement, 4, 4);
            this.drawText(g, this.w - 4 + scoreX, 0, null, this.scoreStatement, 5, 8);
            int difference128 = 0;
            int difference64 = 0;
            if (this.tileSet.tileHeight == 64) {
                difference64 = 10;
            }
            if (this.timeImmortal > 0L && this.timeImmortal < 10000L) {
                this.drawText(g, this.w * 28 / 100 + this.tileSet.tileHeight / 64 * 10 - difference64, 0, null, this.scoreToChr(10 - (int)this.timeImmortal / 1000), 3, 4);
            }
            if (this.timeJump > 0L && this.timeJump < 10000L) {
                if (this.w == 128) {
                    difference128 = 3;
                }
                this.drawText(g, this.w * 50 / 100 + this.tileSet.tileHeight / 64 * 10 - difference128 - difference64, 0, null, this.scoreToChr(10 - (int)this.timeJump / 1000), 3, 4);
            }
            if (this.timeHold > 0L && this.timeHold < 10000L) {
                if (this.w == 128) {
                    difference128 = 5;
                }
                this.drawText(g, this.w * 72 / 100 + this.tileSet.tileHeight / 64 * 10 - difference128 - difference64, 0, null, this.scoreToChr(10 - (int)this.timeHold / 1000), 3, 4);
            }
            this.heightOfMenuAndQuit = 22;
            if (this.getWidth() < 321) {
                this.heightOfMenuAndQuit = 18;
            }
            if (this.getWidth() < 221) {
                this.heightOfMenuAndQuit = 15;
            }
            if (this.getWidth() < 129) {
                this.heightOfMenuAndQuit = 14;
            }
            if (this.gameState == 5) {
                this.drawText(g, 1, this.h - this.heightOfMenuAndQuit, "PAUSE", null, 6, 4);
            }
            if (this.gameState == 6) {
                this.drawText(g, 1, this.h - this.heightOfMenuAndQuit, "START", null, 6, 4);
            }
            this.drawText(g, this.w - 5, this.h - this.heightOfMenuAndQuit, "MENU", null, 6, 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stageAnimation(int time) {
        this.tileSet.x = -(this.w - this.tileSet.fullW) / 2;
        if (this.w == 128) {
            this.tileSet.x -= 16;
        }
    }

    public void keyPress(BBSKeys kcol, int time) {
        if (this.gameState == 5) {
            this._RedEvil.keyPress(this, kcol, time);
        }
        if (this.gameState == 7 && kcol.fire && kcol.released) {
            ++this.gameHasFinished;
            if (this.gameHasFinished == 2) {
                this.stageEnd();
                this.gameHasFinished = 0;
            }
        }
        if (this.gameState == 9 && kcol.fire && kcol.released) {
            ++this.gameHasFinished;
            if (this.gameHasFinished == 2) {
                this.gameState = 1;
                this.gameHasFinished = 0;
            }
        }
        if (this.gameState == 8 && kcol.fire && kcol.released) {
            this.gameState = 3;
        }
    }

    public char[] scoreToChr(int score) {
        int i1 = score / 100000;
        int i2 = score % 100000 / 10000;
        int i3 = score % 10000 / 1000;
        int i4 = score % 1000 / 100;
        int i5 = score % 100 / 10;
        int i6 = score % 10;
        this.scoreS[5] = (char)(48 + i6);
        this.scoreS[4] = score >= 10 ? (char)(48 + i5) : (char)'\u0000';
        this.scoreS[3] = score >= 100 ? (char)(48 + i4) : (char)'\u0000';
        this.scoreS[2] = score >= 1000 ? (char)(48 + i3) : (char)'\u0000';
        this.scoreS[1] = score >= 10000 ? (char)(48 + i2) : (char)'\u0000';
        this.scoreS[0] = score >= 100000 ? (char)(48 + i1) : (char)'\u0000';
        return this.scoreS;
    }

    protected void keyPress(int keyCode) {
        if (this.gameState == 5 || this.gameState == 6 || this.gameState == 8) {
            if (keyCode == 1) {
                if (this.gameState == 5) {
                    this.pauseApp();
                } else if (this.gameState == 6) {
                    this.resumeApp();
                }
            }
            if (keyCode == 2) {
                this.callMenu(2);
            }
        }
    }
}

