/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.helper;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.helper.BBSKeys;
import bbs.framework.models.BBSGame;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BBSAdClient {
    private short state = 0;
    private int timeout = 4000;
    private long fetchStart;
    private String adUrl;
    private static final short STATE_HIDE = 0;
    private static final short STATE_SHOW = 1;
    private static final short STATE_GO = 2;
    private Font fnt = Font.getFont((int)64, (int)0, (int)16);
    private Font fnt2 = Font.getFont((int)64, (int)0, (int)0);
    private Font fnt3 = Font.getFont((int)64, (int)0, (int)8);
    private String adText;
    private Image adImage;
    private String goUrl;
    private short selection = 0;
    private String temp;
    private Image logo;

    public BBSAdClient(BBSGame game) {
    }

    public void show(BBSGame game) {
        this.logo = BBSFunctions.loadImage("/bbs/res/jarbull.png", false);
        this.selection = 0;
        this.state = 1;
        if (this.adUrl == null) {
            this.adUrl = "http://ad.jarbull.com/adrequest.jsp?platform=j2me&midp=2.0&cldc=1.0&w=" + game.w + "&h=" + game.h + "&uid=" + game.instance.getAppProperty("MIDlet-Name");
        }
        this.getAdResult();
        this.fetchStart = game.currentTimeMillis;
        this.adText = null;
        this.adImage = null;
        this.goUrl = null;
    }

    public boolean check() {
        return this.state != 0;
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.goUrl == null && game.currentTimeMillis - this.fetchStart > (long)this.timeout) {
            this.state = 0;
            this.adImage = null;
            this.logo = null;
        }
        if (this.goUrl != null && this.state == 2) {
            BBSFunctions.callUrl(game.instance, this.goUrl);
            this.goUrl = null;
            game.quitApp();
        }
    }

    public void keyPress(BBSKeys kcol) {
        if (kcol.released && (this.adText != null || this.adImage != null) && this.goUrl != null) {
            if (kcol.up && this.selection > 0) {
                this.selection = (short)(this.selection - 1);
            }
            if (kcol.down && this.selection < 1) {
                this.selection = (short)(this.selection + 1);
            }
            if (kcol.fire) {
                if (this.selection == 1) {
                    this.state = 0;
                    this.logo = null;
                    this.adImage = null;
                } else {
                    this.state = (short)2;
                }
            }
        }
    }

    public void drawScreen(BBSGame game, Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        if (this.logo != null) {
            g.drawImage(this.logo, game.w / 2, 10, 17);
        }
        g.setColor(255, 255, 255);
        if (this.adText != null) {
            if (game.w < 140) {
                g.setFont(this.fnt3);
            } else if (game.w < 240) {
                g.setFont(this.fnt2);
            } else {
                g.setFont(this.fnt);
            }
            g.drawString(this.adText, game.w / 2, (game.h - 80) / 2 + 30, 17);
        }
        if (this.adImage != null) {
            g.drawImage(this.adImage, game.w / 2, (game.h - 80) / 2 + 30, 3);
        }
        if (this.goUrl != null) {
            g.setColor(150, 0, 0);
            g.fillRoundRect(game.w / 2 - Math.min(game.w / 2 - 2, 85), game.h - 50 + this.selection * 25, Math.min(game.w - 4, 170), 24, 8, 8);
            g.setColor(255, 255, 255);
            g.setFont(this.fnt);
            g.drawString("VISIT SPONSOR", game.w / 2, game.h - 50 + (22 - g.getFont().getHeight()) / 2, 17);
            g.drawString("CONTINUE", game.w / 2, game.h - 25 + (22 - g.getFont().getHeight()) / 2, 17);
        } else {
            g.setColor(255, 255, 255);
            g.setFont(this.fnt);
            g.drawString("Please Wait...", game.w / 2, game.h - 25 + (22 - g.getFont().getHeight()) / 2, 17);
        }
    }

    private void textReceived(String text) {
        if (text.indexOf("<text_ad>") >= 0) {
            int lPos;
            int pos = text.indexOf("<text_ad_text>") + 14;
            if (pos >= 0 && (lPos = text.indexOf("</text_ad_text>", pos)) > 0) {
                this.adText = text.substring(pos, lPos);
            }
            if ((pos = text.indexOf("<text_ad_link>") + 14) >= 0 && (lPos = text.indexOf("</text_ad_link>", pos)) > 0) {
                this.goUrl = text.substring(pos, lPos);
                pos = this.goUrl.indexOf("http:/");
                if (pos >= 0 && (lPos = this.goUrl.indexOf("]", pos)) > 0) {
                    this.goUrl = this.goUrl.substring(pos, lPos);
                }
            }
        } else if (text.indexOf("<image_ad>") >= 0) {
            int lPos;
            int pos = text.indexOf("<image_ad_src>") + 14;
            if (pos >= 0 && (lPos = text.indexOf("</image_ad_src>", pos)) > 0) {
                this.temp = text.substring(pos, lPos);
                if (this.temp.indexOf("http:") == 0) {
                    this.getRemoteImage(this.temp);
                } else {
                    pos = this.temp.indexOf("http:");
                    if (pos >= 0 && (lPos = this.temp.indexOf("]", pos)) > 0) {
                        this.getRemoteImage(this.temp.substring(pos, lPos));
                    }
                }
            }
            if ((pos = text.indexOf("<image_ad_link>") + 15) >= 0 && (lPos = text.indexOf("</image_ad_link>", pos)) > 0) {
                this.goUrl = text.substring(pos, lPos);
                pos = this.goUrl.indexOf("http:");
                if (pos >= 0 && (lPos = this.goUrl.indexOf("]", pos)) > 0) {
                    this.goUrl = this.goUrl.substring(pos, lPos);
                }
            }
        } else {
            this.state = 0;
        }
    }

    private void imageReceived(Image image) {
        this.adImage = image;
    }

    public void getAdResult() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection connection = null;
                InputStream inputStream = null;
                StringBuffer buffer = new StringBuffer();
                try {
                    int ch;
                    connection = (HttpConnection)Connector.open((String)BBSAdClient.this.adUrl);
                    inputStream = connection.openInputStream();
                    while ((ch = inputStream.read()) != -1) {
                        buffer.append((char)ch);
                    }
                }
                catch (IOException ex) {
                }
                catch (SecurityException ex) {
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (inputStream != null) {
                            connection.close();
                        }
                    }
                    catch (IOException ex) {}
                    BBSAdClient.this.textReceived(buffer.toString());
                }
            }
        });
        thread.start();
    }

    public void getRemoteImage(final String url) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection connection = null;
                byte[] data = null;
                FilterInputStream dataInputStream = null;
                try {
                    connection = (HttpConnection)Connector.open((String)url);
                    int length = (int)connection.getLength();
                    data = new byte[length];
                    dataInputStream = new DataInputStream(connection.openInputStream());
                    ((DataInputStream)dataInputStream).readFully(data);
                }
                catch (SecurityException ex) {
                }
                catch (IOException ex) {
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        if (dataInputStream != null) {
                            dataInputStream.close();
                        }
                    }
                    catch (IOException ex) {}
                    BBSAdClient.this.imageReceived(Image.createImage((byte[])data, (int)0, (int)data.length));
                }
            }
        });
        thread.start();
    }
}

