/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.mMath;

public class Map {
    private int[][] screen;
    private int screenWidth;
    private int screenHeight;

    public Map(int screenWidth, int screenHeight) {
        int i;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.screen = new int[screenWidth][];
        for (i = 0; i < screenWidth; ++i) {
            this.screen[i] = new int[screenHeight];
        }
        for (i = 0; i < screenWidth; ++i) {
            for (int j = 0; j < screenHeight; ++j) {
                this.screen[i][j] = 0;
            }
        }
        this.resetMap();
    }

    public int[][] getMapData() {
        return this.screen;
    }

    public void resetMap() {
        for (int i = 0; i < this.screenWidth; ++i) {
            for (int j = 0; j < this.screenHeight; ++j) {
                this.screen[i][j] = 0;
            }
        }
    }

    public int getPoint(int x, int y) {
        if (x < 0 || x >= this.screenWidth || y < 0 || y >= this.screenHeight) {
            return 0;
        }
        return this.screen[x][y];
    }

    public void setPoint(int x, int y, int value) {
        if (x < 0 || y < 0 || x >= this.screenWidth || y >= this.screenHeight) {
            return;
        }
        this.screen[x][y] = value;
    }

    public void DrawLineForObject(int x1, int y1, int x2, int y2, int type) {
        int angle;
        if (x1 > x2) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if ((angle = x1 == x2 ? 900 : mMath.getInt(Math.toDegrees(mMath.atan((float)(y1 - y2) / (float)(x2 - x1))) * 10.0)) < 0) {
            angle += 1800;
        }
        float remainder = 0.0f;
        int x = x1;
        int y = y1;
        int vertexAngle = angle > 90 ? angle - 90 : 90 + angle;
        this.setPoint(x1, y1, (vertexAngle + this.getPoint(x1, y1)) / 2 * 100 + type);
        this.setPoint(x2, y2, (vertexAngle + this.getPoint(x2, y2)) / 2 * 100 + type);
        if (Math.abs(y2 - y1) > x2 - x1) {
            int n = Math.abs(y2 - y1);
            int unit = (y2 - y1) / n;
            for (int i = 1; i < n; ++i) {
                if (x >= 0 && x < this.screenWidth + mMath.getInt(remainder) && y >= 0 && y < this.screenHeight) {
                    this.screen[x + mMath.getInt((float)remainder)][y] = angle * 100 + type;
                }
                remainder = (float)i / (float)n * (float)(x2 - x1);
                y += unit;
            }
        } else {
            int n = Math.abs(x2 - x1);
            int unit = (x2 - x1) / n;
            for (int i = 1; i < n; ++i) {
                if (x >= 0 && x < this.screenWidth && y >= 0 && y <= this.screenHeight + mMath.getInt(remainder)) {
                    this.setPoint(x, y + mMath.getInt(remainder), angle * 100 + type);
                }
                remainder = (float)i / (float)n * (float)(y2 - y1);
                x += unit;
            }
        }
    }

    public void printMap() {
        for (int i = 0; i < this.screenHeight; ++i) {
            for (int j = 0; j < this.screenWidth; ++j) {
                System.out.print(this.screen[j][i] + " ");
            }
            System.out.println(" ");
        }
    }
}

