/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Screen.GameScreen;
import Game.Screen.SplashScreen;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class MainGame
extends GameCanvas
implements Runnable {
    public Thread th;
    public boolean isActive;
    public boolean isFinish;
    public long timeNow;
    public long timeOld;

    public MainGame() {
        super(true);
        this.setFullScreenMode(true);
        globalVariable.Width = this.getWidth();
        globalVariable.Height = this.getHeight();
        globalVariable.display.setCurrent((Displayable)this);
        SplashScreen splashScreen = new SplashScreen(1);
        splashScreen.start(true);
        globalVariable.screenManager.getScreens().addElement(splashScreen);
        globalVariable.screenManager.setIndex(0);
        this.isFinish = true;
        this.isActive = true;
        this.th = new Thread(this);
        this.th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long differ = 0L;
        Graphics g = this.getGraphics();
        Image imageBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        while (this.isFinish) {
            while (this.isActive) {
                this.timeNow = System.currentTimeMillis();
                globalVariable.screenManager.run(imageBuffer.getGraphics(), this.timeNow);
                g.drawImage(imageBuffer, 0, 0, 0);
                this.flushGraphics();
                this.timeOld = this.timeNow;
                this.timeNow = System.currentTimeMillis();
                differ = this.timeNow - this.timeOld;
                MainGame mainGame = this;
                synchronized (mainGame) {
                    try {
                        long delay = 0L;
                        if (differ < (long)globalVariable.mDelay) {
                            delay = (long)globalVariable.mDelay - differ;
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        globalVariable.screenManager.pointerPressed(x, y);
    }

    protected void pointerDragged(int x, int y) {
        globalVariable.screenManager.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        globalVariable.screenManager.pointerReleased(x, y);
    }

    protected void hideNotify() {
        super.hideNotify();
        this.isActive = false;
        SoundPlayer.pauseAll();
    }

    public boolean isShown() {
        if (this.th != null && !this.isActive) {
            this.isActive = true;
            this.timeOld = System.currentTimeMillis();
            for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof GameScreen) || globalVariable.screenManager.getIndex() != i) continue;
                ((GameScreen)globalVariable.screenManager.getScreens().elementAt(i)).resume();
            }
            SoundPlayer.resumeAll();
        }
        return super.isShown();
    }

    public void displayErrorAlert() {
        Alert message = new Alert("Display Error");
        message.setString("This game can only run on the phone with 360x640 pixel display screen.");
        message.setTimeout(10000);
        message.setType(AlertType.ERROR);
        globalVariable.display.setCurrent((Displayable)message);
    }
}

