/*
 * Decompiled with CFR 0.152.
 */
package game.smarts;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.helper.BBSFunctions;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSSmartSprite;
import game.CrazyPiratesGame;
import game.smarts.Player;
import game.smarts.ThrowCannonBall;
import game.smarts.ThrowSmartPirate;
import javax.microedition.lcdui.Graphics;

public class Obstacle
extends BBSSmartSprite {
    private int waveLength = 0;
    private int waveActive = 0;
    private long tim = 0L;
    private long timeAddX = 0L;

    public Obstacle(BBSGame game, BBSSprite[] sprite, int x, int y, int sType, int oid) {
        super(sprite, sType, oid);
        this.zorder = 2;
        if (game.stage == 4 || game.stage == 8) {
            this.rSprite[0].addFrameSet(new int[]{0, 1}, 450, false);
            this.rSprite[0].addFrameSet(new int[]{2, 3}, 450, true);
            this.waveLength = 5;
        } else {
            this.rSprite[0].addFrameSet(new int[]{0, 1}, 450, true);
        }
        this.waveActive = game.h / 2 + game.tileSet.y;
        this.rSprite[0].x = game.tileSet.fullW / 2;
        this.rSprite[0].y = game.tileSet.fullH;
        this.rSprite[0].setFrameSet(1, 0);
    }

    public static BBSSmartSprite create(BBSGame game, int x, int y, int sType, int oid) {
        BBSSprite[] sprite = null;
        sprite = game.stage == 4 || game.stage == 7 ? new BBSSprite[]{new BBSSprite(game, "sprites/goldenfish.sif", 0, 0, 0, 0, 0, 0)} : new BBSSprite[]{new BBSSprite(game, "sprites/crazyParrot.sif", 0, 0, 0, 0, 0, 0)};
        return new Obstacle(game, sprite, x, y, sType, oid);
    }

    public void doAnimation(BBSSmartGame game, int time) {
        if (game.stage == 1 || game.stage == 2 || game.stage == 4 || game.stage == 7) {
            int angle = (int)(game.currentTimeMillis / 20L % 360L);
            this.rSprite[0].y = game.tileSet.fullH - this.rSprite[0].sData.height * 5 * BBSFunctions.sin(angle) / 100;
            if (angle > 0 && angle < 90) {
                if (this.rSprite[0].state == 2) {
                    this.rSprite[0].setFrameSet(1, 0);
                }
            } else if (this.rSprite[0].state == 1) {
                this.rSprite[0].setFrameSet(2, 0);
            }
            this.rSprite[0].doAnimation(this.rSprite[0].state, 0, time, true);
        } else {
            this.waveLength = BBSFunctions.sin((int)(game.currentTimeMillis / 4L % 360L)) / 5;
            this.rSprite[0].doAnimation(1, 0, time, true);
            this.rSprite[0].y = game.tileSet.fullH - game.h / 2 + this.waveLength;
        }
    }

    public void trigger(String command, int[] pars) {
    }

    public int interract(BBSSmartGame game, BBSSmartSprite sprite, int action) {
        if (action == 1 && Math.abs(this.rSprite[0].x - sprite.rSprite[0].x) <= this.rSprite[0].getFrameWidth() / 2 + sprite.rSprite[0].getFrameWidth() / 2 + 2 && Math.abs(sprite.rSprite[0].y - this.rSprite[0].y) <= this.rSprite[0].getFrameHeight() / 2 + sprite.rSprite[0].getFrameHeight() / 2 + 2 && this.rSprite[0].visible) {
            this.rSprite[0].visible = false;
            if (((Player)((CrazyPiratesGame)game).player).cannonBallNxt < ((Player)((CrazyPiratesGame)game).player).throwCannonBallList.size()) {
                ((ThrowCannonBall)sprite).rSprite[1].x = ((ThrowCannonBall)sprite).rSprite[0].x;
                ((ThrowCannonBall)sprite).rSprite[1].y = ((ThrowCannonBall)sprite).rSprite[0].y;
                ((ThrowCannonBall)sprite).animCounterExplosion = (byte)6;
                ((ThrowCannonBall)sprite).rSprite[1].visible = true;
                ((ThrowCannonBall)sprite).cannonBallSpdX = 0;
                ((ThrowCannonBall)sprite).cannonBallSpdY = 0;
                sprite.rSprite[0].x = game.tileSet.fullW;
                sprite.rSprite[0].y = game.h;
                sprite.rSprite[0].visible = false;
                return 1;
            }
            if (Math.abs(this.rSprite[0].x - sprite.rSprite[0].x) <= this.rSprite[0].getFrameWidth() / 2 + sprite.rSprite[0].getFrameWidth() / 4 + 2 && Math.abs(sprite.rSprite[0].y - this.rSprite[0].y) <= this.rSprite[0].getFrameHeight() / 2 + 2) {
                sprite.rSprite[0].visible = false;
                ((Player)((CrazyPiratesGame)game).player).inTheAir = false;
                ((ThrowSmartPirate)sprite).smartPirateSpdX = 0;
                ((ThrowSmartPirate)sprite).smartPirateSpdY = 0;
                return 1;
            }
            return 1;
        }
        return 0;
    }

    public boolean draw(BBSSmartGame game, Graphics g, int spriteNo) {
        return super.draw(game, g, spriteNo);
    }
}

