/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.library.BBSSpriteData;
import bbs.framework.models.BBSGame;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class BBSSprite {
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int state = 0;
    public int faceTo = 1;
    public int refPX;
    public int refPY;
    public int refPZ;
    public boolean visible = true;
    public int[] frameSequence;
    public int seqFrame = 0;
    public BBSSpriteData sData;
    private int[] frameDelays;
    private Vector fSets = new Vector();
    private Vector fDelays = new Vector();
    private int[][] sets;
    private int seq = 0;
    private int direct = 0;
    private boolean skipFirst = false;
    private boolean temp;
    private int tilx;
    private int tily;
    private int sDir;
    private int sSeq;
    private int shiftX;
    private int shiftY;
    private int width;
    private int height;
    private int realX;
    private int realY;

    public BBSSprite(BBSGame game, String name, int pivotX, int pivotY, int pivotZ, int sX, int sY, int sZ) {
        this.sData = (BBSSpriteData)game.getCache(name);
        if (this.sData == null) {
            this.sData = (BBSSpriteData)game.addCache(name, new BBSSpriteData(game, name));
        }
        this.refPX = (100 + pivotX) * this.sData.width / 200;
        this.refPY = (100 + pivotY) * this.sData.height / 200;
        this.refPZ = pivotZ;
        this.x = sX;
        this.y = sY;
        this.z = sZ;
    }

    public final int addFrameSet(int[] set, int delay, boolean finalize) {
        int ret = 0;
        this.fSets.addElement(set);
        this.fDelays.addElement(new Integer(delay));
        ret = this.fSets.size();
        if (finalize) {
            this.createSets();
        }
        return ret;
    }

    private void createSets() {
        this.sets = new int[this.fSets.size()][];
        this.frameDelays = new int[this.fSets.size()];
        for (int cnt = 0; cnt < this.sets.length; ++cnt) {
            this.sets[cnt] = (int[])this.fSets.elementAt(cnt);
            this.frameDelays[cnt] = (Integer)this.fDelays.elementAt(cnt);
        }
        this.fSets.removeAllElements();
        this.fDelays.removeAllElements();
        this.fSets = null;
        this.fDelays = null;
    }

    private void setFrameSequence(int sequence) {
        this.frameSequence = this.sets[sequence - 1];
        this.seqFrame = 0;
        this.seq = this.frameSequence[this.seqFrame];
    }

    private boolean onceInMs(int time, int duration) {
        return time % duration == 0;
    }

    public final void setDirection(int direction) {
        if (direction != 0) {
            this.faceTo = direction;
            this.direct = 1 - direction;
        }
    }

    public final void setFrame(int frame) {
        this.seqFrame = frame;
        this.seq = this.frameSequence[this.seqFrame];
    }

    public final int setFrameSet(int setNo, int direction) {
        this.temp = false;
        if (direction != 0) {
            this.temp = this.faceTo == direction;
            this.faceTo = direction;
            this.direct = 1 - direction;
        }
        if (this.state != setNo || !this.temp) {
            this.state = setNo;
            this.setFrameSequence(setNo);
            this.skipFirst = true;
        }
        return this.sets[setNo - 1].length;
    }

    public final boolean doAnimation(int setNo, int direction, int time, boolean loop) {
        boolean ret = false;
        if (setNo != 0) {
            if (direction != 0) {
                this.faceTo = direction;
                this.direct = 1 - direction;
            }
            if (this.state != setNo) {
                this.state = setNo;
                this.setFrameSequence(setNo);
            } else if (this.onceInMs(time, this.frameDelays[this.state - 1])) {
                if (loop || this.seqFrame < this.frameSequence.length - 1) {
                    if (!this.skipFirst) {
                        this.seqFrame = (this.seqFrame + 1) % this.frameSequence.length;
                    }
                    this.skipFirst = false;
                }
                ret = true;
            }
        }
        this.seq = this.frameSequence[this.seqFrame];
        return ret;
    }

    public int getFrameWidth() {
        return this.sData.map[Math.abs(this.seq)][2];
    }

    public int getFrameHeight() {
        return this.sData.map[Math.abs(this.seq)][3];
    }

    public final boolean paint(BBSGame game, Graphics g) {
        this.tilx = 0;
        this.tily = 0;
        if (game.tileSet != null) {
            this.tilx = game.tileSet.x;
            this.tily = game.tileSet.y;
        }
        this.sDir = 0;
        if (this.seq >= 0) {
            this.sDir = this.direct;
        }
        this.shiftX = this.sData.map[this.seq][0];
        this.shiftY = this.sData.map[this.seq][1];
        this.width = this.sData.map[this.seq][2];
        this.height = this.sData.map[this.seq][3];
        this.realX = this.sData.map[this.seq][4];
        this.realY = this.sData.map[this.seq][5];
        if (this.faceTo == -1) {
            this.shiftX = this.sData.width - this.sData.map[this.seq][0] - this.sData.map[this.seq][2];
        }
        this.sSeq = Math.abs(this.seq);
        if (this.frameSequence != null && this.visible && this.x - this.refPX + this.shiftX + this.width >= this.tilx && this.x - this.refPX + this.shiftX <= this.tilx + game.w && this.y - this.refPY + this.shiftY + this.height >= this.tily && this.y - this.refPY + this.shiftY <= this.tily + game.h) {
            g.drawRegion(this.sData.spriteSet, this.realX, this.realY, this.width, this.height, this.sDir >= 0 ? this.sDir : 0, this.x - this.tilx - this.refPX + this.shiftX, this.y - this.tily - this.refPY + this.shiftY, 0);
            return true;
        }
        return false;
    }
}

