/*
 * Decompiled with CFR 0.152.
 */
package game;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.helper.BBSKeys;
import bbs.framework.helper.BBSRecStore;
import bbs.framework.library.BBSTile;
import bbs.framework.models.BBSLoader;
import bbs.framework.models.BBSMenu;
import bbs.framework.models.BBSObjectFactory;
import bbs.framework.models.BBSSmartSprite;
import bbs.framework.models.BBSStory;
import bbs.framework.starter.BBSStarter;
import game.CrazyPiratesLoader;
import game.CrazyPiratesMenu;
import game.CrazyPiratesObjects;
import game.smarts.Player;
import game.smarts.ThrowCannonBall;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CrazyPiratesGame
extends BBSSmartGame {
    public BBSSmartSprite player;
    public BBSSmartSprite throwCannonBall;
    public BBSSmartSprite throwSmartSprite;
    public BBSSmartSprite enemy;
    public BBSSmartSprite purplePirate;
    private Image circle = null;
    private Image iconBlueBomb = null;
    private Image iconRedBomb = null;
    private Image iconRedXBomb = null;
    private Image iconYellowBomb = null;
    public boolean activePath = true;
    private int iconCount = 0;
    private int iconShowCount = 0;
    private int iconSpace = 0;
    public static boolean animationCrash = true;
    private long timeWait = 0L;
    public boolean men = true;
    public boolean musicState = false;
    private int ramClear = 0;
    private int timeFinish = 0;
    public int tempScore = 0;
    private Image treasure;
    private char[] scoreS = new char[6];

    public CrazyPiratesGame(BBSStarter inst) {
        super(inst);
    }

    protected BBSObjectFactory getObjectFactory() {
        return new CrazyPiratesObjects();
    }

    public String[] getGameFonts() {
        return new String[]{"piecesofeightswhite", "piecesofeightsred", "piecesofeightsred", "piecesofeightsred"};
    }

    public BBSMenu getGameMenu() {
        return new CrazyPiratesMenu(this);
    }

    public BBSStory getGameStory() {
        return null;
    }

    public BBSLoader getGameLoader() {
        return new CrazyPiratesLoader(this, 2);
    }

    public void stageLoading() {
        this.circle = this.loadImage("sprites/circle.png");
        this.tileSet = new BBSTile();
        String[][] objs = this.loadObjects(this.stage);
        if (this.w <= 208 || this.h <= 208) {
            this.loader.setMaxValue(objs.length + 7);
        } else {
            this.loader.setMaxValue(objs.length + 10);
        }
        this.tileSet.createTiles(this, this.stage, 4, 0, 0, 3, false);
        this.tileSet.y = this.tileSet.fullH - this.tileSet.sch;
        this.loader.progress(this);
        for (int cnt = 0; cnt < objs.length; ++cnt) {
            this.factory.objectFactory(this, objs[cnt], cnt);
            this.loader.progress(this);
        }
        objs = null;
        this.createSmarts();
        this.loader.progress(this);
        this.iconBlueBomb = this.loadImage("sprites/iconBlueBomb.png");
        this.loader.progress(this);
        this.iconRedBomb = this.loadImage("sprites/iconRedBomb.png");
        this.loader.progress(this);
        this.iconRedXBomb = this.loadImage("sprites/iconRedXBomb.png");
        this.loader.progress(this);
        this.iconYellowBomb = this.loadImage("sprites/iconYellowBomb.png");
        this.loader.progress(this);
        if (this.w > 208 && this.h > 208) {
            this.loadSound("_win");
            this.loader.progress(this);
            this.loadMusic("_lost");
            this.loader.progress(this);
            this.loadSound("_wounded");
            this.loader.progress(this);
        }
        this.loadMusic("_menu");
        this.loader.progress(this);
    }

    public void stageStart() {
    }

    public void stageEnd() {
        BBSRecStore fileOpen;
        int val;
        String tmpS;
        String tmpL;
        String tmp;
        if (this.stage >= 15) {
            this.gameState = 9;
            tmp = "";
            tmpL = "0";
            tmpS = "0";
            val = 1;
            this.tempScore = 0;
            fileOpen = new BBSRecStore("CrazyPirates");
            tmp = fileOpen.read("Stage");
            tmpL = fileOpen.read("LastGame");
            tmpS = fileOpen.read("Score");
            if (!tmp.equals("")) {
                val = Integer.parseInt(tmp);
                this.tempScore = Integer.parseInt(tmpS);
            }
            fileOpen.write("Stage", String.valueOf(Math.max(this.stage, val)));
            fileOpen.write("LastGame", String.valueOf(this.stage));
            fileOpen.write("Score", String.valueOf(this.tempScore + ((Player)this.player).score));
            this.tempScore += ((Player)this.player).score;
            fileOpen.close();
            fileOpen = null;
            tmp = null;
            tmpS = null;
        } else {
            ++this.stage;
        }
        if (this.gameState == 7) {
            tmp = "";
            tmpL = "0";
            tmpS = "0";
            val = 1;
            this.tempScore = 0;
            fileOpen = new BBSRecStore("CrazyPirates");
            tmp = fileOpen.read("Stage");
            tmpL = fileOpen.read("LastGame");
            tmpS = fileOpen.read("Score");
            if (!tmp.equals("")) {
                val = Integer.parseInt(tmp);
                this.tempScore = Integer.parseInt(tmpS);
            }
            fileOpen.write("Stage", String.valueOf(Math.max(this.stage, val)));
            fileOpen.write("LastGame", String.valueOf(this.stage));
            fileOpen.write("Score", String.valueOf(this.tempScore + ((Player)this.player).score));
            this.tempScore += ((Player)this.player).score;
            fileOpen.close();
            fileOpen = null;
            tmp = null;
            tmpS = null;
            this.gameState = 3;
        }
    }

    public void stageDraw(Graphics g) {
        if (this.gameState == 9) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.w, this.h);
            this.drawText(g, this.w / 2, this.h - this.h / 8, null, this.scoreToChr(this.tempScore), 1, 32);
            if (this.treasure == null) {
                this.treasure = this.loadImage("menu/treasure.png");
            }
            g.drawImage(this.treasure, this.w / 2, this.h / 2, 3);
        } else {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.w, this.h);
            this.tileSet.drawTiles(this, g, this.stage);
            if (this.gameState == 7) {
                if (this.w > 208 && this.h > 208) {
                    this.playSound("_win");
                }
                this.drawText(g, this.w / 5, this.h / 3, "CONGRATULATIONS.", null, 1, 16);
                if (this.stage % 3 == 0) {
                    if (this.w < 176) {
                        this.drawText(g, this.w - this.w / 16, this.h / 2, "YOU CAN PASS - ", null, 1, 8);
                        this.drawText(g, this.w - this.w / 16, 3 * this.h / 5, "NEXT LEVEL.", null, 1, 8);
                    } else {
                        this.drawText(g, this.w - this.w / 16, this.h / 2, "YOU CAN PASS NEXT LEVEL.", null, 1, 8);
                    }
                } else if (this.w < 176) {
                    this.drawText(g, this.w - this.w / 16, this.h / 2, "YOU CAN PASS - ", null, 1, 8);
                    this.drawText(g, this.w - this.w / 16, 3 * this.h / 5, "NEXT STAGE.", null, 1, 8);
                } else {
                    this.drawText(g, this.w - this.w / 16, this.h / 2, "YOU CAN PASS NEXT STAGE.", null, 1, 8);
                }
            }
            if (this.gameState == 8) {
                if (this.w > 208 && this.h > 208) {
                    this.playMusic("_lost");
                }
                this.drawText(g, this.w / 3, this.h / 3, "LEVEL FAIL...", null, 1, 16);
            }
            if (this.gameState != 8 && this.gameState != 7) {
                this.iconCount = ((Player)this.player).cannonBallNxt;
                while (this.iconCount < ((Player)this.player).throwCannonBallList.size()) {
                    if (this.iconShowCount < 3) {
                        switch (((ThrowCannonBall)((Player)this.player).throwCannonBallList.elementAt((int)this.iconCount)).cannonBallType) {
                            case 1: {
                                g.drawImage(this.iconRedBomb, (this.iconCount - ((Player)this.player).cannonBallNxt - this.iconSpace) * this.iconRedBomb.getWidth(), 0, 0);
                                ++this.iconShowCount;
                                break;
                            }
                            case 2: {
                                g.drawImage(this.iconBlueBomb, (this.iconCount - ((Player)this.player).cannonBallNxt - this.iconSpace) * this.iconRedBomb.getWidth(), 0, 0);
                                ++this.iconShowCount;
                                break;
                            }
                            case 3: {
                                g.drawImage(this.iconYellowBomb, (this.iconCount - ((Player)this.player).cannonBallNxt - this.iconSpace) * this.iconRedBomb.getWidth(), 0, 0);
                                ++this.iconShowCount;
                                break;
                            }
                            case 4: {
                                g.drawImage(this.iconRedXBomb, (this.iconCount - ((Player)this.player).cannonBallNxt - this.iconSpace) * this.iconRedBomb.getWidth(), 0, 0);
                                ++this.iconShowCount;
                                this.iconCount += 2;
                                this.iconSpace += 2;
                            }
                        }
                    }
                    ++this.iconCount;
                }
                this.iconShowCount = 0;
                this.iconSpace = 0;
            }
            this.drawText(g, this.w - 6, this.h - this.h / 10, "MENU", null, 1, 8);
            this.drawText(g, 0, this.h - this.h / 10, "PAUSE", null, 1, 4);
        }
    }

    public void stageAnimation(int time) {
        this.ramClear = this.ramClear > 10000 ? 0 : ++this.ramClear;
        if (this.ramClear % 200 == 0) {
            System.gc();
        }
        if (this.gameState == 8) {
            ++this.timeFinish;
            if (this.timeFinish >= 40) {
                this.timeFinish = 0;
                this.gameState = 3;
            }
        } else if (this.gameState == 7) {
            ++this.timeFinish;
            if (this.timeFinish >= 40) {
                this.timeFinish = 0;
                this.stageEnd();
            }
        } else if (this.gameState == 9) {
            ++this.timeFinish;
            if (this.timeFinish >= 40) {
                this.timeFinish = 0;
                this.gameState = 1;
            }
        }
    }

    public void keyPress(BBSKeys kcol, int time) {
        if (this.gameState != 6) {
            if (this.gameState == 8) {
                this.gameState = 3;
            } else if (this.gameState == 7) {
                this.stageEnd();
            } else if (this.gameState == 9) {
                this.gameState = 1;
            } else if (kcol.right && this.tileSet.x + 5 < this.tileSet.fullW - this.w) {
                this.tileSet.x += 5;
            } else if (kcol.left && this.tileSet.x - 5 > 0) {
                this.tileSet.x -= 5;
            } else if (kcol.left) {
                this.tileSet.x = 0;
            } else if (kcol.up || kcol.down || kcol.fire && this.gameState != 7 && this.gameState != 9 && this.gameState != 8 && this.gameState != 3 && this.gameState != 2) {
                this.player.keyPress(this, kcol, time);
            }
        }
        if (this.gameState == 5 || this.gameState == 6) {
            if (kcol.game_a) {
                if (this.gameState != 6) {
                    this.pauseApp();
                } else {
                    this.resumeApp();
                }
            }
            if (kcol.game_b) {
                this.callMenu(2);
            }
        }
    }

    protected void keyPress(int keyCode) {
        switch (keyCode) {
            case 1: {
                if (this.gameState != 5 && this.gameState != 6) break;
                if (this.gameState != 6) {
                    this.pauseApp();
                    break;
                }
                this.resumeApp();
                break;
            }
            case 2: {
                if (this.gameState != 5 && this.gameState != 6) break;
                this.callMenu(2);
            }
        }
    }

    protected char[] scoreToChr(int score) {
        int i1 = score / 100000;
        int i2 = score % 100000 / 10000;
        int i3 = score % 10000 / 1000;
        int i4 = score % 1000 / 100;
        int i5 = score % 100 / 10;
        int i6 = score % 10;
        this.scoreS[5] = (char)(48 + i6);
        this.scoreS[4] = score >= 10 ? (char)(48 + i5) : (char)'\u0000';
        this.scoreS[3] = score >= 100 ? (char)(48 + i4) : (char)'\u0000';
        this.scoreS[2] = score >= 1000 ? (char)(48 + i3) : (char)'\u0000';
        this.scoreS[1] = score >= 10000 ? (char)(48 + i2) : (char)'\u0000';
        this.scoreS[0] = score >= 100000 ? (char)(48 + i1) : (char)'\u0000';
        return this.scoreS;
    }
}

