/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.util;

import elventales.avoider.Stage;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundUtil {
    public static final int BGM = 0;
    public static final int SFX = 1;
    public static final int WIN = 2;
    public static final int LOSE = 3;
    private Player player;
    private final int volume;
    private int previousType = -1;

    public SoundUtil() {
        this.volume = 7;
    }

    public void play(int type) {
        if (!Stage.isEnableSound) {
            return;
        }
        try {
            if (type != this.previousType) {
                this.stopPlayer();
                this.previousType = type;
                switch (type) {
                    case 0: {
                        this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/bgm.mid"), (String)"audio/midi");
                        break;
                    }
                    case 1: {
                        this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/sfx.mid"), (String)"audio/midi");
                        break;
                    }
                    case 2: {
                        this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/win.mid"), (String)"audio/midi");
                        break;
                    }
                    case 3: {
                        this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/lose.mid"), (String)"audio/midi");
                    }
                }
                this.player.realize();
                if (type == 0) {
                    this.player.setLoopCount(-1);
                }
                ((VolumeControl)this.player.getControl("VolumeControl")).setLevel(7);
            }
            this.player.start();
        }
        catch (MediaException ex) {
            System.out.println("play bgm " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            System.out.println("play bgm " + ex);
        }
    }

    private void stopPlayer() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        catch (MediaException ex) {
            System.out.println("stop" + ex.getMessage());
        }
    }
}

