/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.title;

import elventales.avoider.Stage;
import elventales.avoider.util.KeyTranslator;
import elventales.avoider.window.Window;
import elventales.avoider.window.component.ButtonBackground;
import elventales.avoider.window.component.MiddleButton;
import elventales.avoider.window.component.TitleBackground;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class TitleWindow
extends Window {
    public static final int FREEPLAY = 0;
    public static final int STORY = 1;
    public static final int OPTION = 2;
    public static final int HELP = 3;
    public static final int ABOUT = 4;
    public static final int EXIT = 5;
    private DisplayObject cursor;
    private DisplayObject menu;
    private DisplayObject header;
    private DisplayObject chara;
    public int cursorPosition = 0;

    public void initialize() {
        try {
            this.cursor = new DisplayObject(Image.createImage((String)"/title/title-cursor.png"), 0, 0);
            this.menu = new DisplayObject(Image.createImage((String)"/title/title-menu.png"), 0, 0);
            this.header = new DisplayObject(Image.createImage((String)"/title/title-header.png"), 0, 0);
            this.chara = new DisplayObject(Image.createImage((String)"/title/title-char.png"), 0, 0);
        }
        catch (IOException ex) {
            System.out.println("Title window ex : " + ex.getMessage());
        }
        this.addChild(new DisplayObject(Image.createImage((int)Stage.Width, (int)Stage.Height), 0, 0));
        this.addChild(new TitleBackground());
        this.addChild(this.chara);
        this.addChild(new ButtonBackground());
        this.addChild(new MiddleButton());
        this.addChild(this.cursor);
        this.addChild(this.menu);
        this.addChild(this.header);
        if (Stage.isLandscape) {
            this.chara.x = 170;
            this.chara.y = 80;
        } else {
            this.chara.x = 120;
            this.chara.y = 80;
            this.menu.y = 40;
        }
        this.header.x = Stage.Width / 2 - 60;
        this.setCursorPosition();
    }

    private void setCursorPosition() {
        this.cursor.y = this.menu.y + 80 + this.cursorPosition * 20;
    }

    protected void loop() {
        super.loop();
        this.setCursorPosition();
    }

    protected void keyPressed(int keyCode) {
        if (KeyTranslator.getKeyAction(keyCode) == 8 || keyCode == 53) {
            if (this.cursorPosition != 0) {
                Stage.soundUtil.play(1);
            }
            this.parent.removeDisplay(this);
        } else if (KeyTranslator.getKeyAction(keyCode) == 1 || keyCode == 50) {
            Stage.soundUtil.play(1);
            --this.cursorPosition;
            if (this.cursorPosition < 0) {
                this.cursorPosition += 6;
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 6 || keyCode == 56) {
            Stage.soundUtil.play(1);
            ++this.cursorPosition;
            if (this.cursorPosition > 5) {
                this.cursorPosition -= 6;
            }
        }
        super.keyPressed(keyCode);
    }
}

