/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Blocks {
    public static Blocks sInstance = null;
    static int INCOMING_DIFF = 0;
    static int DSPY_BLOCK_Y_SHIFT = 0;
    static int DSPY_BLOCK_X_SHIFT = 0;
    final int DELAY_BLOCKS_EXPLOSION;
    final int SPEED_BULDOZERS;
    final int ROWS_ON_SCREEN;
    final int BLOCKS_IN_ROW;
    final int BLOCK_BONUS_TIME;
    final int BLOCK_BONUS_ROW;
    final int BLOCK_BONUS_COLUMN;
    final int BLOCK_BONUS_BOMB;
    final int BLOCK_BONUS_EXTRA;
    private int[][] iaExplosionArr = new int[70][3];
    private int[][] iaRows = new int[10][7];
    private int[] iaStackedBlocks = new int[70];
    private int[] iaTestedBlocks = new int[70];
    private int[] iaBouncedBlocks = new int[70];
    public int[] iaPickedBlocks = new int[10];
    public int[] iaNewBlocks = new int[7];
    public int[] iaNewBlocksTime = new int[7];
    public int[] iaNewBlocksShift = new int[7];
    public int[] iaNewBlocksBack = new int[7];
    public int iBlockWidth;
    public int iBlockHeight;
    public int iAllBlocksWidth;
    private int iBoardTop;
    private int iBoardLeft;
    private int iGap;
    private int iLastRow;
    public int iStackedBlocksCnt;
    private int iStackedBlockExplosionDelay;
    public boolean bShakeNeeded;
    private boolean bOverScreen;
    private boolean bExplosion;
    private boolean bHorizontalExplosion = false;
    private int iMovingCordY = 0;
    private int iDeletingPosY = 0;
    private int iBonusFrameInc = 0;
    private int iLevitationX = 0;
    private int iLevitationInc = 1;

    public static Blocks CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new Blocks();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
        System.gc();
    }

    public Blocks() {
        this.DELAY_BLOCKS_EXPLOSION = 12;
        this.SPEED_BULDOZERS = 3;
        this.ROWS_ON_SCREEN = 10;
        this.BLOCKS_IN_ROW = 7;
        this.BLOCK_BONUS_TIME = 100;
        this.BLOCK_BONUS_ROW = 110;
        this.BLOCK_BONUS_COLUMN = 120;
        this.BLOCK_BONUS_BOMB = 130;
        this.BLOCK_BONUS_EXTRA = 200;
    }

    public static void setRes(int w, int h) {
        if (w == 128 && h == 160) {
            DSPY_BLOCK_Y_SHIFT = 19;
            INCOMING_DIFF = 22;
        }
        if (w == 176 && h == 208) {
            DSPY_BLOCK_Y_SHIFT = 23;
            INCOMING_DIFF = 8;
        }
        if (w == 176 && h == 220) {
            DSPY_BLOCK_Y_SHIFT = 22;
            INCOMING_DIFF = 10;
        }
        if (w == 320 && h == 240) {
            DSPY_BLOCK_Y_SHIFT = 22;
            INCOMING_DIFF = -20;
        }
        if (w == 240 && h == 320) {
            DSPY_BLOCK_Y_SHIFT = 30;
            INCOMING_DIFF = 35;
        }
        if (w == 240 && h == 432) {
            DSPY_BLOCK_Y_SHIFT = 25;
            INCOMING_DIFF = 90;
        }
        if (w == 360 && h == 640) {
            DSPY_BLOCK_Y_SHIFT = 40;
            INCOMING_DIFF = 100;
        }
        if (w == 480 && h == 800) {
            DSPY_BLOCK_Y_SHIFT = 60;
            INCOMING_DIFF = 140;
        }
    }

    public void loadResources() {
        Debug.traceIn("> Blocks.loadResources()");
        Resources.loadBlocksResources(GameStateCommon.sInstance.iStage);
        this.iBoardTop = Resources.sprBlocks.getHeight();
        this.iBoardTop = Resources.iRoofH;
        this.iBlockWidth = Resources.sprBlocks.getWidth();
        this.iBlockHeight = Resources.sprBlocks.getHeight();
        this.iBoardLeft = 1;
        this.iGap = 0;
        this.iAllBlocksWidth = this.iBlockWidth * 7;
        DSPY_BLOCK_X_SHIFT = Defines.WIDTH - this.iAllBlocksWidth >> 1;
        Debug.traceOut("< Blocks.loadResources()");
    }

    public void release() {
        Debug.traceIn("> Blocks.release()");
        Resources.releaseBlocksResources();
        for (int i = this.iaRows.length - 1; i >= 0; --i) {
            this.iaRows[i] = null;
        }
        this.iaRows = null;
        this.iaStackedBlocks = null;
        this.iaTestedBlocks = null;
        this.iaBouncedBlocks = null;
        this.iaPickedBlocks = null;
        this.iaNewBlocks = null;
        this.iaNewBlocksTime = null;
        this.iaNewBlocksShift = null;
        this.iaNewBlocksBack = null;
        Debug.traceOut("< Blocks.release()");
    }

    public void saveData(DataOutputStream data) {
        Debug.traceIn("> Blocks.saveData()");
        int iTotalCnt = 70;
        try {
            int i;
            for (int row = 0; row < 10; ++row) {
                for (int col = 0; col < 7; ++col) {
                    data.writeInt(this.iaRows[row][col]);
                }
            }
            for (i = 0; i < iTotalCnt; ++i) {
                data.writeInt(this.iaStackedBlocks[i]);
            }
            for (i = 0; i < iTotalCnt; ++i) {
                data.writeInt(this.iaTestedBlocks[i]);
            }
            for (i = 0; i < iTotalCnt; ++i) {
                data.writeInt(this.iaBouncedBlocks[i]);
            }
            for (i = 0; i < 10; ++i) {
                data.writeInt(this.iaPickedBlocks[i]);
            }
            for (i = 0; i < 7; ++i) {
                data.writeInt(this.iaNewBlocks[i]);
            }
            for (i = 0; i < 7; ++i) {
                data.writeInt(this.iaNewBlocksTime[i]);
            }
            for (i = 0; i < 7; ++i) {
                data.writeInt(this.iaNewBlocksShift[i]);
            }
            for (i = 0; i < 7; ++i) {
                data.writeInt(this.iaNewBlocksBack[i]);
            }
            data.writeInt(this.iStackedBlocksCnt);
            data.writeInt(this.iStackedBlockExplosionDelay);
            data.writeBoolean(this.bShakeNeeded);
            data.writeBoolean(this.bOverScreen);
            data.writeBoolean(this.bExplosion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Debug.traceOut("< Blocks.saveData()");
    }

    public void loadData(DataInputStream data) {
        Debug.traceIn("> Blocks.loadData()");
        int iTotalCnt = 70;
        this.initBlocks();
        try {
            int i;
            for (int row = 0; row < 10; ++row) {
                for (int col = 0; col < 7; ++col) {
                    this.iaRows[row][col] = data.readInt();
                }
            }
            for (i = 0; i < iTotalCnt; ++i) {
                this.iaStackedBlocks[i] = data.readInt();
            }
            for (i = 0; i < iTotalCnt; ++i) {
                this.iaTestedBlocks[i] = data.readInt();
            }
            for (i = 0; i < iTotalCnt; ++i) {
                this.iaBouncedBlocks[i] = data.readInt();
            }
            for (i = 0; i < 10; ++i) {
                this.iaPickedBlocks[i] = data.readInt();
            }
            for (i = 0; i < 7; ++i) {
                this.iaNewBlocks[i] = data.readInt();
            }
            for (i = 0; i < 7; ++i) {
                this.iaNewBlocksTime[i] = data.readInt();
            }
            for (i = 0; i < 7; ++i) {
                this.iaNewBlocksShift[i] = data.readInt();
            }
            for (i = 0; i < 7; ++i) {
                this.iaNewBlocksBack[i] = data.readInt();
            }
            this.iStackedBlocksCnt = data.readInt();
            this.iStackedBlockExplosionDelay = data.readInt();
            this.bShakeNeeded = data.readBoolean();
            this.bOverScreen = data.readBoolean();
            this.bExplosion = data.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateLastRow();
        Debug.traceOut("< Blocks.loadData()");
    }

    public void resetExplosionArray() {
        int iWholeArrLength = this.iaExplosionArr.length;
        for (int i = 0; i < iWholeArrLength; ++i) {
            this.iaExplosionArr[i][0] = -1979;
            this.iaExplosionArr[i][1] = -1979;
            this.iaExplosionArr[i][2] = -1979;
        }
    }

    public void createExplosionArr(int[] arr) {
        if (this.bExplosion) {
            return;
        }
        this.resetExplosionArray();
        int iCnt = Arrays.intsInArray(arr);
        for (int i = 0; i < iCnt; ++i) {
            int iBlockVal = Arrays.intInArray(this.iaStackedBlocks, i);
            int iRow = iBlockVal / 7;
            int iCol = iBlockVal % 7;
            int iPosX = this.getBlockPosX(iCol);
            int iPosY = Defines.HEIGHT - this.getBlockPosY(iRow) - this.iBlockHeight - this.getBlockHeightWShift();
            boolean bIsLastRow = this.isLastRow(iRow, iCol);
            this.iaExplosionArr[i][0] = iPosX;
            this.iaExplosionArr[i][1] = iPosY;
            this.iaExplosionArr[i][2] = this.iaRows[iRow][iCol];
            this.bExplosion = true;
        }
    }

    public void updateExplosionFrame() {
        if (!this.bExplosion) {
            return;
        }
        if ((this.iDeletingPosY -= 20) < -400) {
            this.resetExplosionArray();
            this.iDeletingPosY = 0;
            this.bExplosion = false;
            this.bHorizontalExplosion = false;
        }
    }

    public void paintDeletingAnimals(Graphics g) {
        int iWholeLength = this.iaExplosionArr.length;
        for (int i = 0; i < iWholeLength; ++i) {
            if (this.iaExplosionArr[i][0] == -1979 || this.iaExplosionArr[i][2] >= 100) continue;
            this.paintAnimalExplosion(this.iaExplosionArr[i][2], this.iaExplosionArr[i][0], this.iaExplosionArr[i][1], g);
        }
    }

    public void update() {
        this.updateExplosionFrame();
        this.updateBonusFrame();
        if (this.iStackedBlocksCnt > 3 || this.iStackedBlocksCnt > 0 && this.bOverScreen || this.bExplosion) {
            this.createExplosionArr(this.iaStackedBlocks);
            this.destroyStackedBlocks();
            Arrays.resetIntsArray(this.iaStackedBlocks);
            this.iStackedBlocksCnt = 0;
            this.bShakeNeeded = !this.bOverScreen;
            this.bOverScreen = false;
            Arrays.resetIntsArray(this.iaStackedBlocks);
            return;
        }
        int iCntMovingDozers = 0;
        for (int i = this.iaNewBlocksBack.length - 1; i >= 0; --i) {
            if (this.iaNewBlocksBack[i] == -1979) continue;
            ++iCntMovingDozers;
            int n = i;
            this.iaNewBlocksBack[n] = this.iaNewBlocksBack[n] - 6;
            if (this.iaNewBlocksBack[i] > 0) continue;
            this.iaNewBlocksBack[i] = -1979;
        }
        boolean bDestroyingBlocks = this.iStackedBlocksCnt > 3 && this.iStackedBlockExplosionDelay > 0 || this.bShakeNeeded;
        int iCntPreparedDozers = 0;
        if (!bDestroyingBlocks) {
            for (int i = this.iaNewBlocks.length - 1; i >= 0; --i) {
                if (this.iaNewBlocks[i] == -1979) continue;
                ++iCntPreparedDozers;
                if (this.iaNewBlocksTime[i] > 0) {
                    if (GameStateCommon.sInstance.iBonusNoBlockTime != 0) continue;
                    int n = i;
                    this.iaNewBlocksTime[n] = this.iaNewBlocksTime[n] - 40;
                    continue;
                }
                ++iCntMovingDozers;
                if (this.iaNewBlocksShift[i] < 100) {
                    int n = i;
                    this.iaNewBlocksShift[n] = this.iaNewBlocksShift[n] + 3;
                    continue;
                }
                this.insertBlock(i, this.iaNewBlocks[i]);
                this.iaNewBlocks[i] = -1979;
                this.iaNewBlocksShift[i] = 0;
                this.iaNewBlocksBack[i] = 100;
            }
            this.updateLastRow();
            if (iCntPreparedDozers == 0 && iCntMovingDozers == 0) {
                Level.sInstance.blocks_initNewBlocks();
            }
        }
        if (Keys.key_num0 && iCntMovingDozers == 0) {
            int i;
            if (iCntPreparedDozers == 0) {
                Level.sInstance.blocks_initNewBlocks();
            }
            int iMinTime = 100000;
            for (i = this.iaNewBlocks.length - 1; i >= 0; --i) {
                if (this.iaNewBlocks[i] == -1979 || this.iaNewBlocksTime[i] >= iMinTime) continue;
                iMinTime = this.iaNewBlocksTime[i];
            }
            for (i = this.iaNewBlocks.length - 1; i >= 0; --i) {
                if (this.iaNewBlocks[i] == -1979) continue;
                int n = i;
                this.iaNewBlocksTime[n] = this.iaNewBlocksTime[n] - iMinTime;
            }
            Keys.key_num0 = false;
        }
        if (this.bShakeNeeded) {
            this.bShakeNeeded = this.shakeBlocks();
            if (!this.bShakeNeeded) {
                int len = Arrays.intsInArray(this.iaBouncedBlocks);
                while (len > 0) {
                    int iCol;
                    int val;
                    int iRow;
                    if (this.iaRows[iRow = (val = Arrays.popIntFromArray(this.iaBouncedBlocks, --len)) / 7][iCol = val % 7] == -1979) continue;
                    Arrays.resetIntsArray(this.iaTestedBlocks);
                    this.markBlocks(this.iaTestedBlocks, iRow, iCol);
                    if (Arrays.intsInArray(this.iaTestedBlocks) <= 3) continue;
                    this.markBlocks(this.iaStackedBlocks, iRow, iCol);
                    this.iStackedBlocksCnt = Arrays.intsInArray(this.iaStackedBlocks);
                    this.iStackedBlockExplosionDelay = 12;
                }
            }
            return;
        }
    }

    private void updateBonusFrame() {
        if (++this.iBonusFrameInc >= 7) {
            this.iBonusFrameInc = 0;
        }
        if (Math.abs(this.iLevitationX += this.iLevitationInc) == 4) {
            this.iLevitationInc *= -1;
        }
    }

    private void resetRows() {
        Debug.traceIn("> Blocks.resetRows()");
        for (int i = 0; i < 10; ++i) {
            Arrays.resetIntsArray(this.iaRows[i]);
        }
        Debug.traceOut("< Blocks.resetRows()");
    }

    public void initBlocks() {
        Debug.traceIn("> Blocks.initBlocks()");
        this.resetRows();
        for (int row = 0; row < Level.sInstance.blocks_getInitialRowsCount(); ++row) {
            for (int col = 0; col < 7; ++col) {
                this.iaRows[row][col] = Common.getRandomUInt(Level.sInstance.blocks_getLevelColors());
            }
        }
        this.bShakeNeeded = false;
        this.bOverScreen = false;
        this.bExplosion = false;
        Arrays.resetIntsArray(this.iaPickedBlocks);
        Arrays.resetIntsArray(this.iaStackedBlocks);
        Arrays.resetIntsArray(this.iaBouncedBlocks);
        Arrays.resetIntsArray(this.iaNewBlocks);
        Arrays.resetIntsArray(this.iaNewBlocksBack);
        this.updateLastRow();
        this.resetExplosionArray();
        Debug.traceOut("< Blocks.initBlocks()");
    }

    public int getBlock(int col, int row) {
        if (col < 0) {
            return -1979;
        }
        if (col >= 7) {
            return -1979;
        }
        if (row < 0) {
            return -1979;
        }
        if (row >= 10) {
            return -1979;
        }
        return this.iaRows[row][col];
    }

    public int getLastBlockPos(int col) {
        int iLastBlock = -1979;
        int iLastRow = -1;
        boolean bDrop = Arrays.intsInArray(this.iaPickedBlocks) > 0;
        int iTop = this.iBoardTop;
        if (bDrop) {
            iTop += this.getBlockHeightWShift();
        }
        for (int row = 0; row < 9; ++row) {
            int iBlock = this.iaRows[row][col];
            if (iBlock == -1979) continue;
            if (!bDrop && iLastBlock == iBlock) {
                if (this.iaRows[row + 1][col] != -1979) continue;
                return iTop + iLastRow * this.getBlockHeightWShift();
            }
            iLastBlock = iBlock;
            iLastRow = row;
            if (this.iaRows[row + 1][col] != -1979) continue;
            return iTop + row * this.getBlockHeightWShift();
        }
        return iTop;
    }

    public boolean isAnyLastRowOverMax() {
        return this.iLastRow >= 9;
    }

    private void updateLastRow() {
        this.iLastRow = 0;
        for (int iRow = 9; iRow >= 1; --iRow) {
            for (int iCol = 0; iCol < 7; ++iCol) {
                int iTmpVal = this.iaRows[iRow][iCol];
                if (iTmpVal == -1979) continue;
                this.iLastRow = iRow;
                return;
            }
        }
    }

    private void insertBlock(int iCol, int iBlock) {
        for (int iRow = 9; iRow >= 1; --iRow) {
            this.iaRows[iRow][iCol] = this.iaRows[iRow - 1][iCol];
        }
        this.iaRows[0][iCol] = iBlock;
    }

    private int pickBlocks(int col) {
        int iLastBlock = -1979;
        int iLastRow = -1;
        Level.sInstance.gssCommon.iBonusComboCnt = 0;
        for (int row = 0; row < 9; ++row) {
            int iBlock = this.getBrickVal(row, col);
            if (iBlock == -1979) continue;
            if (iLastBlock == iBlock && iLastBlock < 100) {
                if (this.iaRows[row + 1][col] != -1979) continue;
                for (int i = iLastRow; i <= row; ++i) {
                    Arrays.addIntToArray(this.iaPickedBlocks, this.iaRows[i][col]);
                    this.iaRows[i][col] = -1979;
                }
                continue;
            }
            iLastBlock = iBlock;
            iLastRow = row;
            if (this.iaRows[row + 1][col] != -1979) continue;
            Arrays.addIntToArray(this.iaPickedBlocks, this.iaRows[row][col]);
            this.iaRows[row][col] = -1979;
        }
        return -1979;
    }

    public boolean canDropBlocks(int col) {
        int iPickedBlocksCnt = Arrays.intsInArray(this.iaPickedBlocks);
        for (int row = 9; row >= 0; --row) {
            if (this.iaRows[row][col] == -1979) continue;
            return row + iPickedBlocksCnt < 10;
        }
        return true;
    }

    private boolean markedBlock(int[] iaBlocksBuffer, int row, int col) {
        return Arrays.arrayContainsInt(iaBlocksBuffer, row * 7 + col);
    }

    private void markBlock(int[] iaBlocksBuffer, int row, int col) {
        Debug.trace("Blocks.markBlock(" + row + "," + col + ") -> [" + this.iaRows[row][col] + "]");
        if (this.iaRows[row][col] == -1979) {
            return;
        }
        Arrays.addUniqueIntToArray(iaBlocksBuffer, row * 7 + col);
    }

    private void markBomb(int[] iaBlocksBuffer, int row, int col) {
        Debug.traceIn("> Blocks.markBomb(" + row + "," + col + ")");
        if (row > 1) {
            this.markBlock(iaBlocksBuffer, row - 2, col);
        }
        if (row > 0) {
            this.markBlock(iaBlocksBuffer, row - 1, col);
            if (col > 0) {
                this.markBlock(iaBlocksBuffer, row - 1, col - 1);
            }
            if (col < 6) {
                this.markBlock(iaBlocksBuffer, row - 1, col + 1);
            }
        }
        if (row < 9) {
            this.markBlock(iaBlocksBuffer, row + 1, col);
            if (col > 0) {
                this.markBlock(iaBlocksBuffer, row - 1, col - 1);
            }
            if (col < 6) {
                this.markBlock(iaBlocksBuffer, row - 1, col + 1);
            }
        }
        if (row < 8) {
            this.markBlock(iaBlocksBuffer, row + 2, col);
        }
        if (col > 0) {
            this.markBlock(iaBlocksBuffer, row, col - 1);
        }
        if (col > 1) {
            this.markBlock(iaBlocksBuffer, row, col - 2);
        }
        if (col < 6) {
            this.markBlock(iaBlocksBuffer, row, col + 1);
        }
        if (col < 5) {
            this.markBlock(iaBlocksBuffer, row, col + 2);
        }
        Debug.traceOut("< Blocks.markBomb()");
    }

    private void markRow(int[] iaBlocksBuffer, int row) {
        Debug.traceIn("> Blocks.markRow(" + row + ")");
        for (int col = 0; col < 7; ++col) {
            this.markBlock(iaBlocksBuffer, row, col);
        }
        Debug.traceOut("< Blocks.markRow()");
    }

    private void markCol(int[] iaBlocksBuffer, int col) {
        Debug.traceIn("> Blocks.markCol(" + col + ")");
        for (int row = 0; row < 10; ++row) {
            this.markBlock(iaBlocksBuffer, row, col);
        }
        Debug.traceOut("< Blocks.markRow()");
    }

    private int getBrickVal(int iRow, int iCol) {
        int iRetVal = this.iaRows[iRow][iCol];
        if (iRetVal >= 200) {
            iRetVal -= 200;
        }
        return iRetVal;
    }

    private void markBlocks(int[] iaBlocksBuffer, int row, int col) {
        int brickVal = this.getBrickVal(row, col);
        if (brickVal == -1979) {
            return;
        }
        Arrays.addUniqueIntToArray(iaBlocksBuffer, row * 7 + col);
        if (row > 0 && this.getBrickVal(row - 1, col) == brickVal && !this.markedBlock(iaBlocksBuffer, row - 1, col)) {
            this.markBlocks(iaBlocksBuffer, row - 1, col);
        }
        if (row < 9 && this.getBrickVal(row + 1, col) == brickVal && !this.markedBlock(iaBlocksBuffer, row + 1, col)) {
            this.markBlocks(iaBlocksBuffer, row + 1, col);
        }
        if (col > 0 && this.getBrickVal(row, col - 1) == brickVal && !this.markedBlock(iaBlocksBuffer, row, col - 1)) {
            this.markBlocks(iaBlocksBuffer, row, col - 1);
        }
        if (col < 6 && this.getBrickVal(row, col + 1) == brickVal && !this.markedBlock(iaBlocksBuffer, row, col + 1)) {
            this.markBlocks(iaBlocksBuffer, row, col + 1);
        }
    }

    private void createBlockExplosion(int xpos, int ypos) {
    }

    private void destroyStackedBlocks() {
        Debug.traceIn("> Blocks.destroyStackedBlocks()");
        int scoreCounter = 0;
        int len = Arrays.intsInArray(this.iaStackedBlocks);
        int labelXpos = 0;
        int labelYpos = 0;
        boolean posAcquired = false;
        for (int i = 0; i < len; ++i) {
            int col;
            int val = Arrays.intInArray(this.iaStackedBlocks, i);
            int row = val / 7;
            if (this.iaRows[row][col = val % 7] == -1979) continue;
            int xpos = col * this.iBlockWidth + this.iBlockWidth / 2;
            int ypos = row * this.iBlockHeight + this.iBlockHeight / 2;
            if (this.iaRows[row][col] >= 200) {
                Bonuses.sInstance.createBonus(xpos - Bonuses.sInstance.iBonusWidth / 2, ypos, Common.getRandomUInt(3));
            }
            this.iaRows[row][col] = -1979;
            this.createBlockExplosion(xpos, ypos);
            if (!posAcquired) {
                labelXpos = xpos;
                labelYpos = ypos;
                posAcquired = true;
            }
            --Level.sInstance.gssCommon.iBlocksToNextLev;
            ++scoreCounter;
        }
        Level.sInstance.gssCommon.iBonusComboCnt = Level.sInstance.gssCommon.iBonusComboCnt + (scoreCounter > 0 ? 1 : 0);
        Debug.trace("iComboCount = " + Level.sInstance.gssCommon.iBonusComboCnt);
        if (Level.sInstance.gssCommon.iBonusComboCnt > 1) {
            ScoreLabels.sInstance.createScoreLabelCombo(Level.sInstance.gssCommon.iBonusComboCnt);
            int iBase = 10;
            if (Level.sInstance.gssCommon.iBonusComboCnt > 5) {
                iBase = 100;
            }
            Level.sInstance.incScore(iBase *= Level.sInstance.gssCommon.iBonusComboCnt);
            ScoreLabels.sInstance.createScoreLabel(labelXpos, labelYpos, iBase);
        }
        int scoreInc = 1;
        if (scoreCounter >= 10) {
            scoreInc = 5;
            Vibrator.vibrate(125);
        } else if (scoreCounter >= 8) {
            scoreInc = 3;
            Vibrator.vibrate(75);
        } else if (scoreCounter >= 6) {
            scoreInc = 2;
            Vibrator.vibrate(50);
        } else {
            Vibrator.vibrate(25);
        }
        int iScoreMul = GameStateCommon.sInstance.iScoreMul;
        if (iScoreMul <= 0) {
            iScoreMul = 1;
        }
        Level.sInstance.incScore(iScoreMul * scoreCounter * scoreInc);
        this.updateLastRow();
        if (iScoreMul > 1) {
            ScoreLabels.sInstance.createScoreLabel(labelXpos, labelYpos, iScoreMul, scoreCounter * scoreInc);
        } else {
            ScoreLabels.sInstance.createScoreLabel(labelXpos, labelYpos, scoreCounter * scoreInc);
        }
        Debug.traceOut("< Blocks.destroyStackedBlocks()");
    }

    private int bricksBelow(int row, int col) {
        int cnt = 0;
        for (int i = row; i < 10; ++i) {
            if (this.iaRows[row][col] == -1979) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean shakeBlocks() {
        for (int i = 0; i < 7; ++i) {
            for (int ii = 0; ii < 10; ++ii) {
                if (this.iaRows[ii][i] != -1979 || this.bricksBelow(ii + 1, i) <= 0) continue;
                Arrays.addUniqueIntToArray(this.iaBouncedBlocks, ii * 7 + i);
                for (int iii = ii + 1; iii < 10; ++iii) {
                    this.iaRows[iii - 1][i] = this.iaRows[iii][i];
                    this.iaRows[iii][i] = -1979;
                }
                return true;
            }
        }
        return false;
    }

    private void dropBlocks(int col) {
        Debug.traceIn("> Blocks.dropBlocks()");
        Debug.trace("col = " + col);
        for (int row = 9; row >= -1; --row) {
            int iBlock = -1979;
            if (row >= 0) {
                iBlock = this.iaRows[row][col];
            }
            if (iBlock == -1979 && row >= 0) continue;
            int iPickedCount = Arrays.intsInArray(this.iaPickedBlocks);
            if (iPickedCount == 1) {
                int iPickedBlock = Arrays.intInArray(this.iaPickedBlocks, 0);
                if (iPickedBlock == 110) {
                    this.iaRows[row + 1][col] = iPickedBlock;
                    Arrays.resetIntsArray(this.iaPickedBlocks);
                    Arrays.resetIntsArray(this.iaStackedBlocks);
                    this.markRow(this.iaStackedBlocks, row + 1);
                    this.createExplosionArr(this.iaStackedBlocks);
                    this.bExplosion = true;
                    this.bHorizontalExplosion = true;
                    X.soundManager.Play(X.SOUND_EXPLOSION_ID, 1);
                    this.iStackedBlocksCnt = Arrays.intsInArray(this.iaStackedBlocks);
                    this.iStackedBlockExplosionDelay = 12;
                    Debug.traceOut("< Blocks.dropBlocks() [column]");
                    return;
                }
                if (iPickedBlock == 120) {
                    this.iaRows[row + 1][col] = iPickedBlock;
                    Arrays.resetIntsArray(this.iaPickedBlocks);
                    Arrays.resetIntsArray(this.iaStackedBlocks);
                    this.markCol(this.iaStackedBlocks, col);
                    this.createExplosionArr(this.iaStackedBlocks);
                    this.bExplosion = true;
                    X.soundManager.Play(X.SOUND_EXPLOSION_ID, 1);
                    this.iStackedBlocksCnt = Arrays.intsInArray(this.iaStackedBlocks);
                    this.iStackedBlockExplosionDelay = 12;
                    Debug.traceOut("< Blocks.dropBlocks() [column]");
                    return;
                }
                if (iPickedBlock == 130) {
                    Arrays.resetIntsArray(this.iaPickedBlocks);
                    Arrays.resetIntsArray(this.iaStackedBlocks);
                    this.markBomb(this.iaStackedBlocks, row + 1, col);
                    this.createExplosionArr(this.iaStackedBlocks);
                    this.bExplosion = true;
                    X.soundManager.Play(X.SOUND_EXPLOSION_ID, 1);
                    this.iStackedBlocksCnt = Arrays.intsInArray(this.iaStackedBlocks);
                    this.iStackedBlockExplosionDelay = 12;
                    Debug.traceOut("< Blocks.dropBlocks() [bomb]");
                    return;
                }
            }
            for (int i = row + 1; i < 10; ++i) {
                this.iaRows[i][col] = Arrays.intInArray(this.iaPickedBlocks, i - (row + 1));
            }
            Arrays.resetIntsArray(this.iaPickedBlocks);
            Arrays.resetIntsArray(this.iaStackedBlocks);
            this.markBlocks(this.iaStackedBlocks, row + 1, col);
            this.iStackedBlocksCnt = Arrays.intsInArray(this.iaStackedBlocks);
            this.iStackedBlockExplosionDelay = 12;
            if (this.iStackedBlocksCnt > 3) {
                GameStateCommon.sInstance.incMultiplier();
            }
            Debug.traceOut("< Blocks.dropBlocks() [marked blocks]");
            return;
        }
        Debug.traceOut("< Blocks.dropBlocks()");
    }

    public void manipulateBlocks(int col) {
        Debug.traceIn("> Blocks.manipulateBlocks()");
        int iPickedBlocksCnt = Arrays.intsInArray(this.iaPickedBlocks);
        if (iPickedBlocksCnt > 0) {
            this.dropBlocks(col);
        } else {
            this.pickBlocks(col);
        }
        this.updateLastRow();
        Debug.traceOut("< Blocks.manipulateBlocks()");
    }

    public int getBlockHeightWShift() {
        return this.iBlockHeight - DSPY_BLOCK_Y_SHIFT;
    }

    private int getBlockPosX(int col) {
        return DSPY_BLOCK_X_SHIFT + col * (this.iBlockWidth + this.iGap);
    }

    private int getBlockPosY(int row) {
        return this.iBoardTop + row * this.getBlockHeightWShift();
    }

    private boolean isLastRow(int iRow, int iCol) {
        if (iRow == 9) {
            return true;
        }
        return this.iaRows[iRow][iCol] != -1979 && this.iaRows[iRow + 1][iCol] == -1979;
    }

    private int getColShift(int col) {
        int ypos = Common.barValue(this.iaNewBlocksShift[col], 100, this.iBoardTop);
        int iRetVal = ypos - (this.iBoardTop - this.getBlockHeightWShift());
        return iRetVal < 0 ? 0 : iRetVal + Common.getRandomInt(3);
    }

    public void paintBlock(Graphics g, int iBlock, int iPosX, int iPosY, boolean bShadow, boolean bShake) {
        int iBousFrame = 0;
        try {
            if (iBlock >= 100) {
                iBousFrame = 0;
                Sprite sprBonus = Resources.sprBonus;
                if (iBlock == 110) {
                    iBousFrame = 2;
                    sprBonus = Resources.sprBonus;
                }
                if (iBlock == 120) {
                    iBousFrame = 1;
                    sprBonus = Resources.sprBonus;
                }
                if (iBlock == 130) {
                    iBousFrame = 0;
                    sprBonus = Resources.sprBonus;
                }
                if (iBlock >= 200) {
                    iBousFrame = 0;
                    sprBonus = Resources.sprBonus;
                    Resources.sprBlocks.setFrame(iBlock - 200);
                    Resources.sprBlocks.setPosition(iPosX, iPosY);
                    Resources.sprBlocks.paint(g);
                }
                if (!bShadow) {
                    sprBonus.setFrame(Math.abs(iBousFrame << 1) + (this.iBonusFrameInc >> 2));
                    sprBonus.setPosition(iPosX, iPosY - 4);
                    sprBonus.paint(g);
                } else {
                    Resources.sprShadows.setFrame(GameStateCommon.sInstance.iStage);
                    Resources.sprShadows.setPosition(iPosX, iPosY + Resources.sprBlocks.getHeight() - Resources.sprShadows.getHeight());
                    Resources.sprShadows.paint(g);
                    sprBonus.setFrame(Math.abs(iBousFrame << 1) + (this.iBonusFrameInc >> 2));
                    sprBonus.setPosition(iPosX, iPosY - 8 + (this.iLevitationX >> 1));
                    sprBonus.paint(g);
                }
            } else {
                if (bShadow) {
                    Resources.sprShadows.setFrame(GameStateCommon.sInstance.iStage);
                    Resources.sprShadows.setPosition(iPosX, iPosY + Resources.sprBlocks.getHeight() - Resources.sprShadows.getHeight());
                    Resources.sprShadows.paint(g);
                }
                if (bShake) {
                    Resources.sprBlocks.setFrame(iBlock);
                    Resources.sprBlocks.setPosition(iPosX + Common.getRandomInt(3), iPosY + Common.getRandomInt(3));
                    Resources.sprBlocks.paint(g);
                } else {
                    Resources.sprBlocks.setFrame(iBlock);
                    Resources.sprBlocks.setPosition(iPosX, iPosY);
                    Resources.sprBlocks.paint(g);
                }
            }
        }
        catch (Exception e) {
            Debug.trace("Blocks.paintBlock() exception -> iBlock = " + iBlock);
        }
    }

    public int getTrasholdY() {
        return Defines.HEIGHT - this.iBoardTop - 11 * this.getBlockHeightWShift();
    }

    public void paint(Graphics g) {
        int iNewPos = Defines.HEIGHT - this.iBoardTop - this.iBlockHeight - 10 * this.getBlockHeightWShift();
        int xpos = DSPY_BLOCK_X_SHIFT;
        int ypos = iNewPos;
        for (int row = 9; row >= 0; --row) {
            xpos = DSPY_BLOCK_X_SHIFT;
            for (int col = 0; col < 7; ++col) {
                int iBlock = this.iaRows[row][col];
                if (iBlock == -1979) {
                    xpos += this.iBlockWidth + this.iGap;
                    continue;
                }
                this.paintBlock(g, iBlock, xpos, ypos - this.getColShift(col), true, row == 8);
                xpos += this.iBlockWidth + this.iGap;
            }
            ypos += this.getBlockHeightWShift();
        }
        ypos = iNewPos;
        xpos = DSPY_BLOCK_X_SHIFT;
        for (int col = 0; col < 7; ++col) {
            int iYPos;
            if (this.iaNewBlocks[col] == -1979) {
                xpos += this.iBlockWidth + this.iGap;
                continue;
            }
            this.iMovingCordY = iYPos = Common.barValue(this.iaNewBlocksShift[col], 100, ypos - INCOMING_DIFF);
            if (iYPos == 0) {
                this.paintBlock(g, this.iaNewBlocks[col], xpos, Defines.HEIGHT - iYPos - this.iBlockHeight, true, false);
            }
            if (iYPos != 0) {
                this.paintBlock(g, this.iaNewBlocks[col], xpos, Defines.HEIGHT - iYPos - this.iBlockHeight + Common.getRandomInt(3), true, false);
            }
            xpos += this.iBlockWidth + this.iGap;
        }
    }

    public boolean isAddingRow() {
        return this.iMovingCordY != 0;
    }

    public void paintAnimalExplosion(int idx, int x, int y, Graphics g) {
        Resources.sprBlocksDeleting.setFrame(idx << 1);
        Resources.sprBlocksDeleting.setPosition(x, y + 80 * this.iDeletingPosY / 100);
        Resources.sprBlocksDeleting.paint(g);
        Resources.sprBlocksDeleting.setFrame((idx << 1) + 1);
        Resources.sprBlocksDeleting.setPosition(x, y + this.iDeletingPosY);
        Resources.sprBlocksDeleting.paint(g);
    }
}

