/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.AppSettings;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.XMLScenario;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.OptionsScreen;
import com.ximad.pvn.screens.PauseScreen;
import com.ximad.pvn.screens.RateItDialog;

public class DataManager {
    private static AppSettings as;
    private static int currentMusicLevel;
    private static int prevMusicLevel;
    private static int currentEffectsLevel;
    private static int prevEffectsLevel;
    private static boolean isSoundEnabled;
    private XMLScenario xmlScenario;
    private int ghost = 0;
    public static boolean isRated;

    public DataManager() {
        as = new AppSettings();
        as.init("PandasVsNinjas_122359132134");
        this.ghost = as.readInt(0);
        this.xmlScenario = new XMLScenario();
        DataManager.setCurrentMusicLvl(as.readInt(50));
        DataManager.setCurrentEffectsLvl(as.readInt(50));
        if (this.ghost == 5) {
            this.loadScenarios();
        } else {
            this.xmlScenario.loadFromXML();
        }
        isRated = as.readBoolean(false);
        RateItDialog.show = !isRated;
    }

    public void saveSettings() {
        as.writeInt(5);
        as.writeInt(currentMusicLevel);
        as.writeInt(currentEffectsLevel);
        this.saveScenarios();
        as.writeBoolean(isRated);
        as.commit();
    }

    public void clearAllLevels() {
        this.xmlScenario.loadFromXML();
    }

    private void loadScenarios() {
        GameParameters.scenarios.clear();
        for (int i = 0; i < 2; ++i) {
            Scenario scenario = new Scenario(i, "scenario" + i, false, 25, 0, 0);
            scenario.load(as);
            for (int j = 0; j < 26; ++j) {
                LevelCompleteStat level = new LevelCompleteStat("level_" + i + "_" + j, 0, 0, false, false, 0, "no", 0, 0, 0, 0, 0L);
                level.load(as);
                scenario.level.add(level);
            }
            GameParameters.scenarios.add(scenario);
        }
        GameParameters.scenarios_size = 2;
    }

    public void saveScenarios() {
        for (int i = 0; i < GameParameters.scenarios.size(); ++i) {
            Scenario scenario = (Scenario)GameParameters.scenarios.get(i);
            scenario.save(as);
            for (int j = 0; j < scenario.level.size(); ++j) {
                ((LevelCompleteStat)scenario.level.get(j)).save(as);
            }
        }
    }

    public static boolean getSoundState() {
        return isSoundEnabled;
    }

    public static void changeSoundState() {
        if (isSoundEnabled) {
            prevMusicLevel = currentMusicLevel;
            prevEffectsLevel = currentEffectsLevel;
            DataManager.setCurrentMusicLvl(0);
            DataManager.setCurrentEffectsLvl(0);
        } else {
            DataManager.setCurrentMusicLvl(prevMusicLevel);
            DataManager.setCurrentEffectsLvl(prevEffectsLevel);
        }
        DataManager.onChangeVolume();
    }

    public static int getCurrentMusicLvl() {
        return currentMusicLevel;
    }

    public static void setCurrentMusicLvl(int lvl) {
        currentMusicLevel = lvl;
        if (lvl > 100) {
            currentMusicLevel = 100;
        }
        if (lvl < 0) {
            currentMusicLevel = 0;
        }
        isSoundEnabled = currentMusicLevel != 0 || currentEffectsLevel != 0;
        SoundSystem.mm.setVolume(currentMusicLevel);
        DataManager.onChangeVolume();
    }

    public static int getCurrentEffectsLvl() {
        return currentEffectsLevel;
    }

    public static void setCurrentEffectsLvl(int lvl) {
        currentEffectsLevel = lvl;
        if (lvl > 100) {
            currentEffectsLevel = 100;
        }
        if (lvl < 0) {
            currentEffectsLevel = 0;
        }
        isSoundEnabled = currentMusicLevel != 0 || currentEffectsLevel != 0;
        SoundSystem.sm.setVolume(currentEffectsLevel);
        DataManager.onChangeVolume();
    }

    private static void onChangeVolume() {
        HomeScreen.getInstance().onVolumeChange();
        OptionsScreen.getInstance().onVolumeChange();
        PauseScreen.getInstance().onVolumeChange();
    }

    static {
        currentMusicLevel = 0;
        prevMusicLevel = 10;
        currentEffectsLevel = 0;
        prevEffectsLevel = 10;
        isSoundEnabled = true;
    }
}

