/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.utils.ArrayList;

public class ObstacleClay
extends Obstacle {
    private static final int DENSITY = 10;
    public float collisionForce = 0.0f;

    public ObstacleClay() {
        this.score = 50;
        this.type = 5006;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        super.OnCollision(obj, force);
        if (obj.typeDinamicalObjects == 101) {
            this.collisionForce = force;
            if (this.collisionForce > 7.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 103) {
            this.collisionForce = force;
            if (this.collisionForce > 6.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 104) {
            this.collisionForce = force;
            if (this.collisionForce > 6.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 102) {
            this.collisionForce = force;
            if (this.collisionForce > 21.0f) {
                this.durability = this.durability == 2 ? 0 : --this.durability;
            } else if (this.collisionForce > 8.0f) {
                --this.durability;
            }
        }
    }

    public void update(long dt) {
        super.update(dt);
        if (this.durability <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy) {
            SoundSystem.SOUND_ON_BRICK_DESTROY.play();
            super.crushObstacle(this);
            this.destroyObstacle();
            ++((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).obstacles;
            ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).score += (long)this.score;
        } else if (MyWorld.onPlay) {
            this.defaultFrame = this.nFrames - this.durability;
        }
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        ObstacleClay obj = new ObstacleClay();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 99;
        obj.isCrushable = true;
        obj.density = 10;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage("clay_rect1", shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        ObstacleClay obj = new ObstacleClay();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 99;
        obj.isCrushable = true;
        obj.density = 10;
        obj.angle = angle;
        obj.isStatic = sstatic;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x, int y, int R, String imageName) {
        ObstacleClay obj = new ObstacleClay();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 90;
        obj.isCircle = true;
        obj.isCrushable = true;
        obj.density = 10;
        obj.radius = R;
        obj.isStatic = sstatic;
        shape.add(new Point(x, y));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, String imageName, int angle) {
        ObstacleClay obj = new ObstacleClay();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 90;
        obj.isCrushable = true;
        obj.density = 10;
        obj.angle = angle;
        obj.isTriangle = true;
        obj.isStatic = sstatic;
        obj.imageName = imageName;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }
}

