/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.DataManager;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.SelectLevelScreen;
import javax.microedition.lcdui.Graphics;

public class PauseScreen
extends UiScreen {
    private static PauseScreen instance;
    private Bitmap farBackground;
    private CustomButton btSound;
    private CustomLabelField level;

    public PauseScreen() {
        CustomButton btRestart = new CustomButton(Textures.pauseRestart, Textures.pauseRestart, null){

            protected void touchAction() {
                GameScreen.getInstance().restart();
                Application.setScreen(GameScreen.getInstance());
            }
        };
        CustomButton btSelectLevel = new CustomButton(Textures.pauseSelectLevel, Textures.pauseSelectLevel, null){

            protected void touchAction() {
                Application.setScreen(SelectLevelScreen.getInstance());
                SoundSystem.SOUND_MAIN_THEME.playInLoop();
            }
        };
        CustomButton btMainMenu = new CustomButton(Textures.pauseMainMenu, Textures.pauseMainMenu, null){

            protected void touchAction() {
                Application.setScreen(HomeScreen.getInstance());
                SoundSystem.SOUND_MAIN_THEME.playInLoop();
            }
        };
        CustomButton btBack = new CustomButton(Textures.pauseBack, Textures.pauseBack, null){

            protected void touchAction() {
                Application.setScreen(GameScreen.getInstance());
            }
        };
        this.btSound = new CustomButton(Textures.pauseSoundOff, Textures.pauseSoundOn, null){

            protected void touchAction() {
                DataManager.changeSoundState();
            }
        };
        this.level = new CustomLabelField("", 30, 0xFFFFFF);
        this.add(btRestart, 220, 40);
        this.add(btSelectLevel, 220, 150);
        this.add(btMainMenu, 220, 240);
        this.add(btBack, 0, 240);
        this.add(this.btSound, 540, 260);
        this.add(this.level, 100, 80);
    }

    public void onPaint(Graphics g) {
        if (this.farBackground != null) {
            this.farBackground.draw(g, 0, 0);
        }
        Textures.pausePause.draw(g, 220, 0);
        super.onPaint(g);
    }

    public void setFon(Bitmap image) {
        this.farBackground = image;
        this.farBackground.setDark(150);
    }

    public void setText(String text) {
        this.level.setText(text);
    }

    public static PauseScreen getInstance() {
        if (instance == null) {
            instance = new PauseScreen();
        }
        return instance;
    }

    public void onVolumeChange() {
        if (DataManager.getCurrentEffectsLvl() == 0 && DataManager.getCurrentMusicLvl() == 0) {
            this.btSound.setOffImage(Textures.pauseSoundOff);
            this.btSound.setOnImage(Textures.pauseSoundOff);
        } else {
            this.btSound.setOffImage(Textures.pauseSoundOn);
            this.btSound.setOnImage(Textures.pauseSoundOn);
        }
    }

    public void onShow() {
        this.onVolumeChange();
        PauseScreen.repaint();
    }
}

