/*
 * Decompiled with CFR 0.152.
 */
package com.game.script;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ScriptParse {
    private InputStream is;
    private ByteArrayOutputStream bos;
    public String readValue;
    public int value;

    public void loadScriptFile(String file) {
        this.is = this.getClass().getResourceAsStream(file);
        this.bos = new ByteArrayOutputStream();
    }

    public String readFile() throws IOException {
        byte[] tempData = new byte[1024];
        while (this.is.read(tempData) != -1) {
            this.bos.write(tempData);
        }
        byte[] byteScript = this.bos.toByteArray();
        String str = new String(byteScript, "UTF-8");
        this.bos.close();
        return str;
    }

    public void close() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.bos != null) {
                this.bos.flush();
                this.bos.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final String[] splitStr(String source, String splitStr) {
        if (source == null || splitStr == null) {
            return null;
        }
        int startIndex = 0;
        String[] returnStrArr = null;
        while (startIndex < source.length()) {
            String[] tmp;
            int splitIndex = source.indexOf(splitStr, startIndex);
            if (splitIndex != -1) {
                if (!source.substring(startIndex, splitIndex).equals("")) {
                    if (returnStrArr == null) {
                        returnStrArr = new String[1];
                    } else {
                        tmp = new String[returnStrArr.length + 1];
                        System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                        returnStrArr = tmp;
                    }
                    returnStrArr[returnStrArr.length - 1] = source.substring(startIndex, splitIndex);
                }
                startIndex = splitIndex + splitStr.length();
                continue;
            }
            if (source.substring(startIndex).equals("")) break;
            if (returnStrArr == null) {
                returnStrArr = new String[1];
            } else {
                tmp = new String[returnStrArr.length + 1];
                System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                returnStrArr = tmp;
            }
            returnStrArr[returnStrArr.length - 1] = source.substring(startIndex);
            break;
        }
        return returnStrArr;
    }
}

