/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballGrape
extends SpriteX
implements ICannonball {
    private int speed;
    private int cannonballId;
    private int state;
    private int xspeed;
    private int hp;
    private int yspeed;
    private RectCoordinate rect = null;

    public CannonballGrape(byte[] path, Image img, int id, int xspeed, int yspeed) {
        super(path, img);
        this.setAction(0);
        this.cannonballId = id;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
        this.rect = new RectCoordinate();
        this.rect.setHeight(20);
        this.rect.setWidth(this.getWidth());
    }

    public int getCannonballId() {
        return this.cannonballId;
    }

    public void logic() {
        if (this.y <= -70) {
            this.state = 1;
            this.setVisible(false);
        }
        switch (this.state) {
            case 0: {
                this.move(-this.xspeed, -this.speed);
                break;
            }
            case 4: {
                if (this.getFrame() < this.getSequenceLength() - 1) break;
                this.setState(1);
                this.setVisible(false);
            }
        }
    }

    public final void paint(Graphics2D g) {
        super.paint(g);
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        this.setAction(1);
        this.setState(4);
        monster.changeState(4);
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

