/*
 * Decompiled with CFR 0.152.
 */
package com.game.sprite;

import com.game.sprite.Layer;
import com.game.util.Graphics2D;
import com.game.util.Tools;
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class SpriteX
extends Layer {
    public static final byte TRANS_NONE = 0;
    private static final byte TRANS_ROT90 = 5;
    private static final byte TRANS_ROT180 = 3;
    private static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR = 2;
    private static final byte TRANS_MIRROR_ROT90 = 7;
    private static final byte TRANS_MIRROR_ROT180 = 1;
    private static final byte TRANS_MIRROR_ROT270 = 4;
    private static final byte TILED_OFF_SIZE = 4;
    private static final byte FRAME_HEADER_SIZE = 8;
    private static final byte FRAME_TILE_COUNT_BIT = 1;
    private static final byte FRAME_COLLISION_COUNT_BIT = 2;
    private static final byte FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    private static final byte FRAME_TOP_POS_BIT = 4;
    private static final byte FRAME_BOTTOM_POS_BIT = 5;
    private static final byte FRAME_LEFT_POS_BIT = 6;
    private static final byte FRAME_RIGHT_POS_BIT = 7;
    private static final byte ACTION_HEADER_SIZE = 3;
    private static final byte ACTION_SEQUENCE_LENGTH_BIT = 1;
    private static final byte ACTION_SEQUENCE_DELAY_BIT = 2;
    private static final byte[][] TRANSFORM_TABLE = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    private static final byte[][] ROTATE_TABLE = new byte[][]{{6, 5, 2, 1}, {7, 4, 3, 0}, {4, 7, 0, 3}, {5, 6, 1, 2}, {1, 2, 5, 6}, {0, 3, 4, 7}, {3, 0, 7, 4}, {2, 1, 6, 5}};
    private short[][] actionData;
    public byte actionCount;
    private byte[] actionTrans;
    private short[][] frameData;
    protected byte frameCount;
    private short[] tileData;
    private byte actionIndex;
    private byte sequenceIndex;
    private long lastTime;
    private boolean firstUpdate;
    private boolean disableUpdate;
    private Image image;
    private int updateType = -1;

    public SpriteX() {
    }

    public SpriteX(String spxName) {
        this(Tools.loadFile(spxName), null);
    }

    public SpriteX(String spxName, Image image) {
        this(Tools.loadFile(spxName), image);
    }

    public SpriteX(String spxName, String imageName) {
        this(spxName, Tools.loadImage(imageName));
    }

    public SpriteX(byte[] data, Image image) {
        this.loadSpx(data, image);
    }

    private final void loadSpx(byte[] spxdata, Image image) {
        try {
            short j;
            int offset;
            short length;
            short i;
            if (spxdata == null) {
                return;
            }
            DataInputStream data = Tools.convertStream(spxdata);
            data.readInt();
            data.readByte();
            data.readByte();
            short tileCount = (short)data.readInt();
            if (image != null) {
                this.image = image;
                this.tileData = new short[tileCount * 4];
                int off = 0;
                for (i = 0; i < tileCount; i = (short)(i + 1)) {
                    this.tileData[off + 0] = data.readShort();
                    this.tileData[off + 1] = data.readShort();
                    this.tileData[off + 2] = data.readShort();
                    this.tileData[off + 3] = data.readShort();
                    off += 4;
                }
            } else {
                for (i = 0; i < tileCount; i = (short)(i + 1)) {
                    data.readShort();
                    data.readShort();
                    data.readShort();
                    data.readShort();
                }
            }
            this.frameCount = (byte)data.readInt();
            this.frameData = new short[this.frameCount][];
            for (i = 0; i < this.frameCount; i = (short)(i + 1)) {
                short frameTileCount = (short)data.readInt();
                short collisionCount = (short)data.readInt();
                short referencePointCount = (short)data.readInt();
                length = (short)(8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2);
                this.frameData[i] = new short[length];
                this.frameData[i][0] = length;
                this.frameData[i][1] = frameTileCount;
                this.frameData[i][2] = collisionCount;
                this.frameData[i][3] = referencePointCount;
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                this.frameData[i][6] = data.readShort();
                this.frameData[i][7] = data.readShort();
                offset = 8;
                for (j = 0; j < frameTileCount; j = (short)(j + 1)) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset = (short)(offset + 4);
                }
                for (j = 0; j < collisionCount; j = (short)(j + 1)) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset = (short)(offset + 4);
                }
                for (j = 0; j < referencePointCount; j = (short)(j + 1)) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    offset = (short)(offset + 2);
                }
            }
            this.actionCount = (byte)data.readInt();
            this.actionData = new short[this.actionCount][];
            this.actionTrans = new byte[this.actionCount];
            for (i = 0; i < this.actionCount; i = (short)(i + 1)) {
                short sequenceLength = (short)data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? (short)(3 + sequenceLength * 3) : (short)(3 + sequenceLength);
                this.actionData[i] = new short[length];
                this.actionData[i][0] = length;
                this.actionData[i][1] = sequenceLength;
                this.actionData[i][2] = delay;
                this.setTransform(i, (byte)data.readInt(), true);
                offset = 3;
                if (delay == 1) {
                    for (j = 0; j < sequenceLength; j = (short)(j + 1)) {
                        this.actionData[i][offset] = data.readShort();
                        this.actionData[i][offset + 1] = data.readShort();
                        offset = (short)(offset + 3);
                    }
                    continue;
                }
                for (j = 0; j < sequenceLength; j = (short)(j + 1)) {
                    this.actionData[i][offset] = (byte)data.readShort();
                    offset = (short)(offset + 1);
                }
            }
            this.visible = true;
            data.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SpriteX(SpriteX spx) {
        this.copySpriteX(spx);
    }

    public final void copySpriteX(SpriteX spx) {
        this.actionCount = spx.actionCount;
        this.frameCount = spx.frameCount;
        this.tileData = spx.tileData;
        this.frameData = spx.frameData;
        this.actionData = spx.actionData;
        this.image = spx.image;
        this.actionTrans = new byte[this.actionCount];
        System.arraycopy(spx.actionTrans, 0, this.actionTrans, 0, this.actionCount);
        this.actionIndex = spx.actionIndex;
        this.sequenceIndex = spx.sequenceIndex;
        this.x = spx.x;
        this.y = spx.y;
        this.offsetX = spx.offsetX;
        this.offsetY = spx.offsetY;
        this.visible = spx.visible;
        this.width = spx.width;
        this.height = spx.height;
        this.lastTime = spx.lastTime;
        this.firstUpdate = spx.firstUpdate;
        this.disableUpdate = spx.disableUpdate;
    }

    public final void updateType(int updateType) {
        this.updateType = updateType;
    }

    public final void enableUpdate(boolean enable) {
        if (this.disableUpdate && enable) {
            this.lastTime = System.currentTimeMillis();
        }
        this.disableUpdate = !enable;
    }

    public final void setAction(int actionIndex) {
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            throw new IndexOutOfBoundsException("" + actionIndex);
        }
        this.actionIndex = (byte)actionIndex;
        this.enableUpdate(true);
        this.sequenceIndex = 0;
        this.firstUpdate = false;
    }

    public void setFrame(int sequenceIndex) {
        this.sequenceIndex = (byte)sequenceIndex;
        this.firstUpdate = false;
    }

    public final void setTransform(byte transform, boolean isPos) {
        this.setTransform(this.actionIndex, transform, isPos);
    }

    public final void setTransform(int actionIndex, byte transform, boolean isPos) {
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        this.actionTrans[actionIndex] = (byte)((isPos ? 1 : 0) << 4 | transform & 0xF);
    }

    public final void setTransform(byte transform) {
        this.setTransform(transform, true);
    }

    public final void setAllTransFromMirror(int index) {
        for (int i = 0; i < this.actionCount; ++i) {
            this.setTransform(i, (byte)index, true);
        }
    }

    public final void horizontalAll() {
        for (int i = 0; i < this.actionCount; ++i) {
            this.setTransform(i, ROTATE_TABLE[this.actionTrans[i] & 0xF][2], true);
        }
    }

    protected final void setDelayTime(int actionIndex, short time) {
        if (actionIndex <= 0 || actionIndex >= this.actionCount) {
            throw new ArrayIndexOutOfBoundsException("set delay time:" + actionIndex);
        }
        int framelen = this.actionData[actionIndex][1];
        for (int j = 0; j < framelen; ++j) {
            this.actionData[actionIndex][3 + j * 3 + 2] = time;
        }
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public final int getAction() {
        return this.actionIndex;
    }

    private final byte getTransform() {
        if (this.actionCount > 0) {
            return this.actionTrans[this.actionIndex];
        }
        return 0;
    }

    public int getSequenceFrame(int sequenceIndex) {
        return this.getSequenceFrame(this.actionIndex, sequenceIndex);
    }

    public int getSequenceFrame() {
        return this.getSequenceFrame(this.actionIndex, this.sequenceIndex);
    }

    public int getSequenceFrame(int action, int frame) {
        if (this.isDelay()) {
            return this.actionData[action][3 + frame * 3];
        }
        return this.actionData[action][3 + frame];
    }

    public final int getSequenceLength() {
        return this.actionData[this.actionIndex][1];
    }

    private final boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    private final int getDelayTime() {
        int off = 3 + this.sequenceIndex * 3 + 1;
        return this.actionData[this.actionIndex][off] + this.actionData[this.actionIndex][off + 1];
    }

    public final int getReferencePointX0(int index) {
        return this.getReferencePointX(0, index, true);
    }

    public final int getReferencePointY0(int index) {
        return this.getReferencePointY(0, index, true);
    }

    public final int getReferencePointX(int index) {
        return this.getReferencePointX(this.sequenceIndex, index, false);
    }

    public final int getReferencePointY(int index) {
        return this.getReferencePointY(this.sequenceIndex, index, false);
    }

    private final int getReferencePointX(int sequenceIndex, int index, boolean is1) {
        int frameIndex = this.getSequenceFrame(sequenceIndex);
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refX = this.frameData[frameIndex][offset];
        if ((this.getTransform() & 0xF) == 2) {
            refX = -refX;
        }
        int rx = refX + (is1 ? 0 : this.x);
        return rx;
    }

    private final int getReferencePointY(int sequenceIndex, int index, boolean is1) {
        int frameIndex = this.getSequenceFrame(sequenceIndex);
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refY = this.frameData[frameIndex][offset + 1];
        int ry = refY + (is1 ? 0 : this.y);
        return ry;
    }

    public final int getCollidesX(int action, int frame, int index) {
        int temframe = this.getSequenceFrame(action, frame);
        if (index < 0 || index >= this.frameData[temframe][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[temframe][1] * 4 + index * 4;
        return this.frameData[temframe][offset] + this.x;
    }

    public final int getCollidesY(int action, int frame, int index) {
        int temframe = this.getSequenceFrame(action, frame);
        if (index < 0 || index >= this.frameData[temframe][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[temframe][1] * 4 + index * 4 + 1;
        return this.frameData[temframe][offset] + this.y;
    }

    public final int getCollidesWidth(int action, int frame, int index) {
        int temframe = this.getSequenceFrame(action, frame);
        if (index < 0 || index >= this.frameData[temframe][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[temframe][1] * 4 + index * 4 + 2;
        return this.frameData[temframe][offset];
    }

    public final int getCollidesHeight(int action, int frame, int index) {
        int temframe = this.getSequenceFrame(action, frame);
        if (index < 0 || index >= this.frameData[temframe][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[temframe][1] * 4 + index * 4 + 3;
        return this.frameData[temframe][offset];
    }

    public final int getCollidesX(int index) {
        return this.getCollidesX(this.actionIndex, this.sequenceIndex, index);
    }

    public final int getCollidesY(int index) {
        return this.getCollidesY(this.actionIndex, this.sequenceIndex, index);
    }

    public final int getCollidesWidth(int index) {
        return this.getCollidesWidth(this.actionIndex, this.sequenceIndex, index);
    }

    public final int getCollidesHeight(int index) {
        return this.getCollidesHeight(this.actionIndex, this.sequenceIndex, index);
    }

    public final int getFrameTopPos() {
        return this.getFrameTopPos(this.getSequenceFrame());
    }

    protected final int getFrameBottomPos() {
        return this.getFrameBottomPos(this.getSequenceFrame());
    }

    public final int getFrameLeft() {
        return this.frameData[this.getSequenceFrame()][6];
    }

    public final int getFrameTop() {
        return this.frameData[this.getSequenceFrame()][4];
    }

    public final int getFrameLeftPos() {
        return this.getFrameLeftPos(this.getSequenceFrame());
    }

    protected final int getFrameRightPos() {
        return this.getFrameRightPos(this.getSequenceFrame());
    }

    public final int getFrameTopPos(int frame) {
        return this.frameData[frame][4] + this.y;
    }

    private final int getFrameBottomPos(int frame) {
        return this.frameData[frame][5] + this.y;
    }

    private final int getFrameLeftPos(int frame) {
        return this.frameData[frame][6] + this.x;
    }

    private final int getFrameRightPos(int frame) {
        return this.frameData[frame][7] + this.x;
    }

    public int getWidth() {
        return this.getWidth(this.actionIndex, this.sequenceIndex);
    }

    public int getHeight() {
        return this.getHeight(this.actionIndex, this.sequenceIndex);
    }

    public final int getWidth(int actionIndex, int frameIndex) {
        this.width = (short)(this.getFrameRightPos(this.getSequenceFrame(actionIndex, frameIndex)) - this.getFrameLeftPos(this.getSequenceFrame(actionIndex, frameIndex)));
        return this.width;
    }

    public final int getHeight(int actionIndex, int frameIndex) {
        this.height = (short)(this.getFrameBottomPos(this.getSequenceFrame(actionIndex, frameIndex)) - this.getFrameTopPos(this.getSequenceFrame(actionIndex, frameIndex)));
        return this.height;
    }

    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.paint(g, this.x + this.offsetX, this.y + this.offsetY);
        if (this.actionCount > 0) {
            this.updateNxet();
        }
    }

    public final void paint(Graphics2D g, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int tw = 1;
        int th = 1;
        short tx = 0;
        short ty = 0;
        int frameIndex = this.getSequenceFrame();
        int tileCount = this.frameData[frameIndex][1];
        int offset = 8;
        int actionTransform = this.getTransform() & 0xF;
        boolean isPos = (this.getTransform() >> 4 & 0xFF) == 1;
        for (int i = 0; i < tileCount; ++i) {
            short tileIndex = this.frameData[frameIndex][0 + offset];
            int dx = this.frameData[frameIndex][1 + offset] + x;
            int dy = this.frameData[frameIndex][2 + offset] + y;
            short transform = this.frameData[frameIndex][3 + offset];
            if (this.tileData != null) {
                int index = tileIndex * 4;
                tx = this.tileData[index];
                ty = this.tileData[index + 1];
                tw = this.tileData[index + 2];
                th = this.tileData[index + 3];
            }
            if (actionTransform != 0) {
                int cx = x - dx;
                int cy = y - dy;
                transform = TRANSFORM_TABLE[transform][actionTransform];
                if (isPos) {
                    switch (actionTransform) {
                        case 0: {
                            break;
                        }
                        case 5: {
                            dx = x - (th - cy);
                            dy = y - cx;
                            break;
                        }
                        case 3: {
                            dx = x - (tw - cx);
                            dy = y - (th - cy);
                            break;
                        }
                        case 6: {
                            dx = x - cy;
                            dy = y - (tw - cx);
                            break;
                        }
                        case 2: {
                            dx = x - (tw - cx);
                            break;
                        }
                        case 7: {
                            dx = x - (th - cy);
                            dy = y - (tw - cx);
                            break;
                        }
                        case 1: {
                            dy = y - (th - cy);
                            break;
                        }
                        case 4: {
                            dx = x - cy;
                            dy = y - cx;
                        }
                    }
                }
            }
            if (Tools.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                this.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy);
            }
            offset += 4;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void drawRegion(Graphics2D g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, 20);
    }

    public void lastFrame() {
    }

    public final void nextFrame() {
        if (this.sequenceIndex >= this.getSequenceLength() - 1) {
            this.lastFrame();
            if (this.updateType == -1) {
                this.sequenceIndex = 0;
            } else {
                this.disableUpdate = true;
            }
            return;
        }
        this.sequenceIndex = (byte)Tools.returnItemIndex(this.sequenceIndex, this.getSequenceLength(), 1);
        this.firstUpdate = false;
    }

    private final void update(long time) {
        if (this.disableUpdate) {
            return;
        }
        if (this.isDelay()) {
            int dms;
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = time;
            }
            if (time - this.lastTime >= (long)(dms = this.getDelayTime())) {
                this.nextFrame();
                this.lastTime = time;
            }
        } else {
            this.nextFrame();
        }
    }

    protected final void updateNxet() {
        this.update(System.currentTimeMillis());
    }

    public final boolean isCollewith(SpriteX sprite) {
        if (this.getX() + this.getWidth() > sprite.getX() + sprite.getWidth() && this.getY() + this.getHeight() > sprite.getY() + sprite.getHeight()) {
            return true;
        }
        return sprite.getX() + sprite.getWidth() > this.getX() + this.getWidth() && sprite.getY() + sprite.getHeight() > this.getY() + this.getHeight();
    }
}

