/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.component;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.component.Field;
import com.ximad.zuminja.engine.DataManager;
import javax.microedition.lcdui.Graphics;

public class CustomButton
extends Field {
    private static final int NORMAL = 0;
    private static final int PRESSED = 1;
    private Bitmap imgPressed;
    private Bitmap imgDefault;
    private Bitmap imgFocused;
    private int status;
    private boolean btnState = true;
    private Bitmap image;
    private int normalIndex;
    private int pressedIndex;
    private boolean isChecked;
    private Bitmap imgChecked;

    public CustomButton(Bitmap offImage, Bitmap onImage, Bitmap focusImage) {
        if (offImage != null) {
            this.imgDefault = offImage;
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.imgPressed = onImage;
        this.imgFocused = focusImage;
    }

    public void setCheckState(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public CustomButton(String offImage, String onImage, String focusImage) {
        if (offImage != null) {
            this.imgDefault = Bitmap.getBitmapResource(offImage);
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.imgPressed = Bitmap.getBitmapResource(onImage);
        this.imgFocused = Bitmap.getBitmapResource(focusImage);
    }

    public CustomButton(Bitmap offImage, Bitmap onImage, Bitmap focusImage, Bitmap checkedImage) {
        if (offImage != null) {
            this.imgDefault = offImage;
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.imgPressed = onImage;
        this.imgFocused = focusImage;
        this.imgChecked = checkedImage;
    }

    public CustomButton(String offImage, String onImage, String focusImage, String checkedImage) {
        if (offImage != null) {
            this.imgDefault = Bitmap.getBitmapResource(offImage);
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.imgPressed = Bitmap.getBitmapResource(onImage);
        this.imgFocused = Bitmap.getBitmapResource(focusImage);
        this.imgChecked = Bitmap.getBitmapResource(checkedImage);
    }

    public CustomButton(Bitmap image, int normalIndex, int pressedIndex) {
        this.image = image;
        this.width = image.getTileWidth();
        this.height = image.getTileHeight();
        this.normalIndex = normalIndex;
        this.pressedIndex = pressedIndex;
    }

    public void setOffImage(Bitmap offImagePath) {
        this.imgDefault = offImagePath;
        this.status = 0;
    }

    public void setOnImage(Bitmap onImagePath) {
        this.imgPressed = onImagePath;
        this.status = 1;
    }

    public void setOffImage(int index) {
        this.normalIndex = index;
        this.status = 0;
    }

    public void setOnImage(int index) {
        this.pressedIndex = index;
        this.status = 1;
    }

    public void onPaint(Graphics g) {
        switch (this.status) {
            case 0: {
                if (this.isChecked) {
                    if (this.imgChecked != null) {
                        this.imgChecked.draw(g, this.left, this.top);
                    }
                    return;
                }
                if (this.image != null) {
                    this.image.drawSprite(g, this.left, this.top, this.normalIndex);
                    break;
                }
                if (this.imgDefault == null) break;
                this.imgDefault.draw(g, this.left, this.top);
                break;
            }
            case 1: {
                if (this.image != null) {
                    this.image.drawSprite(g, this.left, this.top, this.pressedIndex);
                    break;
                }
                if (this.imgPressed == null) break;
                this.imgPressed.draw(g, this.left, this.top);
            }
        }
        if (this.show_coords) {
            g.drawString("left: " + this.left + " / top: " + this.top, this.left, this.top, 0);
        }
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        if (!this.btnState) {
            return !out;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.setOnImage(this.imgPressed);
                this.repaint();
                break;
            }
            case 1: {
                this.setOffImage(this.imgDefault);
                if (!out) {
                    DataManager.playButtonSound();
                    this.touchAction();
                    break;
                }
                this.repaint();
            }
        }
        return !out;
    }

    protected void touchAction() {
    }

    public void set_btn_state(boolean b) {
        this.btnState = b;
    }
}

