/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.engine;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.engine.AppSettings;
import com.ximad.zuminja.engine.SoundHandler;
import com.ximad.zuminja.game.Arc;
import com.ximad.zuminja.game.Level;
import com.ximad.zuminja.game.LevelConsts;
import com.ximad.zuminja.game.LevelWithBackground;
import com.ximad.zuminja.game.PackedGame;
import com.ximad.zuminja.game.Path;
import com.ximad.zuminja.game.Point;
import java.util.Vector;
import javax.microedition.media.MediaException;

public class DataManager {
    public static boolean isRated;
    public static int launchNumber;
    public static Bitmap adPopup;
    static AppSettings appSettings;
    static Vector levels;
    static Vector backgrounds;
    static Vector levelWithBackground;
    public static String[] names;
    public static long[] scores;
    public static boolean[] lockedLevels;
    public static boolean[] lockedStages;
    private static SoundHandler soundHandler;
    private static boolean isSoundEnabled;
    private static int currentSoundLevel;
    private static int sound;

    public DataManager() {
        adPopup = Bitmap.getBitmapResource("/img/360x640/rate_it/ad_popup.png");
        appSettings = new AppSettings();
        soundHandler = new SoundHandler();
        this.loadLevels();
        this.initSettings();
        this.loadSettings();
    }

    public static boolean isHighScore(long score) {
        for (int i = 0; i < 10; ++i) {
            if (score <= scores[i]) continue;
            return true;
        }
        return false;
    }

    public static int getLevelsCount() {
        return levels.size();
    }

    public static Level getLevelAt(int index) {
        return (Level)levels.elementAt(index);
    }

    public static int getLevelWithBackgroundCount() {
        return levelWithBackground.size();
    }

    public static LevelWithBackground getLevelWithBackgroundAt(int index) {
        return (LevelWithBackground)levelWithBackground.elementAt(index);
    }

    public static Bitmap getBackgroundAt(int index) {
        return (Bitmap)backgrounds.elementAt(index);
    }

    public void loadLevels() {
        int i;
        levels = new Vector();
        backgrounds = new Vector();
        for (i = 0; i < 20; ++i) {
            backgrounds.addElement(Bitmap.getBitmapResource("/img/360x640/background/" + String.valueOf(i) + ".jpg"));
        }
        for (i = 0; i < 20; ++i) {
            Point[] deathZones = new Point[LevelConsts.deathZones[i][0] + 1];
            for (int j = 0; j < LevelConsts.deathZones[i][0]; ++j) {
                deathZones[j] = new Point(LevelConsts.deathZones[i][2 * j + 1], LevelConsts.deathZones[i][2 * j + 2]);
            }
            deathZones[LevelConsts.deathZones[i][0]] = null;
            int arcsCount = LevelConsts.levels[i][0];
            Arc[] arcs = new Arc[arcsCount];
            int j = 1;
            for (int k = 0; k < arcsCount; ++k) {
                Point endPoint;
                Point startPoint;
                if (LevelConsts.levels[i][++j - 1] == 0) {
                    startPoint = new Point(LevelConsts.levels[i][j], LevelConsts.levels[i][j + 1]);
                    endPoint = new Point(LevelConsts.levels[i][j += 2], LevelConsts.levels[i][j + 1]);
                    j += 2;
                    arcs[k] = new Arc(startPoint, endPoint);
                    continue;
                }
                if (LevelConsts.levels[i][j - 1] == 1) {
                    startPoint = arcs[k - 1].getEndPoint();
                    endPoint = new Point(LevelConsts.levels[i][j], LevelConsts.levels[i][j + 1]);
                    arcs[k] = new Arc(startPoint, endPoint);
                    j += 2;
                    continue;
                }
                Point centerPoint = new Point(LevelConsts.levels[i][j], LevelConsts.levels[i][j + 1]);
                arcs[k] = new Arc(centerPoint, LevelConsts.levels[i][j += 2], LevelConsts.levels[i][j + 1], LevelConsts.levels[i][j + 2], LevelConsts.levels[i][j + 3]);
                j += 4;
            }
            int pipeIndex = LevelConsts.levels[i][j];
            Point pipePoint = new Point(LevelConsts.levels[i][j + 1], LevelConsts.levels[i][j + 2]);
            int bridgeIndex = LevelConsts.levels[i][j += 3];
            Point bridgePoint = new Point(LevelConsts.levels[i][j + 1], LevelConsts.levels[i][j + 2]);
            levels.addElement(new Level(new Point(LevelConsts.levelPoints[i][0], LevelConsts.levelPoints[i][1]), LevelConsts.ballsCount[i], new Path(arcs, arcsCount), deathZones, pipeIndex, pipePoint, bridgeIndex, bridgePoint));
        }
        levelWithBackground = new Vector();
        for (i = 0; i < 20; ++i) {
            levelWithBackground.addElement(new LevelWithBackground(LevelWithBackground.levels[i][0][0], LevelWithBackground.levels[i][1], LevelWithBackground.levels[i][2][0]));
        }
    }

    public void initSettings() {
        isRated = false;
        launchNumber = 1;
        names = new String[10];
        scores = new long[10];
        lockedLevels = new boolean[4];
        DataManager.lockedLevels[0] = true;
        lockedStages = new boolean[20];
        DataManager.lockedStages[0] = true;
        isSoundEnabled = true;
        currentSoundLevel = 50;
        DataManager.setCurrentSoundLvl(currentSoundLevel);
    }

    public static void endLevel(int level) {
        for (int i = 0; i < 4; ++i) {
            if (LevelConsts.LEVEL_POINTS[i] > level + 1) continue;
            DataManager.lockedLevels[i] = true;
        }
        if (level + 1 < 20) {
            DataManager.lockedStages[level + 1] = true;
        }
    }

    public void loadSettings() {
        try {
            appSettings.init("ZuminjaSettings");
            appSettings.start();
            isSoundEnabled = appSettings.readBoolean(true);
            currentSoundLevel = appSettings.readInt(50);
            lockedLevels = appSettings.readBooleanArray(4);
            lockedStages = appSettings.readBooleanArray(20);
            isRated = appSettings.readBoolean(false);
            launchNumber = appSettings.readInt(0) + 1;
            names = appSettings.readStringArray(10, "INVALID_NAME");
            scores = appSettings.readLongArray(10);
            DataManager.lockedLevels[0] = true;
            DataManager.lockedStages[0] = true;
            DataManager.setCurrentSoundLvl(currentSoundLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveSettings() {
        try {
            appSettings.init("ZuminjaSettings");
            appSettings.start();
            appSettings.writeBoolean(isSoundEnabled);
            appSettings.writeInt(currentSoundLevel);
            appSettings.writeBooleanArray(lockedLevels, 4);
            appSettings.writeBooleanArray(lockedStages, 20);
            appSettings.writeBoolean(isRated);
            appSettings.writeInt(launchNumber);
            appSettings.writeStringArray(names, 10);
            appSettings.writeLongArray(scores, 10);
            appSettings.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PackedGame loadLevel() {
        try {
            if (!appSettings.isElementExists("ZuminjaLevel")) {
                return null;
            }
            appSettings.init("ZuminjaLevel");
            appSettings.start();
            PackedGame packedGame = new PackedGame();
            packedGame.loadPackedGame(appSettings);
            return packedGame;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int addScore(String playerName, long score) {
        for (int i = 0; i < 10; ++i) {
            if (scores[i] >= score && names[i] != null) continue;
            for (int j = 9; j > i; --j) {
                DataManager.scores[j] = scores[j - 1];
                DataManager.names[j] = names[j - 1];
            }
            DataManager.names[i] = playerName;
            DataManager.scores[i] = score;
            return i;
        }
        return -1;
    }

    public static void setName(String playerName, int id) {
        if (id != -1) {
            DataManager.names[id] = playerName;
        }
    }

    public static void resetScores() {
        for (int i = 0; i < 10; ++i) {
            DataManager.names[i] = "INVALID_NAME";
            DataManager.scores[i] = 0L;
        }
    }

    public static void saveLevel(PackedGame packedGame) {
        try {
            appSettings.init("ZuminjaLevel");
            appSettings.start();
            packedGame.savePackedGame(appSettings);
            appSettings.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeLevelData() {
        appSettings.removeElement("ZuminjaLevel");
    }

    public static boolean isSavedGameEnabled() {
        return appSettings.isElementExists("ZuminjaLevel");
    }

    public static int getCurrentSoundLvl() {
        return currentSoundLevel;
    }

    public static void setCurrentSoundLvl(int lvl) {
        currentSoundLevel = lvl;
        try {
            soundHandler.setSoundLvl(currentSoundLevel);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public static void stopSound() {
        soundHandler.stopSound();
    }

    public static void playMenuSound() {
        soundHandler.playSoundInLoop("/audio/menu_main.mp3");
    }

    public static void playButtonSound() {
        soundHandler.playSound("/audio/button.mp3");
    }

    public static void playWinSound() {
        soundHandler.playSound("/audio/win1.mp3");
    }

    public static void playLooseSound() {
        soundHandler.playSound("/audio/loose_sound.mp3");
    }

    public static void playPopupSound() {
        soundHandler.playSound("/audio/popup.mp3");
    }

    public static void playLeftPopupSound() {
        soundHandler.playSound("/audio/lives_left_popup.mp3");
    }

    public static void playHoleSound() {
        soundHandler.playSound("/audio/manhole.mp3");
    }

    public static void playDestroySound() {
    }

    public static void playGameSound(int i) {
        if (i != -1) {
            sound = i + 1;
        }
        soundHandler.playSoundInLoop("/audio/" + String.valueOf(sound) + ".mp3");
    }

    public static void playStartSound() {
        soundHandler.playSound("/audio/start.mp3");
    }

    public static void playShotSound() {
    }

    public static boolean getSoundState() {
        return isSoundEnabled;
    }

    public static void setSoundState(boolean state) {
        isSoundEnabled = state;
    }
}

