/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.game.Point;

public class Arc {
    Point center;
    int radius;
    double startDegree;
    double endDegree;
    int type;
    int length;
    boolean direction;
    Point beginPoint;
    Point endPoint;

    public Arc(Point center, int radius, double startDegree, double endDegree, int direction) {
        this.center = center;
        this.radius = radius;
        this.startDegree = startDegree;
        this.endDegree = endDegree;
        this.beginPoint = new Point();
        this.endPoint = new Point();
        this.type = 0;
        this.direction = direction >= 0;
        double degree = startDegree - endDegree;
        if (degree < 0.0) {
            degree += 360.0;
        }
        if (this.direction) {
            degree = 360.0 - degree;
        }
        this.length = (int)(Math.PI * 2 * (double)radius * degree / 360.0);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public Arc(Point point1, Point point2) {
        this.type = 1;
        this.center = new Point();
        this.beginPoint = point1;
        this.endPoint = point2;
        this.length = (int)Math.sqrt((point1.x - point2.x) * (point1.x - point2.x) + (point1.y - point2.y) * (point1.y - point2.y));
    }

    public Point getBeginPoint() {
        return this.beginPoint;
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public Point getCenter() {
        return this.center;
    }

    public int getRadius() {
        return this.radius;
    }

    public double getStartDegree() {
        return this.startDegree;
    }

    public double getEndDegree() {
        return this.endDegree;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }
}

