/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.engine.Consts;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.engine.Utils;
import com.ximad.zuminja.game.Arc;
import com.ximad.zuminja.game.Path;
import com.ximad.zuminja.game.Point;

public class Ball {
    boolean movable;
    boolean isVisible;
    int state;
    int type;
    double currentX;
    int cx;
    int cy;
    int bonus;
    int bonusTick;

    public int getBonus() {
        return this.bonus;
    }

    public int getBonusTick() {
        return this.bonusTick;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus;
    }

    public void setBonusTick(int bonusTick) {
        this.bonusTick = bonusTick;
    }

    public void nextTick() {
        if (this.bonusTick != 0) {
            --this.bonusTick;
        }
        if (this.bonusTick == 0) {
            this.bonus = -1;
        }
    }

    public Ball(double d, int level) {
        this.currentX = d;
        this.movable = true;
        this.isVisible = false;
        this.state = -1;
        this.type = Utils.nextInt(Consts.BALL_TYPES_COUNT[level]);
        this.bonus = -1;
        this.bonusTick = 0;
    }

    public Ball(double d, int type, int state, boolean visible, boolean movable, Path path, int bonus, int bonusTick) {
        this.movable = movable;
        this.isVisible = visible;
        this.state = state;
        this.type = type;
        this.currentX = d;
        this.bonus = bonus;
        this.bonusTick = bonusTick;
        Point thisPoint = Ball.getPoint(path, this.currentX);
        if (thisPoint == null) {
            return;
        }
        this.cx = thisPoint.x;
        this.cy = thisPoint.y;
    }

    public boolean nextState() {
        if (this.state == -1) {
            return false;
        }
        if (this.state + 1 == 8) {
            return true;
        }
        ++this.state;
        return false;
    }

    public int getState() {
        if (this.state == -1) {
            return -1;
        }
        return this.state / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public Bitmap getBallImage() {
        if (this.state == -1) {
            return Resources.getBallImage(this.type);
        }
        return Resources.getFrame(this.type, this.state / 3);
    }

    public static Point getPoint(Path path, double currentX) {
        int tempX = (int)currentX;
        if (tempX < 0) {
            return null;
        }
        for (int i = 0; i < path.getArcsCount(); ++i) {
            int cy;
            int cx;
            Arc currentArc = path.getArc(i);
            if (currentArc.getLength() < tempX) {
                tempX -= currentArc.getLength();
                continue;
            }
            float percent = (float)tempX / (float)currentArc.getLength();
            if (currentArc.getType() == 1) {
                cx = Utils.round((float)currentArc.beginPoint.x + (float)(currentArc.endPoint.x - currentArc.beginPoint.x) * percent);
                cy = Utils.round((float)currentArc.beginPoint.y + (float)(currentArc.endPoint.y - currentArc.beginPoint.y) * percent);
            } else {
                percent = 1.0f - percent;
                double startDegree = currentArc.getStartDegree();
                if (startDegree < currentArc.getEndDegree()) {
                    startDegree += 360.0;
                }
                double degree = startDegree - currentArc.getEndDegree();
                if (currentArc.getDirection()) {
                    degree = 360.0 - degree;
                    degree *= (double)(1.0f - percent);
                    degree += currentArc.getStartDegree();
                } else {
                    degree *= (double)percent;
                    degree += currentArc.getEndDegree();
                }
                cx = Utils.round((double)currentArc.getCenter().x + Math.cos(Math.toRadians(degree)) * (double)currentArc.getRadius());
                cy = Utils.round((double)currentArc.getCenter().y - Math.sin(Math.toRadians(degree)) * (double)currentArc.getRadius());
            }
            return new Point(cx, cy);
        }
        return null;
    }

    public void move(Path path, double speed) {
        if (!this.movable) {
            return;
        }
        this.currentX += speed;
        if (this.currentX <= 0.0) {
            return;
        }
        this.isVisible = true;
        int tempX = (int)this.currentX;
        Point point = Ball.getPoint(path, this.currentX);
        if (point == null) {
            this.movable = false;
            this.isVisible = false;
        } else {
            this.cx = point.x;
            this.cy = point.y;
        }
    }

    public double getCurrentX() {
        return this.currentX;
    }

    public int getCX() {
        return this.cx;
    }

    public int getCY() {
        return this.cy;
    }

    public int getType() {
        return this.type;
    }

    public void setCurrentX(double currentX, Path path) {
        this.currentX = currentX;
        this.isVisible = true;
        Point point = Ball.getPoint(path, currentX);
        if (point == null) {
            this.movable = false;
            this.isVisible = false;
        } else {
            this.cx = point.x;
            this.cy = point.y;
        }
    }

    public void setType(int type) {
        this.type = type;
    }
}

