/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.game.FlyingBall;
import com.ximad.zuminja.game.Point;
import com.ximad.zuminja.game.Track;

public class Launcher {
    FlyingBall currentBall;
    FlyingBall nextBall;
    Point launcherPoint;
    Point ballPoint;
    int angle = 90;
    int nextBallType = -1;
    int nextNextBallType = -1;
    private int level;

    public void rotate(boolean direction) {
        this.angle = direction ? (this.angle += 15) : (this.angle -= 15);
        this.angle += 360;
        this.angle %= 360;
    }

    public Launcher(Point launcherPoint, Track[] tracks, int trackCount, int level) {
        this.launcherPoint = launcherPoint;
        this.level = level;
        this.currentBall = null;
        this.nextBall = new FlyingBall(tracks, trackCount, level);
        this.nextBallType = FlyingBall.getType(tracks, trackCount);
        this.ballPoint = new Point();
    }

    public Launcher(Point launcherPoint, Track[] tracks, int trackCount, int currentBallType, int nextBallType, int nextNextBallType, int level) {
        this.launcherPoint = launcherPoint;
        this.level = level;
        this.currentBall = null;
        if (nextNextBallType != -1) {
            this.nextBall = new FlyingBall(currentBallType, level);
            this.nextBallType = nextBallType;
            this.nextNextBallType = nextNextBallType;
        } else {
            this.nextBall = new FlyingBall(currentBallType, level);
            this.nextBallType = nextBallType;
            this.nextNextBallType = -1;
        }
        this.ballPoint = new Point();
    }

    public Point getPoint() {
        int angle = (this.angle + 353) % 360;
        int angle90 = angle % 90 / 15;
        int resultAngle = angle / 90 * 90 + angle90 * 15 + 11;
        Point tempPoint = new Point((int)((double)this.launcherPoint.x + 27.0 * Math.cos(Math.toRadians(resultAngle))), (int)((double)this.launcherPoint.y - 27.0 * Math.sin(Math.toRadians(resultAngle))));
        return tempPoint;
    }

    public FlyingBall getCurrentBall() {
        return this.currentBall;
    }

    public FlyingBall getNextBall() {
        return this.nextBall;
    }

    public int getNextBallType() {
        return this.nextBallType;
    }

    public void launch(Track[] tracks, int tracksCount) {
        DataManager.playShotSound();
        this.currentBall = this.nextBall;
        this.nextBall = new FlyingBall(this.nextBallType, this.level);
        if (this.nextNextBallType != -1) {
            this.nextBallType = this.nextNextBallType;
            this.nextNextBallType = -1;
        } else {
            this.nextBallType = FlyingBall.getType(tracks, tracksCount);
        }
    }

    public void setAngle(int angle) {
        angle += 360;
        this.angle = angle %= 360;
    }

    public Point getBallPoint() {
        return this.ballPoint;
    }

    public Point getCanonPoint() {
        return this.launcherPoint;
    }

    public void setBallPoint(Point ballPoint) {
        this.ballPoint = new Point(ballPoint);
    }

    public void breakLaunch() {
        this.currentBall = null;
    }

    public int getAngle() {
        return this.angle;
    }
}

