/*
 * Decompiled with CFR 0.152.
 */
package CatchCock;

import CatchCock.Vector2D;
import CatchCock.mMath;
import CatchCock.main;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball {
    float mR;
    float mM;
    Vector2D v;
    Vector2D p;
    boolean ballCreated = false;
    boolean mBasket;
    boolean killMe = false;
    float width = 320.0f;
    float height = 480.0f;
    float mouseX;
    float mouseY;
    float mFriction = 0.03f;
    String TAG = "Ball";
    int mCounter = 0;
    int mCounter2 = 0;
    int mCounter3 = 0;
    int type;
    int img_no;
    Image mBallimg;

    Ball() {
        this.p = new Vector2D(this.width, this.height);
        this.v = new Vector2D();
    }

    Ball(float w, float h) {
        this.width = w;
        this.height = h;
        this.p = new Vector2D(this.width * 2.0f, this.height * 2.0f);
        this.v = new Vector2D();
    }

    void set(float _x, float _y, float _r, float _vx, float _vy, Image Img, boolean _killme, int _type) {
        this.p.SetCartesian(_x, _y);
        this.v.SetCartesian(_vx, _vy);
        this.killMe = _killme;
        this.mR = _r;
        this.mM = this.mR * 0.1f;
        this.mBallimg = Img;
        this.mCounter = 0;
        this.mCounter2 = 0;
        this.mCounter3 = 0;
        this.type = _type;
    }

    public void createBall(int flag, boolean basket, float x, float y) {
        this.mouseX = x;
        this.mouseY = y;
        this.mBasket = basket;
        this.createVelocity(flag);
        this.createRadius();
        this.img_no = 0;
        this.ballCreated = true;
    }

    double GetAngle(double d, double e) {
        if (d == 0.0) {
            return (int)(e >= 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        }
        if (d > 0.0) {
            return mMath.atan(e / d);
        }
        return mMath.atan(e / d) + Math.PI;
    }

    private void createVelocity(int flag) {
        float dis = Math.min(this.dist(this.p.x, this.p.y, this.mouseX, this.mouseY), 300.0f);
        float ang = (float)this.GetAngle(this.p.y - (double)this.mouseY, this.p.x - (double)this.mouseX);
        dis = flag;
        this.v.x = (float)((double)dis * Math.sin(ang));
        this.v.y = (float)((double)dis * Math.cos(ang));
    }

    private void createRadius() {
        this.mM = this.mR * 0.1f;
    }

    private double map(float dis, int i, int j, int k, int l) {
        float kk = (float)Math.sqrt((float)(j + l) / (dis + (float)l));
        return kk;
    }

    void update(Graphics c, float x, float y) {
        if (this.ballCreated) {
            this.p.sub(this.v);
            ++this.mCounter3;
            ++this.mCounter2;
            this.draw(c);
        }
    }

    void checkBoundaryCollision() {
        if (this.p.x > (double)(this.width - this.mR)) {
            this.p.x = this.width - this.mR;
            this.v.x *= -1.0;
        } else if (this.p.x < (double)this.mR) {
            this.p.x = this.mR;
            this.v.x *= -1.0;
        } else if (this.p.y > (double)(this.height - this.mR)) {
            this.p.y = this.height - this.mR;
            this.v.y *= -1.0;
        } else if (this.p.y < (double)this.mR) {
            this.p.y = this.mR;
            this.v.y *= -1.0;
        }
    }

    boolean checkObjectCollision(Ball _b) {
        Ball oBall = _b;
        if (this.ballCreated && oBall.ballCreated) {
            Vector2D bVect = new Vector2D();
            bVect.x = oBall.p.x - this.p.x;
            bVect.y = oBall.p.y - this.p.y;
            float bVectMag = (float)Math.sqrt(bVect.x * bVect.x + bVect.y * bVect.y);
            if (bVectMag < this.mR + oBall.mR) {
                float theta = (float)mMath.atan(bVect.y / bVect.x);
                float sine = (float)Math.sin(theta);
                float cosine = (float)Math.cos(theta);
                Ball[] bTemp = new Ball[]{new Ball(), new Ball()};
                bTemp[1].p.x = (double)cosine * bVect.x + (double)sine * bVect.y;
                bTemp[1].p.y = (double)cosine * bVect.y - (double)sine * bVect.x;
                Vector2D[] vTemp = new Vector2D[]{new Vector2D(), new Vector2D()};
                vTemp[0].x = (double)cosine * this.v.x + (double)sine * this.v.y;
                vTemp[0].y = (double)cosine * this.v.y - (double)sine * this.v.x;
                vTemp[1].x = (double)cosine * oBall.v.x + (double)sine * oBall.v.y;
                vTemp[1].y = (double)cosine * oBall.v.y - (double)sine * oBall.v.x;
                Vector2D[] vFinal = new Vector2D[]{new Vector2D(), new Vector2D()};
                vFinal[0].x = ((double)(this.mM - oBall.mM) * vTemp[0].x + (double)(2.0f * oBall.mM) * vTemp[1].x) / (double)(this.mM + oBall.mM);
                vFinal[0].y = vTemp[0].y;
                vFinal[1].x = ((double)(oBall.mM - this.mM) * vTemp[1].x + (double)(2.0f * this.mM) * vTemp[0].x) / (double)(this.mM + oBall.mM);
                vFinal[1].y = vTemp[1].y;
                bTemp[0].p.x += vFinal[0].x;
                bTemp[1].p.x += vFinal[1].x;
                Ball[] bFinal = new Ball[]{new Ball(), new Ball()};
                bFinal[0].p.x = (double)cosine * bTemp[0].p.x - (double)sine * bTemp[0].p.y;
                bFinal[0].p.y = (double)cosine * bTemp[0].p.y + (double)sine * bTemp[0].p.x;
                bFinal[1].p.x = (double)cosine * bTemp[1].p.x - (double)sine * bTemp[1].p.y;
                bFinal[1].p.y = (double)cosine * bTemp[1].p.y + (double)sine * bTemp[1].p.x;
                oBall.p.x = this.p.x + bFinal[1].p.x;
                oBall.p.y = this.p.y + bFinal[1].p.y;
                this.p.x += bFinal[0].p.x;
                this.p.y += bFinal[0].p.y;
                this.v.x = (double)cosine * vFinal[0].x - (double)sine * vFinal[0].y;
                this.v.y = (double)cosine * vFinal[0].y + (double)sine * vFinal[0].x;
                oBall.v.x = (double)cosine * vFinal[1].x - (double)sine * vFinal[1].y;
                oBall.v.y = (double)cosine * vFinal[1].y + (double)sine * vFinal[1].x;
                return true;
            }
        }
        return false;
    }

    public boolean getKillMe() {
        return this.killMe;
    }

    void drawLine(Graphics g) {
        g.drawLine((int)this.p.x, (int)this.p.y, (int)this.mouseX, (int)this.mouseY);
    }

    void drawCreationBall(Graphics c) {
        this.ellipse(c, (float)this.p.x, (float)this.p.y, this.mR * 2.0f, this.mR * 2.0f);
    }

    private void draw(Graphics c) {
        this.ellipse(c, (float)this.p.x, (float)this.p.y, this.mR, this.mR);
    }

    private float dist(double x, double y, double x2, double y2) {
        return (float)Math.sqrt((x - x2) * (x - x2) + (y - y2) * (y - y2));
    }

    private void ellipse(Graphics c, float x, float y, float f, float g) {
        if (this.mBallimg != null && this.mBasket) {
            if (this.v.x != 0.0 && this.v.y != 0.0 && this.mCounter3 < 20) {
                ++this.mCounter3;
            }
            if (x > 0.0f && x < 48.0f) {
                this.img_no = 4;
            }
            if (x >= 48.0f && x < 96.0f) {
                this.img_no = 3;
            }
            if (x >= 96.0f && x < 144.0f) {
                this.img_no = 2;
            }
            if (x >= 192.0f && x < 240.0f) {
                this.img_no = 1;
            }
            if (x >= 240.0f && x < 288.0f) {
                this.img_no = 0;
            }
            c.drawImage(main.mImg_Tokri1[this.img_no], (int)x - this.mBallimg.getWidth() / 2, (int)y - this.mBallimg.getHeight() / 2, 0);
        }
    }

    public void NewcreateVelocity(boolean flag, float xx, float yy) {
        float dis = Math.min(this.dist(this.p.x, this.p.y, xx, yy), 300.0f);
        float ang = (float)this.GetAngle(this.p.y - (double)yy, this.p.x - (double)xx);
        dis = flag ? (float)this.map(dis, 0, 100, 0, 20) : 0.0f;
        this.v.x = (float)((double)dis * Math.sin(ang));
        this.v.y = (float)((double)dis * Math.cos(ang));
    }

    public void oppcreateVelocity(float speed, float xx, float yy) {
        float ang = (float)this.GetAngle((double)yy - this.p.y, (double)xx - this.p.x);
        this.v.x = (float)((double)speed * Math.sin(ang));
        this.v.y = (float)((double)speed * Math.cos(ang));
    }

    void ballFriction() {
        if (this.v.x > 0.0) {
            this.v.x -= (double)this.mFriction;
        }
        if (this.v.x < 0.0) {
            this.v.x += (double)this.mFriction;
        }
        if (this.v.y > 0.0) {
            this.v.y -= (double)this.mFriction;
        }
        if (this.v.y < 0.0) {
            this.v.y += (double)this.mFriction;
        }
    }
}

