/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.engine;

import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.utils.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bitmap {
    private static final int MAX_CACHED_RGB_SIZE = 10000;
    private String name;
    private Image image;
    private int[] rgbData;
    private int width;
    private int height;
    private static int[] sharedBufferSrc;
    private static int[] sharedBufferTransform;
    private int tilesCountX;
    private int spriteWidth;
    private int spriteHeight;
    private static int countt;
    private static int s;
    private static int[] xx;
    private static int[] yy;
    private static int[] newX;
    private static int[] newY;
    private static int[] yMinusRefYTimesDegSin;
    private static int[] yMinusRefYTimesDegCos;

    private Bitmap(Bitmap source) {
        this.image = null;
        this.name = source.name;
        this.width = source.width;
        this.height = source.height;
        this.spriteWidth = source.spriteWidth;
        this.spriteHeight = source.spriteHeight;
    }

    public Bitmap(Image image) {
        this.image = image;
        this.name = "";
        try {
            this.width = image.getWidth();
            this.height = image.getHeight();
        }
        catch (Exception e) {
            this.width = 0;
            this.height = 0;
        }
    }

    public Bitmap(String name) {
        try {
            this.image = Image.createImage((String)name);
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        }
        catch (Exception e) {
            Utils.log("ERROR new Bitmap() " + name + " // text = " + e.getMessage());
        }
        Utils.log(name + " - Loaded " + ++countt + " images, total    " + (s += this.width * this.height) / 1024 + " kilopixels");
        this.name = name;
    }

    public Bitmap(String name, int width, int height) {
        this.name = name;
        try {
            this.image = Image.createImage((String)name);
        }
        catch (Exception e) {
            Utils.log("ERROR new Bitmap() " + name + "  " + width + " x " + height);
            return;
        }
        int srcWidth = this.image.getWidth();
        int srcHeight = this.image.getHeight();
        if (srcWidth != width || srcHeight != height) {
            int[] srcRgb = new int[srcWidth * srcHeight];
            this.image.getRGB(srcRgb, 0, srcWidth, 0, 0, srcWidth, srcHeight);
            int[] scaledRgb = Bitmap.scale(width, height, srcWidth, srcWidth, srcHeight, srcRgb);
            this.image = Image.createRGBImage((int[])scaledRgb, (int)width, (int)height, (boolean)true);
            srcRgb = null;
            scaledRgb = null;
        }
        this.width = width;
        this.height = height;
    }

    public Bitmap(Image img, int width, int height) {
        this.name = "";
        this.image = img;
        int srcWidth = this.image.getWidth();
        int srcHeight = this.image.getHeight();
        if (srcWidth != width || srcHeight != height) {
            int[] srcRgb = new int[srcWidth * srcHeight];
            this.image.getRGB(srcRgb, 0, srcWidth, 0, 0, srcWidth, srcHeight);
            int[] scaledRgb = Bitmap.scale(width, height, srcWidth, srcWidth, srcHeight, srcRgb);
            this.image = Image.createRGBImage((int[])scaledRgb, (int)width, (int)height, (boolean)false);
            srcRgb = null;
            scaledRgb = null;
        }
        this.width = width;
        this.height = height;
    }

    public void draw(Graphics g, int x, int y) {
        if (this.image != null && x < 360 && x + this.width > 0 && y < 640 && y + this.height > 0) {
            g.drawImage(this.image, x, y, 20);
        }
    }

    public void draw2(Graphics g, int x, int y) {
        if (this.image != null) {
            g.drawRegion(this.image, 0, 0, this.width, this.height, 0, x, y, 0);
        }
    }

    public void drawFlag(Graphics g, int x, int y, int flag) {
        if (this.image != null) {
            g.drawImage(this.image, x, y, flag);
        }
    }

    public void drawTexture(Graphics g, int x, int y, int xx, int yy) {
        if (this.image == null) {
            return;
        }
        for (int tempX = x; tempX < xx; tempX += this.width) {
            for (int tempY = y; tempY < yy; tempY += this.height) {
                int _width = this.width;
                int _height = this.height;
                if (tempX + this.width > xx) {
                    _width = xx - tempX;
                }
                if (tempY + this.height > yy) {
                    _height = yy - tempY;
                }
                g.drawRegion(this.image, 0, 0, _width, _height, 0, tempX, tempY, 0);
            }
        }
    }

    public void setDark(int value) {
        int[] srcRgb = new int[this.width * this.height];
        int val = 255 - value;
        this.image.getRGB(srcRgb, 0, this.width, 0, 0, this.width, this.height);
        for (int i = 0; i < srcRgb.length; ++i) {
            int pix = srcRgb[i];
            int r = pix >> 16 & 0xFF;
            int g = pix >> 8 & 0xFF;
            int b = pix & 0xFF;
            r = r * val >> 8;
            g = g * val >> 8;
            b = b * val >> 8;
            srcRgb[i] = b | g << 8 | r << 16 | pix & 0xFF000000;
        }
        this.image = Image.createRGBImage((int[])srcRgb, (int)this.width, (int)this.height, (boolean)true);
    }

    private boolean drawRotated90n(Graphics g, int x, int y, int referenceX, int referenceY, int angle) {
        if (angle >= 355 || angle <= 5) {
            if (x > Application.screenWidth || x + this.width < 0 || y > Application.screenHeight || y + this.height < 0) {
                return true;
            }
            this.draw(g, x, y);
            return true;
        }
        if (angle >= 85 && angle <= 95) {
            if (x > Application.screenWidth || referenceX + this.height / 2 < 0 || y > Application.screenHeight || referenceY + this.width / 2 < 0) {
                return true;
            }
            g.drawRegion(this.image, 0, 0, this.width, this.height, 5, referenceX - this.height / 2, referenceY - this.width / 2, 20);
            return true;
        }
        if (angle >= 175 && angle <= 185) {
            if (x > Application.screenWidth || x + this.width < 0 || y > Application.screenHeight || y + this.height < 0) {
                return true;
            }
            g.drawRegion(this.image, 0, 0, this.width, this.height, 3, x, y, 20);
            return true;
        }
        if (angle >= 265 && angle <= 275) {
            if (x > Application.screenWidth || referenceX + this.height / 2 < 0 || y > Application.screenHeight || referenceY + this.width / 2 < 0) {
                return true;
            }
            g.drawRegion(this.image, 0, 0, this.width, this.height, 6, referenceX - this.height / 2, referenceY - this.width / 2, 20);
            return true;
        }
        return false;
    }

    public void drawRotated(Graphics g, int x, int y, int referenceX, int referenceY, int angle) {
        if ((angle %= 360) % 90 == 0) {
            this.drawRotated90n(g, x, y, referenceX, referenceY, angle);
            return;
        }
        float anf = (float)(Math.PI * (double)angle / 180.0);
        float cos = (float)Math.cos(anf);
        float sin = (float)Math.sin(anf);
        Bitmap.xx[0] = x - referenceX;
        Bitmap.xx[1] = x - referenceX + this.width;
        Bitmap.xx[2] = x - referenceX + this.width;
        Bitmap.xx[3] = x - referenceX;
        Bitmap.yy[0] = y - referenceY;
        Bitmap.yy[1] = y - referenceY;
        Bitmap.yy[2] = y - referenceY + this.height;
        Bitmap.yy[3] = y - referenceY + this.height;
        for (int i = 0; i < 4; ++i) {
            Bitmap.newX[i] = Bitmap.round((float)xx[i] * cos - (float)yy[i] * sin) + referenceX;
            Bitmap.newY[i] = Bitmap.round((float)yy[i] * cos + (float)xx[i] * sin) + referenceY;
        }
        int minX = newX[0];
        int minY = newY[0];
        int maxX = newX[0];
        int maxY = newY[0];
        for (int i = 1; i < 4; ++i) {
            if (minX > newX[i]) {
                minX = newX[i];
            }
            if (minY > newY[i]) {
                minY = newY[i];
            }
            if (maxX < newX[i]) {
                maxX = newX[i];
            }
            if (maxY >= newY[i]) continue;
            maxY = newY[i];
        }
        if (maxX < 0 || minX > Application.screenWidth || maxY < 0 || minY > Application.screenHeight) {
            return;
        }
        this.drawRotatedImage(sin, cos, minX, minY, 0, 0, g);
    }

    public void drawRotatedCenter(Graphics g, int x, int y, int angle) {
        int halfX = this.width / 2;
        int halfY = this.height / 2;
        this.drawRotated(g, x - halfX, y - halfY, x, y, angle);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.image;
    }

    public static int[] scale(int scaledWidth, int scaledHeight, int scanlength, int sourceWidth, int sourceHeight, int[] rgbData) {
        int[] scaledRgbData = new int[scaledWidth * scaledHeight];
        for (int y = 0; y < scaledHeight; ++y) {
            int c1 = y * scaledWidth;
            int c2 = y * sourceHeight / scaledHeight * scanlength;
            for (int x = 0; x < scaledWidth; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + x * sourceWidth / scaledWidth];
            }
        }
        return scaledRgbData;
    }

    private void drawRotatedImage(float sin, float cos, int x, int y, int referenceX, int referenceY, Graphics g) {
        if (this.image == null) {
            return;
        }
        int[] rgb = this.getSourceImageRGB();
        int rotatedWidth = this.getRotatedWidth(cos, sin);
        int rotatedHeight = this.getRotatedHeight(cos, sin);
        int size = rotatedWidth * rotatedHeight;
        int[] rotatedRgb = Bitmap.getSharedBufferTransform(size);
        for (int i = 0; i < size; ++i) {
            rotatedRgb[i] = 0;
        }
        this.rotate(rgb, referenceX, referenceY, 0xFFFFFF, cos, sin, rotatedRgb, rotatedWidth, rotatedHeight);
        g.drawRGB(rotatedRgb, 0, rotatedWidth, x, y, rotatedWidth, rotatedHeight, true);
    }

    public Bitmap rotateImage(float angRad) {
        int w = this.width;
        int h = this.height;
        Bitmap newBitmap = new Bitmap(this);
        int[] oldData = new int[w * h];
        int[] newData = new int[w * h];
        this.image.getRGB(oldData, 0, w, 0, 0, w, h);
        int axisX = w / 2;
        int axisY = h / 2;
        for (int x = 0; x < oldData.length; ++x) {
            int oldX = x % w;
            int oldY = x / w;
            int op = oldX - axisX;
            int adj = oldY - axisY;
            float oldTg = Utils.atan2(op, adj);
            float rad = (float)Math.sqrt(op * op + adj * adj);
            float newTg_1 = oldTg + angRad;
            int newX = Utils.round((float)((double)rad * Math.sin(newTg_1) + (double)axisX));
            int newY = Utils.round((float)((double)rad * Math.cos(newTg_1) + (double)axisY));
            newData[x] = newX < 0 || newY < 0 || newX >= w || newY >= h ? 0 : oldData[newY * w + newX];
        }
        newBitmap.image = Image.createRGBImage((int[])newData, (int)w, (int)h, (boolean)true);
        return newBitmap;
    }

    public void setRgbData(int[] rgbData) {
        this.rgbData = rgbData;
    }

    protected static int round(float value) {
        if (value < 0.0f) {
            return (int)((double)value - 0.5);
        }
        return (int)((double)value + 0.5);
    }

    private void rotate(int[] sourceRgbData, int referenceX, int referenceY, int backgroundColor, float degreeCos, float degreeSin, int[] rotatedRGB, int rotatedWidth, int rotatedHeight) {
        int halfOfWidth = this.width / 2;
        int halfOfHeight = this.height / 2;
        int halfOfRotatedHeight = rotatedHeight / 2;
        int halfOfRotatedWidth = rotatedWidth / 2;
        int degCos = (int)(1024.0f * degreeCos);
        int degSin = (int)(1024.0f * degreeSin);
        int rotatedHeightMinus1 = rotatedHeight - 1;
        int rgbDataLen = this.width * this.height - 1;
        int maxWidth = this.width - 1;
        if (yMinusRefYTimesDegSin == null || yMinusRefYTimesDegSin.length < rotatedHeight) {
            yMinusRefYTimesDegSin = new int[rotatedHeight];
            yMinusRefYTimesDegCos = new int[rotatedHeight];
        }
        for (int y = 0; y < rotatedHeight; ++y) {
            Bitmap.yMinusRefYTimesDegSin[y] = halfOfWidth + ((y - halfOfRotatedHeight) * degSin >> 10);
            Bitmap.yMinusRefYTimesDegCos[y] = halfOfHeight + ((y - halfOfRotatedHeight) * degCos >> 10);
        }
        int x = -1;
        while (++x < rotatedWidth) {
            int xMinusRefXTimesDegCosXPlusHalfWidth = (x - halfOfRotatedWidth) * degCos >> 10;
            int xMinusRefXTimesDegSinXMinusHalfOfHeight = (x - halfOfRotatedWidth) * degSin >> 10;
            int y = -1;
            while (++y < rotatedHeightMinus1) {
                int newy;
                int sourcePos;
                int newx = xMinusRefXTimesDegCosXPlusHalfWidth + yMinusRefYTimesDegSin[y];
                if (newx < 0 || newx > maxWidth || (sourcePos = newx + (newy = yMinusRefYTimesDegCos[y] - xMinusRefXTimesDegSinXMinusHalfOfHeight) * this.width) < 0 || sourcePos > rgbDataLen) continue;
                rotatedRGB[x + y * rotatedWidth] = sourceRgbData[sourcePos];
            }
        }
    }

    private int getRotatedWidth(float degreeCos, float degreeSin) {
        int maxX;
        int pointX1 = 0;
        int pointX2 = Bitmap.round((float)this.width * degreeCos);
        int pointX3 = Bitmap.round((float)(-this.height) * degreeSin);
        int pointX4 = Bitmap.round((float)this.width * degreeCos - (float)this.height * degreeSin);
        int minX = pointX1;
        if (pointX2 < minX) {
            minX = pointX2;
        }
        if (pointX3 < minX) {
            minX = pointX3;
        }
        if (pointX4 < minX) {
            minX = pointX4;
        }
        if (pointX2 > (maxX = pointX1)) {
            maxX = pointX2;
        }
        if (pointX3 > maxX) {
            maxX = pointX3;
        }
        if (pointX4 > maxX) {
            maxX = pointX4;
        }
        return maxX - minX;
    }

    private int getRotatedHeight(float degreeCos, float degreeSin) {
        int maxY;
        int pointY1 = 0;
        int pointY2 = Bitmap.round((float)this.width * degreeSin);
        int pointY3 = Bitmap.round((float)this.height * degreeCos);
        int pointY4 = Bitmap.round((float)this.width * degreeSin + (float)this.height * degreeCos);
        int minY = pointY1;
        if (pointY2 < minY) {
            minY = pointY2;
        }
        if (pointY3 < minY) {
            minY = pointY3;
        }
        if (pointY4 < minY) {
            minY = pointY4;
        }
        if (pointY2 > (maxY = pointY1)) {
            maxY = pointY2;
        }
        if (pointY3 > maxY) {
            maxY = pointY3;
        }
        if (pointY4 > maxY) {
            maxY = pointY4;
        }
        return maxY - minY;
    }

    private int[] getSourceImageRGB() {
        int size = this.width * this.height;
        if (size < 10000) {
            if (this.rgbData == null) {
                this.rgbData = new int[size];
                this.image.getRGB(this.rgbData, 0, this.width, 0, 0, this.width, this.height);
            }
            return this.rgbData;
        }
        if (sharedBufferSrc == null || sharedBufferSrc.length < size) {
            sharedBufferSrc = new int[size];
        }
        this.image.getRGB(sharedBufferSrc, 0, this.width, 0, 0, this.width, this.height);
        return sharedBufferSrc;
    }

    public static byte[] getByteArray(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int a = (ARGB & 0xFF000000) >> 24;
            int r = (ARGB & 0xFF0000) >> 16;
            int g = (ARGB & 0xFF00) >> 8;
            int b = ARGB & 0xFF;
            rawByte[n] = (byte)b;
            rawByte[n + 1] = (byte)g;
            rawByte[n + 2] = (byte)r;
            rawByte[n + 3] = (byte)a;
            n += 4;
        }
        raw = null;
        return rawByte;
    }

    private static int[] getSharedBufferTransform(int size) {
        if (sharedBufferTransform == null || sharedBufferTransform.length < size) {
            sharedBufferTransform = new int[size];
        }
        return sharedBufferTransform;
    }

    public void drawRotatedCenterSquareImage(int x, int y, int angle, Graphics g) {
        angle %= 360;
        int size_div_2 = this.width / 2;
        if (this.width != this.height) {
            Utils.log("[!!!] drawRotatedCenterSquareImage - INVALID SIZE " + this.name);
        }
        if (this.drawRotated90n(g, x - size_div_2, y - size_div_2, x, y, angle)) {
            return;
        }
        int[] srcData = this.getSourceImageRGB();
        int[] dstData = Bitmap.getSharedBufferTransform(this.width * this.height);
        float rads = (float)Math.PI * (float)angle / 180.0f;
        float sinA = (float)Math.sin(rads);
        float cosA = (float)Math.cos(rads);
        int intSinA = (int)(256.0f * sinA);
        int intCosA = (int)(256.0f * cosA);
        int my = -(this.height >> 1);
        int size_div_2_shl_8 = size_div_2 << 8;
        for (int i = 0; i < this.height; ++i) {
            int wpos = i * this.width;
            int xacc = my * intSinA - size_div_2 * intCosA + size_div_2_shl_8;
            int yacc = my * intCosA + size_div_2 * intSinA + size_div_2_shl_8;
            for (int j = 0; j < this.width; ++j) {
                int srcX = xacc >> 8;
                int srcY = yacc >> 8;
                dstData[wpos++] = srcX < 0 || srcY < 0 || srcX > this.width - 1 || srcY > this.width - 1 ? srcData[0] : srcData[srcX + srcY * this.width];
                xacc += intCosA;
                yacc -= intSinA;
            }
            ++my;
        }
        g.drawRGB(dstData, 0, this.width, x - this.width / 2, y - this.height / 2, this.width, this.height, true);
    }

    public Bitmap setTiles(int tilesCountX, int tilesCountY) {
        this.tilesCountX = tilesCountX;
        this.spriteWidth = this.width / tilesCountX;
        this.spriteHeight = this.height / tilesCountY;
        return this;
    }

    public void drawSprite(Graphics g, int x, int y, int index) {
        int indexX = index % this.tilesCountX;
        int indexY = index / this.tilesCountX;
        int xSrc = this.spriteWidth * indexX;
        int ySrc = this.spriteHeight * indexY;
        g.drawRegion(this.image, xSrc, ySrc, this.spriteWidth, this.spriteHeight, 0, x, y, 20);
    }

    public int getTileWidth() {
        return this.spriteWidth;
    }

    public int getTileHeight() {
        return this.spriteHeight;
    }

    static {
        countt = 0;
        s = 0;
        xx = new int[4];
        yy = new int[4];
        newX = new int[4];
        newY = new int[4];
    }
}

