/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import sheet.Cell;
import sheet.CellContainer;
import sheet.Sheet;

final class Table
implements CellContainer {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int DB_VERSION_1 = 1;
    public static final int DB_LAST_VERSION = 1;
    public static final int MD_NORMAL = 0;
    public static final int MD_CELLSIZE = 1;
    private String name;
    private Cell[][] cells;
    private short[] rows;
    private short[] cols;
    private boolean dataChanged;
    private short szX;
    private short szY;
    private byte cursorX;
    private byte cursorY;
    private short tblLeft;
    private short tblTop;
    private short tblRight;
    private short tblBottom;

    public Table(short n, short n2, short s, short s2) {
        this.cells = new Cell[n][n2];
        this.rows = new short[n2];
        this.cols = new short[n];
        this.szX = n;
        this.szY = n2;
        int n3 = 0;
        while (n3 < n) {
            this.cols[n3] = s;
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            this.rows[n4] = s2;
            ++n4;
        }
        this.name = "noname";
    }

    public void moveCursor(int n) {
        switch (n) {
            case 3: {
                if (this.cursorX > 0) {
                    this.cursorX = (byte)(this.cursorX - 1);
                    if (this.cursorX >= this.tblLeft) break;
                    this.tblLeft = (short)(this.tblLeft - 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 4: {
                if (this.cursorX < this.szX - 1) {
                    this.cursorX = (byte)(this.cursorX + 1);
                    if (this.cursorX < this.tblRight) break;
                    this.tblLeft = (short)(this.tblLeft + 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 1: {
                if (this.cursorY > 0) {
                    this.cursorY = (byte)(this.cursorY - 1);
                    if (this.cursorY >= this.tblTop) break;
                    this.tblTop = (short)(this.tblTop - 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 2: {
                if (this.cursorY < this.szY - 1) {
                    this.cursorY = (byte)(this.cursorY + 1);
                    if (this.cursorY < this.tblBottom) break;
                    this.tblTop = (short)(this.tblTop + 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
            }
        }
    }

    public short getColumnWidth(int n) {
        return this.cols[n];
    }

    public short getRowHeight(int n) {
        return this.rows[n];
    }

    public void setRowHeight(int n, short s) {
        this.rows[n] = s;
        int n2 = 0;
        while (n2 < this.szX) {
            Cell cell = this.cells[n2][n];
            if (cell != null) {
                cell.render();
            }
            ++n2;
        }
        this.notifyChanged();
    }

    public void setColumnWidth(int n, short s) {
        this.cols[n] = s;
        int n2 = 0;
        while (n2 < this.szY) {
            Cell cell = this.cells[n][n2];
            if (cell != null) {
                cell.render();
            }
            ++n2;
        }
        this.notifyChanged();
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        Font font = Font.getFont((int)64, (int)0, (int)8);
        int n8 = font.getHeight() + 1;
        int n9 = font.stringWidth("10") + 2;
        graphics.setColor(0);
        graphics.setFont(font);
        short s = this.tblLeft;
        int n10 = n9;
        while (n10 < n && s < this.szX) {
            n7 = this.getColumnWidth(s);
            n6 = 65 + s;
            graphics.drawString(String.valueOf((char)n6), n10 + 1 + n7 / 2, 1, 17);
            n10 += n7 + 1;
            s = (short)(s + 1);
        }
        this.tblRight = (short)(s - 1);
        graphics.drawLine(0, n8, n10, n8);
        s = this.tblTop;
        int n11 = n8;
        while (n11 < n2 && s < this.szY) {
            n7 = this.getRowHeight(s);
            n6 = n9;
            n5 = s == this.cursorY ? 1 : 0;
            graphics.drawString(String.valueOf(s + 1), n9 - 1, n11 + n7 - n8 + 2, 24);
            n4 = this.tblLeft;
            while (n4 <= this.tblRight) {
                Cell cell = this.cells[n4][s];
                short s2 = this.getColumnWidth(n4);
                int n12 = 0;
                if (cell != null) {
                    n12 = cell.paint(graphics, n6 + 1, n11 + 1);
                }
                if (n4 == this.cursorX && n5 != 0) {
                    graphics.setColor(n12);
                    graphics.drawRect(n6 + 1, n11 + 1, s2 - 1, n7 - 1);
                    graphics.setColor(0);
                }
                if (cell != null && !cell.isCalculated()) {
                    int n13 = n6 + s2;
                    int n14 = n11 + n7;
                    graphics.drawLine(n6 + 1, n11 + 1, n13, n14);
                    graphics.drawLine(n6 + 1, n14, n13, n11 + 1);
                }
                n6 += s2 + 1;
                ++n4;
            }
            n11 += n7 + 1;
            if (n3 == 1 && n5 != 0) {
                graphics.setStrokeStyle(1);
                graphics.drawLine(0, n11, n10, n11);
                graphics.setStrokeStyle(0);
            } else {
                graphics.drawLine(0, n11, n10, n11);
            }
            s = (short)(s + 1);
        }
        this.tblBottom = (short)(s - 1);
        graphics.drawLine(n9, 0, n9, n11);
        n7 = this.tblLeft;
        n6 = n9;
        while (n7 <= this.tblRight) {
            n5 = this.getColumnWidth(n7);
            n6 += n5 + 1;
            if (n3 == 1 && n7 == this.cursorX) {
                graphics.setStrokeStyle(1);
                graphics.drawLine(n6, 0, n6, n11);
                graphics.setStrokeStyle(0);
            } else {
                graphics.drawLine(n6, 0, n6, n11);
            }
            ++n7;
        }
        if (this.dataChanged) {
            n5 = n9 / 2;
            n4 = n8 / 2;
            graphics.drawLine(n5 - 1, n4 - 1, n5 + 1, n4 + 1);
            graphics.drawLine(n5 + 1, n4 - 1, n5 - 1, n4 + 1);
        }
    }

    public Cell getByName(String string) throws IllegalArgumentException {
        try {
            int n = string.charAt(0) - 65;
            if (n >= this.szX) {
                n = string.charAt(0) - 97;
            }
            int n2 = Integer.parseInt(string.substring(1, string.length())) - 1;
            return this.cells[n][n2];
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Wrong cell name '" + string + "'");
        }
    }

    public void notifyChanged() {
        this.dataChanged = true;
    }

    public boolean isChanged() {
        return this.dataChanged;
    }

    public void calculate() {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.szX) {
            int n4 = 0;
            while (n4 < this.szY) {
                if (this.cells[n3][n4] != null) {
                    this.cells[n3][n4].notCalculated();
                }
                ++n4;
            }
            ++n3;
        }
        while (n2 != 0 && n != n2) {
            n = n2;
            n2 = 0;
            int n5 = 0;
            while (n5 < this.szX) {
                int n6 = 0;
                while (n6 < this.szY) {
                    Cell cell = this.cells[n5][n6];
                    if (cell != null && !cell.isCalculated() && !cell.calculate()) {
                        ++n2;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public Cell getCurrentCell(boolean bl) {
        Cell cell = this.cells[this.cursorX][this.cursorY];
        if (cell == null && bl) {
            this.cells[this.cursorX][this.cursorY] = cell = new Cell(this, this.cursorX, this.cursorY);
        }
        return cell;
    }

    public void clearCurrentCell() {
        if (this.cells[this.cursorX][this.cursorY] != null) {
            this.cells[this.cursorX][this.cursorY] = null;
            this.notifyChanged();
        }
    }

    public int getCurrentColumn() {
        return this.cursorX;
    }

    public int getCurrentRow() {
        return this.cursorY;
    }

    public String getName() {
        return this.name;
    }

    public void save(String string) throws IllegalArgumentException {
        this.name = string;
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            int n2;
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            byte[] byArray = new byte[(this.szX + 1) * 2 + (this.szY + 1) * 2 + 3];
            byArray[0] = 1;
            byArray[1] = (byte)this.szX;
            byArray[2] = (byte)this.szY;
            int n3 = 3;
            int n4 = 0;
            while (n4 < this.szX) {
                n2 = this.getColumnWidth(n4);
                byArray[n3] = (byte)n2;
                byArray[n3 + 1] = (byte)(n2 >>> 8);
                n3 += 2;
                ++n4;
            }
            n2 = 0;
            while (n2 < this.szY) {
                n = this.getRowHeight(n2);
                byArray[n3] = (byte)n;
                byArray[n3 + 1] = (byte)(n >>> 8);
                n3 += 2;
                ++n2;
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            n = 0;
            while (n < this.szX) {
                int n5 = 0;
                while (n5 < this.szY) {
                    byte[] byArray2;
                    Cell cell = this.cells[n][n5];
                    if (cell != null && (byArray2 = cell.serialize(1)) != null) {
                        recordStore.addRecord(byArray2, 0, byArray2.length);
                    }
                    ++n5;
                }
                ++n;
            }
            recordStore.closeRecordStore();
            this.dataChanged = false;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("'" + string + "' can't be saved");
        }
    }

    public static Table load(String string) throws IllegalArgumentException {
        Table table;
        try {
            short s;
            int n;
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            short s2 = recordStore.getNumRecords();
            byte[] byArray = recordStore.getRecord(1);
            byte by = byArray[0];
            if (by != 1) {
                throw new IllegalArgumentException();
            }
            int n2 = byArray[1];
            int n3 = byArray[2];
            int n4 = 3;
            table = new Table((short)n2, (short)n3, 0, 0);
            table.name = string;
            int n5 = 0;
            while (n5 < n2) {
                n = (short)(byArray[n4] + (byArray[n4 + 1] << 8));
                n4 += 2;
                table.setColumnWidth(n5, (short)n);
                ++n5;
            }
            n = 0;
            while (n < n3) {
                s = (short)(byArray[n4] + (byArray[n4 + 1] << 8));
                n4 += 2;
                table.setRowHeight(n, s);
                ++n;
            }
            s = 2;
            while (s <= s2) {
                byte[] byArray2 = recordStore.getRecord((int)s);
                Cell cell = Cell.deserialize(byArray2, table, by);
                if (cell != null) {
                    table.cells[cell.getColumn()][cell.getRow()] = cell;
                }
                ++s;
            }
            recordStore.closeRecordStore();
            table.dataChanged = false;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("'" + string + "' can't be read");
        }
        return table;
    }
}

