/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.util;

public class PMMath {
    public static final int FRAC_BITS = 16;
    public static final int ONE = 65536;
    public static final int HALF = 32768;

    public static final int FP(float f) {
        return (int)(f * 65536.0f);
    }

    public static final int FP(int n) {
        return n * 65536;
    }

    public static final int MUL(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int DIV(int n, int n2) {
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int LEN(int n, int n2) {
        long l = n;
        long l2 = n2;
        l = l * l >> 16;
        l2 = l2 * l2 >> 16;
        return (int)PMMath.SQRT(l + l2);
    }

    public static final int LEN(int n, int n2, int n3) {
        long l = n;
        long l2 = n2;
        long l3 = n3;
        l = l * l >> 16;
        l2 = l2 * l2 >> 16;
        l3 = l3 * l3 >> 16;
        return (int)PMMath.SQRT(l + l2 + l3);
    }

    public static final int FxPtoInt(int n) {
        return n >> 16;
    }

    public static final float FxptoFloat(int n) {
        return (float)n / 65536.0f;
    }

    public static final int LENApprox(int n, int n2, int n3) {
        long l = n;
        long l2 = n2;
        l = l * l >> 16;
        l2 = l2 * l2 >> 16;
        return (int)PMMath.SQRTApprox(l + l2, n3);
    }

    public static final int LENApprox(int n, int n2, int n3, int n4) {
        long l = n;
        long l2 = n2;
        long l3 = n3;
        l = l * l >> 16;
        l2 = l2 * l2 >> 16;
        l3 = l3 * l3 >> 16;
        return (int)PMMath.SQRTApprox(l + l2 + l3, n4);
    }

    public static final int LENApprox(int n, int n2, int n3, int n4, int n5) {
        long l = n;
        long l2 = n2;
        long l3 = n3;
        l = l * l >> 16;
        l2 = l2 * l2 >> 16;
        l3 = l3 * l3 >> 16;
        return (int)PMMath.SQRTApprox(l + l2 + l3, n4, n5);
    }

    public static long SQRTApprox(long l, long l2) {
        return PMMath.SQRTApprox(l, l2, 5);
    }

    public static long SQRTApprox(long l, long l2, int n) {
        if (l2 == 0L) {
            return PMMath.SQRT(l);
        }
        for (int i = 0; i < n; ++i) {
            l2 -= ((l2 * l2 >> 16) - l << 16) / (l2 << 2);
        }
        return l2;
    }

    public static long SQRT(long l) {
        long l2 = l;
        long l3 = 0L;
        long l4 = l2;
        long l5 = 1L;
        while (l4 > 0L) {
            l3 = l5;
            l4 = l2 / (l5 *= 100L);
        }
        long l6 = 0L;
        l5 = 0L;
        while (l3 > 0L) {
            l4 = l2 / l3;
            long l7 = l6 = 10L * l5;
            while (l7 < l6 + 10L && l7 * l7 <= l4) {
                l5 = l7++;
            }
            l3 /= 100L;
        }
        return l5 << 8;
    }
}

