/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.VarProxy;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.game.pixeline.Pixeline;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class HUD {
    private static final int STATE_ENTERING = 0;
    private static final int STATE_IDLE = 1;
    private int mState;
    private InterpolatorSpring mSpringLifeBox;
    private InterpolatorSpring mSpringCoinBox;
    private Pixeline mPixeline;
    private boolean mTotembarEnabled;
    private static final int BUTTON_ID_JUMP = 0;
    private static final int BUTTON_ID_TOTEMBAR = 1;
    private static final int BUTTON_ID_TOTEM1 = 2;
    private static final int BUTTON_ID_TOTEM2 = 3;
    private static final int BUTTON_ID_TOTEM3 = 4;
    private static final int BUTTON_ID_MENU = 5;
    private static final int BUTTON_COUNT = 6;
    private int[] mButtonCoords;
    private int[] mButtonID;
    private boolean[] mButtonPressed;
    private static final int PRESSED_OFFSET = 2;
    private static final int STATE_BAR_HIDDEN = 0;
    private static final int STATE_BAR_ENTER = 1;
    private static final int STATE_BAR_VISIBLE = 2;
    private static final int STATE_BAR_EXIT = 3;
    private int mBarState;
    private int mInterp;
    private int mTotemBarHeight;
    private int mTotemRequested;
    private Movie mAnimGainLife;
    private boolean mAnimGainLifeActive;
    private Movie[] mAnimLoseHealth;
    private boolean[] mAnimLoseHealthActive;
    private static final int STATE_KEY_VOID = 0;
    private static final int STATE_KEY_ENTERING = 1;
    private static final int STATE_KEY_IDLE = 2;
    private static final int STATE_KEY_EXITING = 3;
    private int mKeyState;
    private Movie mAnimKeyEnter;
    private Movie mAnimKeyIdle;
    private Movie mAnimKeyExit;
    public static final int LIFEBOXSTART = -12320768;
    public static final int COINBOXSTART = -9109504;

    public HUD(Pixeline pixeline) {
        int n;
        this.mPixeline = pixeline;
        this.mState = 0;
        this.mBarState = 0;
        this.mTotembarEnabled = GameState.isTotem1Unlocked();
        this.mInterp = 0;
        this.mTotemRequested = -1;
        this.mButtonCoords = new int[24];
        this.mButtonID = new int[6];
        this.mButtonPressed = new boolean[6];
        for (n = 0; n < 6; ++n) {
            this.mButtonPressed[n] = false;
        }
        this.mButtonID[0] = 0;
        this.mButtonCoords[0] = 553;
        this.mButtonCoords[1] = 285;
        this.mButtonCoords[2] = 659;
        this.mButtonCoords[3] = 391;
        this.mButtonID[1] = 1;
        this.mButtonCoords[4] = VarProxy.HUD_totemBarButtonX - 35;
        this.mButtonCoords[5] = VarProxy.HUD_totemBarButtonY - 35;
        this.mButtonCoords[6] = VarProxy.HUD_totemBarButtonX + 35;
        this.mButtonCoords[7] = VarProxy.HUD_totemBarButtonY + 35;
        n = 249;
        this.mButtonID[2] = 2;
        this.mButtonCoords[8] = 556;
        this.mButtonCoords[9] = n - 32;
        this.mButtonCoords[10] = 620;
        this.mButtonCoords[11] = n + 32;
        this.mButtonID[3] = 3;
        this.mButtonCoords[12] = 556;
        this.mButtonCoords[13] = (n -= 65) - 32;
        this.mButtonCoords[14] = 620;
        this.mButtonCoords[15] = n + 32;
        this.mButtonID[4] = 4;
        this.mButtonCoords[16] = 556;
        this.mButtonCoords[17] = (n -= 65) - 32;
        this.mButtonCoords[18] = 620;
        this.mButtonCoords[19] = n + 32;
        this.mTotemBarHeight = 320 - n;
        this.mButtonID[5] = 5;
        this.mButtonCoords[20] = 559;
        this.mButtonCoords[21] = 7;
        this.mButtonCoords[22] = 617;
        this.mButtonCoords[23] = 65;
        Touch.init(6, this.mButtonCoords, this.mButtonID, true);
        this.mSpringLifeBox = new InterpolatorSpring();
        this.mSpringCoinBox = new InterpolatorSpring();
        int n2 = -12320768;
        int n3 = -9109504;
        int n4 = 0;
        int n5 = VarProxy.HUD_silverCoinBoxX << 16;
        this.mSpringLifeBox.set(n2, 0, n4, 0);
        this.mSpringCoinBox.set(n3, 0, n5, 0);
        this.mAnimGainLife = Movie.load((short)-23666);
        this.mAnimGainLifeActive = false;
        this.mAnimLoseHealth = new Movie[3];
        this.mAnimLoseHealthActive = new boolean[3];
        for (int i = 0; i < this.mAnimLoseHealth.length; ++i) {
            this.mAnimLoseHealth[i] = Movie.load((short)2675);
            this.mAnimLoseHealth[i].loadGfx();
            this.mAnimLoseHealth[i].gotoTick(0);
            this.mAnimLoseHealthActive[i] = false;
        }
        this.mAnimKeyEnter = Movie.load((short)-27532);
        this.mAnimKeyIdle = Movie.load((short)31807);
        this.mAnimKeyExit = Movie.load((short)18629);
        this.mAnimKeyEnter.loadGfx();
        this.mAnimKeyIdle.loadGfx();
        this.mAnimKeyExit.loadGfx();
        this.mAnimKeyEnter.gotoTick(0);
        this.mAnimKeyIdle.gotoTick(0);
        this.mAnimKeyExit.gotoTick(0);
        this.mKeyState = 0;
    }

    public void update() {
        if (this.mState == 1) {
            int n;
            PixelineData pixelineData = this.mPixeline.getDataRef();
            if (!Dialog.isActive() && pixelineData.isAlive()) {
                for (n = 0; n < 6; ++n) {
                    this.mButtonPressed[n] = Touch.isDown(this.mButtonID[n]);
                }
                if (!GameState.mIsSingleTouch || GameState.mAnalogTouch == 0) {
                    if (Touch.isPressed(0)) {
                        pixelineData.setJumpButtonPressed(true);
                    } else {
                        pixelineData.setJumpButtonPressed(false);
                    }
                    if (Touch.isDown(0)) {
                        pixelineData.setJumpButtonDown(true);
                    } else {
                        pixelineData.setJumpButtonDown(false);
                    }
                }
                if (Touch.wasReleased(5) || Touch.isPressed(5)) {
                    StateGame.startMenu();
                }
                switch (this.mBarState) {
                    case 0: {
                        n = 0;
                        if (this.mTotembarEnabled && (Touch.wasReleased(1) || GameState.mIsSingleTouch && (Touch.isPressed(1) || Touch.isDown(1)))) {
                            n = 1;
                        }
                        if (n == 0) break;
                        this.mBarState = 1;
                        this.mInterp = 0;
                        SoundBuffer.play(31, 500);
                        break;
                    }
                    case 1: {
                        int n2;
                        this.mInterp += 9921 * Timer.mDt >> 6;
                        if (this.mInterp < 65536) break;
                        this.mInterp = 65536;
                        this.mBarState = 2;
                        for (n2 = 0; n2 < this.mButtonPressed.length; ++n2) {
                            this.mButtonPressed[n2] = false;
                        }
                        break;
                    }
                    case 2: {
                        int n2 = 0;
                        if (Touch.wasReleased(1) || GameState.mIsSingleTouch && (Touch.isPressed(1) || Touch.isDown(1))) {
                            n2 = 1;
                            SoundBuffer.play(31, 500);
                        } else if (Touch.wasReleased(2) || GameState.mIsSingleTouch && (Touch.isPressed(2) || Touch.isDown(2))) {
                            if (GameState.isTotem1Unlocked()) {
                                this.mTotemRequested = 1;
                                n2 = 1;
                                SoundBuffer.play(33, 500);
                            } else {
                                SoundBuffer.play(29, 500);
                            }
                        } else if (Touch.wasReleased(3) || GameState.mIsSingleTouch && (Touch.isPressed(3) || Touch.isDown(3))) {
                            if (GameState.isTotem2Unlocked()) {
                                this.mTotemRequested = 2;
                                n2 = 1;
                                SoundBuffer.play(33, 500);
                            } else {
                                SoundBuffer.play(29, 500);
                            }
                        } else if (Touch.wasReleased(4) || GameState.mIsSingleTouch && (Touch.isPressed(4) || Touch.isDown(4))) {
                            if (GameState.isTotem3Unlocked()) {
                                this.mTotemRequested = 3;
                                n2 = 1;
                                SoundBuffer.play(33, 500);
                            } else {
                                SoundBuffer.play(29, 500);
                            }
                        } else if (Touch.wasReleased(0) || GameState.mIsSingleTouch && (Touch.isPressed(0) || Touch.isDown(0))) {
                            this.mTotemRequested = 0;
                            n2 = 1;
                            SoundBuffer.play(33, 500);
                        }
                        if (n2 == 0) break;
                        this.mBarState = 3;
                        this.mInterp = 65536;
                        break;
                    }
                    case 3: {
                        this.mInterp -= 9921 * Timer.mDt >> 6;
                        if (this.mInterp > 0) break;
                        if (this.mTotemRequested > -1) {
                            this.mPixeline.eventRequestTransform(this.mTotemRequested);
                            this.mTotemRequested = -1;
                        }
                        this.mInterp = 0;
                        this.mBarState = 0;
                    }
                }
            }
            for (n = 0; n < this.mAnimLoseHealth.length; ++n) {
                if (!this.mAnimLoseHealthActive[n] || !this.mAnimLoseHealth[n].update(Timer.mDt)) continue;
                this.mAnimLoseHealth[n].gotoTick(0);
                this.mAnimLoseHealthActive[n] = false;
            }
            if (this.mAnimGainLifeActive && this.mAnimGainLife.update(Timer.mDt)) {
                this.mAnimGainLife.gotoTick(0);
                this.mAnimGainLifeActive = false;
            }
            switch (this.mKeyState) {
                case 0: {
                    if (GameState.mActiveNumUnusedKeys <= 0) break;
                    this.mAnimKeyEnter.gotoTick(0);
                    this.mKeyState = 1;
                    break;
                }
                case 1: {
                    if (GameState.mActiveNumUnusedKeys <= 0) {
                        this.mAnimKeyExit.gotoTick(0);
                        this.mKeyState = 3;
                        break;
                    }
                    if (!this.mAnimKeyEnter.update(Timer.mDt)) break;
                    this.mAnimKeyIdle.gotoTick(0);
                    this.mKeyState = 2;
                    break;
                }
                case 2: {
                    if (GameState.mActiveNumUnusedKeys <= 0) {
                        this.mAnimKeyExit.gotoTick(0);
                        this.mKeyState = 3;
                        break;
                    }
                    this.mAnimKeyIdle.update(Timer.mDt);
                    break;
                }
                case 3: {
                    if (GameState.mActiveNumUnusedKeys > 0) {
                        this.mAnimKeyEnter.gotoTick(0);
                        this.mKeyState = 1;
                        break;
                    }
                    if (!this.mAnimKeyExit.update(Timer.mDt)) break;
                    this.mKeyState = 0;
                }
            }
        } else {
            this.mSpringLifeBox.update(Timer.mDt);
            this.mSpringCoinBox.update(Timer.mDt);
            if (this.mSpringLifeBox.isDone() && this.mSpringCoinBox.isDone()) {
                this.mState = 1;
            }
        }
    }

    public void draw(int n) {
        if (StateGame.mState == 3) {
            return;
        }
        int n2 = this.mSpringLifeBox.getX() >> 16;
        int n3 = this.mSpringCoinBox.getX() >> 16;
        PMImageManager.draw(485, n2, 0);
        PMImageManager.draw(487, n3, 0);
        PixelineData pixelineData = this.mPixeline.getDataRef();
        int n4 = VarProxy.HUD_livesX + n2;
        int n5 = VarProxy.HUD_livesY;
        if (this.mAnimGainLifeActive) {
            this.mAnimGainLife.draw(n4, n5);
        } else {
            PMImageManager.draw(479, n4, n5);
        }
        PMImageManager.draw(484, n4 += 18, n5);
        PMCanvas.PMGraphics_drawString(n4 += 26, n5 - 33, "" + GameState.mLives, 0);
        int n6 = pixelineData.getHealth();
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    n4 = VarProxy.HUD_health1X + n2;
                    n5 = VarProxy.HUD_health1Y;
                    break;
                }
                case 1: {
                    n4 = VarProxy.HUD_health2X + n2;
                    n5 = VarProxy.HUD_health2Y;
                    break;
                }
                case 2: {
                    n4 = VarProxy.HUD_health3X + n2;
                    n5 = VarProxy.HUD_health3Y;
                }
            }
            if (i < n6) {
                PMImageManager.draw(480, n4, n5);
            } else {
                PMImageManager.draw(481, n4, n5);
            }
            if (!this.mAnimLoseHealthActive[i]) continue;
            this.mAnimLoseHealth[i].draw(n4, n5);
        }
        String string = "" + GameState.mSilverCoins;
        int n7 = 58 + PMFont.stringWidth(string, 0);
        n4 = n3 - (n7 >> 1) + 16;
        n5 = VarProxy.HUD_silverCoinsY;
        PMImageManager.draw(482, n4, n5);
        PMImageManager.draw(484, n4 += 16, n5);
        PMCanvas.PMGraphics_drawString(n4 += 26, n5 - 33, string, 0);
        switch (this.mKeyState) {
            case 1: {
                this.mAnimKeyEnter.draw(VarProxy.HUD_keyBoxX, -5);
                break;
            }
            case 2: {
                this.mAnimKeyIdle.draw(VarProxy.HUD_keyBoxX, -5);
                break;
            }
            case 3: {
                this.mAnimKeyExit.draw(VarProxy.HUD_keyBoxX, -5);
            }
        }
        n4 = 588 + (this.mButtonPressed[5] ? 2 : 0);
        n5 = 36 + (this.mButtonPressed[5] ? 2 : 0);
        PMImageManager.draw(499, n4, n5);
        if (this.mBarState != 0 && this.mTotembarEnabled) {
            n4 = 588;
            n5 = 320 - MathUtil.smoothStep(this.mInterp, this.mTotemBarHeight);
            int n8 = pixelineData.getTotemState();
            int n9 = 0;
            n9 = GameState.isTotem1Unlocked() ? (n8 == 1 ? 488 : 492) : 496;
            int n10 = 0;
            n10 = GameState.isTotem2Unlocked() ? (n8 == 2 ? 489 : 493) : 496;
            int n11 = 0;
            n11 = GameState.isTotem3Unlocked() ? (n8 == 3 ? 490 : 494) : 496;
            int n12 = n8 == 0 ? 491 : 495;
            PMImageManager.draw(n11, n4 + (this.mBarState == 2 && this.mButtonPressed[4] ? 2 : 0), n5 + (this.mBarState == 2 && this.mButtonPressed[4] ? 2 : 0));
            if (this.mBarState == 0) {
                PMImageManager.draw(498, n4, n5);
            }
            PMImageManager.draw(n10, n4 + (this.mBarState == 2 && this.mButtonPressed[3] ? 2 : 0), (n5 += 65) + (this.mBarState == 2 && this.mButtonPressed[3] ? 2 : 0));
            PMImageManager.draw(n9, n4 + (this.mBarState == 2 && this.mButtonPressed[2] ? 2 : 0), (n5 += 65) + (this.mBarState == 2 && this.mButtonPressed[2] ? 2 : 0));
            PMImageManager.draw(n12, n4 + (this.mBarState == 2 && this.mButtonPressed[0] ? 2 : 0), (n5 += 65) + (this.mBarState == 2 && this.mButtonPressed[0] ? 2 : 0));
        } else {
            n4 = 588 + (this.mButtonPressed[0] ? 2 : 0);
            n5 = 320 + (this.mButtonPressed[0] ? 2 : 0);
            PMImageManager.draw(498, n4, n5);
        }
        if (this.mTotembarEnabled) {
            n4 = VarProxy.HUD_totemBarButtonX + (this.mButtonPressed[1] ? 2 : 0);
            n5 = VarProxy.HUD_totemBarButtonY + (this.mButtonPressed[1] ? 2 : 0);
            PMImageManager.draw(497, n4, n5);
        }
        if (this.mBarState == 0) {
            InputProxy.drawTouchInput(true);
        }
    }

    public void activateTouch() {
        Touch.init(6, this.mButtonCoords, this.mButtonID, true);
    }

    public boolean totemBarActive() {
        return this.mBarState != 0;
    }

    public boolean isHUDReady() {
        return this.mState == 1;
    }

    public void eventLoseHealth(int n) {
        if (!this.mAnimLoseHealthActive[n]) {
            this.mAnimLoseHealthActive[n] = true;
        }
    }

    public void eventGainLife() {
        if (!this.mAnimGainLifeActive) {
            this.mAnimGainLifeActive = true;
            this.mAnimGainLife.gotoTick(0);
        }
    }
}

