/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.items;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.VisualEffect;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class GoldCoins {
    private static final int HALF_WIDTH = 8;
    private static final int HALF_WIDTH_FP = 524288;
    private static final int STATE_COIN_IDLE = 0;
    private static final int STATE_COIN_GONE = 1;
    private World mWorldRef;
    private Vector2[] mPositions;
    private int[] mStates;
    private Movie mAnimIdle;

    public GoldCoins(Vector2[] vector2Array, World world) {
        this.mPositions = vector2Array;
        this.mStates = new int[vector2Array.length];
        this.mWorldRef = world;
        this.mAnimIdle = Movie.load((short)-4793);
        this.mAnimIdle.loadGfx();
        this.mAnimIdle.gotoTick(0);
        int n = this.mPositions.length;
        for (int i = 0; i < n; ++i) {
            short s = (short)(1 << i);
            if ((GameState.mActiveGoldCoinsFound & s) == 0) continue;
            this.mStates[i] = 1;
        }
    }

    public void update() {
        this.mAnimIdle.update(Timer.mDt);
    }

    public void draw(Vector2 vector2) {
        int n = this.mPositions.length;
        for (int i = 0; i < n; ++i) {
            if (this.mStates[i] == 1) continue;
            Vector2 vector22 = this.mPositions[i];
            long l = (long)vector22.mX * 5L >> 1;
            long l2 = (long)vector2.mX * 5L >> 1;
            int n2 = (int)((l >> 16) - (l2 >> 16));
            int n3 = 40;
            long l3 = (long)vector22.mY * 5L >> 1;
            long l4 = (long)vector2.mY * 5L >> 1;
            int n4 = (int)((l3 >> 16) - (l4 >> 16));
            int n5 = 40;
            if (!Camera.isInside(n2 - (n3 >> 1), n4 - (n5 >> 1), n3, n5) || this.mStates[i] != 0) continue;
            this.mAnimIdle.draw(n2, n4);
        }
    }

    public int collision(int n, int n2, int n3, int n4) {
        int n5 = this.mPositions.length;
        for (int i = 0; i < n5; ++i) {
            if (this.mStates[i] != 0) continue;
            Vector2 vector2 = this.mPositions[i];
            int n6 = vector2.mX - 524288;
            int n7 = vector2.mX + 524288;
            int n8 = vector2.mY - 524288;
            int n9 = vector2.mY + 524288;
            if (n3 < n6 || n > n7 || n4 < n8 || n2 > n9) continue;
            this.mStates[i] = 1;
            VisualEffect.spawn(1, vector2);
            return i;
        }
        return -1;
    }

    public int getNumTotalCoins() {
        return this.mPositions.length;
    }
}

