/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.math.Interpolator;
import dk.progressivemedia.skeleton.math.InterpolatorLinear;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;

public class Dialog {
    public static final int MODE_USER = 1;
    public static final int MODE_TIMED = 2;
    private static int mProgressionMode;
    public static final int ENTER_MODE_TOP = 0;
    public static final int ENTER_MODE_BOTTOM = 1;
    private static int mEnterMode;
    public static final int DIALOG_TYPE_PIXELINE = 0;
    public static final int DIALOG_TYPE_BOOK = 1;
    private static int mDialogType;
    private static final int STATE_VOID = -1;
    private static final int STATE_ENTER = 0;
    private static final int STATE_STRING_TYPING = 1;
    private static final int STATE_ACTIVE = 2;
    private static final int STATE_ACTIVE_DONE_USER = 3;
    private static final int STATE_ACTIVE_DONE_TIME = 4;
    private static final int STATE_EXIT = 5;
    private static int mState;
    private static String mText;
    private static int mTextLength;
    private static int[] mLineSplit;
    private static int mDialogHeight;
    private static InterpolatorSpring mSpring;
    private static InterpolatorLinear mLinear;
    private static Interpolator mActiveInterp;
    private static int mTimer;
    private static int mCharTimer;
    private static int mCharIndex;
    public static final int MASTER_ALPHA_SPEED = 8192;

    public static void init(int n, int n2) {
        mProgressionMode = 3;
        mEnterMode = n;
        mDialogType = n2;
        mState = -1;
        mSpring.setStiffness(26000);
        mSpring.setDamping(23000);
        mSpring.setMaxVelocity(7500000);
        switch (mDialogType) {
            case 0: {
                mDialogHeight = 98;
                break;
            }
            case 1: {
                mDialogHeight = 88;
            }
        }
    }

    public static void deinit() {
        mLineSplit = null;
        mText = null;
    }

    public static void startDialog(int n) {
        mState = 0;
        mProgressionMode = n;
        mActiveInterp = mSpring;
        switch (mEnterMode) {
            case 1: {
                int n2 = 240 + mDialogHeight << 16;
                int n3 = 0x850000;
                mActiveInterp.set(0xA00000, n2, 0xA00000, n3);
                break;
            }
            case 0: {
                int n4 = -(mDialogHeight << 16);
                int n5 = 0x460000;
                mActiveInterp.set(0xA00000, n4, 0xA00000, n5);
            }
        }
    }

    public static void pushText(short s) {
        mText = PMText.getText(0x50000 | s);
        mTextLength = mText.length();
        mTimer = 2000 + mTextLength * 33;
        mCharTimer = 8;
        mCharIndex = 0;
        if (mState == 2 || mState == 3 || mState == 4) {
            mState = 1;
        }
        mLineSplit = PMFont.stringBoxLines(170, mText, 1);
    }

    public static void endDialog() {
        mState = 5;
        mActiveInterp = mLinear;
        switch (mEnterMode) {
            case 1: {
                int n = 0x850000;
                int n2 = 240 + mDialogHeight << 16;
                mActiveInterp.set(0xA00000, n, 0xA00000, n2);
                break;
            }
            case 0: {
                int n = 0x460000;
                int n3 = -(mDialogHeight << 16);
                mActiveInterp.set(0xA00000, n, 0xA00000, n3);
            }
        }
    }

    public static void update() {
        mActiveInterp.update(Timer.mDt);
        switch (mState) {
            case 0: {
                if (!mActiveInterp.isDone()) break;
                mState = 1;
                break;
            }
            case 1: {
                if (InputProxy.isReleasedFire2()) {
                    mState = 3;
                }
                if (mCharIndex < mTextLength) {
                    if ((mProgressionMode & 1) != 0 && (Touch.mScreenPressed || InputProxy.isPressedFire() || InputProxy.isPressedCancel())) {
                        mCharIndex = mTextLength;
                    } else if ((mCharTimer -= Timer.mDt) <= 0) {
                        int n;
                        for (n = -mCharTimer + 8; n >= 8 && mCharIndex < mTextLength; ++mCharIndex, n -= 8) {
                        }
                        mCharTimer = 8 + n;
                    }
                }
                if (mCharIndex < mTextLength) break;
                mState = 2;
                break;
            }
            case 2: {
                if (InputProxy.isReleasedFire2()) {
                    mState = 3;
                }
                if ((mProgressionMode & 1) != 0 && (Touch.mScreenPressed || InputProxy.isPressedFire() || InputProxy.isPressedCancel())) {
                    mState = 3;
                }
                if ((mProgressionMode & 2) == 0 || mState != 2 || (mTimer -= Timer.mDt) > 0) break;
                mState = 4;
                break;
            }
            case 5: {
                if (!mActiveInterp.isDone()) break;
                mState = -1;
            }
        }
    }

    public static void draw() {
        if (mState != -1) {
            int n = mActiveInterp.getX() >> 16;
            int n2 = mActiveInterp.getY() >> 16;
            int n3 = mDialogType == 0 ? 28 : 29;
            PMImageManager.draw(n3, n, n2);
            switch (mState) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n4 = n + -55;
                    int n5 = n2 + -4;
                    for (int i = 0; i < mLineSplit.length; ++i) {
                        if (mCharIndex >= mLineSplit[i]) {
                            int n6 = mLineSplit[i];
                            n6 = i < mLineSplit.length - 1 ? (mCharIndex >= mLineSplit[i + 1] ? mLineSplit[i + 1] - 1 : mCharIndex) : (mCharIndex >= mTextLength ? mTextLength : mCharIndex);
                            PMCanvas.PMGraphics_drawString(n4, n5 - 6, mText.substring(mLineSplit[i], n6), 1);
                        }
                        n5 += 12;
                    }
                    break;
                }
            }
        }
    }

    public static boolean isActive() {
        return mState != -1;
    }

    public static boolean isOpen() {
        return mState != -1 && mState != 5;
    }

    public static boolean isReady() {
        return mState != -1 && mState != 5 && mState != 0;
    }

    public static boolean isTextDoneUser() {
        return mState == 3;
    }

    public static boolean isTextDoneTime() {
        return mState == 4;
    }

    static {
        mState = -1;
        mSpring = new InterpolatorSpring();
        mLinear = new InterpolatorLinear();
        mActiveInterp = null;
    }
}

