/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.skeleton.game.Platform;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceMovementCtrlCircular;
import dk.progressivemedia.skeleton.game.SurfaceMovementCtrlLinear;
import dk.progressivemedia.skeleton.game.SurfaceSolidityCtrlCorrosive;
import dk.progressivemedia.skeleton.game.SurfaceSolidityCtrlDisappearing;
import dk.progressivemedia.skeleton.math.Vector2;

public class LevelFileLoader {
    private static final int LEVEL_FORMAT_VERSION = 1;
    private int mTilemapWidth;
    private int mTilemapHeight;
    private int mWorldTheme;
    private int mTilemapNumLayers;
    private boolean[][] mCollisionTilemap;
    private byte[][] mPrimaryTilemap;
    private byte[][] mOverlayTilemap;
    private Surface[] mSurfaces;
    private int mSurfaceIdx;
    private Platform[] mPlatforms;
    private int mPlatformIdx;
    private Vector2 mSpawnpoint;
    private Vector2[] mCheckpoints;
    private Vector2 mExitArea;
    private Vector2[] mKeyPositions;
    private Vector2[] mChestPositions;
    private Vector2[] mGoldCoinPositions;
    private Vector2[] mSilverCoinPositions;
    private Vector2[] mHealthPositions;
    private Vector2[] mTutorialPositions;
    private int[] mTutorialTypes;
    private Vector2[] mEnemy1Positions;
    private Vector2[] mEnemy2Positions;
    private Vector2[] mEnemy3Positions;
    private Vector2[] mEnemy4Positions;
    private Vector2[] mEnemy5Positions;
    private Vector2[] mEnemy6Positions;
    private boolean[] mEnemy4Directions;
    private int[] mEnemy4FiringRanges;
    private Vector2[] mEnemy5MovementDirection;
    private int[] mEnemy5MovementLength;
    private int[] mEnemy5MovementSpeed;
    private Vector2[] mDanger1Positions;
    private int[] mDanger1Widths;
    private int[] mDanger1Heights;
    private Vector2[] mDanger2Positions;
    private int[] mDanger2InitialDelays;
    private int[] mDanger2Delays;
    private int[] mDanger2JumpForces;
    private Vector2[] mDanger3Positions;
    private int[] mDanger3Heights;
    private Vector2[] mDanger4Positions;
    private int[] mDanger4TileWidths;
    private int[] mDanger4Orientations;

    public LevelFileLoader(String string) {
        PMFile.openFile(string);
        if (PMFile.readInt() == 1) {
            this.loadHeaderAndLayers();
            this.loadSurfaces();
            this.loadDynamicSurfaces();
            this.loadSpawnAndCheckpoints();
            this.loadExitArea();
            this.loadChests();
            this.loadKeys();
            this.loadCoins();
            this.loadHealth();
            this.loadEnemies();
            this.loadWaterDangers();
            this.loadJumperDangers();
            this.loadStoneDangers();
            this.loadSpikeDangers();
            this.loadTutorials();
        }
        PMFile.closeFile();
    }

    private void loadHeaderAndLayers() {
        int n;
        int n2;
        this.mTilemapWidth = PMFile.readInt();
        this.mTilemapHeight = PMFile.readInt();
        this.mWorldTheme = PMFile.readInt();
        this.mTilemapNumLayers = PMFile.readInt();
        this.mCollisionTilemap = new boolean[this.mTilemapWidth][this.mTilemapHeight];
        for (n2 = 0; n2 < this.mTilemapHeight; ++n2) {
            for (n = 0; n < this.mTilemapWidth; ++n) {
                this.mCollisionTilemap[n][n2] = PMFile.readInt() == 1;
            }
        }
        this.mPrimaryTilemap = new byte[this.mTilemapWidth][this.mTilemapHeight];
        for (n2 = 0; n2 < this.mTilemapHeight; ++n2) {
            for (n = 0; n < this.mTilemapWidth; ++n) {
                int n3 = PMFile.readInt();
                if (n3 > 100) {
                    n3 = 0;
                }
                this.mPrimaryTilemap[n][n2] = (byte)n3;
            }
        }
        if (this.mTilemapNumLayers > 2) {
            this.mOverlayTilemap = new byte[this.mTilemapWidth][this.mTilemapHeight];
            for (n2 = 0; n2 < this.mTilemapHeight; ++n2) {
                for (n = 0; n < this.mTilemapWidth; ++n) {
                    this.mOverlayTilemap[n][n2] = (byte)PMFile.readInt();
                }
            }
        }
    }

    private void loadSurfaces() {
        int n = PMFile.readInt();
        int n2 = PMFile.readInt();
        this.mSurfaceIdx = 0;
        this.mSurfaces = new Surface[n + n2];
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = PMFile.readInt();
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            for (int j = 0; j < n4; ++j) {
                nArray[j] = PMFile.readInt();
                nArray2[j] = PMFile.readInt();
            }
            int[] nArray3 = new int[n4 - 1];
            int[] nArray4 = new int[n4 - 1];
            for (int j = 0; j < n4 - 1; ++j) {
                nArray3[j] = PMFile.readInt();
                nArray4[j] = PMFile.readInt();
            }
            int[] nArray5 = new int[n4 - 1];
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                nArray5[n3] = PMFile.readInt();
            }
            n3 = PMFile.readInt();
            this.mSurfaces[this.mSurfaceIdx++] = new Surface(nArray, nArray2, nArray3, nArray4, nArray5, n3 != 0, false);
        }
    }

    private void loadDynamicSurfaces() {
        int n = PMFile.readInt();
        this.mPlatformIdx = 0;
        this.mPlatforms = new Platform[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            boolean bl;
            boolean bl2;
            int n5;
            int n6 = PMFile.readInt();
            int[] nArray = new int[n6];
            int[] nArray2 = new int[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                nArray[n5] = PMFile.readInt();
                nArray2[n5] = PMFile.readInt();
            }
            n5 = n6 - 1;
            int[] nArray3 = new int[n5];
            int[] nArray4 = new int[n5];
            for (int j = 0; j < n5; ++j) {
                nArray3[j] = PMFile.readInt();
                nArray4[j] = PMFile.readInt();
            }
            int[] nArray5 = new int[n5];
            for (bl2 = false; bl2 < nArray5.length; bl2 += 1) {
                nArray5[bl2] = PMFile.readInt();
            }
            bl2 = PMFile.readInt() != 0;
            int n7 = PMFile.readInt();
            int n8 = PMFile.readInt();
            Surface surface = new Surface(nArray, nArray2, nArray3, nArray4, nArray5, bl2, true);
            this.mSurfaces[this.mSurfaceIdx++] = surface;
            PlatformData platformData = new PlatformData(surface, n7, n8);
            Platform platform = new Platform(platformData);
            this.mPlatforms[this.mPlatformIdx++] = platform;
            int n9 = PMFile.readInt();
            boolean bl3 = bl = PMFile.readInt() != 0;
            if (n9 == 1) {
                Vector2 vector2 = new Vector2();
                vector2.mX = PMFile.readInt();
                vector2.mY = PMFile.readInt();
                n4 = PMFile.readInt();
                n3 = PMFile.readInt();
                platform.assignMovementCtrl(new SurfaceMovementCtrlLinear(platformData, vector2, n4, n3, !bl));
            } else if (n9 == 2) {
                Vector2 vector2 = new Vector2();
                vector2.mX = PMFile.readInt();
                vector2.mY = PMFile.readInt();
                n4 = PMFile.readInt();
                n3 = PMFile.readInt();
                n2 = PMFile.readInt();
                int n10 = PMFile.readInt();
                platform.assignMovementCtrl(new SurfaceMovementCtrlCircular(platformData, vector2, n3, n4, n2, n10, !bl));
            }
            int n11 = PMFile.readInt();
            if (n11 == 1) {
                n4 = PMFile.readInt();
                n3 = PMFile.readInt();
                n2 = PMFile.readInt();
                platform.assignSolidityCtrl(new SurfaceSolidityCtrlDisappearing(platformData, n4, n3, n2), 2);
                continue;
            }
            if (n11 != 2) continue;
            n4 = PMFile.readInt();
            platform.assignSolidityCtrl(new SurfaceSolidityCtrlCorrosive(platformData, n4), 1);
        }
    }

    private void loadSpawnAndCheckpoints() {
        int n = PMFile.readInt();
        int n2 = PMFile.readInt();
        this.mSpawnpoint = new Vector2(n, n2);
        int n3 = PMFile.readInt();
        this.mCheckpoints = new Vector2[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = PMFile.readInt();
            int n5 = PMFile.readInt();
            this.mCheckpoints[i] = new Vector2(n4, n5);
        }
    }

    private void loadExitArea() {
        int n = PMFile.readInt();
        int n2 = PMFile.readInt();
        this.mExitArea = new Vector2(n, n2);
    }

    private void loadChests() {
        int n = PMFile.readInt();
        this.mChestPositions = new Vector2[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            this.mChestPositions[i] = new Vector2(n2, n3);
        }
    }

    private void loadKeys() {
        int n = PMFile.readInt();
        this.mKeyPositions = new Vector2[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            this.mKeyPositions[i] = new Vector2(n2, n3);
        }
    }

    private void loadCoins() {
        int n;
        int n2;
        int n3;
        int n4 = PMFile.readInt();
        this.mGoldCoinPositions = new Vector2[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = PMFile.readInt();
            n = PMFile.readInt();
            this.mGoldCoinPositions[n3] = new Vector2(n2, n);
        }
        n3 = PMFile.readInt();
        this.mSilverCoinPositions = new Vector2[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            n = PMFile.readInt();
            int n5 = PMFile.readInt();
            this.mSilverCoinPositions[n2] = new Vector2(n, n5);
        }
    }

    private void loadHealth() {
        int n = PMFile.readInt();
        this.mHealthPositions = new Vector2[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            this.mHealthPositions[i] = new Vector2(n2, n3);
        }
    }

    private void loadEnemies() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = PMFile.readInt();
        this.mEnemy1Positions = new Vector2[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = PMFile.readInt();
            n6 = PMFile.readInt();
            n5 = PMFile.readInt() == 0 ? 0 : 1;
            this.mEnemy1Positions[n8] = new Vector2(n7, n6);
        }
        n8 = PMFile.readInt();
        this.mEnemy2Positions = new Vector2[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = PMFile.readInt();
            n5 = PMFile.readInt();
            n4 = PMFile.readInt() == 0 ? 0 : 1;
            this.mEnemy2Positions[n7] = new Vector2(n6, n5);
        }
        n7 = PMFile.readInt();
        this.mEnemy3Positions = new Vector2[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = PMFile.readInt();
            n4 = PMFile.readInt();
            n3 = PMFile.readInt() == 0 ? 0 : 1;
            this.mEnemy3Positions[n6] = new Vector2(n5, n4);
        }
        n6 = PMFile.readInt();
        this.mEnemy4Positions = new Vector2[n6];
        this.mEnemy4FiringRanges = new int[n6];
        this.mEnemy4Directions = new boolean[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = PMFile.readInt();
            n3 = PMFile.readInt();
            n2 = PMFile.readInt();
            n = PMFile.readInt();
            this.mEnemy4Positions[n5] = new Vector2(n4, n3);
            this.mEnemy4FiringRanges[n5] = n;
            this.mEnemy4Directions[n5] = n2 != 0;
        }
        n5 = PMFile.readInt();
        this.mEnemy5Positions = new Vector2[n5];
        this.mEnemy5MovementDirection = new Vector2[n5];
        this.mEnemy5MovementLength = new int[n5];
        this.mEnemy5MovementSpeed = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = PMFile.readInt();
            n2 = PMFile.readInt();
            this.mEnemy5Positions[n4] = new Vector2(n3, n2);
            n = PMFile.readInt();
            int n10 = PMFile.readInt();
            this.mEnemy5MovementDirection[n4] = new Vector2(n, n10);
            this.mEnemy5MovementLength[n4] = PMFile.readInt();
            this.mEnemy5MovementSpeed[n4] = PMFile.readInt();
        }
        n4 = PMFile.readInt();
        this.mEnemy6Positions = new Vector2[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = PMFile.readInt();
            n = PMFile.readInt();
            this.mEnemy6Positions[n3] = new Vector2(n2, n);
        }
    }

    private void loadWaterDangers() {
        int n = PMFile.readInt();
        this.mDanger1Positions = new Vector2[n];
        this.mDanger1Widths = new int[n];
        this.mDanger1Heights = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            this.mDanger1Positions[i] = new Vector2(n2, n3);
            this.mDanger1Widths[i] = PMFile.readInt();
            this.mDanger1Heights[i] = PMFile.readInt();
        }
    }

    private void loadJumperDangers() {
        int n = PMFile.readInt();
        this.mDanger2Positions = new Vector2[n];
        this.mDanger2JumpForces = new int[n];
        this.mDanger2Delays = new int[n];
        this.mDanger2InitialDelays = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            int n4 = PMFile.readInt();
            int n5 = PMFile.readInt();
            int n6 = PMFile.readInt();
            this.mDanger2Positions[i] = new Vector2(n2, n3);
            this.mDanger2JumpForces[i] = n4;
            this.mDanger2Delays[i] = n5;
            this.mDanger2InitialDelays[i] = n6;
        }
    }

    private void loadStoneDangers() {
        int n = PMFile.readInt();
        this.mDanger3Positions = new Vector2[n];
        this.mDanger3Heights = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            int n4 = PMFile.readInt();
            this.mDanger3Positions[i] = new Vector2(n2, n3);
            this.mDanger3Heights[i] = n4;
        }
    }

    private void loadSpikeDangers() {
        int n = PMFile.readInt();
        this.mDanger4Positions = new Vector2[n];
        this.mDanger4TileWidths = new int[n];
        this.mDanger4Orientations = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            int n4 = PMFile.readInt();
            int n5 = PMFile.readInt();
            this.mDanger4Positions[i] = new Vector2(n2, n3);
            this.mDanger4TileWidths[i] = n4;
            this.mDanger4Orientations[i] = n5;
        }
    }

    private void loadTutorials() {
        int n = PMFile.readInt();
        this.mTutorialPositions = new Vector2[n];
        this.mTutorialTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = PMFile.readInt();
            int n3 = PMFile.readInt();
            int n4 = PMFile.readInt();
            this.mTutorialPositions[i] = new Vector2(n3, n4);
            this.mTutorialTypes[i] = n2;
        }
    }

    public int getTilemapWidth() {
        return this.mTilemapWidth;
    }

    public int getTilemapHeight() {
        return this.mTilemapHeight;
    }

    public int getWorldTheme() {
        return this.mWorldTheme;
    }

    public boolean[][] getCollisionTilemap() {
        return this.mCollisionTilemap;
    }

    public byte[][] getPrimaryTilemap() {
        return this.mPrimaryTilemap;
    }

    public byte[][] getOverlayTilemap() {
        return this.mOverlayTilemap;
    }

    public Surface[] getSurfaces() {
        return this.mSurfaces;
    }

    public Platform[] getPlatforms() {
        return this.mPlatforms;
    }

    public Vector2 getSpawnpoint() {
        return this.mSpawnpoint;
    }

    public Vector2[] getCheckpoints() {
        return this.mCheckpoints;
    }

    public Vector2 getExitArea() {
        return this.mExitArea;
    }

    public Vector2[] getKeyPositions() {
        return this.mKeyPositions;
    }

    public Vector2[] getChestPositions() {
        return this.mChestPositions;
    }

    public Vector2[] getGoldCoinPositions() {
        return this.mGoldCoinPositions;
    }

    public Vector2[] getSilverCoinPositions() {
        return this.mSilverCoinPositions;
    }

    public Vector2[] getHealthPositions() {
        return this.mHealthPositions;
    }

    public Vector2[] getTutorialPositions() {
        return this.mTutorialPositions;
    }

    public int[] getTutorialTypes() {
        return this.mTutorialTypes;
    }

    public Vector2[] getEnemy1Positions() {
        return this.mEnemy1Positions;
    }

    public Vector2[] getEnemy2Positions() {
        return this.mEnemy2Positions;
    }

    public Vector2[] getEnemy3Positions() {
        return this.mEnemy3Positions;
    }

    public Vector2[] getEnemy4Positions() {
        return this.mEnemy4Positions;
    }

    public Vector2[] getEnemy5Positions() {
        return this.mEnemy5Positions;
    }

    public Vector2[] getEnemy6Positions() {
        return this.mEnemy6Positions;
    }

    public boolean[] getEnemy4Directions() {
        return this.mEnemy4Directions;
    }

    public int[] getEnemy4FiringRanges() {
        return this.mEnemy4FiringRanges;
    }

    public Vector2[] getEnemy5MovementDirections() {
        return this.mEnemy5MovementDirection;
    }

    public int[] getEnemy5MovementLengths() {
        return this.mEnemy5MovementLength;
    }

    public int[] getEnemy5MovementSpeeds() {
        return this.mEnemy5MovementSpeed;
    }

    public Vector2[] getDanger1Positions() {
        return this.mDanger1Positions;
    }

    public int[] getDanger1Widths() {
        return this.mDanger1Widths;
    }

    public int[] getDanger1Heights() {
        return this.mDanger1Heights;
    }

    public Vector2[] getDanger2Positions() {
        return this.mDanger2Positions;
    }

    public int[] getDanger2JumpForces() {
        return this.mDanger2JumpForces;
    }

    public int[] getDanger2Delays() {
        return this.mDanger2Delays;
    }

    public int[] getDanger2InitialDelays() {
        return this.mDanger2InitialDelays;
    }

    public Vector2[] getDanger3Positions() {
        return this.mDanger3Positions;
    }

    public int[] getDanger3Heights() {
        return this.mDanger3Heights;
    }

    public Vector2[] getDanger4Positions() {
        return this.mDanger4Positions;
    }

    public int[] getDanger4TileWidths() {
        return this.mDanger4TileWidths;
    }

    public int[] getDanger4Orientations() {
        return this.mDanger4Orientations;
    }
}

